/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sem.mp.EdgeGroupCollection;
import com.kingdee.eas.sem.mp.EdgeGroupFactory;
import com.kingdee.eas.sem.mp.EdgeGroupInfo;
import com.kingdee.eas.sem.mp.EdgeParamFactory;
import com.kingdee.eas.sem.mp.EdgeParamInfo;
import com.kingdee.eas.sem.mp.IEdgeParam;
import com.kingdee.eas.sem.mp.IWarnGroup;
import com.kingdee.eas.sem.mp.KPICollection;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewCollection;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewInfo;
import com.kingdee.eas.sem.mp.KPITimeTypeEnum;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueFactory;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamNewCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamNewInfo;
import com.kingdee.eas.sem.mp.WarnGroupCollection;
import com.kingdee.eas.sem.mp.WarnGroupFactory;
import com.kingdee.eas.sem.mp.WarnGroupInfo;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.KPITimeHandle;
import com.kingdee.eas.sem.mp.util.CreateRandomString;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.ScriptUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class KPIValueHandle {
    private Map fileStdValueMap = new HashMap();
    private Map warnParamMap = new HashMap();
    Map edgeParamMap = new LinkedHashMap();
    private KPIInfo kpiInfo = null;
    private boolean isExistKpiValue = false;
    protected static final String RES = "com.kingdee.eas.sem.mp.app.KPIAppResource";

    public CoreBaseInfo transmitMini(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.init();
        this.kpiInfo = new KPIInfo();
        boolean processFlag = false;
        KPIValueInfo kpiValueInfo = null;
        KPIValueInfo newKpiValue = null;
        processFlag = this.getExistCompanyInfo(ctx, hsData);
        if (!processFlag) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"not_exist_org"));
        }
        KPIInfo kpiInfo = this.getExistKpiInfo(ctx, hsData);
        if (kpiInfo == null) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"not_exist_kpidefine"));
        }
        this.setKpiInfo(kpiInfo);
        processFlag = this.checkStandardValueColumn(hsData, kpiInfo);
        if (!processFlag) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"dif_standardvalue"));
        }
        processFlag = this.checkKPIDefine(hsData, kpiInfo);
        if (!processFlag) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"dif_kpi"));
        }
        processFlag = this.checkWarnParamValue(ctx, hsData, kpiInfo);
        if (!processFlag) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"edge_value_error"));
        }
        kpiValueInfo = this.getExistKpiValueInfo(ctx, hsData, kpiInfo);
        Date date = new Date();
        if (null == kpiValueInfo) {
            newKpiValue = this.newKpiValue(ctx, hsData, kpiInfo, date);
        } else {
            this.setExistKpiValue(true);
            newKpiValue = this.updateKpiValue(ctx, hsData, kpiInfo, kpiValueInfo);
        }
        return newKpiValue;
    }

    private boolean getExistCompanyInfo(Context ctx, Hashtable hsData) throws TaskExternalException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        String companyNumber = hsData.get("company.number").toString();
        String companyName = hsData.get("company.name").toString();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        StringBuffer mask = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyInfo.getNumber(), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(companyInfo.getNumber() + "!%"), CompareType.LIKE));
        mask.append(" #0 or #1 ");
        filter.setMaskString(mask.toString());
        view.setFilter(filter);
        SorterItemInfo sorterInfo = new SorterItemInfo("longNumber");
        sorterInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(sorterInfo);
        CompanyOrgUnitCollection cols = null;
        try {
            cols = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
            if (cols.size() > 0) {
                for (CompanyOrgUnitInfo orgUnitInfo : cols) {
                    if (!companyNumber.equals(orgUnitInfo.getNumber()) || !companyName.equals(orgUnitInfo.getName())) continue;
                    return true;
                }
                return false;
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("getExistCompanyInfo exception..");
        }
        return false;
    }

    public KPIInfo getExistKpiInfo(Context ctx, Hashtable hsData) throws TaskExternalException {
        String companyNumber = hsData.get("company.number").toString();
        String companyName = hsData.get("company.name").toString();
        String kpiNumber = hsData.get("kpi.number").toString();
        String kpiName = hsData.get("kpi.name").toString();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("partFI.*"));
        view.getSelector().add(new SelectorItemInfo("warnParam.*"));
        view.getSelector().add(new SelectorItemInfo("warnParam.edgeParam.*"));
        view.getSelector().add(new SelectorItemInfo("warnParam.warnGroup.*"));
        view.getSelector().add(new SelectorItemInfo("currentWarnStatus.*"));
        view.getSelector().add(new SelectorItemInfo("refValue.*"));
        view.getSelector().add(new SelectorItemInfo("refValue.refGroup.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("partFI.number", (Object)companyNumber));
        filter.getFilterItems().add(new FilterItemInfo("partFI.name", (Object)companyName));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)kpiNumber));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)kpiName));
        view.setFilter(filter);
        KPICollection kpiCols = null;
        try {
            kpiCols = KPIFactory.getLocalInstance(ctx).getKPICollection(view);
        }
        catch (Exception e) {
            throw new TaskExternalException("getExistKpiInfo exception..");
        }
        if (null != kpiCols && kpiCols.size() > 0) {
            return kpiCols.get(0);
        }
        return null;
    }

    private boolean checkStandardValueColumn(Hashtable hsData, KPIInfo kpiInfo) throws TaskExternalException {
        String currentName = "";
        String currentValue = "";
        int fileStdSize = 0;
        int tempSize = 5;
        KPIRefStandardValueNewCollection stdCols = kpiInfo.getRefValue();
        if (stdCols.size() < 6) {
            tempSize = 5;
        } else if (stdCols.size() < 11) {
            tempSize = 10;
        } else if (stdCols.size() < 16) {
            tempSize = 15;
        } else if (stdCols.size() < 21) {
            tempSize = 20;
        }
        for (int i = 1; i <= tempSize; ++i) {
            currentName = hsData.get("stdValue.name" + i).toString();
            currentValue = hsData.get("stdValue.value" + i).toString();
            if (currentName.equals("")) continue;
            ++fileStdSize;
            try {
                if (!"".equals(currentValue)) {
                    new BigDecimal(currentValue);
                }
                this.fileStdValueMap.put(currentName, KPIValueHandle.nullToString(currentValue));
                continue;
            }
            catch (Exception e) {
                throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpivalue_standardValue_error"));
            }
        }
        if (fileStdSize == stdCols.size()) {
            String refGroupName2 = null;
            Iterator it = null;
            it = stdCols.iterator();
            while (it.hasNext()) {
                KPIRefStandardValueNewInfo stdValueNewInfo = (KPIRefStandardValueNewInfo)it.next();
                refGroupName2 = stdValueNewInfo.getRefGroup().getName();
                if (null != this.fileStdValueMap.get(refGroupName2)) continue;
                return false;
            }
            boolean tempFlag = false;
            for (String refGroupName2 : this.fileStdValueMap.keySet()) {
                Iterator itCols = stdCols.iterator();
                while (itCols.hasNext()) {
                    KPIRefStandardValueNewInfo stdValueNewInfo = (KPIRefStandardValueNewInfo)itCols.next();
                    if (!refGroupName2.equals(stdValueNewInfo.getRefGroup().getName())) continue;
                    tempFlag = true;
                }
                if (tempFlag) {
                    tempFlag = !tempFlag;
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkKPIDefine(Hashtable hsData, KPIInfo kpiInfo) throws TaskExternalException {
        if (!hsData.get("kpi.timeType").toString().equals(kpiInfo.getTimeType().toString())) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"dif_timeType_error"));
        }
        if (!hsData.get("kpi.numberUnit").toString().equals(KPIValueHandle.nullToString(kpiInfo.getNumberUnit()))) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"dif_numberUnit_error"));
        }
        if (!hsData.get("edgeGroup.name").toString().equals(kpiInfo.getCurrentWarnStatus().getName())) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"dif_edgeGroup_error"));
        }
        KPIValueHandle.dateFormat(hsData.get("operateTime").toString());
        return true;
    }

    private boolean checkWarnParamValue(Context ctx, Hashtable hsData, KPIInfo kpiInfo) throws TaskExternalException {
        if (!this.checkWarnParam(ctx, hsData)) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpivalue_warnparam_error") + ":" + EASResource.getString((String)RES, (String)"warnparam_edge_value_error"));
        }
        EdgeGroupInfo edgeInfo = kpiInfo.getCurrentWarnStatus();
        Iterator it = this.edgeParamMap.keySet().iterator();
        int left = edgeInfo.getFormula().indexOf(">");
        int right = edgeInfo.getFormula().indexOf("<");
        String value = null;
        try {
            if (left > -1 && right > -1) {
                this.checkImportValue(hsData, 0);
                if (it.hasNext()) {
                    value = (String)it.next();
                    BigDecimal warnHigh = new BigDecimal((String)this.edgeParamMap.get(value));
                    value = (String)it.next();
                    BigDecimal errorHigh = new BigDecimal((String)this.edgeParamMap.get(value));
                    value = (String)it.next();
                    BigDecimal warnLow = new BigDecimal((String)this.edgeParamMap.get(value));
                    value = (String)it.next();
                    BigDecimal errorLow = new BigDecimal((String)this.edgeParamMap.get(value));
                    if (errorHigh.compareTo(warnHigh) <= 0 || warnHigh.compareTo(warnLow) <= 0 || warnLow.compareTo(errorLow) <= 0) {
                        return false;
                    }
                }
            } else if (left > -1 && right == -1) {
                this.checkImportValue(hsData, 1);
                if (it.hasNext()) {
                    value = (String)it.next();
                    BigDecimal warnHigh = new BigDecimal((String)this.edgeParamMap.get(value));
                    value = (String)it.next();
                    BigDecimal errorHigh = new BigDecimal((String)this.edgeParamMap.get(value));
                    if (errorHigh.compareTo(warnHigh) <= 0) {
                        return false;
                    }
                }
            } else if (left == -1 && right > -1) {
                this.checkImportValue(hsData, 1);
                if (it.hasNext()) {
                    BigDecimal errorLow;
                    value = (String)it.next();
                    BigDecimal warnLow = new BigDecimal((String)this.edgeParamMap.get(value));
                    if (warnLow.compareTo(errorLow = new BigDecimal((String)this.edgeParamMap.get(value = (String)it.next()))) <= 0) {
                        return false;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpivalue_warnparam_error"));
        }
        return true;
    }

    private boolean checkWarnParam(Context ctx, Hashtable hsData) throws TaskExternalException {
        String edgeName = hsData.get("edgeGroup.name").toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        EdgeGroupCollection edgeCols = null;
        EdgeGroupInfo edgeGroupInfo = null;
        for (int i = 1; i < 5; ++i) {
            String wp = hsData.get("warnParam.name" + i).toString();
            if (null == wp || "" == wp) continue;
            if (null != hsData.get("warnParam.value" + i)) {
                this.warnParamMap.put(wp, hsData.get("warnParam.value" + i).toString());
                continue;
            }
            return false;
        }
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)edgeName));
        view.setFilter(filter);
        try {
            edgeCols = EdgeGroupFactory.getLocalInstance(ctx).getEdgeGroupCollection(view);
            if (null != edgeCols && edgeCols.size() > 0) {
                edgeGroupInfo = edgeCols.get(0);
                filter.getFilterItems().clear();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)edgeGroupInfo.getId().toString()));
                IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.sem.mp.app.EdgeGroupParamQuery"));
                exec.setObjectView(view);
                IRowSet rsParam = exec.executeQuery();
                IWarnGroup warnGroup = WarnGroupFactory.getLocalInstance(ctx);
                WarnGroupCollection warnGroupCol = warnGroup.getWarnGroupCollection("order by periority desc");
                WarnGroupInfo wgInfo = null;
                int warnCount = warnGroupCol.size();
                for (int i = 0; i < warnCount; ++i) {
                    wgInfo = warnGroupCol.get(i);
                    if (wgInfo.getPeriority() != 2) continue;
                    warnGroupCol.remove(wgInfo);
                    break;
                }
                IEdgeParam edgeParma = EdgeParamFactory.getLocalInstance(ctx);
                EdgeParamInfo edgeParamInfo = null;
                WarnGroupInfo warnGroupInfo = null;
                rsParam.beforeFirst();
                int warnGroupCount = warnGroupCol.size();
                while (rsParam.next()) {
                    for (int i = 0; i < warnGroupCount; ++i) {
                        warnGroupInfo = warnGroupCol.get(i);
                        edgeParamInfo = edgeParma.getEdgeParamInfo((IObjectPK)new ObjectUuidPK(rsParam.getString("edgeParam.id")));
                        this.edgeParamMap.put(warnGroupInfo.getName() + edgeParamInfo.getName(), this.warnParamMap.get(warnGroupInfo.getName() + edgeParamInfo.getName()));
                    }
                }
                if (this.edgeParamMap.size() == this.warnParamMap.size()) {
                    Iterator edgeParamMapIt = this.edgeParamMap.keySet().iterator();
                    while (edgeParamMapIt.hasNext()) {
                        Object obj = this.warnParamMap.get(edgeParamMapIt.next());
                        if (null != obj) continue;
                        return false;
                    }
                    Iterator fileMapIt = this.warnParamMap.keySet().iterator();
                    while (fileMapIt.hasNext()) {
                        Object obj = this.edgeParamMap.get(fileMapIt.next());
                        if (null != obj) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpivalue_warnparam_error"));
        }
    }

    private KPIValueInfo getExistKpiValueInfo(Context ctx, Hashtable hsData, KPIInfo kpiInfo) throws TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sc = view.getSelector();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("warnparam.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpi.id", (Object)kpiInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", hsData.get("operateTime"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("timeText", (Object)KPIValueHandle.getTimeText(KPIValueHandle.dateFormat(hsData.get("operateTime").toString()), kpiInfo.getTimeType())));
        view.setFilter(filter);
        StringBuffer maskString = new StringBuffer();
        maskString.append(" #0 and ( #1 or #2 )");
        KPIValueInfo kpiValueInfo = null;
        filter.setMaskString(maskString.toString());
        KPIValueCollection cols = null;
        try {
            cols = KPIValueFactory.getLocalInstance(ctx).getKPIValueCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException("getExistKpiValueInfo exception..");
        }
        if (cols != null && cols.size() > 0) {
            kpiValueInfo = cols.get(0);
        }
        return kpiValueInfo;
    }

    private KPIValueInfo newKpiValue(Context ctx, Hashtable hsData, KPIInfo kpiInfo, Date date) throws TaskExternalException {
        BigDecimal kpiValue = null;
        try {
            kpiValue = new BigDecimal(hsData.get("kpiValue").toString());
        }
        catch (Exception e) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpivalue_value_error"));
        }
        date = KPIValueHandle.dateFormat(hsData.get("operateTime").toString());
        KPITimeTypeEnum timeType = kpiInfo.getTimeType();
        String timeText = KPIValueHandle.getTimeText(KPIValueHandle.dateFormat(hsData.get("operateTime").toString()), timeType);
        KPIValueInfo valueInfo = new KPIValueInfo();
        valueInfo.setBizDate(date);
        valueInfo.setId(BOSUuid.create((BOSObjectType)valueInfo.getBOSType()));
        Timestamp tempTime = this.getTime();
        valueInfo.setCreateTime(tempTime);
        valueInfo.setLastUpdateTime(tempTime);
        valueInfo.setLastComputeTime(this.getTime());
        String tempNumber = CreateRandomString.getRandomString();
        valueInfo.setNumber(tempNumber);
        valueInfo.setLongnumber(tempNumber);
        valueInfo.setTimeText(timeText);
        valueInfo.setKpi(kpiInfo);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String tempDisplayName = KPITimeHandle.getTimeDisplay(timeType, calendar, LocaleUtils.getLocale((String)"L1"));
        valueInfo.setName(tempDisplayName, LocaleUtils.getLocale((String)"L1"));
        valueInfo.setDisplayName(tempDisplayName, LocaleUtils.getLocale((String)"L1"));
        tempDisplayName = KPITimeHandle.getTimeDisplay(timeType, calendar, LocaleUtils.getLocale((String)"L2"));
        valueInfo.setName(tempDisplayName, LocaleUtils.getLocale((String)"L2"));
        valueInfo.setDisplayName(tempDisplayName, LocaleUtils.getLocale((String)"L2"));
        tempDisplayName = KPITimeHandle.getTimeDisplay(timeType, calendar, LocaleUtils.getLocale((String)"L3"));
        valueInfo.setDisplayName(tempDisplayName, LocaleUtils.getLocale((String)"L3"));
        valueInfo.setName(tempDisplayName, LocaleUtils.getLocale((String)"L3"));
        valueInfo.setKpiValue(kpiValue);
        KPIWarnParamNewCollection tempWarnCols = kpiInfo.getWarnParam();
        if (kpiInfo.isIsWarnable()) {
            this.setKpiValueCurrentWarn(ctx, kpiInfo, valueInfo, tempWarnCols);
        } else {
            valueInfo.setCurrentWarnStatus(null);
        }
        return valueInfo;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private void setKpiValueCurrentWarn(Context ctx, KPIInfo kpiInfo, KPIValueInfo valueInfo, KPIWarnParamNewCollection params) throws TaskExternalException {
        if (params == null) {
            return;
        }
        if (params != null) {
            BigDecimal kpiValue = valueInfo.getKpiValue();
            HashMap<String, BigDecimal> paramsMap = new HashMap<String, BigDecimal>();
            int paramCount = params.size();
            for (int i = 0; i < paramCount; ++i) {
                KPIWarnParamNewInfo paramInfo = params.get(i);
                paramsMap.put(paramInfo.getEdgeParam().getId().toString() + paramInfo.getWarnGroup().getId().toString(), paramInfo.getCurrentValue());
            }
            try {
                String egFormula = " " + kpiInfo.getCurrentWarnStatus().getFormula();
                IWarnGroup warnGroup = WarnGroupFactory.getLocalInstance(ctx);
                EntityViewInfo wgevi = new EntityViewInfo();
                SorterItemInfo sort = new SorterItemInfo("periority");
                sort.setSortType(SortType.ASCEND);
                wgevi.getSorter().add(sort);
                WarnGroupCollection wgs = warnGroup.getWarnGroupCollection(wgevi);
                if (wgs != null) {
                    int i;
                    int wgCount = wgs.size();
                    for (i = 0; i < wgCount - 1; ++i) {
                        WarnGroupInfo wgInfo = wgs.get(i);
                        StringTokenizer st = new StringTokenizer(egFormula, "$");
                        StringBuffer scriptFormula = new StringBuffer();
                        boolean flag = true;
                        while (st.hasMoreTokens()) {
                            if (flag) {
                                scriptFormula.append(st.nextToken());
                            } else {
                                String token = st.nextToken();
                                if (token.equalsIgnoreCase("CURRENTVALUE")) {
                                    scriptFormula.append(kpiValue);
                                } else {
                                    token = token + wgInfo.getId().toString();
                                    BigDecimal paramValue = (BigDecimal)paramsMap.get(token);
                                    scriptFormula.append(paramValue);
                                }
                            }
                            flag = !flag;
                        }
                        boolean result = (Boolean)ScriptUtil.evalExpr((String)scriptFormula.toString(), null);
                        if (result) break;
                    }
                    if (i < wgCount) {
                        valueInfo.setCurrentWarnStatus(wgs.get(i));
                    }
                }
            }
            catch (Exception e) {
                throw new TaskExternalException("setKpiValueCurrentWarn exception..");
            }
        }
    }

    private KPIValueInfo updateKpiValue(Context ctx, Hashtable hsData, KPIInfo kpiInfo, KPIValueInfo valueInfo) throws TaskExternalException {
        try {
            valueInfo.setKpiValue(new BigDecimal(hsData.get("kpiValue").toString()));
            if (kpiInfo.isIsWarnable()) {
                this.setKpiValueCurrentWarn(ctx, kpiInfo, valueInfo, kpiInfo.getWarnParam());
            } else {
                valueInfo.setCurrentWarnStatus(null);
            }
            return valueInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException("updateKpiValue exception..");
        }
    }

    public KPIInfo getKpiInfo() {
        return this.kpiInfo;
    }

    public void setKpiInfo(KPIInfo kpiInfo) {
        this.kpiInfo = kpiInfo;
    }

    public boolean isExistKpiValue() {
        return this.isExistKpiValue;
    }

    public void setExistKpiValue(boolean isExistKpiValue) {
        this.isExistKpiValue = isExistKpiValue;
    }

    public Map getFileStdValueMap() {
        return this.fileStdValueMap;
    }

    public void setFileStdValueMap(Map fileStdValueMap) {
        this.fileStdValueMap = fileStdValueMap;
    }

    public Map getWarnParamMap() {
        return this.warnParamMap;
    }

    public void setWarnParamMap(Map warnParamMap) {
        this.warnParamMap = warnParamMap;
    }

    private static Date dateFormat(String date) throws TaskExternalException {
        Date strtodate = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            strtodate = formatter.parse(date);
        }
        catch (Exception e) {
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpivalue_import_timeType_error"));
        }
        return strtodate;
    }

    private static String getTimeText(Date currentDate, KPITimeTypeEnum timeType) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        return KPITimeHandle.getTimeText(timeType, calendar);
    }

    private String getDisplayName(Date currentDate, KPITimeTypeEnum timeType, Locale locale) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        return KPITimeHandle.getTimeDisplay(timeType, calendar, locale);
    }

    private void checkImportValue(Hashtable hsData, int i) throws TaskExternalException {
        if (i == 0) {
            String wpName1 = hsData.get("warnParam.name1").toString();
            String wpName2 = hsData.get("warnParam.name2").toString();
            String wpName3 = hsData.get("warnParam.name3").toString();
            String wpName4 = hsData.get("warnParam.name4").toString();
            if ("".equals(wpName1) || "".equals(wpName2) || "".equals(wpName3) || "".equals(wpName4)) {
                throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpivalue_warnparam_name_error"));
            }
        } else if (i == 1) {
            String wpName1 = hsData.get("warnParam.name1").toString();
            String wpName2 = hsData.get("warnParam.name2").toString();
            if ("".equals(wpName1) || "".equals(wpName2)) {
                throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpivalue_warnparam_name_error"));
            }
        }
    }

    private static Object nullToString(Object value) {
        if (null != value) {
            return value;
        }
        return "";
    }

    private void init() {
        this.fileStdValueMap.clear();
        this.warnParamMap.clear();
        this.edgeParamMap.clear();
    }
}

