/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.sem.mp.IKPIValueRefStandardValue;
import com.kingdee.eas.sem.mp.IKPIWarnParam;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewCollection;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewInfo;
import com.kingdee.eas.sem.mp.KPITimeTypeEnum;
import com.kingdee.eas.sem.mp.KPIValueFactory;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueCollection;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueFactory;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamFactory;
import com.kingdee.eas.sem.mp.KPIWarnParamInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamNewCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamNewInfo;
import com.kingdee.eas.sem.mp.app.KPIValueHandle;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class KPIValueTransmission
extends AbstractDataTransmission {
    private KPIValueHandle kpiDataHandle = new KPIValueHandle();
    protected static final String RES = "com.kingdee.eas.sem.mp.app.KPIAppResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return KPIValueFactory.getLocalInstance(ctx);
        }
        catch (Exception e) {
            throw new TaskExternalException("BOSException: KPIDataTransmission getLocalInstance", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        return this.kpiDataHandle.transmitMini(hsData, ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        KPIValueInfo kpiValueInfo = (KPIValueInfo)coreBaseInfo;
        if (null != kpiValueInfo) {
            if (!this.isSltImportUpdate()) {
                if (this.kpiDataHandle.isExistKpiValue()) throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpivalue_has_exist"));
                super.submit(coreBaseInfo, ctx);
                this.newKPIValueEntries(ctx, this.kpiDataHandle.getKpiInfo(), kpiValueInfo);
            } else {
                super.submit(coreBaseInfo, ctx);
                if (this.kpiDataHandle.isExistKpiValue()) {
                    this.deleteCollection(ctx, kpiValueInfo.getId().toString());
                }
                this.newKPIValueEntries(ctx, this.kpiDataHandle.getKpiInfo(), kpiValueInfo);
            }
        }
        this.kpiDataHandle.setExistKpiValue(false);
        this.kpiDataHandle.setKpiInfo(null);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            Object objPrecision = rs.getObject("KPI.DISPLAYPRECISION");
            result.put("name", rs.getString("NAME"));
            result.put("kpi.name", rs.getString("KPI.NAME"));
            result.put("kpi.number", rs.getString("KPI.NUMBER"));
            result.put("kpi.timeType", (Object)KPITimeTypeEnum.getEnum(rs.getString("KPI.TIMETYPE")));
            result.put("kpi.numberUnit", rs.getObject("KPI.NUMBERUNIT") == null ? "" : rs.getString("KPI.NUMBERUNIT"));
            if (null == rs.getObject("KPIVALUE")) {
                result.put("kpiValue", new Integer(0));
            } else {
                result.put("kpiValue", rs.getObject("KPIVALUE"));
            }
            result.put("edgeGroup.name", rs.getString("EDGEGROUP.NAME"));
            result.put("company.name", rs.getString("PARTFI.NAME"));
            result.put("company.number", rs.getString("PARTFI.NUMBER"));
            result.put("currentStatus", rs.getString("currentWarnStatus.name"));
            result.put("operateTime", rs.getString("bizDate").substring(0, 10));
            String kpiValueId = rs.getString("ID");
            this.addStandardValue(ctx, result, kpiValueId, objPrecision);
            this.addWarnParam(ctx, result, kpiValueId, objPrecision);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"kpivalue_exportTransmit_error"));
        }
        return result;
    }

    private void addStandardValue(Context ctx, Hashtable result, String kpiValueId, Object obj) throws TaskExternalException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kPIValue", (Object)kpiValueId));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("refGroup.*"));
        evi.getSorter().add(new SorterItemInfo("refGroup.number"));
        try {
            IKPIValueRefStandardValue refValue = KPIValueRefStandardValueFactory.getLocalInstance(ctx);
            KPIValueRefStandardValueCollection cols = refValue.getKPIValueRefStandardValueCollection(evi);
            if (null != cols && cols.size() > 0) {
                int i = 1;
                Iterator it = cols.iterator();
                while (it.hasNext()) {
                    KPIValueRefStandardValueInfo refInfo = (KPIValueRefStandardValueInfo)it.next();
                    result.put("stdValue.name" + i, refInfo.getRefGroup().getName());
                    result.put("stdValue.value" + i, KPIValueTransmission.nullToString(refInfo.getRefValue()));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException("SQLException:KPIDataTransmission addStandardValue ", (Throwable)e);
        }
    }

    private void addWarnParam(Context ctx, Hashtable result, String kpiValueId, Object obj) throws TaskExternalException {
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            evi.setFilter(filter);
            evi.getSelector().add("*");
            evi.getSelector().add("warnGroup.*");
            evi.getSelector().add("edgeParam.*");
            evi.getSorter().add(new SorterItemInfo("warnGroup.name"));
            evi.getSorter().add(new SorterItemInfo("edgeParam.name"));
            filter.getFilterItems().add(new FilterItemInfo("kpivalue", (Object)kpiValueId));
            KPIWarnParamCollection wpCols = KPIWarnParamFactory.getLocalInstance(ctx).getKPIWarnParamCollection(evi);
            Iterator it = wpCols.iterator();
            int i = 1;
            while (it.hasNext()) {
                KPIWarnParamInfo info = (KPIWarnParamInfo)it.next();
                result.put("warnParam.name" + i, KPIValueTransmission.nullToString(info.getWarnGroup().getName() + info.getEdgeParam().getName()));
                result.put("warnParam.value" + i, KPIValueTransmission.nullToString(info.getCurrentValue()));
                ++i;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException("SQLException:KPIDataTransmission addWarnParam ", (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return super.getExportFilterForQuery(ctx);
    }

    public String getExportQueryInfo(Context ctx) {
        return super.getExportQueryInfo(ctx);
    }

    private static String cutString(String refValue, Object obj) {
        if (null != refValue) {
            try {
                int length = 0;
                if (null != obj) {
                    length = (Integer)obj;
                }
                if (length == 0) {
                    length = 2;
                }
                if (refValue.indexOf(".") > -1 && length > 0) {
                    String[] arr = refValue.split("\\.");
                    if (length <= arr[1].length()) {
                        return arr[0] + "." + arr[1].substring(0, length);
                    }
                    return refValue;
                }
                return refValue;
            }
            catch (Exception exception) {}
        } else {
            return refValue;
        }
        return null;
    }

    private void deleteCollection(Context ctx, String kpiValueID) throws TaskExternalException {
        try {
            String sql = "delete from T_MP_KPIWarnParam where fkpiValue=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{kpiValueID});
            sql = "delete from T_MP_KPIValueRefStandardValue where fkpiValueid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{kpiValueID});
        }
        catch (Exception e) {
            throw new TaskExternalException("deleteCollection exception");
        }
    }

    private void newKPIValueEntries(Context ctx, KPIInfo kpiInfo, KPIValueInfo valueInfo) throws TaskExternalException {
        try {
            KPIRefStandardValueNewCollection standardValueCols = kpiInfo.getRefValue();
            IKPIValueRefStandardValue iREF = KPIValueRefStandardValueFactory.getLocalInstance(ctx);
            KPIValueRefStandardValueCollection tempCols = new KPIValueRefStandardValueCollection();
            for (int i = 0; i < standardValueCols.size(); ++i) {
                KPIValueRefStandardValueInfo rfsInfo = new KPIValueRefStandardValueInfo();
                KPIRefStandardValueNewInfo svn = standardValueCols.get(i);
                if ("".equals(this.kpiDataHandle.getFileStdValueMap().get(svn.getRefGroup().getName()).toString())) {
                    rfsInfo.setRefValue(new BigDecimal(0));
                } else {
                    rfsInfo.setRefValue(new BigDecimal(this.kpiDataHandle.getFileStdValueMap().get(svn.getRefGroup().getName()).toString()));
                }
                rfsInfo.setRefParam(svn.getRefValue());
                rfsInfo.setKPIValue(valueInfo);
                rfsInfo.setRefGroup(svn.getRefGroup());
                iREF.addnew(rfsInfo);
                tempCols.add(rfsInfo);
            }
            KPIWarnParamNewCollection tempWarnCols = kpiInfo.getWarnParam();
            IKPIWarnParam iWarnparam = KPIWarnParamFactory.getLocalInstance(ctx);
            for (int i = 0; i < tempWarnCols.size(); ++i) {
                KPIWarnParamNewInfo wpnf = tempWarnCols.get(i);
                KPIWarnParamInfo warnParamInfo = new KPIWarnParamInfo();
                warnParamInfo.setEdgeParam(wpnf.getEdgeParam());
                warnParamInfo.setWarnGroup(wpnf.getWarnGroup());
                warnParamInfo.setWarnSchema(wpnf.getWarnSchema());
                warnParamInfo.setParamValue(wpnf.getParamValue());
                if ("".equals(this.kpiDataHandle.getWarnParamMap().get(wpnf.getWarnGroup().toString() + wpnf.getEdgeParam().toString()).toString())) {
                    warnParamInfo.setCurrentValue(new BigDecimal(0));
                } else {
                    warnParamInfo.setCurrentValue(new BigDecimal(this.kpiDataHandle.getWarnParamMap().get(wpnf.getWarnGroup().toString() + wpnf.getEdgeParam().toString()).toString()));
                }
                warnParamInfo.setKpiValue(valueInfo);
                iWarnparam.addnew(warnParamInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException("newKPIValueEntries exception");
        }
    }

    public static String getStringDate() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    private static Object nullToString(Object value) {
        if (null != value) {
            return value;
        }
        return "";
    }
}

