/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.IKPIWarnParam;
import com.kingdee.eas.sem.mp.IWarnGroup;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamFactory;
import com.kingdee.eas.sem.mp.KPIWarnParamInfo;
import com.kingdee.eas.sem.mp.KPIWarnShcemaCollection;
import com.kingdee.eas.sem.mp.KPIWarnShcemaFactory;
import com.kingdee.eas.sem.mp.KPIWarnShcemaInfo;
import com.kingdee.eas.sem.mp.MPException;
import com.kingdee.eas.sem.mp.WarnGroupCollection;
import com.kingdee.eas.sem.mp.WarnGroupFactory;
import com.kingdee.eas.sem.mp.WarnGroupInfo;
import com.kingdee.eas.sem.mp.app.AbstractKPIWarnShcemaControllerBean;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.ScriptUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.StringTokenizer;

public class KPIWarnShcemaControllerBean
extends AbstractKPIWarnShcemaControllerBean {
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addNewCheck(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        KPIWarnShcemaInfo info = (KPIWarnShcemaInfo)model;
        this._execWarnSchema(ctx, (IObjectPK)new ObjectUuidPK(info.getKpi().getId().toString()));
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        KPIWarnShcemaInfo info = (KPIWarnShcemaInfo)model;
        this._execWarnSchema(ctx, (IObjectPK)new ObjectUuidPK(info.getKpi().getId().toString()));
    }

    private void addNewCheck(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        KPIWarnShcemaInfo value = (KPIWarnShcemaInfo)model;
        KPIInfo kpiInfo = value.getKpi();
        if (kpiInfo == null) {
            throw new MPException(MPException.KPIBLANKEXCEPTION);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpi", (Object)value.getKpi().getId().toString()));
        evi.setFilter(filter);
        KPIWarnShcemaCollection collection = this.getKPIWarnShcemaCollection(ctx, evi);
        if (collection.size() > 0 && super._exists(ctx, filter)) {
            String name = EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.KPI");
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
        IWarnGroup wg = WarnGroupFactory.getLocalInstance(ctx);
        WarnGroupInfo wgInfo = wg.getLowestValue();
        IKPI kpi = KPIFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.*"));
        KPIInfo kpiInfo2 = kpi.getKPIInfo((IObjectPK)new ObjectUuidPK(value.getKpi().get("id").toString()), selector);
        value.getKpi().setCompany(kpiInfo2.getCompany());
        kpi.submit((CoreBaseInfo)value.getKpi());
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IKPI kpi = KPIFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("kpi.*");
        KPIWarnShcemaInfo kpiWarnSchemaInfo = this.getKPIWarnShcemaInfo(ctx, pk, selector);
        KPIInfo kpiInfo = kpiWarnSchemaInfo.getKpi();
        if (kpiInfo != null) {
            kpiInfo.setCurrentWarnStatus(null);
            kpi.updateWithoutExecuteWarn((IObjectPK)new ObjectUuidPK(kpiInfo.getId().toString()), kpiInfo);
        }
        IKPIWarnParam kpiWarnParam = KPIWarnParamFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("warnSchema", (Object)pk.getKeyValue("id").toString()));
        kpiWarnParam.delete(filter);
        super._delete(ctx, pk);
    }

    protected void _execWarnSchema(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BigDecimal kpiValue;
        HashMap<String, BigDecimal> paramsMap = new HashMap<String, BigDecimal>();
        IKPI kpi = KPIFactory.getLocalInstance(ctx);
        KPIInfo kpiInfo = kpi.getKPIInfo(pk);
        if (kpiInfo.getFormula() != null && kpiInfo.getFormula().length() > 0) {
            kpiValue = kpi.calcFormula(pk);
            kpiInfo.setCurrentValue(kpiValue);
            kpiInfo.setLastComputeTime(new Timestamp(System.currentTimeMillis()));
            kpi.updateWithoutExecuteWarn(pk, kpiInfo);
        } else {
            kpiValue = kpiInfo.getCurrentValue();
        }
        if (kpiInfo.isIsWarnable()) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo wsfilter = new FilterInfo();
            wsfilter.getFilterItems().add(new FilterItemInfo("kpi", (Object)kpiInfo.getId().toString()));
            evi.setFilter(wsfilter);
            evi.getSelector().add("id");
            evi.getSelector().add("edgeGroup.formula");
            KPIWarnShcemaCollection warnSchemas = this.getKPIWarnShcemaCollection(ctx, evi);
            if (warnSchemas != null && warnSchemas.size() > 0) {
                KPIWarnShcemaInfo warnSchemaInfo = warnSchemas.get(0);
                IKPIWarnParam kpiWarnParam = KPIWarnParamFactory.getLocalInstance(ctx);
                EntityViewInfo paramEvi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("warnSchema", (Object)warnSchemaInfo.getId().toString()));
                paramEvi.setFilter(filter);
                paramEvi.getSelector().add("id");
                KPIWarnParamCollection params = kpiWarnParam.getKPIWarnParamCollection(paramEvi);
                if (params != null) {
                    int paramCount = params.size();
                    for (int i = 0; i < paramCount; ++i) {
                        KPIWarnParamInfo paramInfo = params.get(i);
                        ObjectUuidPK paramPk = new ObjectUuidPK(paramInfo.getId().toString());
                        kpiWarnParam.calcCurrentValue((IObjectPK)paramPk);
                        paramInfo = kpiWarnParam.getKPIWarnParamInfo((IObjectPK)paramPk);
                        paramsMap.put(paramInfo.getEdgeParam().getId().toString() + paramInfo.getWarnGroup().getId().toString(), paramInfo.getCurrentValue());
                    }
                    String egFormula = " " + warnSchemaInfo.getEdgeGroup().getFormula();
                    IWarnGroup warnGroup = WarnGroupFactory.getLocalInstance(ctx);
                    EntityViewInfo wgevi = new EntityViewInfo();
                    SorterItemInfo sort = new SorterItemInfo("periority");
                    sort.setSortType(SortType.ASCEND);
                    wgevi.getSorter().add(sort);
                    WarnGroupCollection wgs = warnGroup.getWarnGroupCollection(wgevi);
                    if (wgs != null) {
                        int i;
                        int wgCount = wgs.size();
                        for (i = 0; i < wgCount - 1; ++i) {
                            WarnGroupInfo wgInfo = wgs.get(i);
                            StringTokenizer st = new StringTokenizer(egFormula, "$");
                            StringBuffer scriptFormula = new StringBuffer();
                            boolean flag = true;
                            while (st.hasMoreTokens()) {
                                if (flag) {
                                    scriptFormula.append(st.nextToken());
                                } else {
                                    String token = st.nextToken();
                                    if (token.equalsIgnoreCase("CURRENTVALUE")) {
                                        scriptFormula.append(kpiValue);
                                    } else {
                                        token = token + wgInfo.getId().toString();
                                        BigDecimal paramValue = (BigDecimal)paramsMap.get(token);
                                        scriptFormula.append(paramValue);
                                    }
                                }
                                flag = !flag;
                            }
                            boolean result = (Boolean)ScriptUtil.evalExpr((String)scriptFormula.toString(), null);
                            if (result) break;
                        }
                        if (i < wgCount) {
                            kpi.updateWithoutExecuteWarn(pk, kpiInfo);
                        }
                    }
                }
            }
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String string = "";
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("kpi.*"));
        KPIWarnShcemaInfo info = KPIWarnShcemaFactory.getLocalInstance(ctx).getKPIWarnShcemaInfo(pk, sc);
        if (info != null && info.getKpi() != null) {
            string = info.getKpi().getNumber() + ":" + info.getKpi().getName();
        }
        return string;
    }
}

