/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.sem.mp.DisplaySchemaFactory;
import com.kingdee.eas.sem.mp.DisplaySchemaInfo;
import com.kingdee.eas.sem.mp.KPICollection;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamInfo;
import com.kingdee.eas.sem.mp.MPException;
import com.kingdee.eas.sem.mp.SchemaKPIInfo;
import com.kingdee.eas.sem.mp.app.AbstractSchemaKPIControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SchemaKPIControllerBean
extends AbstractSchemaKPIControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.app.SchemaKPIControllerBean");

    protected void _saveSelectedKPI(Context ctx, String schemaId, String[] selectedKPIsId, Map paramMap) throws BOSException, EASBizException {
        if (null != schemaId && schemaId.trim().length() > 0) {
            String delSql = "delete from T_MP_SchemaKPI where fdisplayschemaid = ?";
            DbUtil.execute((Context)ctx, (String)delSql, (Object[])new Object[]{schemaId});
            String insertSql = "insert into T_MP_SchemaKPI(FID,FDisplaySchemaId,FSelectedKPIId,FKpiOrder) values(?,?,?,?)";
            String id = null;
            SchemaKPIInfo kpiInfo = new SchemaKPIInfo();
            if (null != selectedKPIsId && selectedKPIsId.length > 0) {
                Connection conn = this.getConnection(ctx);
                try {
                    PreparedStatement preStmt = conn.prepareStatement(insertSql);
                    int j = selectedKPIsId.length;
                    for (int i = 0; i < j; ++i) {
                        id = BOSUuid.create((BOSObjectType)kpiInfo.getBOSType()).toString().trim();
                        preStmt.setString(1, id);
                        preStmt.setString(2, schemaId);
                        preStmt.setString(3, selectedKPIsId[i]);
                        preStmt.setInt(4, (Integer)paramMap.get(selectedKPIsId[i]));
                        preStmt.addBatch();
                    }
                    preStmt.executeBatch();
                    preStmt.close();
                }
                catch (SQLException sqlEx) {
                    logger.error((Object)("insert data to T_MP_SchemaKPI err: " + sqlEx.getMessage()));
                    throw new MPException(MPException.SAVEKPIEXCEPTION, sqlEx);
                }
                finally {
                    if (null != conn) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {}
                    }
                }
            }
        }
    }

    protected KPICollection _getSelectedKPI(Context ctx, String schemaId) throws BOSException, EASBizException {
        Object[] param;
        String selectSql;
        IRowSet rowSet;
        KPICollection kpis = null;
        if (null != schemaId && schemaId.trim().length() > 0 && null != (rowSet = DbUtil.executeQuery((Context)ctx, (String)(selectSql = "select FSelectedKPIId from T_MP_SchemaKPI where FDisplaySchemaId = ?"), (Object[])(param = new Object[]{schemaId})))) {
            try {
                EntityViewInfo ev = new EntityViewInfo();
                SelectorItemCollection selector = ev.getSelector();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                selector.add("isPercent");
                selector.add("displayPrecision");
                selector.add("CSF.id");
                selector.add("CSF.name");
                selector.add("CSF.BSC");
                selector.add("CSF.BSC.name");
                selector.add("isWarnable");
                selector.add("company.id");
                selector.add("company.name");
                selector.add("refValue.refGroup.name");
                selector.add("refValue.refValue");
                selector.add("numberUnit");
                selector.add("refValue.refGroup");
                selector.add("company");
                selector.add("formula");
                selector.add("kpiValue.id");
                selector.add("kpiValue.timeText");
                selector.add("kpiValue.name");
                selector.add("kpiValue.kpiValue");
                selector.add("kpiValue.warnparam.id");
                selector.add("kpiValue.warnparam.warnGroup.name");
                selector.add("kpiValue.warnparam.edgeParam.name");
                selector.add("kpiValue.warnparam.paramValue");
                selector.add("kpiValue.warnparam.currentValue");
                selector.add("kpiValue.displayName");
                selector.add("kpiValue.currentWarnStatus.*");
                selector.add("isUnpassedVoucherIncluded");
                FilterInfo filter = new FilterInfo();
                int i = 0;
                StringBuffer mark = new StringBuffer();
                if (rowSet.next()) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)rowSet.getString("FSelectedKPIId")));
                    mark.append("#").append(String.valueOf(i));
                    ++i;
                } else {
                    return null;
                }
                while (rowSet.next()) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)rowSet.getString("FSelectedKPIId")));
                    mark.append(" or #").append(String.valueOf(i));
                    ++i;
                }
                filter.setMaskString(mark.toString());
                ev.setFilter(filter);
                SorterItemInfo sorter = new SorterItemInfo("kpiValue.bizDate");
                sorter.setSortType(SortType.DESCEND);
                ev.getSorter().add(sorter);
                kpis = KPIFactory.getLocalInstance(ctx).getKPICollection(ev);
                this.setKpiWarnParam(kpis, ctx);
            }
            catch (SQLException ex) {
                logger.info((Object)"_getSelectedKPI error!");
                ex.printStackTrace();
                return null;
            }
        }
        return kpis;
    }

    private void setKpiWarnParam(KPICollection kpis, Context ctx) throws BOSException, EASBizException {
        if (null != kpis && kpis.size() > 0) {
            KPIInfo kpiInfo = null;
            Iterator it = kpis.iterator();
            while (it.hasNext()) {
                kpiInfo = (KPIInfo)it.next();
                if (null == kpiInfo) continue;
                this.setKpiWarnShcema(kpiInfo, ctx);
            }
        }
    }

    private void setKpiWarnShcema(KPIInfo kpiInfo, Context ctx) throws BOSException {
        KPIWarnParamCollection wpCols = null;
        KPIWarnParamInfo wpInfo = null;
        KPIValueCollection kpiValueCols = kpiInfo.getKpiValue();
        if (null != kpiValueCols && kpiValueCols.size() > 0 && null != (wpCols = kpiValueCols.get(0).getWarnparam()) && wpCols.size() > 0) {
            Iterator it = wpCols.iterator();
            while (it.hasNext()) {
                wpInfo = (KPIWarnParamInfo)it.next();
                kpiInfo.put(wpInfo.getWarnGroup().getName() + wpInfo.getEdgeParam().getName(), this.getEffectValue(kpiInfo.getDisplayPrecision(), wpInfo.getCurrentValue()));
            }
        }
    }

    private BigDecimal getEffectValue(int precision, BigDecimal value) {
        return value.setScale(precision, 4);
    }

    protected KPICollection _getLastSchemeKPis(Context ctx) throws BOSException {
        KPICollection kpis = new KPICollection();
        String creatorID = ctx.getCaller().toString().trim();
        String comId = ContextUtil.getCurrentAdminUnit((Context)ctx).getId().toString();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("creator", (Object)creatorID));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)comId));
        evi.setFilter(filter);
        SorterItemInfo sort = new SorterItemInfo("lastUpdateTime");
        sort.setSortType(SortType.DESCEND);
        evi.getSorter().add(sort);
        try {
            List list = DisplaySchemaFactory.getLocalInstance(ctx).getPermCollection(creatorID, comId);
            if (null != list && list.size() > 0) {
                String id = ((DisplaySchemaInfo)list.get(0)).getId().toString();
                kpis = this._getSelectedKPI(ctx, id);
            }
        }
        catch (EASBizException e) {
        }
        catch (BOSException e) {
            // empty catch block
        }
        return kpis;
    }
}

