/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sem.mp.BSCCollection;
import com.kingdee.eas.sem.mp.BSCFactory;
import com.kingdee.eas.sem.mp.BSCInfo;
import com.kingdee.eas.sem.mp.IBSC;
import com.kingdee.eas.sem.mp.KPIException;
import com.kingdee.util.LocaleUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BSCAppUtil {
    private static final Logger logger = CoreUIObject.getLogger(BSCAppUtil.class);

    public static List importDataFromParent(Context ctx, IObjectPK[] selectPKs, CompanyOrgUnitInfo org) throws BOSException, EASBizException {
        ArrayList<IObjectPK> list = new ArrayList<IObjectPK>();
        if (org == null) {
            throw new KPIException(KPIException.COMPANY_IS_NULL);
        }
        if (selectPKs == null) {
            throw new KPIException(KPIException.NEED_IMPORT_BSC_ISNULL);
        }
        BSCInfo rootBSC = null;
        rootBSC = BSCAppUtil.getRootBsc(ctx, org);
        if (rootBSC == null) {
            throw new KPIException(KPIException.INIT_BSCROOT_ERROR);
        }
        IBSC ibsc = BSCFactory.getLocalInstance(ctx);
        int num = selectPKs.length;
        for (int i = 0; i < num; ++i) {
            BSCInfo parentInfo = ibsc.getBSCInfo(selectPKs[i]);
            BSCInfo newInfo = (BSCInfo)parentInfo.clone();
            newInfo.setPartFI(org);
            if (parentInfo.getRefBSC() == null) {
                newInfo.setRefBSC(parentInfo);
            }
            newInfo.setParent(rootBSC);
            newInfo.setId(null);
            list.add(ibsc.addnew((CoreBaseInfo)newInfo));
        }
        return list;
    }

    public static List importDataFromParent(Context ctx, BSCCollection bscCols, CompanyOrgUnitInfo org) throws BOSException, EASBizException {
        ArrayList<IObjectPK> list = new ArrayList<IObjectPK>();
        if (org == null) {
            throw new KPIException(KPIException.COMPANY_IS_NULL);
        }
        if (bscCols == null) {
            throw new KPIException(KPIException.NEED_IMPORT_BSC_ISNULL);
        }
        BSCInfo rootBSC = null;
        rootBSC = BSCAppUtil.getRootBsc(ctx, org);
        if (rootBSC == null) {
            throw new KPIException(KPIException.INIT_BSCROOT_ERROR);
        }
        IBSC ibsc = BSCFactory.getLocalInstance(ctx);
        int num = bscCols.size();
        for (int i = 0; i < num; ++i) {
            BSCInfo parentInfo = bscCols.get(i);
            BSCInfo newInfo = (BSCInfo)parentInfo.clone();
            newInfo.setPartFI(org);
            if (parentInfo.getRefBSC() == null) {
                newInfo.setRefBSC(parentInfo);
            }
            newInfo.setParent(rootBSC);
            newInfo.setId(null);
            list.add(ibsc.addnew((CoreBaseInfo)newInfo));
        }
        return list;
    }

    public static BSCInfo getRootBsc(Context ctx, CompanyOrgUnitInfo companyOrgInfo) throws EASBizException, BOSException {
        IBSC ibsc = BSCFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("partfi.id", (Object)companyOrgInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("isRef", (Object)Boolean.TRUE));
        ev.setFilter(filter);
        BSCInfo rootBSC = null;
        BSCCollection bscColl = ibsc.getBSCCollection(ev);
        if (bscColl.size() > 0) {
            rootBSC = bscColl.get(0);
        }
        if (rootBSC == null) {
            rootBSC = BSCAppUtil.initParentBsc(ctx, companyOrgInfo);
        }
        return rootBSC;
    }

    public static BSCInfo initParentBsc(Context ctx, CompanyOrgUnitInfo companyOrgInfo) throws EASBizException, BOSException {
        BSCInfo bscInfo = new BSCInfo();
        bscInfo.setNumber("BSC");
        bscInfo.setName("BSC", LocaleUtils.getLocale((String)"L1"));
        bscInfo.setName("BSC", LocaleUtils.getLocale((String)"L2"));
        bscInfo.setName("BSC", LocaleUtils.getLocale((String)"L3"));
        bscInfo.setIsRef(true);
        bscInfo.setParent(null);
        bscInfo.setPartFI(companyOrgInfo);
        IBSC ibsc = BSCFactory.getLocalInstance(ctx);
        IObjectPK bscId = ibsc.addnew((CoreBaseInfo)bscInfo);
        bscInfo.setId(BOSUuid.read((String)bscId.toString()));
        return bscInfo;
    }
}

