/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sem.mp.BSCCollection;
import com.kingdee.eas.sem.mp.BSCFactory;
import com.kingdee.eas.sem.mp.BSCInfo;
import com.kingdee.eas.sem.mp.CSFCollection;
import com.kingdee.eas.sem.mp.CSFFactory;
import com.kingdee.eas.sem.mp.CSFInfo;
import com.kingdee.eas.sem.mp.IBSC;
import com.kingdee.eas.sem.mp.ICSF;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CSFAppUtil {
    private static final Logger logger = Logger.getLogger(CSFAppUtil.class);

    public static List importDataFromParent(Context ctx, IObjectPK[] selectedPKs, HashMap orgMap) throws BOSException, EASBizException {
        ArrayList<Object> list = new ArrayList<Object>();
        CompanyOrgUnitInfo currentAdminOrg = (CompanyOrgUnitInfo)orgMap.get("currentAdminOrg");
        IBSC ibsc = BSCFactory.getLocalInstance(ctx);
        EntityViewInfo evi0 = new EntityViewInfo();
        FilterInfo filter0 = new FilterInfo();
        filter0.getFilterItems().add(new FilterItemInfo("partfi.id", (Object)currentAdminOrg.getId()));
        evi0.setFilter(filter0);
        BSCCollection bscColl = ibsc.getBSCCollection(evi0);
        ArrayList<String> bscIDList = new ArrayList<String>();
        HashMap<String, BSCInfo> bscFIDMap = new HashMap<String, BSCInfo>();
        HashMap<String, BSCInfo> bscNumMap = new HashMap<String, BSCInfo>();
        HashMap<String, BSCInfo> bscNameMap = new HashMap<String, BSCInfo>();
        BSCInfo parentBSCInfo = null;
        BSCInfo parentBSC = null;
        SelectorItemCollection selector1 = new SelectorItemCollection();
        selector1.add("refBSC.*");
        for (int i = 0; i < bscColl.size(); ++i) {
            BSCInfo bsc = bscColl.get(i);
            if (bsc.isIsRef()) {
                parentBSC = bsc;
            }
            if ((parentBSCInfo = ibsc.getBSCInfo((IObjectPK)new ObjectUuidPK(bsc.getId()), selector1).getRefBSC()) != null) {
                bscIDList.add(parentBSCInfo.getId().toString());
                bscFIDMap.put(parentBSCInfo.getId().toString(), bsc);
            }
            bscNumMap.put(bsc.getNumber(), bsc);
            bscNameMap.put(bsc.getName(), bsc);
        }
        BSCInfo relatedBSCInfo = null;
        BSCInfo newBSCInfo = null;
        IObjectPK bscID = null;
        CSFInfo csfInfo = null;
        CSFInfo newcsf = null;
        boolean isNew = false;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("BSC.*");
        ICSF icsf = CSFFactory.getLocalInstance(ctx);
        int size = selectedPKs.length;
        for (int i = 0; i < size; ++i) {
            csfInfo = icsf.getCSFInfo(selectedPKs[i], selector);
            relatedBSCInfo = csfInfo.getBSC();
            newBSCInfo = null;
            if (parentBSC == null && relatedBSCInfo.getParent() != null) {
                parentBSC = ibsc.getBSCInfo((IObjectPK)new ObjectUuidPK(relatedBSCInfo.getParent().getId()));
                parentBSC.setPartFI(currentAdminOrg);
                parentBSC.setIsRef(true);
                parentBSC.setId(null);
                parentBSC = ibsc.getBSCInfo(ibsc.addnew((CoreBaseInfo)parentBSC));
            }
            if (relatedBSCInfo != null && !bscIDList.contains(relatedBSCInfo.getId().toString())) {
                if (bscNumMap.containsKey(relatedBSCInfo.getNumber())) {
                    newBSCInfo = (BSCInfo)bscNumMap.get(relatedBSCInfo.getNumber());
                } else if (bscNameMap.containsKey(relatedBSCInfo.getName())) {
                    newBSCInfo = (BSCInfo)bscNameMap.get(relatedBSCInfo.getName());
                } else {
                    newBSCInfo = (BSCInfo)relatedBSCInfo.clone();
                    newBSCInfo.setPartFI(currentAdminOrg);
                    newBSCInfo.setParent(parentBSC);
                    newBSCInfo.setRefBSC(relatedBSCInfo);
                    newBSCInfo.setId(null);
                    bscID = ibsc.addnew((CoreBaseInfo)newBSCInfo);
                    newBSCInfo = ibsc.getBSCInfo(bscID);
                    bscIDList.add(relatedBSCInfo.getId().toString());
                    bscFIDMap.put(relatedBSCInfo.getId().toString(), newBSCInfo);
                }
            }
            CSFInfo tempCsfInfo = null;
            String numberFilter = "select id where number='" + csfInfo.getNumber() + "' and partfi.id='" + currentAdminOrg.getId().toString() + "'";
            tempCsfInfo = CSFAppUtil.getCsfInfo(ctx, numberFilter);
            if (tempCsfInfo != null) {
                list.add(tempCsfInfo.getId());
                continue;
            }
            String nameFilter = "select id where name='" + csfInfo.getName() + "' and partfi.id='" + currentAdminOrg.getId().toString() + "'";
            tempCsfInfo = CSFAppUtil.getCsfInfo(ctx, nameFilter);
            if (tempCsfInfo != null) {
                list.add(tempCsfInfo.getId());
                continue;
            }
            newcsf = (CSFInfo)csfInfo.clone();
            newcsf.setPartFi(currentAdminOrg);
            newcsf.setParent(csfInfo);
            newcsf.setId(null);
            if (newBSCInfo != null) {
                newcsf.setBSC(newBSCInfo);
            } else if (relatedBSCInfo != null && bscIDList.contains(relatedBSCInfo.getId().toString())) {
                newcsf.setBSC((BSCInfo)bscFIDMap.get(relatedBSCInfo.getId().toString()));
            }
            list.add(icsf.addnew((CoreBaseInfo)newcsf));
        }
        return list;
    }

    private static void importBSC() {
    }

    private static BSCCollection getNeedImportBscCols(Map curBscMap, Map parentBscMap) {
        BSCCollection bscCols = new BSCCollection();
        if (parentBscMap == null || parentBscMap.size() <= 0) {
            return null;
        }
        if (curBscMap == null || curBscMap.size() <= 0) {
            Collection cols = parentBscMap.values();
            Iterator ite = cols.iterator();
            while (ite.hasNext()) {
                bscCols.add((BSCInfo)ite.next());
            }
            return bscCols;
        }
        Set keySet = parentBscMap.keySet();
        Iterator ite = keySet.iterator();
        while (ite.hasNext()) {
            String key = ite.next().toString();
            BSCInfo bscInfo = (BSCInfo)parentBscMap.get(key);
            if (curBscMap.containsKey(bscInfo.getNumber()) || curBscMap.containsKey(bscInfo.getName())) continue;
            bscCols.add(bscInfo);
        }
        return bscCols;
    }

    private static Map getParentBscMap(Context ctx, IObjectPK[] selectedPKs) throws BOSException {
        int csfSize;
        HashMap<String, BSCInfo> bscMap = null;
        CSFCollection csfCols = CSFAppUtil.getParentCsfCols(ctx, selectedPKs);
        if (csfCols != null && (csfSize = csfCols.size()) > 0) {
            bscMap = new HashMap<String, BSCInfo>(csfSize);
            Iterator ite = csfCols.iterator();
            while (ite.hasNext()) {
                CSFInfo tempCsfInfo = (CSFInfo)ite.next();
                BSCInfo tempBscInfo = tempCsfInfo.getBSC();
                if (tempBscInfo != null) {
                    bscMap.put(tempBscInfo.getNumber(), tempBscInfo);
                    bscMap.put(tempBscInfo.getName(), tempBscInfo);
                    continue;
                }
                logger.info((Object)"sem_mp: getParentBscMap error, csf hasn't bsc!");
            }
        }
        return bscMap;
    }

    private static BSCCollection getParentBscCols(Context ctx, IObjectPK[] selectedPKs) throws BOSException {
        BSCCollection bscCols = null;
        CSFCollection csfCols = CSFAppUtil.getParentCsfCols(ctx, selectedPKs);
        if (csfCols != null) {
            bscCols = new BSCCollection();
            Iterator ite = csfCols.iterator();
            while (ite.hasNext()) {
                CSFInfo tempCsfInfo = (CSFInfo)ite.next();
                BSCInfo tempBscInfo = tempCsfInfo.getBSC();
                bscCols.add(tempBscInfo);
            }
        }
        return bscCols;
    }

    private static CSFCollection getParentCsfCols(Context ctx, IObjectPK[] selectedPKs) throws BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("parent.id");
        selector.add("BSC.*");
        selector.add("BSC.refBSC.id");
        ICSF icsf = CSFFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int size = selectedPKs.length;
        for (int i = 0; i < size; ++i) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)selectedPKs[i].toString()));
        }
        ev.setSelector(selector);
        ev.setFilter(filter);
        return icsf.getCSFCollection(ev);
    }

    private static Map getCurrentCompanyBscMap(Context ctx, CompanyOrgUnitInfo currentCompanyOrg) throws BOSException {
        int bscSize;
        HashMap<String, BSCInfo> bscMap = null;
        BSCCollection bscCols = CSFAppUtil.getCurrentCompanyBscCols(ctx, currentCompanyOrg);
        if (bscCols != null && (bscSize = bscCols.size()) > 0) {
            bscMap = new HashMap<String, BSCInfo>(bscSize);
            Iterator ite = bscCols.iterator();
            while (ite.hasNext()) {
                BSCInfo bscInfo = (BSCInfo)ite.next();
                bscMap.put(bscInfo.getNumber(), bscInfo);
                bscMap.put(bscInfo.getName(), bscInfo);
            }
        }
        return bscMap;
    }

    private static BSCCollection getCurrentCompanyBscCols(Context ctx, CompanyOrgUnitInfo currentCompanyOrg) throws BOSException {
        IBSC ibsc = BSCFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("number");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("partfi.id", (Object)currentCompanyOrg.getId()));
        ev.setFilter(filter);
        ev.setSelector(selector);
        return ibsc.getBSCCollection(ev);
    }

    private static CSFInfo getCsfInfo(Context ctx, String filterSql) throws BOSException {
        CSFInfo csfInfo = null;
        CSFCollection csfCols = CSFFactory.getLocalInstance(ctx).getCSFCollection(filterSql);
        if (csfCols != null && csfCols.size() > 0) {
            csfInfo = csfCols.get(0);
        }
        return csfInfo;
    }
}

