/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sem.mp.CSFCollection;
import com.kingdee.eas.sem.mp.CSFFactory;
import com.kingdee.eas.sem.mp.CSFInfo;
import com.kingdee.eas.sem.mp.ICSF;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.IKPIValueRefStandardValue;
import com.kingdee.eas.sem.mp.IRefGroup;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewCollection;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewInfo;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueFactory;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamNewCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamNewInfo;
import com.kingdee.eas.sem.mp.RefGroupCollection;
import com.kingdee.eas.sem.mp.RefGroupFactory;
import com.kingdee.eas.sem.mp.RefGroupInfo;
import com.kingdee.eas.sem.mp.app.util.RefGroupAppUtil;
import com.kingdee.eas.sem.mp.formulaservice.FormulaParseFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class KPICommonHandle {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.app.util.KPICommonHandle");

    public static void cloneKpi(Context ctx, KPIInfo parentInfo, CompanyOrgUnitInfo curCompanyInfo, CompanyOrgUnitInfo parentCompanyOrg, Map curRefMap, Map refGroupMap, Map params, List resultList) throws EASBizException, BOSException {
        String formula;
        Object obj;
        KPIInfo newKpiInfo = (KPIInfo)parentInfo.clone();
        newKpiInfo.getKpiValue().clear();
        newKpiInfo.setId(null);
        if (!curCompanyInfo.isIsBizUnit() && (obj = params.get("setKpiParams")) != null && obj instanceof Boolean && ((Boolean)obj).booleanValue() && (formula = newKpiInfo.getFormula()) != null && ((formula = formula.toLowerCase()).indexOf("DyItem".toLowerCase()) >= 0 || formula.indexOf("AcctItem".toLowerCase()) >= 0)) {
            params.put("company", curCompanyInfo.getId().toString());
            String newFormula = KPICommonHandle.resetFormula(ctx, newKpiInfo.getFormula(), params);
            newKpiInfo.setFormula(newFormula);
        }
        if (parentInfo.getParent() == null) {
            newKpiInfo.setParent(parentInfo);
        } else {
            newKpiInfo.setParent(parentInfo.getParent());
        }
        newKpiInfo.setPartFI(curCompanyInfo);
        KPIRefStandardValueNewCollection refCols = newKpiInfo.getRefValue();
        refCols.clear();
        KPICommonHandle.copyKpiRefStandYardValue(ctx, newKpiInfo, parentInfo.getRefValue(), refCols, curRefMap);
        KPIWarnParamNewCollection newWarnParamCols = newKpiInfo.getWarnParam();
        newWarnParamCols.clear();
        KPICommonHandle.copyKpiWarnParam(ctx, newKpiInfo, parentInfo.getWarnParam(), newWarnParamCols, refGroupMap);
        CSFInfo relatedCSFInfo = parentInfo.getCsf();
        if (relatedCSFInfo != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("partfi.id", (Object)curCompanyInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)relatedCSFInfo.getNumber()));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)relatedCSFInfo.getName()));
            filter.setMaskString(" ( #0 and (#1 or #2)) ");
            ev.setFilter(filter);
            ICSF icsf = CSFFactory.getLocalInstance(ctx);
            CSFCollection csfCols = icsf.getCSFCollection(ev);
            if (csfCols != null && csfCols.size() > 0) {
                CSFInfo tempCsfInfo = csfCols.get(0);
                newKpiInfo.setCsf(tempCsfInfo);
            } else {
                HashMap<String, CompanyOrgUnitInfo> orgMap = new HashMap<String, CompanyOrgUnitInfo>();
                orgMap.put("currentAdminOrg", curCompanyInfo);
                orgMap.put("parentAdminOrg", parentCompanyOrg);
                List tempList = icsf.importDataFromParent(new IObjectPK[]{new ObjectUuidPK(relatedCSFInfo.getId())}, orgMap);
                if (tempList != null && tempList.size() > 0) {
                    String newCsfId = tempList.get(0).toString();
                    CSFInfo tempCsfInfo = icsf.getCSFInfo((IObjectPK)new ObjectUuidPK(newCsfId));
                    newKpiInfo.setCsf(tempCsfInfo);
                }
            }
        }
        IKPI iKpi = KPIFactory.getLocalInstance(ctx);
        IObjectPK tempKpi = iKpi.addnew((CoreBaseInfo)newKpiInfo);
    }

    private static void copyKpiWarnParam(Context ctx, KPIInfo newKpiInfo, KPIWarnParamNewCollection parentWarnCols, KPIWarnParamNewCollection childWarnCols, Map refGroupMap) {
        if (parentWarnCols != null && parentWarnCols.size() > 0) {
            int n = parentWarnCols.size();
            for (int j = 0; j < n; ++j) {
                KPIWarnParamNewInfo paramInfo = (KPIWarnParamNewInfo)parentWarnCols.get(j).clone();
                paramInfo.setId(null);
                paramInfo.setKpi(newKpiInfo);
                String paramValue = paramInfo.getParamValue();
                paramInfo.setParamValue(KPICommonHandle.getNewParamValue(ctx, paramValue, refGroupMap));
                childWarnCols.add(paramInfo);
            }
        }
    }

    private static void copyKpiRefStandYardValue(Context ctx, KPIInfo newKpiInfo, KPIRefStandardValueNewCollection parentRefCols, KPIRefStandardValueNewCollection childRefCols, Map curRefMap) {
        KPIRefStandardValueNewInfo newRefSVInfo;
        RefGroupInfo parentRefInfo;
        KPIRefStandardValueNewInfo parentRefSVInfo;
        Iterator ite = parentRefCols.iterator();
        while (ite.hasNext()) {
            parentRefSVInfo = (KPIRefStandardValueNewInfo)ite.next();
            parentRefInfo = parentRefSVInfo.getRefGroup();
            RefGroupInfo newRefInfo = (RefGroupInfo)curRefMap.get(parentRefInfo.getNumber());
            if (null == newRefInfo) {
                newRefInfo = (RefGroupInfo)curRefMap.get(parentRefInfo.getName());
            }
            newRefSVInfo = (KPIRefStandardValueNewInfo)parentRefSVInfo.clone();
            newRefSVInfo.setKpi(newKpiInfo);
            newRefSVInfo.setId(null);
            if (newRefInfo != null) {
                newRefSVInfo.setRefGroup(newRefInfo);
                childRefCols.add(newRefSVInfo);
                continue;
            }
            logger.info((Object)"sem_mp error:In the copyKpiRefStandYardValue error");
        }
        boolean flag = true;
        Iterator it = curRefMap.keySet().iterator();
        while (it.hasNext()) {
            parentRefInfo = (RefGroupInfo)curRefMap.get(it.next());
            Iterator iter = parentRefCols.iterator();
            while (iter.hasNext()) {
                parentRefSVInfo = (KPIRefStandardValueNewInfo)iter.next();
                if (!parentRefInfo.getName().equals(parentRefSVInfo.getRefGroup().getName())) continue;
                flag = true;
            }
            if (!flag) {
                newRefSVInfo = new KPIRefStandardValueNewInfo();
                newRefSVInfo.setKpi(newKpiInfo);
                newRefSVInfo.setRefGroup(parentRefInfo);
                childRefCols.add(newRefSVInfo);
                continue;
            }
            flag = !flag;
        }
    }

    public static void copyKpiStandyardValue(Context ctx, CompanyOrgUnitInfo currentCompanyhOrg, CompanyOrgUnitInfo parentCompanyOrg) throws BOSException, EASBizException, SQLException {
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" select  \"RefGroup\".fid as id,\"RefGroup\".fnumber as number,");
        sql.append(" \"RefGroup\".fname_").append(loc).append(" as name ");
        sql.append(" from T_MP_RefGroup as \"RefGroup\" ");
        sql.append(" where \"RefGroup\".fpartfi='").append(parentCompanyOrg.getId().toString()).append("'");
        sql.append(" and ( \"RefGroup\".fname_").append(loc).append(" not in(");
        sql.append(" select distinct fname_").append(loc).append(" from T_MP_RefGroup");
        sql.append(" where FPartFI='").append(currentCompanyhOrg.getId().toString()).append("') ");
        sql.append(" and \"RefGroup\".fnumber not in( select distinct fnumber from T_MP_RefGroup");
        sql.append(" where FPartFI='").append(currentCompanyhOrg.getId().toString()).append("')) ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        IObjectPK[] selectedPKs = new IObjectPK[rowSet.size()];
        int i = 0;
        while (rowSet.next()) {
            selectedPKs[i++] = new ObjectUuidPK(rowSet.getString("id"));
        }
        RefGroupAppUtil.importDataFromParent(ctx, selectedPKs, currentCompanyhOrg);
    }

    protected static Map handleRefGroup(Context ctx, OrgUnitInfo currentAdminOrg, OrgUnitInfo parentAdminOrg) throws BOSException, EASBizException, SQLException {
        StringBuffer sqlNumber = new StringBuffer();
        sqlNumber.append(" select \"parent\".fid as parentId,\"child\".fid as childId from ");
        sqlNumber.append(" (select fid ,fnumber from t_mp_refgroup where fpartfi= ?) as \"parent\" inner join ");
        sqlNumber.append(" (select fid ,fnumber from t_mp_refgroup where fpartfi= ?) as \"child\" ");
        sqlNumber.append(" on \"parent\".fnumber = \"child\".fnumber ");
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sqlName = new StringBuffer();
        sqlName.append(" select \"parent\".fid as parentId,\"child\".fid as childId from ");
        sqlName.append(" (select fid,fname_").append(loc).append(" from t_mp_refgroup where fpartfi= ?) as \"parent\" inner join ");
        sqlName.append(" (select fid,fname_").append(loc).append(" from t_mp_refgroup where fpartfi= ?) as \"child\" ");
        sqlName.append(" on \"parent\".fname_").append(loc).append(" = \"child\".fname_").append(loc);
        HashMap<String, String> refGroupMap = new HashMap<String, String>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlName.toString(), (Object[])new String[]{currentAdminOrg.getId().toString(), parentAdminOrg.getId().toString()});
        if (rowSet != null) {
            while (rowSet.next()) {
                refGroupMap.put(rowSet.getString("parentId"), rowSet.getString("childId"));
            }
        }
        if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlNumber.toString(), (Object[])new String[]{currentAdminOrg.getId().toString(), parentAdminOrg.getId().toString()})) != null) {
            while (rowSet.next()) {
                refGroupMap.put(rowSet.getString("parentId"), rowSet.getString("childId"));
            }
        }
        return refGroupMap;
    }

    private static RefGroupInfo getChildRefGroup(Context ctx, String whereSql) {
        RefGroupInfo refInfo = null;
        try {
            IRefGroup iRefGroup = RefGroupFactory.getLocalInstance(ctx);
            RefGroupCollection refCols = iRefGroup.getRefGroupCollection(whereSql);
            if (refCols != null && refCols.size() > 0) {
                refInfo = refCols.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"assign kpi getChildRefGroup error!");
            e.printStackTrace();
        }
        return refInfo;
    }

    public static Map getCompanyRefGroupForID(Context ctx, CompanyOrgUnitInfo companyOrg) throws BOSException {
        HashMap<String, RefGroupInfo> refMap = new HashMap<String, RefGroupInfo>();
        RefGroupInfo refInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("partfi", (Object)companyOrg));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        ev.setFilter(filter);
        ev.setSelector(selector);
        IRefGroup iRefGroup = RefGroupFactory.getLocalInstance(ctx);
        RefGroupCollection refCols = iRefGroup.getRefGroupCollection(ev);
        if (refCols != null) {
            Iterator ite = refCols.iterator();
            refInfo = (RefGroupInfo)ite.next();
            refMap.put(refInfo.getId().toString(), refInfo);
        }
        return refMap;
    }

    public static Map getCompanyRefGroup(Context ctx, CompanyOrgUnitInfo companyOrg) throws BOSException {
        HashMap<String, RefGroupInfo> refMap = new HashMap<String, RefGroupInfo>();
        RefGroupInfo refInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("partfi", (Object)companyOrg.getId().toString()));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        ev.setFilter(filter);
        ev.setSelector(selector);
        IRefGroup iRefGroup = RefGroupFactory.getLocalInstance(ctx);
        RefGroupCollection refCols = iRefGroup.getRefGroupCollection(ev);
        if (refCols != null) {
            Iterator ite = refCols.iterator();
            while (ite.hasNext()) {
                refInfo = (RefGroupInfo)ite.next();
                refMap.put(refInfo.getName(), refInfo);
                refMap.put(refInfo.getNumber(), refInfo);
            }
        }
        return refMap;
    }

    private static String getNewParamValue(Context ctx, String paramValue, Map refGroupMap) {
        if (paramValue == null) {
            return null;
        }
        String tempParamValue = paramValue;
        String paramFormulaValue = " " + tempParamValue;
        StringTokenizer st = new StringTokenizer(paramFormulaValue, "$");
        StringBuffer formula = new StringBuffer();
        boolean flag = true;
        String tempGroupId = "Error";
        while (st.hasMoreTokens()) {
            if (flag) {
                formula.append(st.nextToken());
            } else {
                String refGroupId = st.nextToken();
                Object obj = refGroupMap.get(refGroupId);
                if (obj != null) {
                    tempGroupId = obj.toString();
                }
                tempParamValue = StringUtil.replace((String)tempParamValue, (String)refGroupId, (String)tempGroupId);
            }
            flag = !flag;
        }
        return tempParamValue;
    }

    private static void copyRefGroup(Context ctx, KPIValueInfo kpiValueInfo, String parentKpiValueId, OrgUnitInfo currentAdminOrg, OrgUnitInfo parentAdminOrg) throws BOSException, EASBizException, SQLException {
        IRefGroup iRefGroup = RefGroupFactory.getLocalInstance(ctx);
        RefGroupCollection refCols = iRefGroup.getRefGroupCollection("select *  where company.id='" + currentAdminOrg.getId().toString() + "'");
        StringBuffer sql = new StringBuffer();
        sql.append(" select t2.FRefValue as refvalue from t_mp_refgroup t1 ");
        sql.append("  inner join T_MP_KPIValueRefStandardValue t2 ");
        sql.append("  on t1.fid=t2.FRefGroupID ");
        sql.append("  and t1.fid=? and t2.FKPIValueID=? ");
        if (refCols != null) {
            IKPIValueRefStandardValue iKPIValueRef = KPIValueRefStandardValueFactory.getLocalInstance(ctx);
            int n = refCols.size();
            for (int i = 0; i < n; ++i) {
                StringBuffer tempSql = new StringBuffer();
                tempSql.append(sql);
                RefGroupInfo refInfo = refCols.get(i);
                RefGroupInfo parentRefInfo = refInfo.getParent();
                KPIValueRefStandardValueInfo refStandardInfo = new KPIValueRefStandardValueInfo();
                if (parentRefInfo != null) {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{parentRefInfo.getId().toString(), parentKpiValueId});
                    if (rowSet != null && rowSet.next()) {
                        refStandardInfo.setRefValue(rowSet.getBigDecimal("refvalue"));
                    } else {
                        refStandardInfo.setRefValue(null);
                    }
                } else {
                    refStandardInfo.setRefValue(null);
                }
                refStandardInfo.setKPIValue(kpiValueInfo);
                refStandardInfo.setRefGroup(refInfo);
                iKPIValueRef.addnew(refStandardInfo);
            }
        } else {
            return;
        }
    }

    private static String resetFormula(Context ctx, String formula, Map params) {
        String newFormula = formula;
        if (formula == null) {
            return newFormula;
        }
        String companyId = null;
        String acctItem = null;
        String dyItem = null;
        Object area = null;
        Object obj = params.get("company");
        if (obj == null) {
            logger.info((Object)"resetFormula: company is null");
            return newFormula;
        }
        companyId = obj.toString();
        obj = params.get("acctItemParam");
        if (obj == null) {
            logger.info((Object)"resetFormula: acctItem is null");
            return newFormula;
        }
        acctItem = obj.toString();
        obj = params.get("dyitemparam");
        if (obj == null) {
            logger.info((Object)"resetFormula: dyItem is null");
            return newFormula;
        }
        dyItem = obj.toString();
        Expression express = null;
        try {
            express = FormulaParseFactory.parseFormula(formula);
            FormulaParseFactory.resetFormula(ctx, express, params);
            return express.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void updateKpi(Context ctx, KPIInfo parentInfo, KPIInfo oldKpiInfo, CompanyOrgUnitInfo curCompanyInfo, CompanyOrgUnitInfo parentCompanyOrg, Map curRefMap, Map refGroupMap, Map params, List resultList) throws EASBizException, BOSException {
        String formula;
        Object obj;
        KPIInfo newKpiInfo = (KPIInfo)parentInfo.clone();
        newKpiInfo.setId(oldKpiInfo.getId());
        if (!curCompanyInfo.isIsBizUnit() && (obj = params.get("setKpiParams")) != null && obj instanceof Boolean && ((Boolean)obj).booleanValue() && (formula = newKpiInfo.getFormula()) != null && ((formula = formula.toLowerCase()).indexOf("DyItem".toLowerCase()) >= 0 || formula.indexOf("AcctItem".toLowerCase()) >= 0)) {
            params.put("company", curCompanyInfo.getId().toString());
            String newFormula = KPICommonHandle.resetFormula(ctx, newKpiInfo.getFormula(), params);
            newKpiInfo.setFormula(newFormula);
        }
        if (parentInfo.getParent() == null) {
            newKpiInfo.setParent(parentInfo);
        } else {
            newKpiInfo.setParent(parentInfo.getParent());
        }
        newKpiInfo.setPartFI(curCompanyInfo);
        newKpiInfo.getRefValue().addCollection(oldKpiInfo.getRefValue());
        KPICommonHandle.updateKpiRefStandYardValue(ctx, newKpiInfo, oldKpiInfo, curRefMap);
        newKpiInfo.getRefValue().clear();
        newKpiInfo.getRefValue().addCollection(oldKpiInfo.getRefValue());
        KPICommonHandle.deleteKpiWarnParam(ctx, oldKpiInfo.getId().toString());
        KPIWarnParamNewCollection newWarnParamCols = newKpiInfo.getWarnParam();
        newWarnParamCols.clear();
        KPICommonHandle.copyKpiWarnParam(ctx, newKpiInfo, parentInfo.getWarnParam(), newWarnParamCols, refGroupMap);
        CSFInfo relatedCSFInfo = parentInfo.getCsf();
        if (relatedCSFInfo != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("partfi.id", (Object)curCompanyInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)relatedCSFInfo.getNumber()));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)relatedCSFInfo.getName()));
            filter.setMaskString(" ( #0 and (#1 or #2)) ");
            ev.setFilter(filter);
            ICSF icsf = CSFFactory.getLocalInstance(ctx);
            CSFCollection csfCols = icsf.getCSFCollection(ev);
            if (csfCols != null && csfCols.size() > 0) {
                CSFInfo tempCsfInfo = csfCols.get(0);
                newKpiInfo.setCsf(tempCsfInfo);
            } else {
                HashMap<String, CompanyOrgUnitInfo> orgMap = new HashMap<String, CompanyOrgUnitInfo>();
                orgMap.put("currentAdminOrg", curCompanyInfo);
                orgMap.put("parentAdminOrg", parentCompanyOrg);
                List tempList = icsf.importDataFromParent(new IObjectPK[]{new ObjectUuidPK(relatedCSFInfo.getId())}, orgMap);
                if (tempList != null && tempList.size() > 0) {
                    String newCsfId = tempList.get(0).toString();
                    CSFInfo tempCsfInfo = icsf.getCSFInfo((IObjectPK)new ObjectUuidPK(newCsfId));
                    newKpiInfo.setCsf(tempCsfInfo);
                }
            }
        }
        IKPI iKpi = KPIFactory.getLocalInstance(ctx);
        iKpi.update((IObjectPK)new ObjectUuidPK(newKpiInfo.getId()), (CoreBaseInfo)newKpiInfo);
    }

    private static void updateKpiRefStandYardValue(Context ctx, KPIInfo newKpiInfo, KPIInfo oldKpiInfo, Map curRefMap) {
        KPIRefStandardValueNewInfo newRefSVInfo;
        KPIRefStandardValueNewCollection parentRefCols = newKpiInfo.getRefValue();
        KPIRefStandardValueNewCollection childRefCols = oldKpiInfo.getRefValue();
        KPIRefStandardValueNewInfo parentRefValue = null;
        KPIRefStandardValueNewInfo oldRefValue = null;
        RefGroupInfo parentRefInfo = null;
        Iterator childIter = childRefCols.iterator();
        while (childIter.hasNext()) {
            oldRefValue = (KPIRefStandardValueNewInfo)childIter.next();
            String number = oldRefValue.getRefGroup().getNumber();
            if (number == null) {
                number = oldRefValue.getRefGroup().getName();
            }
            Iterator ite = parentRefCols.iterator();
            while (ite.hasNext()) {
                parentRefValue = (KPIRefStandardValueNewInfo)ite.next();
                parentRefInfo = parentRefValue.getRefGroup();
                if (!parentRefInfo.getNumber().equals(number) && !parentRefInfo.getName().equals(number)) continue;
                oldRefValue.setRefValue(parentRefValue.getRefValue());
            }
        }
        boolean flag = true;
        Iterator it = curRefMap.keySet().iterator();
        while (it.hasNext()) {
            parentRefInfo = (RefGroupInfo)curRefMap.get(it.next());
            Iterator iter = parentRefCols.iterator();
            while (iter.hasNext()) {
                parentRefValue = (KPIRefStandardValueNewInfo)iter.next();
                if (!parentRefInfo.getName().equals(parentRefValue.getRefGroup().getName())) continue;
                flag = true;
            }
            if (!flag) {
                newRefSVInfo = new KPIRefStandardValueNewInfo();
                newRefSVInfo.setKpi(newKpiInfo);
                newRefSVInfo.setRefGroup(parentRefInfo);
                childRefCols.add(newRefSVInfo);
                continue;
            }
            flag = !flag;
        }
        flag = true;
        Iterator iter = parentRefCols.iterator();
        while (iter.hasNext()) {
            parentRefValue = (KPIRefStandardValueNewInfo)iter.next();
            Iterator it2 = childRefCols.iterator();
            while (it2.hasNext()) {
                oldRefValue = (KPIRefStandardValueNewInfo)it2.next();
                if (!oldRefValue.getRefGroup().getName().equals(parentRefValue.getRefGroup().getName())) continue;
                flag = true;
            }
            if (!flag) {
                parentRefInfo = parentRefValue.getRefGroup();
                RefGroupInfo newRefInfo = (RefGroupInfo)curRefMap.get(parentRefInfo.getNumber());
                if (null == newRefInfo) {
                    newRefInfo = (RefGroupInfo)curRefMap.get(parentRefInfo.getName());
                }
                newRefSVInfo = (KPIRefStandardValueNewInfo)parentRefValue.clone();
                newRefSVInfo.setKpi(newKpiInfo);
                newRefSVInfo.setId(null);
                if (newRefInfo != null) {
                    newRefSVInfo.setRefGroup(newRefInfo);
                    childRefCols.add(newRefSVInfo);
                    continue;
                }
                logger.info((Object)"sem_mp error:In the copyKpiRefStandYardValue error");
                continue;
            }
            flag = !flag;
        }
    }

    private static void deleteKpiWarnParam(Context ctx, String kpiId) throws EASBizException, BOSException {
        String sql = "delete from T_MP_KPIWarnParamNew where fkpiid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{kpiId});
    }
}

