/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.formulaservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Area3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.AreaExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BoolExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.EmptyArgExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NumberExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.sem.mp.BGCompanyMapFacadeFactory;
import com.kingdee.eas.sem.mp.KPIFormulaParseException;
import com.kingdee.eas.sem.mp.KPITimeTypeEnum;
import com.kingdee.eas.sem.mp.formulaservice.FormulaInfo;
import com.kingdee.eas.sem.mp.formulaservice.KPIFormulaInfo;
import com.kingdee.eas.sem.mp.formulaservice.KPIFormulaParamsInfo;
import com.kingdee.eas.sem.mp.formulaservice.MultiFormulaInfo;
import com.kingdee.eas.sem.mp.formulaservice.SimpleFormulaInfo;
import com.kingdee.eas.sem.mp.formulaservice.XMLUtil;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.AbstractFormulaTimeService;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.CslLYBQEQService;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.CslYQService;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.FinancialBTETService;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.FinancialBYBQEYEQService;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.FinancialYBQEQService;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.NoTimeService;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class FormulaParseFactory {
    static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.formulaservice");

    public static boolean isMultiFormula(String formula) throws KPIFormulaParseException {
        if (formula == null) {
            throw new KPIFormulaParseException(KPIFormulaParseException.FORMULA_IS_NULL);
        }
        return false;
    }

    public static FormulaInfo parseFormula(Expression expression, KPITimeTypeEnum timeType) throws Exception {
        return FormulaParseFactory.contructFunctionFormula(expression, timeType, false);
    }

    public static FormulaInfo parseFormula(Expression expression, KPITimeTypeEnum timeType, Date date) throws Exception {
        return FormulaParseFactory.contructFunctionFormula(expression, timeType, date);
    }

    public static Expression parseFormula(String formulaLine) throws Exception {
        return ExcelFormulaPaserHelper.parse((String)formulaLine);
    }

    public static boolean hasChangeNotTimeParams(Expression sourceExpr, Expression targetExpr) throws KPIFormulaParseException, FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (sourceExpr == null || targetExpr == null) {
            throw new KPIFormulaParseException(KPIFormulaParseException.FORMULA_IS_NULL);
        }
        if (sourceExpr instanceof FunctionExpr && targetExpr instanceof FunctionExpr) {
            return FormulaParseFactory.hasChangeNotTimeParams((FunctionExpr)sourceExpr, (FunctionExpr)targetExpr);
        }
        if (sourceExpr instanceof UnaryOperationExpr && targetExpr instanceof UnaryOperationExpr) {
            UnaryOperationExpr tempSource = (UnaryOperationExpr)sourceExpr;
            UnaryOperationExpr tempTarget = (UnaryOperationExpr)targetExpr;
            if (tempSource.operationType == tempTarget.operationType) {
                return FormulaParseFactory.hasChangeNotTimeParams(tempSource.operand, tempTarget.operand);
            }
            throw new KPIFormulaParseException(KPIFormulaParseException.NOT_SAME_FORMULA);
        }
        if (sourceExpr instanceof BinaryOperationExpr && targetExpr instanceof BinaryOperationExpr) {
            BinaryOperationExpr tempSource = (BinaryOperationExpr)sourceExpr;
            BinaryOperationExpr tempTarget = (BinaryOperationExpr)targetExpr;
            if (tempSource.operationType == tempTarget.operationType) {
                return FormulaParseFactory.hasChangeNotTimeParams(tempSource.left, tempTarget.left) && FormulaParseFactory.hasChangeNotTimeParams(tempSource.right, tempTarget.right);
            }
            throw new KPIFormulaParseException(KPIFormulaParseException.NOT_SAME_FORMULA);
        }
        if (sourceExpr instanceof IntExpr && targetExpr instanceof IntExpr) {
            return ((IntExpr)sourceExpr).value.intValue() != ((IntExpr)targetExpr).value.intValue();
        }
        if (sourceExpr instanceof NumberExpr && targetExpr instanceof NumberExpr) {
            return ((NumberExpr)sourceExpr).value.compareTo(((NumberExpr)targetExpr).value) != 0;
        }
        if (sourceExpr instanceof StringExpr && targetExpr instanceof StringExpr) {
            return !((StringExpr)sourceExpr).value.equals(((StringExpr)targetExpr).value);
        }
        if (sourceExpr instanceof BoolExpr && targetExpr instanceof BoolExpr) {
            return ((BoolExpr)sourceExpr).value != ((BoolExpr)targetExpr).value;
        }
        if (sourceExpr instanceof AreaExpr && targetExpr instanceof AreaExpr) {
            return false;
        }
        if (sourceExpr instanceof ReferenceExpr && targetExpr instanceof ReferenceExpr) {
            return false;
        }
        if (sourceExpr instanceof Area3DExpr && targetExpr instanceof Area3DExpr) {
            return false;
        }
        if (sourceExpr instanceof Ref3DExpr && targetExpr instanceof Ref3DExpr) {
            return false;
        }
        if (sourceExpr instanceof EmptyArgExpr && targetExpr instanceof EmptyArgExpr) {
            return false;
        }
        throw new KPIFormulaParseException(KPIFormulaParseException.NOT_SAME_FORMULA);
    }

    public static boolean hasChangeNotTimeParams(int[] paramIndex, SimpleFormulaInfo oldInfo, SimpleFormulaInfo newInfo) throws KPIFormulaParseException {
        List oldList = oldInfo.getParams();
        List newList = newInfo.getParams();
        Expression oldExpression = null;
        Expression newExpression = null;
        boolean isEqual = false;
        int paramCount = oldList.size();
        for (int index = 0; index < paramCount; ++index) {
            if (FormulaParseFactory.isTimeParam(paramIndex, index)) continue;
            oldExpression = (Expression)oldList.get(index);
            newExpression = (Expression)newList.get(index);
            if (oldExpression instanceof IntExpr) {
                if (((IntExpr)oldExpression).value.compareTo(((IntExpr)newExpression).value) == 0) continue;
                isEqual = true;
                break;
            }
            if (oldExpression instanceof NumberExpr) {
                if (((NumberExpr)oldExpression).value.compareTo(((NumberExpr)newExpression).value) == 0) continue;
                isEqual = true;
                break;
            }
            if (oldExpression instanceof StringExpr) {
                if (((StringExpr)oldExpression).value.equals(((StringExpr)newExpression).value)) continue;
                isEqual = true;
                break;
            }
            if (oldExpression instanceof BoolExpr) {
                if (((BoolExpr)oldExpression).value == ((BoolExpr)newExpression).value) continue;
                isEqual = true;
                break;
            }
            throw new KPIFormulaParseException(KPIFormulaParseException.TIMEPARAM_TYPE_ERROR);
        }
        int j = paramIndex.length;
        for (int i = 0; i < j; ++i) {
        }
        return isEqual;
    }

    private static boolean isTimeParam(int[] timeParams, int param) {
        int j = timeParams.length;
        for (int i = 0; i < j; ++i) {
            if (param != timeParams[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChangeNotTimeParams(int[] paramIndex, FormulaInfo oldInfo, FormulaInfo newInfo) throws KPIFormulaParseException {
        if (oldInfo instanceof SimpleFormulaInfo && newInfo instanceof SimpleFormulaInfo) {
            return FormulaParseFactory.hasChangeNotTimeParams(paramIndex, oldInfo, newInfo);
        }
        if (oldInfo instanceof MultiFormulaInfo && newInfo instanceof MultiFormulaInfo) {
            return false;
        }
        return false;
    }

    protected static boolean hasUpdateNoTimeParam(SimpleFormulaInfo oldFormula, SimpleFormulaInfo newFormula) throws KPIFormulaParseException {
        List tempList = oldFormula.getTimeParams();
        int timeParamCount = tempList.size();
        int[] tempIndex = new int[timeParamCount];
        for (int i = 0; i < timeParamCount; ++i) {
            tempIndex[i] = ((KPIFormulaParamsInfo)tempList.get(i)).getTimeParamIndex();
        }
        return FormulaParseFactory.hasChangeNotTimeParams(tempIndex, oldFormula, newFormula);
    }

    private static boolean hasChangeNotTimeParams(FunctionExpr sourceExpr, FunctionExpr targetExpr) throws KPIFormulaParseException, FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (sourceExpr == null || targetExpr == null) {
            throw new KPIFormulaParseException(KPIFormulaParseException.FORMULA_IS_NULL);
        }
        if (sourceExpr.funcionName.equals(targetExpr)) {
            SimpleFormulaInfo sourceSim = FormulaParseFactory.contructFunctionFormula(sourceExpr);
            SimpleFormulaInfo targetSim = FormulaParseFactory.contructFunctionFormula(sourceExpr);
            return FormulaParseFactory.hasUpdateNoTimeParam(sourceSim, targetSim);
        }
        throw new KPIFormulaParseException(KPIFormulaParseException.NOT_SAME_FORMULA);
    }

    public static int checkHasTimeParams(String formulaName) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (formulaName == null) {
            return -1;
        }
        HashMap formulas = XMLUtil.getFormula();
        if (formulas.containsKey(formulaName)) {
            return 1;
        }
        return 2;
    }

    public static KPIFormulaInfo getHasTimeFormulaInfo(String formulaName) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (formulaName == null) {
            return null;
        }
        return XMLUtil.getFormulaInfo(formulaName);
    }

    protected String getFormulaName(String formula) {
        if (formula == null) {
            return null;
        }
        String formulaName = null;
        try {
            Expression expression = ExcelFormulaPaserHelper.parse((String)formula);
            formulaName = ((FunctionExpr)expression).funcionName;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formulaName;
    }

    public static boolean isSameFormula(String oneFormula, String twoFormula) throws Exception {
        Expression oneExpression = ExcelFormulaPaserHelper.parse((String)oneFormula);
        Expression twoExpression = ExcelFormulaPaserHelper.parse((String)twoFormula);
        return FormulaParseFactory.isSameFormula(oneExpression, twoExpression);
    }

    public static FormulaInfo contructFunctionFormula(Expression expression, KPITimeTypeEnum timeType, boolean renewTime) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (renewTime) {
            return FormulaParseFactory.contructFunctionFormula(expression, timeType, new Date());
        }
        return FormulaParseFactory.contructFunctionFormula(expression, timeType, null);
    }

    public static FormulaInfo contructFunctionFormula(Expression expression, KPITimeTypeEnum timeType, Date date) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (expression == null) {
            return null;
        }
        FormulaInfo formulaInfo = null;
        if (expression instanceof FunctionExpr) {
            formulaInfo = FormulaParseFactory.contructFunctionFormula_FunctionExpr((FunctionExpr)expression, timeType, date);
            List list = ((FunctionExpr)expression).parameters;
            if (list != null && list.size() > 0) {
                Iterator ite = list.iterator();
                while (ite.hasNext()) {
                    FormulaParseFactory.contructFunctionFormula((Expression)ite.next(), timeType, date);
                }
            }
        } else if (expression instanceof BinaryOperationExpr) {
            formulaInfo = FormulaParseFactory.contructFunctionFormula_BinaryOperationExpr((BinaryOperationExpr)expression, timeType, date);
            List tempList = ((MultiFormulaInfo)formulaInfo).getSubFormula();
            SimpleFormulaInfo tempSimpleInfo = FormulaParseFactory.getFirstSimpleFormulaInfo(tempList);
            if (formulaInfo == null) {
                formulaInfo.setTimeText("");
                formulaInfo.setTimeType("");
                formulaInfo.setDispalyName("\u65e0\u65f6\u95f4\u7eac\u5ea6\uff01");
            } else {
                formulaInfo.setTimeText(tempSimpleInfo.getTimeText());
                formulaInfo.setTimeType(tempSimpleInfo.getTimeType());
                formulaInfo.setDispalyName(tempSimpleInfo.getDispalyName());
            }
        } else {
            formulaInfo = expression instanceof UnaryOperationExpr ? FormulaParseFactory.contructFunctionFormula_UnaryOperationExpr((UnaryOperationExpr)expression, timeType, date) : FormulaParseFactory.contructFunctionFormula_BasicExpr(expression);
        }
        formulaInfo.setHasTimeParam(FormulaParseFactory.checkHasTimeParam(formulaInfo));
        return formulaInfo;
    }

    public static FormulaInfo contructFunctionFormula_BinaryOperationExpr(BinaryOperationExpr binaryOperationExpr, KPITimeTypeEnum timeType, boolean renewTime) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (binaryOperationExpr == null) {
            return null;
        }
        MultiFormulaInfo formulaInfo = new MultiFormulaInfo();
        formulaInfo.setSubFormula(new ArrayList());
        Expression leftExpr = binaryOperationExpr.left;
        Expression rightExpr = binaryOperationExpr.right;
        formulaInfo.getSubFormula().add(FormulaParseFactory.contructFunctionFormula(leftExpr, timeType, renewTime));
        formulaInfo.getSubFormula().add(FormulaParseFactory.contructFunctionFormula(rightExpr, timeType, renewTime));
        return formulaInfo;
    }

    public static FormulaInfo contructFunctionFormula_BinaryOperationExpr(BinaryOperationExpr binaryOperationExpr, KPITimeTypeEnum timeType, Date newTime) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (binaryOperationExpr == null) {
            return null;
        }
        MultiFormulaInfo formulaInfo = new MultiFormulaInfo();
        formulaInfo.setSubFormula(new ArrayList());
        Expression leftExpr = binaryOperationExpr.left;
        Expression rightExpr = binaryOperationExpr.right;
        formulaInfo.getSubFormula().add(FormulaParseFactory.contructFunctionFormula(leftExpr, timeType, newTime));
        formulaInfo.getSubFormula().add(FormulaParseFactory.contructFunctionFormula(rightExpr, timeType, newTime));
        return formulaInfo;
    }

    protected static FormulaInfo contructFunctionFormula_UnaryOperationExpr(UnaryOperationExpr unaryOperationExpr, KPITimeTypeEnum timeType, boolean renewTime) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (unaryOperationExpr == null) {
            return null;
        }
        FormulaInfo formulaInfo = null;
        String operType = unaryOperationExpr.getOperation();
        Expression expression = unaryOperationExpr.operand;
        formulaInfo = FormulaParseFactory.contructFunctionFormula(expression, timeType, renewTime);
        formulaInfo.setFormulaUniqueName(operType + formulaInfo.getFormulaUniqueName());
        return formulaInfo;
    }

    protected static FormulaInfo contructFunctionFormula_UnaryOperationExpr(UnaryOperationExpr unaryOperationExpr, KPITimeTypeEnum timeType, Date newTime) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (unaryOperationExpr == null) {
            return null;
        }
        FormulaInfo formulaInfo = null;
        String operType = unaryOperationExpr.getOperation();
        Expression expression = unaryOperationExpr.operand;
        formulaInfo = FormulaParseFactory.contructFunctionFormula(expression, timeType, newTime);
        formulaInfo.setFormulaUniqueName(operType + formulaInfo.getFormulaUniqueName());
        return formulaInfo;
    }

    protected static SimpleFormulaInfo contructFunctionFormula(FunctionExpr functionExpr) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (functionExpr == null) {
            return null;
        }
        SimpleFormulaInfo formulaInfo = new SimpleFormulaInfo();
        List tempList = FormulaParseFactory.getTimeParams(functionExpr.funcionName);
        formulaInfo.setFormulaUniqueName(functionExpr.funcionName);
        formulaInfo.setFormulaName(functionExpr.funcionName);
        formulaInfo.setFormulaLine(functionExpr.toString());
        formulaInfo.setParams(functionExpr.parameters);
        formulaInfo.setTimeParams(tempList);
        formulaInfo.setHasTimeParam(tempList != null && tempList.size() != 0);
        return formulaInfo;
    }

    protected static SimpleFormulaInfo contructFunctionFormula_FunctionExpr(FunctionExpr functionExpr, KPITimeTypeEnum timeType, boolean reNewTime) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (functionExpr == null) {
            return null;
        }
        SimpleFormulaInfo formulaInfo = new SimpleFormulaInfo();
        KPIFormulaInfo kpiFormulaInfo = FormulaParseFactory.parseKPIFormulaInfo(functionExpr.funcionName);
        if (kpiFormulaInfo != null) {
            AbstractFormulaTimeService timeService = "CslRptFormula_LYBQEQ".equalsIgnoreCase(kpiFormulaInfo.getFormulaTimeType()) ? new CslLYBQEQService() : ("CslRptFormula_LYQ".equalsIgnoreCase(kpiFormulaInfo.getFormulaTimeType()) ? new CslYQService() : ("Financial_BYBQEYEQ".equalsIgnoreCase(kpiFormulaInfo.getFormulaTimeType()) ? new FinancialBYBQEYEQService() : ("Financial_YBQEQ".equalsIgnoreCase(kpiFormulaInfo.getFormulaTimeType()) ? new FinancialYBQEQService() : ("Financial_BTET".equalsIgnoreCase(kpiFormulaInfo.getFormulaTimeType()) ? new FinancialBTETService() : new NoTimeService()))));
            if (reNewTime) {
                timeService.resetFormulaTime(formulaInfo, functionExpr, kpiFormulaInfo, new Date(), timeType);
            } else {
                timeService.initFormulaTime(formulaInfo, functionExpr, kpiFormulaInfo, timeType);
            }
        } else {
            logger.info((Object)"\u89e3\u6790\u516c\u5f0f\u51fa\u9519 \uff01");
        }
        return formulaInfo;
    }

    protected static SimpleFormulaInfo contructFunctionFormula_FunctionExpr(FunctionExpr functionExpr, KPITimeTypeEnum timeType, Date newTime) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (functionExpr == null) {
            return null;
        }
        SimpleFormulaInfo formulaInfo = new SimpleFormulaInfo();
        KPIFormulaInfo kpiFormulaInfo = FormulaParseFactory.parseKPIFormulaInfo(functionExpr.funcionName);
        if (kpiFormulaInfo != null) {
            AbstractFormulaTimeService timeService = "CslRptFormula_LYBQEQ".equalsIgnoreCase(kpiFormulaInfo.getFormulaTimeType()) ? new CslLYBQEQService() : ("CslRptFormula_LYQ".equalsIgnoreCase(kpiFormulaInfo.getFormulaTimeType()) ? new CslYQService() : ("Financial_BYBQEYEQ".equalsIgnoreCase(kpiFormulaInfo.getFormulaTimeType()) ? new FinancialBYBQEYEQService() : ("Financial_YBQEQ".equalsIgnoreCase(kpiFormulaInfo.getFormulaTimeType()) ? new FinancialYBQEQService() : ("Financial_BTET".equalsIgnoreCase(kpiFormulaInfo.getFormulaTimeType()) ? new FinancialBTETService() : new NoTimeService()))));
            if (newTime != null) {
                timeService.resetFormulaTime(formulaInfo, functionExpr, kpiFormulaInfo, newTime, timeType);
            } else {
                timeService.initFormulaTime(formulaInfo, functionExpr, kpiFormulaInfo, timeType);
            }
        } else {
            logger.info((Object)"\u8be5\u516c\u5f0f\u6ca1\u6709\u65f6\u95f4\u7ef4\u5ea6 \uff01");
        }
        return formulaInfo;
    }

    protected static FormulaInfo contructFunctionFormula_BasicExpr(Expression expression) {
        SimpleFormulaInfo formulaInfo = null;
        if (expression instanceof IntExpr || expression instanceof NumberExpr || expression instanceof StringExpr || expression instanceof BoolExpr || expression instanceof AreaExpr || expression instanceof ReferenceExpr || expression instanceof Area3DExpr || expression instanceof EmptyArgExpr || expression instanceof EmptyArgExpr) {
            formulaInfo = new SimpleFormulaInfo();
            formulaInfo.setHasTimeParam(false);
            ArrayList<Expression> tempList = new ArrayList<Expression>(1);
            tempList.add(expression);
            formulaInfo.setParams(tempList);
        }
        return formulaInfo;
    }

    private static boolean checkHasTimeParam(FormulaInfo formulaInfo) {
        if (formulaInfo != null) {
            if (formulaInfo instanceof MultiFormulaInfo) {
                List tempList = ((MultiFormulaInfo)formulaInfo).getSubFormula();
                Iterator ite = tempList.iterator();
                if (ite.hasNext()) {
                    FormulaInfo tempFormulaInfo = (FormulaInfo)ite.next();
                    if (tempFormulaInfo instanceof MultiFormulaInfo) {
                        return FormulaParseFactory.checkHasTimeParam((MultiFormulaInfo)tempFormulaInfo);
                    }
                    return ((SimpleFormulaInfo)tempFormulaInfo).isHasTimeParam();
                }
            } else {
                return ((SimpleFormulaInfo)formulaInfo).isHasTimeParam();
            }
        }
        return false;
    }

    public static KPIFormulaInfo parseKPIFormulaInfo(String formulaName) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (formulaName == null) {
            return null;
        }
        HashMap formulas = null;
        formulas = XMLUtil.getFormula();
        Object obj = formulas.get(formulaName.toLowerCase());
        if (obj != null && obj instanceof KPIFormulaInfo) {
            return (KPIFormulaInfo)obj;
        }
        return null;
    }

    protected static List getTimeParams(String formulaName) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (formulaName == null) {
            return null;
        }
        HashMap formulas = null;
        formulas = XMLUtil.getFormula();
        Object obj = formulas.get(formulaName.toLowerCase());
        if (obj != null && obj instanceof KPIFormulaInfo) {
            return ((KPIFormulaInfo)obj).getParams();
        }
        return null;
    }

    public static boolean isSameFormula(Expression sourceExpr, Expression targetExpr) {
        if (sourceExpr == null || targetExpr == null) {
            MsgBox.showInfo((String)"the formula is null");
            SysUtil.abort();
        }
        if (sourceExpr instanceof FunctionExpr && targetExpr instanceof FunctionExpr) {
            return ((FunctionExpr)sourceExpr).funcionName.equals(((FunctionExpr)targetExpr).funcionName);
        }
        if (sourceExpr instanceof UnaryOperationExpr && targetExpr instanceof UnaryOperationExpr) {
            UnaryOperationExpr tempSource = (UnaryOperationExpr)sourceExpr;
            UnaryOperationExpr tempTarget = (UnaryOperationExpr)targetExpr;
            if (tempSource.operationType == tempTarget.operationType) {
                return FormulaParseFactory.isSameFormula(tempSource.operand, tempTarget.operand);
            }
            return false;
        }
        if (sourceExpr instanceof BinaryOperationExpr && targetExpr instanceof BinaryOperationExpr) {
            BinaryOperationExpr tempSource = (BinaryOperationExpr)sourceExpr;
            BinaryOperationExpr tempTarget = (BinaryOperationExpr)targetExpr;
            if (tempSource.operationType == tempTarget.operationType) {
                return FormulaParseFactory.isSameFormula(tempSource.left, tempTarget.left) && FormulaParseFactory.isSameFormula(tempSource.right, tempTarget.right);
            }
            return false;
        }
        if (sourceExpr instanceof IntExpr && targetExpr instanceof IntExpr) {
            return ((IntExpr)sourceExpr).value.intValue() == ((IntExpr)targetExpr).value.intValue();
        }
        if (sourceExpr instanceof NumberExpr && targetExpr instanceof NumberExpr) {
            return ((NumberExpr)sourceExpr).value.compareTo(((NumberExpr)targetExpr).value) == 0;
        }
        if (sourceExpr instanceof StringExpr && targetExpr instanceof StringExpr) {
            return ((StringExpr)sourceExpr).value.equals(((StringExpr)targetExpr).value);
        }
        if (sourceExpr instanceof BoolExpr && targetExpr instanceof BoolExpr) {
            return ((BoolExpr)sourceExpr).value == ((BoolExpr)targetExpr).value;
        }
        if (sourceExpr instanceof AreaExpr && targetExpr instanceof AreaExpr) {
            return true;
        }
        if (sourceExpr instanceof ReferenceExpr && targetExpr instanceof ReferenceExpr) {
            return true;
        }
        if (sourceExpr instanceof Area3DExpr && targetExpr instanceof Area3DExpr) {
            return true;
        }
        if (sourceExpr instanceof Ref3DExpr && targetExpr instanceof Ref3DExpr) {
            return true;
        }
        if (sourceExpr instanceof EmptyArgExpr && targetExpr instanceof EmptyArgExpr) {
            return true;
        }
        return true;
    }

    private static SimpleFormulaInfo getFirstSimpleFormulaInfo(List tempList) {
        if (tempList == null || tempList.size() <= 0) {
            return null;
        }
        Object obj = tempList.get(0);
        if (obj instanceof SimpleFormulaInfo) {
            return (SimpleFormulaInfo)obj;
        }
        if (obj instanceof MultiFormulaInfo) {
            return FormulaParseFactory.getFirstSimpleFormulaInfo(((MultiFormulaInfo)obj).getSubFormula());
        }
        return null;
    }

    public static void resetFormula(Context ctx, Expression expression, Map params) {
        if (expression == null) {
            return;
        }
        if (expression instanceof FunctionExpr) {
            FormulaParseFactory.resetFunctionExpr(ctx, (FunctionExpr)expression, params);
        } else if (expression instanceof BinaryOperationExpr) {
            FormulaParseFactory.resetBinaryOperationExpr(ctx, (BinaryOperationExpr)expression, params);
        } else if (expression instanceof UnaryOperationExpr) {
            FormulaParseFactory.resetUnaryOperationExpr(ctx, (UnaryOperationExpr)expression, params);
        }
    }

    public static void resetBinaryOperationExpr(Context ctx, BinaryOperationExpr binaryOperationExpr, Map params) {
        Expression leftExpr = binaryOperationExpr.left;
        Expression rightExpr = binaryOperationExpr.right;
        FormulaParseFactory.resetFormula(ctx, leftExpr, params);
        FormulaParseFactory.resetFormula(ctx, rightExpr, params);
    }

    public static void resetUnaryOperationExpr(Context ctx, UnaryOperationExpr unaryOperationExpr, Map params) {
        Expression expression = unaryOperationExpr.operand;
        FormulaParseFactory.resetFormula(ctx, expression, params);
    }

    public static void resetFunctionExpr(Context ctx, FunctionExpr functionExpr, Map params) {
        block15: {
            if (functionExpr == null) {
                return;
            }
            try {
                if (!"AcctItem".equalsIgnoreCase(functionExpr.funcionName) && !"DyItem".equalsIgnoreCase(functionExpr.funcionName)) {
                    return;
                }
                KPIFormulaInfo kpiFormulaInfo = FormulaParseFactory.parseKPIFormulaInfo(functionExpr.funcionName);
                if (kpiFormulaInfo == null) break block15;
                String dataSource = null;
                if ("acctItem".equalsIgnoreCase(functionExpr.funcionName)) {
                    dataSource = params.get("acctItemParam").toString();
                } else if ("dyItem".equalsIgnoreCase(functionExpr.funcionName)) {
                    dataSource = params.get("dyitemparam").toString();
                }
                String company = params.get("company").toString();
                HashMap tempMap = kpiFormulaInfo.getParamsMap();
                int dataSourceIndex = ((KPIFormulaParamsInfo)tempMap.get("datasource")).getTimeParamIndex();
                int orgTreeCslRptIndex = ((KPIFormulaParamsInfo)tempMap.get("orgtreecslrpt")).getTimeParamIndex();
                int orgUnitCslRptIndex = ((KPIFormulaParamsInfo)tempMap.get("orgunitcslrpt")).getTimeParamIndex();
                String orgTreeCslRpt = ((StringExpr)functionExpr.parameters.get((int)orgTreeCslRptIndex)).value;
                String companyNumber = null;
                try {
                    companyNumber = BGCompanyMapFacadeFactory.getLocalInstance(ctx).getNumber(orgTreeCslRpt, company);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                if (dataSource != null) {
                    functionExpr.parameters.set(dataSourceIndex, new StringExpr(dataSource));
                }
                if (companyNumber != null) {
                    functionExpr.parameters.set(orgUnitCslRptIndex, new StringExpr(companyNumber));
                }
            }
            catch (FactoryConfigurationError e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            String formula = "AcctItem(\"11\",\"1001002\",\"BB01\",\"BB01\",\"1005\",\"1006\",\"DAILY\",0,0,0,\"NORMAL\",\"BEGINBALANCE\",\"MONEY\",false)";
            KPIFormulaInfo info = FormulaParseFactory.parseKPIFormulaInfo("AcctItem");
            System.out.println(info.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

