/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.formulaservice;

import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.excelformula.expr.Area3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.AreaExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BoolExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.EmptyArgExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NumberExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.sem.mp.formulaservice.FormulaInfo;
import com.kingdee.eas.sem.mp.formulaservice.FormulaParseFactory;
import com.kingdee.eas.sem.mp.formulaservice.KPIFormulaInfo;
import com.kingdee.eas.sem.mp.formulaservice.KPIFormulaParamsInfo;
import com.kingdee.eas.sem.mp.formulaservice.MultiFormulaInfo;
import com.kingdee.eas.sem.mp.formulaservice.SimpleFormulaInfo;
import com.kingdee.eas.sem.mp.formulaservice.XMLUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class FormulaResetFactory {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.formulaservice.FormulaResetFactory");

    public static FormulaInfo reSetFormula(String oldFormula, Date oldDate) throws Exception {
        Expression tempExpr = null;
        tempExpr = FormulaParseFactory.parseFormula(oldFormula);
        FormulaInfo tempFormulaInfo = FormulaResetFactory.parseFormula(tempExpr, oldDate);
        tempFormulaInfo.setFormulaLine(tempExpr.toString());
        return tempFormulaInfo;
    }

    public static FormulaInfo parseFormula(Expression expression, boolean reNewTime) throws Exception {
        return FormulaResetFactory.contructFunctionFormula(expression, reNewTime);
    }

    public static FormulaInfo parseFormula(Expression expression, Date oldDate) throws Exception {
        return FormulaResetFactory.contructFunctionFormula(expression, oldDate);
    }

    public static FormulaInfo contructFunctionFormula(Expression expression, boolean renewTime) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (expression == null) {
            return null;
        }
        FormulaInfo formulaInfo = null;
        formulaInfo = expression instanceof FunctionExpr ? FormulaResetFactory.contructFunctionFormula_FunctionExpr((FunctionExpr)expression, renewTime) : (expression instanceof BinaryOperationExpr ? FormulaResetFactory.contructFunctionFormula_BinaryOperationExpr((BinaryOperationExpr)expression, renewTime) : (expression instanceof UnaryOperationExpr ? FormulaResetFactory.contructFunctionFormula_UnaryOperationExpr((UnaryOperationExpr)expression, renewTime) : FormulaResetFactory.contructFunctionFormula_BasicExpr(expression)));
        formulaInfo.setHasTimeParam(FormulaResetFactory.checkHasTimeParam(formulaInfo));
        return formulaInfo;
    }

    public static FormulaInfo contructFunctionFormula(Expression expression, Date oldDate) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (expression == null) {
            return null;
        }
        FormulaInfo formulaInfo = null;
        formulaInfo = expression instanceof FunctionExpr ? FormulaResetFactory.contructFunctionFormula_FunctionExpr((FunctionExpr)expression, oldDate) : (expression instanceof BinaryOperationExpr ? FormulaResetFactory.contructFunctionFormula_BinaryOperationExpr((BinaryOperationExpr)expression, oldDate) : (expression instanceof UnaryOperationExpr ? FormulaResetFactory.contructFunctionFormula_UnaryOperationExpr((UnaryOperationExpr)expression, oldDate) : FormulaResetFactory.contructFunctionFormula_BasicExpr(expression)));
        formulaInfo.setHasTimeParam(FormulaResetFactory.checkHasTimeParam(formulaInfo));
        return formulaInfo;
    }

    protected static SimpleFormulaInfo contructFunctionFormula_FunctionExpr(FunctionExpr functionExpr, boolean reNewTime) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (functionExpr == null) {
            return null;
        }
        SimpleFormulaInfo formulaInfo = new SimpleFormulaInfo();
        HashMap tempMap = null;
        KPIFormulaInfo kpiFormulaInfo = FormulaResetFactory.parseKPIFormulaInfo(functionExpr.funcionName);
        if (kpiFormulaInfo != null) {
            tempMap = kpiFormulaInfo.getParamsMap();
            if ("CslRptFormula_LYBQEQ".equals(kpiFormulaInfo.getFormulaCategory())) {
                StringBuffer timeText = new StringBuffer();
                int year = 0;
                int beginPeriod = 0;
                int endPeriod = 0;
                int rptPeriodTypeIndex = ((KPIFormulaParamsInfo)tempMap.get("rptPeriodType")).getTimeParamIndex();
                String rptPeriodType = ((StringExpr)functionExpr.parameters.get((int)rptPeriodTypeIndex)).value;
                int yearIndex = ((KPIFormulaParamsInfo)tempMap.get("year")).getTimeParamIndex();
                year = ((IntExpr)functionExpr.parameters.get((int)yearIndex)).value.intValue();
                int beginPeriodIndex = ((KPIFormulaParamsInfo)tempMap.get("beginPeriod")).getTimeParamIndex();
                beginPeriod = ((IntExpr)functionExpr.parameters.get((int)beginPeriodIndex)).value.intValue();
                int endPeriodIndex = ((KPIFormulaParamsInfo)tempMap.get("endPeriod")).getTimeParamIndex();
                endPeriod = ((IntExpr)functionExpr.parameters.get((int)endPeriodIndex)).value.intValue();
                if (reNewTime || year == 0 || beginPeriod == 0 || endPeriod == 0) {
                    RptPeriodTypeEnum periodTypeEnum = RptPeriodTypeEnum.getEnum((String)rptPeriodType);
                    int[] yearAndPeriod = RPTDateUtil.getPeriod((Date)new Date(), (RptPeriodTypeEnum)periodTypeEnum);
                    year = yearAndPeriod[0];
                    beginPeriod = yearAndPeriod[1];
                    endPeriod = yearAndPeriod[1];
                    functionExpr.parameters.set(yearIndex, new IntExpr(new BigInteger(String.valueOf(year))));
                    functionExpr.parameters.set(beginPeriodIndex, new IntExpr(new BigInteger(String.valueOf(beginPeriod))));
                    functionExpr.parameters.set(endPeriodIndex, new IntExpr(new BigInteger(String.valueOf(endPeriod))));
                    formulaInfo.setFormulaLine(functionExpr.toString());
                }
                timeText.append(rptPeriodType).append("!").append(year);
                timeText.append("!").append(beginPeriod);
                timeText.append("!").append(endPeriod);
                formulaInfo.setTimeText(timeText.toString());
                formulaInfo.setFormulaLine(functionExpr.toString());
                StringBuffer displayName = new StringBuffer();
                displayName.append(String.valueOf(year));
                displayName.append("\u5e74");
                displayName.append(String.valueOf(beginPeriod));
                displayName.append("\u671f");
                displayName.append("_");
                displayName.append(String.valueOf(year));
                displayName.append("\u5e74");
                displayName.append(String.valueOf(endPeriod));
                displayName.append("\u671f");
                formulaInfo.setDispalyName(displayName.toString());
                formulaInfo.setTimeType("CslRptFormula_LYBQEQ");
            } else if ("CslRptFormula_LYQ".equals(kpiFormulaInfo.getFormulaCategory())) {
                formulaInfo.setFormulaLine(functionExpr.toString());
                formulaInfo.setTimeParams(kpiFormulaInfo.getParams());
                formulaInfo.setHasTimeParam(kpiFormulaInfo.getParams() != null && kpiFormulaInfo.getParams().size() != 0);
                formulaInfo.setTimeType("CslRptFormula_LYQ");
            } else if ("Financial_BYBQEYEQ".equals(kpiFormulaInfo.getFormulaCategory())) {
                StringBuffer timeText = new StringBuffer();
                String startDate = "";
                String endDate = "";
                int startDateIndex = ((KPIFormulaParamsInfo)tempMap.get("startDate")).getTimeParamIndex();
                startDate = ((StringExpr)functionExpr.parameters.get((int)startDateIndex)).value;
                int endDateIndex = ((KPIFormulaParamsInfo)tempMap.get("endDate")).getTimeParamIndex();
                endDate = ((StringExpr)functionExpr.parameters.get((int)endDateIndex)).value;
                Date date = new Date();
                timeText.append(date.getYear() + 1900);
                timeText.append("-");
                if (date.getMonth() + 1 < 10) {
                    timeText.append("0");
                    timeText.append(date.getMonth() + 1);
                } else {
                    timeText.append(date.getMonth() + 1);
                }
                timeText.append("-");
                if (date.getDate() < 10) {
                    timeText.append("0");
                    timeText.append(date.getDate());
                } else {
                    timeText.append(date.getDate());
                }
                if (reNewTime || startDate == null || "".equals(startDate)) {
                    startDate = timeText.toString();
                    functionExpr.parameters.set(startDateIndex, new StringExpr(timeText.toString()));
                }
                if (reNewTime || endDate == null || "".equals(endDate)) {
                    endDate = timeText.toString();
                    functionExpr.parameters.set(endDateIndex, new StringExpr(timeText.toString()));
                }
                formulaInfo.setTimeText(timeText.toString());
                formulaInfo.setDispalyName(startDate);
                formulaInfo.setFormulaLine(functionExpr.toString());
                formulaInfo.setTimeParams(kpiFormulaInfo.getParams());
                formulaInfo.setHasTimeParam(kpiFormulaInfo.getParams() != null && kpiFormulaInfo.getParams().size() != 0);
                formulaInfo.setTimeType("Financial_BYBQEYEQ");
            } else {
                formulaInfo.setTimeParams(kpiFormulaInfo.getParams());
                formulaInfo.setHasTimeParam(kpiFormulaInfo.getParams() != null && kpiFormulaInfo.getParams().size() != 0);
            }
        } else {
            formulaInfo.setTimeParams(null);
            formulaInfo.setHasTimeParam(false);
        }
        formulaInfo.setFormulaUniqueName(functionExpr.funcionName);
        formulaInfo.setFormulaName(functionExpr.funcionName);
        formulaInfo.setParams(functionExpr.parameters);
        return formulaInfo;
    }

    protected static SimpleFormulaInfo contructFunctionFormula_FunctionExpr(FunctionExpr functionExpr, Date oldDate) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (functionExpr == null) {
            return null;
        }
        SimpleFormulaInfo formulaInfo = new SimpleFormulaInfo();
        HashMap tempMap = null;
        KPIFormulaInfo kpiFormulaInfo = FormulaResetFactory.parseKPIFormulaInfo(functionExpr.funcionName);
        if (kpiFormulaInfo != null) {
            tempMap = kpiFormulaInfo.getParamsMap();
            if ("CslRptFormula_LYBQEQ".equals(kpiFormulaInfo.getFormulaTimeType())) {
                StringBuffer timeText = new StringBuffer();
                int year = 0;
                int beginPeriod = 0;
                int endPeriod = 0;
                int rptPeriodTypeIndex = ((KPIFormulaParamsInfo)tempMap.get("rptperiodtype")).getTimeParamIndex();
                String rptPeriodType = ((StringExpr)functionExpr.parameters.get((int)rptPeriodTypeIndex)).value;
                int yearIndex = ((KPIFormulaParamsInfo)tempMap.get("year")).getTimeParamIndex();
                year = ((IntExpr)functionExpr.parameters.get((int)yearIndex)).value.intValue();
                int beginPeriodIndex = ((KPIFormulaParamsInfo)tempMap.get("beginperiod")).getTimeParamIndex();
                beginPeriod = ((IntExpr)functionExpr.parameters.get((int)beginPeriodIndex)).value.intValue();
                int endPeriodIndex = ((KPIFormulaParamsInfo)tempMap.get("endperiod")).getTimeParamIndex();
                endPeriod = ((IntExpr)functionExpr.parameters.get((int)endPeriodIndex)).value.intValue();
                RptPeriodTypeEnum periodTypeEnum = RptPeriodTypeEnum.getEnum((String)rptPeriodType);
                int[] yearAndPeriod = RPTDateUtil.getPeriod((Date)oldDate, (RptPeriodTypeEnum)periodTypeEnum);
                year = yearAndPeriod[0];
                beginPeriod = yearAndPeriod[1];
                endPeriod = yearAndPeriod[1];
                functionExpr.parameters.set(yearIndex, new IntExpr(new BigInteger(String.valueOf(year))));
                functionExpr.parameters.set(beginPeriodIndex, new IntExpr(new BigInteger(String.valueOf(beginPeriod))));
                functionExpr.parameters.set(endPeriodIndex, new IntExpr(new BigInteger(String.valueOf(endPeriod))));
                formulaInfo.setFormulaLine(functionExpr.toString());
                formulaInfo.setTimeType("CslRptFormula_LYBQEQ");
            } else if (!"CslRptFormula_LYQ".equals(kpiFormulaInfo.getFormulaTimeType())) {
                if ("Financial_BTET".equals(kpiFormulaInfo.getFormulaTimeType())) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    String timeText = format.format(oldDate);
                    int startDateIndex = ((KPIFormulaParamsInfo)tempMap.get("startdate")).getTimeParamIndex();
                    functionExpr.parameters.set(startDateIndex, new StringExpr(timeText));
                    int endDateIndex = ((KPIFormulaParamsInfo)tempMap.get("enddate")).getTimeParamIndex();
                    functionExpr.parameters.set(endDateIndex, new StringExpr(timeText));
                    formulaInfo.setTimeText(timeText);
                    formulaInfo.setDispalyName(timeText);
                    formulaInfo.setFormulaLine(functionExpr.toString());
                    formulaInfo.setTimeParams(kpiFormulaInfo.getParams());
                    formulaInfo.setHasTimeParam(kpiFormulaInfo.getParams() != null && kpiFormulaInfo.getParams().size() != 0);
                    formulaInfo.setTimeType("Financial_BYBQEYEQ");
                } else if ("Financial_BYBQEYEQ".equals(kpiFormulaInfo.getFormulaTimeType())) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    String timeText = format.format(oldDate);
                    int startDateIndex = ((KPIFormulaParamsInfo)tempMap.get("startdate")).getTimeParamIndex();
                    int endDateIndex = ((KPIFormulaParamsInfo)tempMap.get("enddate")).getTimeParamIndex();
                    functionExpr.parameters.set(startDateIndex, new StringExpr(timeText));
                    functionExpr.parameters.set(endDateIndex, new StringExpr(timeText));
                    formulaInfo.setTimeText(timeText.toString());
                    formulaInfo.setDispalyName(timeText);
                    formulaInfo.setFormulaLine(functionExpr.toString());
                    formulaInfo.setTimeParams(kpiFormulaInfo.getParams());
                    formulaInfo.setHasTimeParam(kpiFormulaInfo.getParams() != null && kpiFormulaInfo.getParams().size() != 0);
                    formulaInfo.setTimeType("Financial_BYBQEYEQ");
                } else {
                    formulaInfo.setTimeParams(kpiFormulaInfo.getParams());
                    formulaInfo.setHasTimeParam(kpiFormulaInfo.getParams() != null && kpiFormulaInfo.getParams().size() != 0);
                }
            }
        } else {
            formulaInfo.setTimeParams(null);
            formulaInfo.setHasTimeParam(false);
        }
        formulaInfo.setFormulaUniqueName(functionExpr.funcionName);
        formulaInfo.setFormulaName(functionExpr.funcionName);
        formulaInfo.setParams(functionExpr.parameters);
        return formulaInfo;
    }

    public static FormulaInfo contructFunctionFormula_BinaryOperationExpr(BinaryOperationExpr binaryOperationExpr, boolean renewTime) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (binaryOperationExpr == null) {
            return null;
        }
        MultiFormulaInfo formulaInfo = new MultiFormulaInfo();
        formulaInfo.setSubFormula(new ArrayList());
        Expression leftExpr = binaryOperationExpr.left;
        Expression rightExpr = binaryOperationExpr.right;
        formulaInfo.getSubFormula().add(FormulaResetFactory.contructFunctionFormula(leftExpr, renewTime));
        formulaInfo.getSubFormula().add(FormulaResetFactory.contructFunctionFormula(rightExpr, renewTime));
        List tempList = formulaInfo.getSubFormula();
        if (tempList != null && tempList.size() > 0) {
            int n = tempList.size();
            for (int i = 0; i < n; ++i) {
                if (!(tempList.get(i) instanceof SimpleFormulaInfo)) continue;
                SimpleFormulaInfo tempSimpleInfo = (SimpleFormulaInfo)tempList.get(i);
                formulaInfo.setTimeText(tempSimpleInfo.getTimeText());
                formulaInfo.setTimeType(tempSimpleInfo.getTimeType());
                formulaInfo.setDispalyName(tempSimpleInfo.getDispalyName());
                break;
            }
        }
        return formulaInfo;
    }

    public static FormulaInfo contructFunctionFormula_BinaryOperationExpr(BinaryOperationExpr binaryOperationExpr, Date oldDate) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (binaryOperationExpr == null) {
            return null;
        }
        MultiFormulaInfo formulaInfo = new MultiFormulaInfo();
        formulaInfo.setSubFormula(new ArrayList());
        Expression leftExpr = binaryOperationExpr.left;
        Expression rightExpr = binaryOperationExpr.right;
        formulaInfo.getSubFormula().add(FormulaResetFactory.contructFunctionFormula(leftExpr, oldDate));
        formulaInfo.getSubFormula().add(FormulaResetFactory.contructFunctionFormula(rightExpr, oldDate));
        List tempList = formulaInfo.getSubFormula();
        if (tempList != null && tempList.size() > 0) {
            int n = tempList.size();
            for (int i = 0; i < n; ++i) {
                if (!(tempList.get(i) instanceof SimpleFormulaInfo)) continue;
                SimpleFormulaInfo tempSimpleInfo = (SimpleFormulaInfo)tempList.get(i);
                formulaInfo.setTimeText(tempSimpleInfo.getTimeText());
                formulaInfo.setTimeType(tempSimpleInfo.getTimeType());
                formulaInfo.setDispalyName(tempSimpleInfo.getDispalyName());
                break;
            }
        }
        return formulaInfo;
    }

    protected static FormulaInfo contructFunctionFormula_UnaryOperationExpr(UnaryOperationExpr unaryOperationExpr, boolean renewTime) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (unaryOperationExpr == null) {
            return null;
        }
        FormulaInfo formulaInfo = null;
        String operType = unaryOperationExpr.getOperation();
        Expression expression = unaryOperationExpr.operand;
        formulaInfo = FormulaResetFactory.contructFunctionFormula(expression, renewTime);
        formulaInfo.setFormulaUniqueName(operType + formulaInfo.getFormulaUniqueName());
        return formulaInfo;
    }

    protected static FormulaInfo contructFunctionFormula_UnaryOperationExpr(UnaryOperationExpr unaryOperationExpr, Date oldDate) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (unaryOperationExpr == null) {
            return null;
        }
        FormulaInfo formulaInfo = null;
        String operType = unaryOperationExpr.getOperation();
        Expression expression = unaryOperationExpr.operand;
        formulaInfo = FormulaResetFactory.contructFunctionFormula(expression, oldDate);
        formulaInfo.setFormulaUniqueName(operType + formulaInfo.getFormulaUniqueName());
        return formulaInfo;
    }

    protected static FormulaInfo contructFunctionFormula_BasicExpr(Expression expression) {
        SimpleFormulaInfo formulaInfo = null;
        if (expression instanceof IntExpr || expression instanceof NumberExpr || expression instanceof StringExpr || expression instanceof BoolExpr || expression instanceof AreaExpr || expression instanceof ReferenceExpr || expression instanceof Area3DExpr || expression instanceof EmptyArgExpr || expression instanceof EmptyArgExpr) {
            formulaInfo = new SimpleFormulaInfo();
            formulaInfo.setHasTimeParam(false);
            ArrayList<Expression> tempList = new ArrayList<Expression>(1);
            tempList.add(expression);
            formulaInfo.setParams(tempList);
        }
        return formulaInfo;
    }

    private static boolean checkHasTimeParam(FormulaInfo formulaInfo) {
        if (formulaInfo != null) {
            if (formulaInfo instanceof MultiFormulaInfo) {
                List tempList = ((MultiFormulaInfo)formulaInfo).getSubFormula();
                Iterator ite = tempList.iterator();
                if (ite.hasNext()) {
                    FormulaInfo tempFormulaInfo = (FormulaInfo)ite.next();
                    if (tempFormulaInfo instanceof MultiFormulaInfo) {
                        return FormulaResetFactory.checkHasTimeParam((MultiFormulaInfo)tempFormulaInfo);
                    }
                    return ((SimpleFormulaInfo)tempFormulaInfo).isHasTimeParam();
                }
            } else {
                return ((SimpleFormulaInfo)formulaInfo).isHasTimeParam();
            }
        }
        return false;
    }

    public static KPIFormulaInfo parseKPIFormulaInfo(String formulaName) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (formulaName == null) {
            return null;
        }
        HashMap formulas = null;
        formulas = XMLUtil.getFormula();
        Object obj = formulas.get(formulaName.toLowerCase());
        if (obj != null && obj instanceof KPIFormulaInfo) {
            return (KPIFormulaInfo)obj;
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

