/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.formulaservice.timeservice;

import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.sem.mp.KPITimeTypeEnum;
import com.kingdee.eas.sem.mp.formulaservice.KPIFormulaInfo;
import com.kingdee.eas.sem.mp.formulaservice.KPIFormulaParamsInfo;
import com.kingdee.eas.sem.mp.formulaservice.SimpleFormulaInfo;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.FinancialTimeService;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.KPITimeHandle;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FinancialBTETService
extends FinancialTimeService {
    static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.formulaservice.timeservice.CslLYBQEQService");
    private static final String BEGINDATE = "startdate";
    private static final String ENDDATE = "enddate";

    public void initFormulaTime(SimpleFormulaInfo simpleInfo, FunctionExpr functionExpr, KPIFormulaInfo kpiFormulaInfo, KPITimeTypeEnum timeType) {
    }

    public void resetFormulaTime(SimpleFormulaInfo simpleInfo, FunctionExpr functionExpr, KPIFormulaInfo kpiFormulaInfo, Date date, KPITimeTypeEnum timeType) {
        this.handleKPITime(simpleInfo, functionExpr, kpiFormulaInfo, date, timeType);
    }

    private void handleKPITime(SimpleFormulaInfo simpleInfo, FunctionExpr functionExpr, KPIFormulaInfo kpiFormulaInfo, Date date, KPITimeTypeEnum timeType) {
        String timeText;
        if (simpleInfo == null || functionExpr == null || kpiFormulaInfo == null) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = format.format(date);
        try {
            date = format.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String displayName = timeText = KPITimeHandle.getTimeText(timeType, calendar);
        HashMap tempMap = kpiFormulaInfo.getParamsMap();
        int beginTimeIndex = ((KPIFormulaParamsInfo)tempMap.get(BEGINDATE)).getTimeParamIndex();
        int endTimeIndex = ((KPIFormulaParamsInfo)tempMap.get(ENDDATE)).getTimeParamIndex();
        functionExpr.parameters.set(beginTimeIndex, new StringExpr(dateString));
        functionExpr.parameters.set(endTimeIndex, new StringExpr(dateString));
        simpleInfo.setTimeParams(kpiFormulaInfo.getParams());
        simpleInfo.setFormulaLine(functionExpr.toString());
        simpleInfo.setTimeText(timeText);
        simpleInfo.setFormulaLine(functionExpr.toString());
        simpleInfo.setDispalyName(displayName);
        simpleInfo.setTimeType("CslRptFormula_LYBQEQ");
        simpleInfo.setFormulaUniqueName(functionExpr.funcionName);
        simpleInfo.setFormulaName(functionExpr.funcionName);
        simpleInfo.setParams(functionExpr.parameters);
        simpleInfo.setHasTimeParam(true);
    }
}

