/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.formulaservice.timeservice;

import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.sem.mp.KPITimeTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class KPITimeHandle {
    protected static final String RES = "com.kingdee.eas.sem.mp.MPResource";

    public static String getTimeText(String timeType, Calendar calendar) {
        KPITimeTypeEnum timeTypeEnum = KPITimeTypeEnum.getEnum(timeType);
        return KPITimeHandle.getTimeText(timeTypeEnum, calendar);
    }

    public static String getTimeText(KPITimeTypeEnum timeType, Calendar calendar) {
        StringBuffer displayName = new StringBuffer();
        if (KPITimeTypeEnum.day.equals((Object)timeType)) {
            Date date = calendar.getTime();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            displayName.append(format.format(date));
        } else if (KPITimeTypeEnum.month.equals((Object)timeType)) {
            Date date = calendar.getTime();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            displayName.append(format.format(date));
        } else if (KPITimeTypeEnum.week.equals((Object)timeType)) {
            displayName.append(calendar.get(1));
            displayName.append("-");
            displayName.append(calendar.get(3));
        } else if (KPITimeTypeEnum.season.equals((Object)timeType)) {
            displayName.append(calendar.get(1));
            displayName.append("-");
            int tempMonth = calendar.get(2) + 1;
            if (tempMonth > 0 && tempMonth <= 3) {
                displayName.append(1);
            } else if (tempMonth > 3 && tempMonth <= 6) {
                displayName.append(2);
            } else if (tempMonth > 6 && tempMonth <= 9) {
                displayName.append(3);
            } else if (tempMonth > 9 && tempMonth <= 12) {
                displayName.append(4);
            }
        } else if (KPITimeTypeEnum.halfYear.equals((Object)timeType)) {
            displayName.append(calendar.get(1));
            displayName.append("-");
            int tempMonth = calendar.get(2);
            if (tempMonth <= 5) {
                displayName.append("1");
            } else {
                displayName.append("2");
            }
        } else if (KPITimeTypeEnum.year.equals((Object)timeType)) {
            displayName.append(calendar.get(1));
        } else {
            displayName.append("NoTime");
        }
        return displayName.toString();
    }

    public static String getTimeDisplay(KPITimeTypeEnum timeType, Calendar calendar, Locale locale) {
        StringBuffer displayName = new StringBuffer();
        if (KPITimeTypeEnum.day.equals((Object)timeType)) {
            Date date = calendar.getTime();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            displayName.append(format.format(date));
        } else if (KPITimeTypeEnum.month.equals((Object)timeType)) {
            displayName.append(calendar.get(1));
            displayName.append(ResourceBase.getString((String)RES, (String)"kpi_year", (Locale)locale));
            displayName.append(calendar.get(2) + 1);
            displayName.append(ResourceBase.getString((String)RES, (String)"kpi_month", (Locale)locale));
        } else if (KPITimeTypeEnum.week.equals((Object)timeType)) {
            displayName.append(calendar.get(1));
            displayName.append(ResourceBase.getString((String)RES, (String)"kpi_year", (Locale)locale));
            displayName.append(calendar.get(3));
            displayName.append(ResourceBase.getString((String)RES, (String)"kpi_week", (Locale)locale));
        } else if (KPITimeTypeEnum.season.equals((Object)timeType)) {
            displayName.append(calendar.get(1));
            displayName.append(ResourceBase.getString((String)RES, (String)"kpi_year", (Locale)locale));
            int tempMonth = calendar.get(2) + 1;
            if (tempMonth > 0 && tempMonth <= 3) {
                displayName.append(1);
            } else if (tempMonth > 3 && tempMonth <= 6) {
                displayName.append(2);
            } else if (tempMonth > 6 && tempMonth <= 9) {
                displayName.append(3);
            } else if (tempMonth > 9 && tempMonth <= 12) {
                displayName.append(4);
            }
            displayName.append(ResourceBase.getString((String)RES, (String)"kpi_season", (Locale)locale));
        } else if (KPITimeTypeEnum.halfYear.equals((Object)timeType)) {
            displayName.append(calendar.get(1));
            int tempMonth = calendar.get(2);
            if (tempMonth <= 5) {
                displayName.append(ResourceBase.getString((String)RES, (String)"kpi_halfYear_first", (Locale)locale));
            } else {
                displayName.append(ResourceBase.getString((String)RES, (String)"kpi_halfYear_seconde", (Locale)locale));
            }
        } else if (KPITimeTypeEnum.year.equals((Object)timeType)) {
            displayName.append(calendar.get(1));
            displayName.append(ResourceBase.getString((String)RES, (String)"kpi_year", (Locale)locale));
        } else {
            displayName.append("NoTime!");
        }
        return displayName.toString();
    }

    public static void setKpiCalculateContext(Map context, KPITimeTypeEnum timeType, Calendar calendar) {
        RptPeriodTypeEnum rptReriodEnum;
        Short period;
        Integer year = new Integer(calendar.get(1));
        if (KPITimeTypeEnum.day.equals((Object)timeType)) {
            period = new Short(new Integer(calendar.get(6)).shortValue());
            rptReriodEnum = RptPeriodTypeEnum.DAILY;
        } else if (KPITimeTypeEnum.month.equals((Object)timeType)) {
            period = new Short(new Integer(calendar.get(2) + 1).shortValue());
            rptReriodEnum = RptPeriodTypeEnum.MONTHLY;
        } else if (KPITimeTypeEnum.week.equals((Object)timeType)) {
            period = new Short(new Integer(calendar.get(3)).shortValue());
            rptReriodEnum = RptPeriodTypeEnum.WEEKLY;
        } else if (KPITimeTypeEnum.season.equals((Object)timeType)) {
            int tempMonth = calendar.get(2) + 1;
            period = tempMonth > 0 && tempMonth <= 3 ? new Short(1) : (tempMonth > 3 && tempMonth <= 6 ? new Short(2) : (tempMonth > 6 && tempMonth <= 9 ? new Short(3) : (tempMonth > 9 && tempMonth <= 12 ? new Short(4) : new Short(1))));
            rptReriodEnum = RptPeriodTypeEnum.QUARTERLY;
        } else if (KPITimeTypeEnum.halfYear.equals((Object)timeType)) {
            int tempMonth = calendar.get(2);
            period = tempMonth <= 5 ? new Short(1) : new Short(2);
            rptReriodEnum = RptPeriodTypeEnum.SEMIYEARLY;
        } else if (KPITimeTypeEnum.year.equals((Object)timeType)) {
            period = new Short(new Integer(calendar.get(1)).shortValue());
            rptReriodEnum = RptPeriodTypeEnum.YEARLY;
        } else {
            period = new Short(new Integer(calendar.get(6)).shortValue());
            rptReriodEnum = RptPeriodTypeEnum.DAILY;
        }
        context.put("IContextHandler_period", period);
        context.put("IContextHandler_period_type", rptReriodEnum);
        context.put("IContextHandler_year", year);
    }
}

