/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.client.SysContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BuildOrgTree {
    private static final Logger logger = CoreUIObject.getLogger(BuildOrgTree.class);
    private static BuildOrgTree instance;
    PropertyChangeListener listen = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            BuildOrgTree.this.map = null;
            BuildOrgTree.this.idlists = null;
            BuildOrgTree.this.model = null;
        }
    };
    private HashMap map = null;
    private List idlists = null;
    private TreeModel model = null;

    public static BuildOrgTree getInstance() {
        if (instance == null) {
            instance = new BuildOrgTree();
        }
        return instance;
    }

    private BuildOrgTree() {
        MainFrameCallBack.addPropertyChangeListener((String)"HRSwitchOrg", (PropertyChangeListener)this.listen);
        MainFrameCallBack.addPropertyChangeListener((String)"ReLogin", (PropertyChangeListener)new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                BuildOrgTree.this.map = null;
                BuildOrgTree.this.idlists = null;
                BuildOrgTree.this.model = null;
                instance = null;
            }
        });
    }

    private HashMap getMap() {
        if (this.map != null) {
            return this.map;
        }
        try {
            CompanyOrgUnitCollection coms = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection("select id");
            this.map = new HashMap();
            int n = coms.size();
            for (int i = 0; i < n; ++i) {
                this.map.put(coms.get(i).getId().toString(), new Boolean(false));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
        return this.map;
    }

    private void travOrg(DefaultKingdeeTreeNode rootNode, List lists) {
        if (rootNode == null) {
            return;
        }
        OrgStructureInfo info = null;
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)rootNode.getChildAt(i);
            info = (OrgStructureInfo)node.getUserObject();
            String orgId = null;
            String string = orgId = info == null || info.getUnit() == null ? null : info.getUnit().getId().toString();
            if (orgId != null) {
                lists.add(orgId);
            }
            if (node.getChildCount() == 0) continue;
            this.travOrg(node, lists);
        }
    }

    public List getOrgLists() {
        if (this.idlists != null) {
            return this.idlists;
        }
        TreeModel tm = null;
        try {
            tm = this.getOrgModel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (tm == null) {
            return null;
        }
        this.idlists = new ArrayList();
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)tm.getRoot();
        OrgStructureInfo info = (OrgStructureInfo)rootNode.getUserObject();
        String orgId = null;
        String string = orgId = info == null || info.getUnit() == null ? null : info.getUnit().getId().toString();
        if (orgId != null) {
            this.idlists.add(orgId);
        }
        this.travOrg(rootNode, this.idlists);
        return this.idlists;
    }

    public void buildCommonTree(KDTree treeMain) throws Exception {
        if (treeMain == null) {
            throw new NullPointerException("treeMain is null ");
        }
        treeMain.setShowsRootHandles(true);
        TreeModel tm = this.getOrgModel();
        treeMain.setModel(tm);
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)tm.getRoot();
        if (rootNode != null) {
            treeMain.setRootVisible(true);
            TreePath path = new TreePath(rootNode);
            treeMain.expandPath(path);
            treeMain.setSelectionPath(path);
        } else {
            treeMain.setModel(null);
        }
    }

    protected TreeModel getOrgModel() throws Exception {
        if (this.model != null) {
            return this.model;
        }
        CompanyF7 af7 = new CompanyF7();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (company != null) {
            OrgTreeInfo oti = new OrgTreeInfo();
            oti.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000024F2827FD"));
            this.model = af7.getTreeModel(OrgViewType.COMPANY, oti);
        }
        return this.model;
    }

    private HashMap getTreeCols(TreeModel model) {
        HashMap<String, AdminOrgUnitInfo> map = new HashMap<String, AdminOrgUnitInfo>();
        if (model == null) {
            return map;
        }
        Object obj = model.getRoot();
        if (obj != null && obj instanceof AdminOrgUnitInfo) {
            AdminOrgUnitInfo tempInfo = (AdminOrgUnitInfo)obj;
            map.put(tempInfo.getId().toString(), tempInfo);
            this.initTreeMap(model, tempInfo, map);
        }
        return map;
    }

    private void initTreeMap(TreeModel model, AdminOrgUnitInfo parent, Map map) {
        int childCount = model.getChildCount(parent);
        for (int i = 0; i < childCount; ++i) {
            Object obj = model.getChild(parent, i);
            AdminOrgUnitInfo tempInfo = (AdminOrgUnitInfo)obj;
            map.put(tempInfo.getId().toString(), tempInfo);
            this.initTreeMap(model, tempInfo, map);
        }
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfo(String orgID) {
        return BuildOrgTree.getCompanyOrgUnitInfo(BOSUuid.read((String)orgID));
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfo(BOSUuid orgID) {
        CompanyOrgUnitInfo company = null;
        try {
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
        }
        catch (Exception e) {
            logger.info((Object)"sem_mp: getCompanyOrgUnitInfo error!");
            e.printStackTrace();
        }
        return company;
    }
}

