/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.sem.mp.KPICommentCollection;
import com.kingdee.eas.sem.mp.KPICommentFactory;
import com.kingdee.eas.sem.mp.KPICommentInfo;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class KPICommentServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.doPost(arg0, arg1);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String obj = request.getParameter("kpiValueId");
        if (obj == null) {
            return;
        }
        String kpiValueId = obj.toString();
        kpiValueId = kpiValueId.replaceAll(" ", "+");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        KPICommentCollection comments = this.getKpiComments(ctx, kpiValueId);
        if (comments == null) {
            return;
        }
        String userId = ctx.getCaller().toString();
        response.setContentType("text/xml; charset=utf-8");
        response.setHeader("Cache-Control", "no-cache");
        request.setCharacterEncoding("utf-8");
        StringBuffer bb = new StringBuffer();
        bb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        bb.append("<rows>\n");
        bb.append("<head>\n");
        bb.append("<afterInit>\n");
        bb.append("<call command=\"clearAll\"></call>\n");
        bb.append("</afterInit>\n");
        bb.append("</head>\n");
        int n = comments.size();
        for (int i = 0; i < n; ++i) {
            KPICommentInfo commentInfo = comments.get(i);
            String comment = commentInfo.getComment();
            String tempUserId = commentInfo.getCreator().getId().toString();
            if (userId.equals(tempUserId)) {
                bb.append("<row id=\"").append(commentInfo.getId().toString()).append("true").append("\">\n");
            } else {
                bb.append("<row id=\"").append(commentInfo.getId().toString()).append("\">\n");
            }
            bb.append("<cell>").append(comment).append("</cell>\n");
            bb.append("<cell>").append(commentInfo.getCreator().getName()).append("</cell>\n");
            bb.append("<cell>").append(commentInfo.getCreateTime()).append("</cell>\n");
            bb.append("</row>\n");
        }
        bb.append("</rows>");
        response.getWriter().write(bb.toString());
    }

    private KPICommentCollection getKpiComments(Context ctx, String kpiValueId) {
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = ev.getSelector();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("creator.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpiValue.id", (Object)kpiValueId));
        ev.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("createTime");
        sorter.setSortType(SortType.DESCEND);
        ev.getSorter().add(sorter);
        KPICommentCollection comments = null;
        try {
            comments = KPICommentFactory.getLocalInstance(ctx).getKPICommentCollection(ev);
        }
        catch (Exception e) {
            comments = null;
            e.printStackTrace();
        }
        return comments;
    }
}

