/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.freechart.chart.ChartFactory;
import com.kingdee.bos.ctrl.freechart.chart.ChartUtilities;
import com.kingdee.bos.ctrl.freechart.chart.JFreeChart;
import com.kingdee.bos.ctrl.freechart.chart.axis.NumberAxis;
import com.kingdee.bos.ctrl.freechart.chart.plot.CategoryPlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.PlotOrientation;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.CategoryItemRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.LineAndShapeRenderer;
import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.category.DefaultCategoryDataset;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.IKPIValue;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPITimeTypeEnum;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueFactory;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.KPITimeHandle;
import com.kingdee.eas.sem.mp.util.KPIFormatHandle;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ViewKpiChartServlet
extends HttpServlet {
    private static final long serialVersionUID = -632654842573960832L;
    Logger logger = Logger.getLogger((String)"com.kingdee.eas.sem.mp.web.ViewKpiChartServlet");

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String kpiId = request.getParameter("kpiId");
        if (kpiId == null) {
            this.createLineChart("", response);
            return;
        }
        kpiId = kpiId.replaceAll(" ", "+");
        String beginPeriod = request.getParameter("beginPeriod");
        String endPeriod = request.getParameter("endPeriod");
        Date bPeriod = null;
        Date ePeriod = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (beginPeriod != null && beginPeriod.trim().length() > 0) {
                bPeriod = format.parse(beginPeriod);
            }
            if (endPeriod != null && endPeriod.trim().length() > 0) {
                ePeriod = format.parse(endPeriod);
            }
        }
        catch (ParseException e1) {
            bPeriod = null;
            ePeriod = null;
            this.logger.info((Object)"parse beginPeriod error");
            e1.printStackTrace();
        }
        boolean isFilter = false;
        if (bPeriod != null) {
            isFilter = true;
        }
        if (ePeriod == null) {
            ePeriod = new Date();
        }
        try {
            SelectorItemCollection scc = new SelectorItemCollection();
            scc.add(new SelectorItemInfo("id"));
            scc.add(new SelectorItemInfo("name"));
            scc.add(new SelectorItemInfo("timeType"));
            scc.add(new SelectorItemInfo("numberUnit"));
            scc.add(new SelectorItemInfo("displayPrecision"));
            scc.add(new SelectorItemInfo("isPercent"));
            IKPI iKPI = KPIFactory.getLocalInstance(ctx);
            KPIInfo info = iKPI.getKPIInfo((IObjectPK)new ObjectUuidPK(kpiId), scc);
            if (info == null) {
                this.createLineChart("", response);
                this.logger.info((Object)"get kpi error!");
                return;
            }
            String tempBeginPeriod = null;
            String tempEndPeriod = null;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("kpi.id", (Object)kpiId));
            KPITimeTypeEnum kpiType = info.getTimeType();
            Calendar calendar = Calendar.getInstance();
            if (bPeriod != null) {
                calendar.setTime(bPeriod);
                tempBeginPeriod = KPITimeHandle.getTimeText(kpiType, calendar);
            }
            calendar.setTime(ePeriod);
            tempEndPeriod = KPITimeHandle.getTimeText(kpiType, calendar);
            if (tempBeginPeriod != null) {
                filter.getFilterItems().add(new FilterItemInfo("timeText", (Object)tempBeginPeriod, CompareType.GREATER_EQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("timeText", (Object)tempEndPeriod, CompareType.LESS_EQUALS));
            ev.setFilter(filter);
            SorterItemInfo itemInfo = new SorterItemInfo("timeText");
            itemInfo.setSortType(SortType.DESCEND);
            ev.getSorter().add(itemInfo);
            IKPIValue kpiValue = KPIValueFactory.getLocalInstance(ctx);
            KPIValueCollection valueCols = kpiValue.getKPIValueCollection(ev);
            if (isFilter) {
                this.createLineChart(info, valueCols, response);
            } else {
                this.createLineChart(info, this.getResultCols(valueCols, kpiType), response);
            }
        }
        catch (Exception e) {
            this.logger.info((Object)"view kpiHistoryLineChart error!");
            e.printStackTrace();
        }
    }

    private KPIValueCollection getResultCols(KPIValueCollection cols, KPITimeTypeEnum kpiType) {
        KPIValueCollection resultCols = new KPIValueCollection();
        if (cols == null) {
            return resultCols;
        }
        int resultCount = 0;
        resultCount = KPITimeTypeEnum.day.equals((Object)kpiType) ? 30 : (KPITimeTypeEnum.week.equals((Object)kpiType) ? 10 : (KPITimeTypeEnum.month.equals((Object)kpiType) ? 12 : (KPITimeTypeEnum.season.equals((Object)kpiType) ? 10 : (KPITimeTypeEnum.halfYear.equals((Object)kpiType) ? 10 : (KPITimeTypeEnum.year.equals((Object)kpiType) ? 5 : 30)))));
        int sourceColsCount = cols.size();
        for (int i = 0; i < sourceColsCount && i < resultCount; ++i) {
            resultCols.add(cols.get(i));
        }
        return resultCols;
    }

    private void createLineChart(KPIInfo kpiInfo, KPIValueCollection cols, HttpServletResponse response) {
        if (cols != null && cols.size() > 0) {
            int colsLeng;
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            String title = kpiInfo.getName();
            if (kpiInfo.getNumberUnit() != null) {
                title = title + "(" + kpiInfo.getNumberUnit() + ")";
            }
            String domain = "";
            String range = "";
            int size = colsLeng = cols.size() - 1;
            int i = 0;
            while (colsLeng >= 0) {
                KPIValueInfo valueInfo = cols.get(colsLeng);
                dataset.addValue(valueInfo.getKpiValue().doubleValue(), (Comparable)((Object)kpiInfo.getName()), (Comparable)((Object)valueInfo.getName()));
                --colsLeng;
                ++i;
            }
            JFreeChart chart = ChartFactory.createLineChart((String)title, (String)domain, (String)range, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            CategoryPlot plot = (CategoryPlot)chart.getPlot();
            NumberAxis numberaxis = (NumberAxis)plot.getRangeAxis();
            DecimalFormat decimalFormat = new DecimalFormat();
            KPIFormatHandle.initKpiFormter(kpiInfo.isIsPercent(), kpiInfo.getDisplayPrecision(), decimalFormat);
            numberaxis.setNumberFormatOverride((NumberFormat)decimalFormat);
            LineAndShapeRenderer theRenderer = new LineAndShapeRenderer();
            theRenderer.setDrawOutlines(true);
            plot.setRenderer((CategoryItemRenderer)theRenderer);
            plot.setBackgroundPaint((Paint)new Color(238, 238, 238));
            chart.setBackgroundPaint((Paint)new Color(238, 238, 238));
            try {
                int width = 800;
                int height = 600;
                int j = size / 10;
                if (j == 1) {
                    width = 800;
                } else if (j >= 2) {
                    width = 1000;
                }
                response.setContentType("image/png;charset=GB2312");
                ServletOutputStream output = response.getOutputStream();
                ChartUtilities.writeChartAsPNG((OutputStream)output, (JFreeChart)chart, (int)width, (int)height);
                output.flush();
                output.close();
            }
            catch (IOException exz) {
                this.logger.info((Object)"....Cann't   Create   image   File");
                exz.printStackTrace();
            }
        } else {
            this.createLineChart(kpiInfo.getName(), response);
        }
    }

    private void createLineChart(String kpiName, HttpServletResponse response) {
        String title = "";
        String domain = "";
        String range = "";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        JFreeChart chart = ChartFactory.createLineChart((String)kpiName, (String)domain, (String)range, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        LineAndShapeRenderer theRenderer = new LineAndShapeRenderer();
        theRenderer.setDrawOutlines(true);
        plot.setRenderer((CategoryItemRenderer)theRenderer);
        plot.setBackgroundPaint((Paint)new Color(238, 238, 238));
        chart.setBackgroundPaint((Paint)new Color(238, 238, 238));
        try {
            int width = 800;
            int height = 600;
            response.setContentType("image/png;charset=GB2312");
            ServletOutputStream output = response.getOutputStream();
            ChartUtilities.writeChartAsPNG((OutputStream)output, (JFreeChart)chart, (int)width, (int)height);
            output.flush();
            output.close();
        }
        catch (IOException exz) {
            this.logger.info((Object)"....Cann't   Create   image   File");
            exz.printStackTrace();
        }
    }
}

