/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.abnormal;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AbnormalAttendanceCollection;
import com.kingdee.eas.hr.ats.AbnormalAttendanceFactory;
import com.kingdee.eas.hr.ats.AbnormalAttendanceInfo;
import com.kingdee.eas.hr.ats.AtsAbnormalOprationStatusEnum;
import com.kingdee.eas.hr.ats.AttendanceProjectFactory;
import com.kingdee.eas.hr.ats.AttendanceProjectInfo;
import com.kingdee.eas.hr.ats.IAbnormalAttendance;
import com.kingdee.eas.hr.ats.abnormal.AbnormalUtils;
import com.kingdee.eas.hr.ats.app.AbnormalAttendanceControllerBean;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AbnormalWebUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.abnormal.AbnormalWebUtil");

    public HashMap<String, String> feedBack(Context ctx, String billIds) {
        try {
            if (null != billIds && !"".equals(billIds)) {
                System.out.println("--------------- this method is feedBack,the billId is : " + billIds);
                int all = billIds.split(",").length;
                UserInfo currentUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
                String billIdsIn = "'" + billIds.replaceAll(",", "','") + "'";
                String oql = "where id in (" + billIdsIn + ")";
                IAbnormalAttendance localInstance = AbnormalAttendanceFactory.getLocalInstance(ctx);
                AbnormalAttendanceCollection abnormals = localInstance.getAbnormalAttendanceCollection(oql);
                if (abnormals == null || abnormals.size() == 0) {
                    return AbnormalWebUtil.returnMsg("0", all + "");
                }
                Date date = new Date();
                Timestamp timestamp = AtsDateUtils.dateToTimestamp(date);
                UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
                AbnormalAttendanceInfo info = null;
                CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
                for (int index = 0; index < abnormals.size(); ++index) {
                    info = abnormals.get(index);
                    if (!info.getOperationStatus().getValue().equalsIgnoreCase(AtsAbnormalOprationStatusEnum.confirm.getValue())) continue;
                    info.setOperationStatus(AtsAbnormalOprationStatusEnum.applied);
                    info.setLastUpdateTime(timestamp);
                    info.setLastUpdateUser(currentUser);
                    System.out.println("--------------- this method is feedBack,the billId is ===: " + info.getId());
                    AbnormalUtils.closedAbnormal(ctx, info, localInstance);
                    coreBaseCollection.add((CoreBaseInfo)info);
                }
                localInstance.updateBatchData(coreBaseCollection);
                int succes = coreBaseCollection.size();
                int error = all - succes;
                return AbnormalWebUtil.returnMsg(String.valueOf(succes), String.valueOf(error));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Abnormal checkIsAccepted error:", (Throwable)e);
        }
        return null;
    }

    public HashMap<String, String> accept(Context ctx, String billIds) {
        try {
            if (null != billIds && !"".equals(billIds)) {
                System.out.println("--------------- this method is accept,the billId is : " + billIds);
                int all = billIds.split(",").length;
                UserInfo currentUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
                String billIdsIn = "'" + billIds.replaceAll(",", "','") + "'";
                String oql = "where id in (" + billIdsIn + ")";
                IAbnormalAttendance localInstance = AbnormalAttendanceFactory.getLocalInstance(ctx);
                AbnormalAttendanceCollection abnormals = localInstance.getAbnormalAttendanceCollection(oql);
                if (abnormals == null || abnormals.size() == 0) {
                    return AbnormalWebUtil.returnMsg("0", all + "");
                }
                Date date = new Date();
                Timestamp timestamp = AtsDateUtils.dateToTimestamp(date);
                UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
                AbnormalAttendanceInfo info = null;
                CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
                AbnormalAttendanceControllerBean controllerBean = new AbnormalAttendanceControllerBean();
                for (int index = 0; index < abnormals.size(); ++index) {
                    info = abnormals.get(index);
                    if (!info.getOperationStatus().getValue().equalsIgnoreCase(AtsAbnormalOprationStatusEnum.confirm.getValue()) || !this.checkIsAccepted(ctx, info)) continue;
                    info = abnormals.get(index);
                    info.setOperationStatus(AtsAbnormalOprationStatusEnum.accepted);
                    info.setLastUpdateTime(timestamp);
                    info.setLastUpdateUser(currentUser);
                    System.out.println("--------------- this method is accept,the billId is ===: " + info.getId());
                    AbnormalUtils.closedAbnormal(ctx, info, localInstance);
                    coreBaseCollection.add((CoreBaseInfo)info);
                }
                localInstance.updateBatchData(coreBaseCollection);
                int succes = coreBaseCollection.size();
                int error = all - succes;
                return AbnormalWebUtil.returnMsg(String.valueOf(succes), String.valueOf(error));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Abnormal accept error:", (Throwable)e);
        }
        return null;
    }

    private boolean checkIsAccepted(Context ctx, AbnormalAttendanceInfo info) {
        AttendanceProjectInfo attendanceProject = info.getAttendanceProject();
        if (attendanceProject == null || attendanceProject.getId() == null) {
            return false;
        }
        try {
            AttendanceProjectInfo attendanceProjectInfo = AttendanceProjectFactory.getLocalInstance(ctx).getAttendanceProjectInfo("select accept where id ='" + attendanceProject.getId().toString() + "'");
            boolean accept = attendanceProjectInfo.isAccept();
            return accept;
        }
        catch (Exception e) {
            logger.error((Object)"Abnormal checkIsAccepted error:", (Throwable)e);
            return false;
        }
    }

    public static HashMap<String, String> returnMsg(String sucess, String error) {
        HashMap<String, String> resulte = new HashMap<String, String>();
        resulte.put("errorCount", error);
        resulte.put("successCount", sucess);
        return resulte;
    }

    public static void confirmUnnormal(Context ctx, CoreBaseInfo model) {
        AbnormalWebUtil abnormalWebUtil = new AbnormalWebUtil();
        String abnormalIds = (String)model.get("abnormalId");
        if (!StringUtils.isEmpty((String)abnormalIds)) {
            List abList = JSON.parseArray((String)abnormalIds, String.class);
            StringBuilder sb = new StringBuilder();
            for (String s : abList) {
                sb.append(s + ",");
            }
            abnormalWebUtil.feedBack(ctx, sb.toString().substring(0, sb.length() - 1));
        }
    }
}

