/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AbnormalAttendanceFactory;
import com.kingdee.eas.hr.ats.AbnormalAttendanceInfo;
import com.kingdee.eas.hr.ats.AtsAbnormalOprationStatusEnum;
import com.kingdee.eas.hr.ats.AttendanceStatusEnum;
import com.kingdee.eas.hr.ats.abnormal.task.AbnormalTaskActuator;
import com.kingdee.eas.hr.ats.app.AbstractAbnormalAttendanceControllerBean;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import java.util.Date;
import org.apache.log4j.Logger;

public class AbnormalAttendanceControllerBean
extends AbstractAbnormalAttendanceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.app.AbnormalAttendanceControllerBean");

    @Override
    protected void onBillSubmit(Context ctx, CoreBaseInfo model) throws EASBizException, BOSException {
        AbnormalAttendanceInfo info = (AbnormalAttendanceInfo)model;
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        info.setLastUpdateTime(AtsDateUtils.dateToTimestamp(new Date()));
    }

    @Override
    protected void _setState(Context ctx, BOSUuid billId, HRBillStateEnum state) throws BOSException, EASBizException {
        super._setState(ctx, billId, state);
        if (state.getValue() == HRBillStateEnum.AUDITED.getValue()) {
            AbnormalAttendanceInfo info = AbnormalAttendanceFactory.getLocalInstance(ctx).getAbnormalAttendanceInfo("where id = '" + billId.toString() + "'");
            if (info != null && info.getOperationStatus() != null && info.getOperationStatus().getValue() != null && info.getOperationStatus().getValue().equalsIgnoreCase(AtsAbnormalOprationStatusEnum.confirm.getValue())) {
                info.setOperationStatus(AtsAbnormalOprationStatusEnum.applied);
            }
            if (info == null) {
                return;
            }
            info.setStatus(AttendanceStatusEnum.closed);
            info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
            info.setLastUpdateTime(AtsDateUtils.dateToTimestamp(new Date()));
            AbnormalAttendanceFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), info);
        }
    }

    @Override
    protected void _sendAbnormalTask(Context ctx) throws BOSException {
        AbnormalTaskActuator abnormalTaskActuator = new AbnormalTaskActuator();
        abnormalTaskActuator.sendTask(ctx);
    }

    @Override
    protected void _closeWF(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _abortWF(Context ctx, IObjectValue model) throws BOSException {
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        AbnormalAttendanceInfo abnormalInfo = (AbnormalAttendanceInfo)model;
        service.abortProcessByHoldedObjectId(abnormalInfo.getId().toString());
    }
}

