/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsScheduleShiftEntryCollection;
import com.kingdee.eas.hr.ats.AtsScheduleShiftEntryInfo;
import com.kingdee.eas.hr.ats.AtsScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.app.AbstractAtsScheduleShiftControllerBean;
import com.kingdee.eas.hr.ats.helper.AtsScheduleShiftHelper;
import com.kingdee.eas.hr.ats.result.AttendCalculateJob;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsWaitCalUtil;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.IntersectUtile;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AtsScheduleShiftControllerBean
extends AbstractAtsScheduleShiftControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.app.AtsScheduleShiftControllerBean");
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _setPassState_atsScheduleShift(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        Class<AtsScheduleShiftControllerBean> clazz = AtsScheduleShiftControllerBean.class;
        synchronized (AtsScheduleShiftControllerBean.class) {
            this._setState(ctx, billId, HRBillStateEnum.AUDITED);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            AtsScheduleShiftHelper.updateScheduleShiftInfo(ctx, billId.toString());
            this._scheduleShiftTriggerCal(ctx, "", "", "", billId.toString());
            return;
        }
    }

    @Override
    protected Map _importAtsScheduleShiftData(Context ctx, List list, boolean isOverImport, int errorHandleMode) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _invalid(Context ctx, String billId) throws BOSException {
    }

    @Override
    protected void beforeSubmit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        this.validateIntersect(ctx, (AtsScheduleShiftInfo)model);
        super.beforeSubmit(ctx, model);
    }

    @Override
    protected void beforSubmitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        this.validateIntersect(ctx, (AtsScheduleShiftInfo)model);
        super.beforSubmitEffect(ctx, model);
    }

    protected void validateIntersect(Context ctx, AtsScheduleShiftInfo model) throws BOSException, EASBizException {
        AtsScheduleShiftEntryCollection items;
        AtsScheduleShiftEntryCollection atsScheduleShiftEntryCollection = items = model == null ? null : model.getEntries();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)items)) {
            return;
        }
        int i = items.size();
        while (i-- > 0) {
            ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftHelper.getScheduleoByAtsScheduleItem(ctx, items.get(i));
            IntersectUtile.scheduleEditIntersetcValidate(ctx, scheduleShiftInfo);
        }
    }

    @Override
    protected void _scheduleShiftTriggerCal(Context ctx, String beginTime, String endTime, String personId, String billId) throws BOSException, EASBizException {
        AtsScheduleShiftEntryCollection coll = AtsScheduleShiftHelper.getAtsScheduleShiftEntryCollection(ctx, billId);
        Iterator itr = coll.iterator();
        AttendCalculateJob backJob = new AttendCalculateJob();
        while (itr.hasNext()) {
            AtsScheduleShiftEntryInfo info = (AtsScheduleShiftEntryInfo)itr.next();
            String personIdStr = info.getProposerBefore().getId().toString();
            String attendDatestr = AtsDateUtils.dateShortToString(info.getAttendDateBefore());
            AtsWaitCalUtil.updateHasCal2WaitCal(ctx, personIdStr, attendDatestr);
            attendDatestr = attendDatestr + "," + attendDatestr;
            if (StringUtils.isEmpty((String)personIdStr)) continue;
            backJob.createScheduleShiftModifyTriggerAttendCalJob(ctx, attendDatestr, "", personIdStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        Class<AtsScheduleShiftControllerBean> clazz = AtsScheduleShiftControllerBean.class;
        synchronized (AtsScheduleShiftControllerBean.class) {
            super._setApproveState(ctx, billId);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        Class<AtsScheduleShiftControllerBean> clazz = AtsScheduleShiftControllerBean.class;
        synchronized (AtsScheduleShiftControllerBean.class) {
            super._setEditState(ctx, billId);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        Class<AtsScheduleShiftControllerBean> clazz = AtsScheduleShiftControllerBean.class;
        synchronized (AtsScheduleShiftControllerBean.class) {
            super._setNoPassState(ctx, billId);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

