/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AttendanceProjectFactory;
import com.kingdee.eas.hr.ats.AttendanceProjectInfo;
import com.kingdee.eas.hr.ats.app.AbstractAttendanceResultFacadeControllerBean;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public class AttendanceResultFacadeControllerBean
extends AbstractAttendanceResultFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.app.AttendanceResultFacadeControllerBean");

    @Override
    protected int _sumAbsenceNum(Context ctx, String personId, int inputDayNum) throws BOSException {
        int returnFlag = 1;
        Date currentDate = AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(new Date()));
        String sql = "select count(1) as cnt from t_hr_ats_attendanceResult where fproposerid = ? and S23 > 0and fattencedate between ? and ?";
        Date beginDate = AtsDateUtils.dateAdd(currentDate, 3, 0 - inputDayNum, false);
        Date endDate = AtsDateUtils.dateAdd(currentDate, 3, -1, false);
        java.sql.Date sqlBeginDate = new java.sql.Date(beginDate.getTime());
        java.sql.Date sqlEndDate = new java.sql.Date(endDate.getTime());
        Object[] params = new Object[]{personId, sqlBeginDate, sqlEndDate};
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        if (rowset != null) {
            try {
                while (rowset.next()) {
                    int count = rowset.getInt("cnt");
                    if (count != inputDayNum) continue;
                    returnFlag = 0;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        rowset = null;
        return returnFlag;
    }

    @Override
    protected float _getAttenceProjectVal(Context ctx, String personId, int inputDayNum, String attenceNum) throws BOSException {
        float count;
        block5: {
            count = 1.0f;
            try {
                Object[] params;
                AttendanceProjectInfo attenceProjectInfo = AttendanceProjectFactory.getLocalInstance(ctx).getAttendanceProjectInfo("where number = '" + attenceNum + "'");
                if (attenceProjectInfo == null) break block5;
                String attenceCol = "S" + attenceProjectInfo.getColumnNO();
                String sql = "select sum(" + attenceCol + ") as cnt from t_hr_ats_attendanceResult where fproposerid = ? and fattencedate between ? and ? ";
                IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])(params = this.getParams(personId, inputDayNum)));
                if (rowset == null) break block5;
                try {
                    while (rowset.next()) {
                        count = rowset.getFloat("cnt");
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
        }
        return count;
    }

    @Override
    protected String _getAttenceDetailVal(Context ctx, String personId, int inputDayNum, String attenceNum) throws BOSException {
        System.out.println(ctx == null ? "---------------------Get the attendance detail data to start_getAttenceDetailVal context is null" : "---------------------start to call _getAttenceDetailVal()");
        StringBuffer body = new StringBuffer();
        try {
            AttendanceProjectInfo attenceProjectInfo = AttendanceProjectFactory.getLocalInstance(ctx).getAttendanceProjectInfo("where number = '" + attenceNum + "'");
            System.out.println("---------------start to call _getAttenceDetailVal() attenceProjectInfo");
            if (attenceProjectInfo != null) {
                IRowSet rowSet = this.getAttenceDetailResult(ctx, attenceProjectInfo, personId, inputDayNum);
                body = this.setMessageBody(ctx, attenceProjectInfo, rowSet);
            }
        }
        catch (Throwable e1) {
            e1.printStackTrace();
            System.out.println("---------------call _getAttenceDetailVal() error" + e1.getMessage());
        }
        System.out.println("---------------Get the attendance detail data to startend to call _getAttenceDetailVal()");
        return body.toString();
    }

    public StringBuffer setMessageBody(Context ctx, AttendanceProjectInfo attenceProjectInfo, IRowSet rowSet) {
        StringBuffer body = new StringBuffer();
        String attendanceName = attenceProjectInfo.getName();
        int dataType = attenceProjectInfo.getDataType().getValue();
        String unit = attenceProjectInfo.getUnit() == null ? "" : attenceProjectInfo.getUnit().getAlias();
        int decimalPlaces = DecimalPlaceUtil.getDecimalPlaceSystem(ctx);
        int splitIndex = 1;
        if (rowSet != null) {
            try {
                if (rowSet.size() > 0) {
                    StringBuffer detailStr = new StringBuffer();
                    while (rowSet.next()) {
                        String val = rowSet.getString("cnt");
                        java.sql.Date attenceDate = rowSet.getDate("AttenceDate");
                        if (StringUtils.isEmpty((String)val) || (dataType == 1 || dataType == 2) && Float.parseFloat(val) <= 0.0f) continue;
                        val = DecimalPlaceUtil.decimalPlaceCtrl(ctx, new BigDecimal(val), decimalPlaces).toString();
                        detailStr.append(attenceDate + "  " + val + unit + "   ");
                        if (splitIndex % 5 != 0) continue;
                        detailStr.append(" \n");
                    }
                    if (detailStr.length() > 0) {
                        body.append(attendanceName + " : \n");
                        body.append(detailStr);
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return body;
    }

    public IRowSet getAttenceDetailResult(Context ctx, AttendanceProjectInfo attenceProjectInfo, String personId, int inputDayNum) {
        IRowSet rowSet = null;
        try {
            String attenceCol = "S" + attenceProjectInfo.getColumnNO();
            String sql = "select " + attenceCol + " as cnt,FAttenceDate as AttenceDate from t_hr_ats_attendanceResult where fproposerid = ? and fattencedate between ? and ?  order by FAttenceDate ";
            Object[] params = this.getParams(personId, inputDayNum);
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rowSet;
    }

    public Object[] getParams(String personId, int inputDayNum) {
        Date currentDate = AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(new Date()));
        Date beginDate = AtsDateUtils.dateAdd(currentDate, 3, 0 - inputDayNum, false);
        Date endDate = AtsDateUtils.dateAdd(currentDate, 3, -1, false);
        java.sql.Date sqlBeginDate = new java.sql.Date(beginDate.getTime());
        java.sql.Date sqlEndDate = new java.sql.Date(endDate.getTime());
        Object[] params = new Object[]{personId, sqlBeginDate, sqlEndDate};
        return params;
    }
}

