/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.lazyload.IObjectValueLazyLoader;
import com.kingdee.bos.dao.ormapping.lazyload.ObjectValueLazyLoaderFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsBillBizException;
import com.kingdee.eas.hr.ats.AtsNeedReBilll;
import com.kingdee.eas.hr.ats.AtsTripBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.CanTripBillEntryCollection;
import com.kingdee.eas.hr.ats.CanTripBillEntryFactory;
import com.kingdee.eas.hr.ats.CanTripBillEntryInfo;
import com.kingdee.eas.hr.ats.CanTripBillFactory;
import com.kingdee.eas.hr.ats.CanTripBillInfo;
import com.kingdee.eas.hr.ats.IsAttendanceEnum;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.TripbillCancelEnum;
import com.kingdee.eas.hr.ats.app.AbstractCanTripBillControllerBean;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.util.AtsLeaveBillUtils;
import com.kingdee.eas.hr.ats.util.AtsWaitCalUtil;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.IntersectUtile;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.app.BillExtendBeanProcess;
import com.kingdee.eas.hr.base.app.HRBillBeanBizFactory;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.PlugInBeanFactory;
import com.kingdee.eas.hr.base.app.PlugInBeanProxy;
import com.kingdee.eas.hr.base.util.IReflectMethod;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.log4j.Logger;

public class CanTripBillControllerBean
extends AbstractCanTripBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.app.CanTripBillControllerBean");
    private IHRBillBizBean bizBean = null;

    @Override
    protected void _canTripBillTriggerCal(Context ctx, String beginTime, String endTime, String billId, String personId) throws BOSException {
        String serviceName = "canTripBillTrigerCalculateOSF";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("billId", billId);
        param.put("personId", personId);
        param.put("beginTime", beginTime);
        param.put("endTime", endTime);
        OSFAppUtil osfUtil = new OSFAppUtil();
        try {
            Object object = OSFAppUtil.callService((Context)ctx, (String)serviceName, param);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void beforSubmitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        this.onConfirmed(ctx, (CanTripBillInfo)model);
        this.validateIntersect(ctx, (CanTripBillInfo)model);
        super.beforSubmitEffect(ctx, model);
    }

    @Override
    protected void beforeSubmit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        this.validateIntersect(ctx, (CanTripBillInfo)model);
        super.beforeSubmit(ctx, model);
    }

    @Override
    protected void afterSubmit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        super.afterSubmit(ctx, model);
        this.updateAtsTripBillEntry(ctx, model, 0);
    }

    protected void updateAtsTripBillEntry(Context ctx, CoreBaseInfo model, int submitType) {
        CanTripBillInfo canTripBillInfo = (CanTripBillInfo)model;
        CanTripBillEntryCollection canTripBillEntryCollection = canTripBillInfo.getEntries();
        CanTripBillEntryInfo canTripBillEntryInfo = canTripBillEntryCollection.get(0);
        AtsTripBillEntryInfo atsTripBillInfo = canTripBillEntryInfo.getTripEntryBill();
        AtsLeaveBillUtils.updateAtsTripBillEntryIsCancelTripInfo(ctx, atsTripBillInfo.getId().toString(), submitType);
    }

    @Override
    protected void afterSave(Context ctx, CoreBaseInfo model) throws EASBizException, BOSException {
        super.afterSave(ctx, model);
        this.updateAtsTripBillEntry(ctx, model, 2);
    }

    @Override
    protected void afterSubmitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        super.afterSubmitEffect(ctx, model);
        this.updateAtsTripBillEntry(ctx, model, 1);
        this._setPassState_atsCanTripBill(ctx, model.getId());
    }

    protected void validateIntersect(Context ctx, CanTripBillInfo model) throws BOSException, EASBizException {
        CanTripBillEntryCollection tripItems;
        CanTripBillEntryCollection canTripBillEntryCollection = tripItems = model == null ? null : model.getEntries();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)tripItems)) {
            return;
        }
        IObjectValueLazyLoader loader = ObjectValueLazyLoaderFactory.getLocalInstance((Context)ctx);
        ArrayList<MultiKey> personDateRange = new ArrayList<MultiKey>(tripItems.size());
        int i = tripItems.size();
        while (i-- > 0) {
            CanTripBillEntryInfo item = tripItems.get(i);
            String person = CoreBaseUtile.getId((CoreBaseInfo)loader.getProperty((IObjectValue)item, "person"));
            personDateRange.add(new MultiKey((Object)person, loader.getProperty((IObjectValue)item, "realStartTime"), loader.getProperty((IObjectValue)item, "realEndTime")));
        }
        IntersectUtile.isIntersectWithAccrossSupport(ctx, personDateRange, null, true);
        IntersectUtile.isIntersectWithSchedule(ctx, personDateRange, null, true, true);
    }

    @Override
    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._abortBizBill(ctx, billId);
        String oql = " select  TripEntryBill.id where bill = '" + billId + "' ";
        CanTripBillEntryCollection canTripBillEntryCollection = CanTripBillEntryFactory.getLocalInstance(ctx).getCanTripBillEntryCollection(oql);
        for (int k = 0; k < canTripBillEntryCollection.size(); ++k) {
            String entryBillId = canTripBillEntryCollection.get(k).getTripEntryBill().getString("id");
            AtsLeaveBillUtils.updateAtsTripBillEntryIsCancelTripInfo(ctx, entryBillId, 2);
        }
    }

    @Override
    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        if (billID == null) {
            return;
        }
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        if (this.bizBean != null) {
            this.bizBean._personPlanChek(ctx, (IObjectValue)model);
        }
        this.initBizBean(ctx);
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITED);
        }
        if (ApproveTypeEnum.DIRECT.equals((Object)model.getApproveType())) {
            this.saveMultiApproveInfo(ctx, billID);
        }
    }

    private void saveMultiApproveInfo(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IMultiApprove im = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setIsPass(ApproveResult.PASS);
        info.setOpinion(ResourceBase.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"0_HRBillBaseControllerBean", (Locale)ctx.getLocale()));
        info.setBillId(billId);
        info.setBosTypeStr(billId.getType().toString());
        im.addnew((CoreBaseInfo)info);
    }

    private void initBizBean(Context ctx) throws BOSException, EASBizException {
        if (this.bizBean == null) {
            this.bizBean = this.getBizBean();
            if (this.bizBean != null) {
                BillExtendBeanProcess billExtend = BillExtendBeanProcess.getInstance((String)this.bizBean.getExtendBillName(ctx));
                PlugInBeanProxy plugIn = null;
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                EntityObjectInfo entity = loader.getEntity(this.getBOSType());
                if (entity != null) {
                    String fullName = entity.getFullName();
                    try {
                        plugIn = PlugInBeanFactory.getPlugIn((Context)ctx, (String)fullName);
                    }
                    catch (Exception e) {
                        throw new BOSException("PlugInBean Get Error:" + e.getMessage(), e.getCause());
                    }
                }
                IReflectMethod[] decorators = null;
                if (plugIn != null && billExtend != null) {
                    decorators = new IReflectMethod[]{plugIn, billExtend};
                } else if (billExtend != null) {
                    decorators = new IReflectMethod[]{billExtend};
                } else if (plugIn != null) {
                    decorators = new IReflectMethod[]{plugIn};
                }
                if (decorators != null) {
                    try {
                        this.bizBean = new HRBillBeanBizFactory(this.bizBean).getBizProxy(decorators);
                    }
                    catch (Throwable e) {
                        throw new BOSException("bizBean:" + this.bizBean.getExtendBillName(ctx) + ";plugin:" + plugIn, e);
                    }
                }
            }
        }
    }

    @Override
    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        super._setEditState(ctx, billId);
        this.updateTripEntryConfirmState(ctx, billId, 2);
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        super._setNoPassState(ctx, billId);
        this.updateTripEntryConfirmState(ctx, billId, 2);
    }

    private void updateTripEntryConfirmState(Context ctx, BOSUuid billId, int TripEntryConfirmState) {
        try {
            CanTripBillInfo canTripBillInfo = CanTripBillFactory.getLocalInstance(ctx).getCanTripBillInfo("select entries.tripEntryBill.id where id='" + billId.toString() + "'");
            String id = canTripBillInfo.getEntries().get(0).getTripEntryBill().getId().toString();
            AtsLeaveBillUtils.updateAtsTripBillEntryIsCancelTripInfo(ctx, id, TripEntryConfirmState);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _setPassState_atsCanTripBill(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        CanTripBillInfo canTripBillInfo = CanTripBillFactory.getLocalInstance(ctx).getCanTripBillInfo((IObjectPK)new ObjectUuidPK(billId.toString()));
        this.updateTripBillInfoData(ctx, canTripBillInfo);
        AtsWaitCalUtil.atsBillWaitCal(ctx, billId.toString());
        this._setState(ctx, billId, HRBillStateEnum.AUDITED);
    }

    private boolean onConfirmed(Context ctx, CanTripBillInfo model) throws EASBizException {
        String tripEntryId;
        CanTripBillEntryCollection canEntry = model == null ? null : model.getEntries();
        AtsTripBillEntryInfo tripEntry = this.getAtsTripBillEntryInfo(ctx, canEntry);
        String string = tripEntryId = tripEntry == null ? null : tripEntry.getId().toString();
        if (org.apache.commons.lang.StringUtils.isEmpty((String)tripEntryId)) {
            return true;
        }
        boolean onConfirm = true;
        try {
            String oql = "select 1 where bill.billState > 0 and bill.billState < 4 and  tripEntryBill='" + tripEntryId + "'";
            onConfirm = CanTripBillEntryFactory.getLocalInstance(ctx).exists(oql);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (onConfirm) {
            throw new AtsBillBizException(AtsBillBizException.HASCONFIRMED);
        }
        return false;
    }

    private AtsTripBillEntryInfo getAtsTripBillEntryInfo(Context ctx, CanTripBillEntryCollection canEntry) throws EASBizException {
        AtsTripBillEntryInfo tripEntry;
        AtsTripBillEntryInfo atsTripBillEntryInfo = tripEntry = !AtsCollectionUtile.isEmpty((IObjectCollection)canEntry) && canEntry.get(0) != null ? canEntry.get(0).getTripEntryBill() : null;
        if (null == tripEntry && canEntry.get(0) != null && canEntry.get(0).getId() != null) {
            try {
                CanTripBillEntryInfo _entryInfo = CanTripBillEntryFactory.getLocalInstance(ctx).getCanTripBillEntryInfo(" where id = '" + canEntry.get(0).getId().toString() + "'");
                if (_entryInfo != null) {
                    tripEntry = _entryInfo.getTripEntryBill();
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return tripEntry;
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        String fromUIPK = (String)model.get("fromUIPK");
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)fromUIPK) && !fromUIPK.equals("com.kingdee.eas.hr.ats.app.CanTripBillFormWorkflow")) {
            this.onConfirmed(ctx, (CanTripBillInfo)model);
        }
        IObjectPK iObjectPK = super.submit(ctx, model);
        CanTripBillInfo canTripBillInfo = (CanTripBillInfo)model;
        CanTripBillEntryCollection canTripBillEntryCollection = canTripBillInfo.getEntries();
        CanTripBillEntryInfo canTripBillEntryInfo = canTripBillEntryCollection.get(0);
        canTripBillEntryInfo = CanTripBillEntryFactory.getLocalInstance(ctx).getCanTripBillEntryInfo("select tripentryBill.id where id='" + canTripBillEntryInfo.getString("id") + "'");
        AtsLeaveBillUtils.updateAtsTripBillEntryIsCancelTripInfo(ctx, canTripBillEntryInfo.getTripEntryBill().getString("id"), 0);
        return iObjectPK;
    }

    private void updateTripBillInfoData(Context ctx, CanTripBillInfo canTripBillInfo) {
        CanTripBillEntryInfo canTripBillEntryInfo = canTripBillInfo.getEntries().get(0);
        AtsTripBillEntryInfo tmpAtsTripBillInfo = canTripBillEntryInfo.getTripEntryBill();
        PersonInfo person = canTripBillEntryInfo.getPerson();
        String personId = person != null && person.getId() != null ? person.getId().toString() : "";
        String tripBillId = tmpAtsTripBillInfo != null && tmpAtsTripBillInfo.getId() != null ? tmpAtsTripBillInfo.getId().toString() : "";
        try {
            AtsTripBillEntryInfo entryInfo = AtsTripBillEntryFactory.getLocalInstance(ctx).getAtsTripBillEntryInfo((IObjectPK)new ObjectUuidPK(tripBillId));
            String sql_query = "   select entry.fid entryId, bill.*,entry.*  from T_ATS_CanTripBill bill  left join  T_ATS_CanTripBillEntry entry on bill.fid = entry.fbillid  where entry.fpersonid='" + personId + "' and entry.FTripEntryBillID = '" + tripBillId + "' and bill.fbillstate != 4 and bill.fbillstate != 0 ";
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql_query);
            CanTripBillEntryCollection canTripBillEntryCollection = new CanTripBillEntryCollection();
            while (row.next()) {
                CanTripBillEntryInfo tmpEntryInfo = new CanTripBillEntryInfo();
                tmpEntryInfo.setRealTripDays(row.getBigDecimal("FRealTripDays"));
                tmpEntryInfo.setRealStartTime(row.getTimestamp("FRealStartTime"));
                tmpEntryInfo.setRealEndTime(row.getTimestamp("FRealEndTime"));
                tmpEntryInfo.setIsAllDay(row.getBoolean("FIsAllDay"));
                tmpEntryInfo.setId(BOSUuid.read((String)row.getString("entryId")));
                canTripBillEntryCollection.add(tmpEntryInfo);
            }
            if (AtsCollectionUtile.isEmpty((IObjectCollection)canTripBillEntryCollection)) {
                return;
            }
            CanTripBillEntryInfo tmpCanTripBillEntryInfo = canTripBillEntryCollection.get(0);
            entryInfo.setRealTripStartTime(tmpCanTripBillEntryInfo.getRealStartTime());
            entryInfo.setRealTripEndTime(tmpCanTripBillEntryInfo.getRealEndTime());
            entryInfo.setRealTripDays(tmpCanTripBillEntryInfo.getRealTripDays());
            entryInfo.setIsCancelTrip(TripbillCancelEnum.hasconfirm);
            entryInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
            entryInfo.setLastUpdateTime(HRTimeWebUtils.dateToTimestamp(new Date()));
            entryInfo.setIsAllDay(tmpCanTripBillEntryInfo.isIsAllDay());
            entryInfo.setIsCalOt(true);
            Set<String> entryIds = this.getNeedRecallBilEntryIds(ctx, canTripBillInfo.getId().toString());
            if (entryIds.contains(tmpCanTripBillEntryInfo.getId().toString())) {
                entryInfo.setIsRecallBill(AtsNeedReBilll.yes);
            }
            AtsTripBillEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(entryInfo.getId()), entryInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Set<String> getNeedRecallBilEntryIds(Context ctx, String billId) throws BOSException {
        if (StringUtils.isEmpty((String)billId)) {
            return new HashSet<String>();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select entry.Fid as id ").append(" from t_ats_canTripBill bill ").append(" left OUTER JOIN t_ats_CanTripBillEntry entry on bill.fid=entry.FBillID ").append(" where bill.fId = '").append(billId).append("' ");
        sql.append(" and ( ").append(" exists (").append(this.getScheduleShiftSqlByCreateTime()).append(") ").append(" or ").append(" exists (").append(this.getScheduleShiftLogSqlByCreateTime()).append(")").append(")");
        HashSet<String> entryIds = new HashSet<String>();
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (row.next()) {
                entryIds.add(row.getString("id"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return entryIds;
    }

    protected String getScheduleShiftLogSqlByCreateTime() {
        return " select 1  from t_hr_ats_attendanceFileHis his  inner join T_HR_ATS_ScheduleShiftDataLog log on his.feffdt <= log.fAttendDate and his.fleffdt >= log.fAttendDate and his.fProposerId = log.fPersonId  where  log.fOperType = '" + OperTypeEnum.scheduleShift.getValue() + "'  and log.fOperAction = '" + OperActionEnum.delete.getValue() + "'  and his.fAttendFileState = '" + AttendFileStateEnum.enable.getValue() + "'  and his.fIsAttendance = '" + IsAttendanceEnum.no.getValue() + "'  and his.fProposerId = entry.FPersonID  and log.FLastUpdateTime > bill.FCreateTime  and dateAdd(day, -1, entry.fRealStartTime) <= log.fAttendDate  and entry.fRealEndTime >= log.fAttendDate";
    }

    protected String getScheduleShiftSqlByCreateTime() {
        return "select 1 from t_hr_ats_scheduleshift C  where C.FProposerID = entry.FPersonID  and C.FLastUpdateTime > bill.FCreateTime   and dateAdd(day,-1, entry.fRealStartTime) <= C.FATTENDDATE  and entry.fRealEndTime >= C.FATTENDDATE ";
    }

    @Override
    protected void _invalid(Context ctx, String id) throws BOSException {
    }
}

