/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsHolidayFileCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileFactory;
import com.kingdee.eas.hr.ats.AtsHolidayResEnum;
import com.kingdee.eas.hr.ats.AtsNounCommonResEnum;
import com.kingdee.eas.hr.ats.AtsOverTimeBillResEnum;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.app.AbstractHolidayLimitControllerBean;
import com.kingdee.eas.hr.ats.formula.limit.LimitFormulaExecutor;
import com.kingdee.eas.hr.ats.holidayLimit.generate.manager.GenHolidayLimitManager;
import com.kingdee.eas.hr.ats.syn.datasynch.UpdateJobInstStateAndExceptionThread;
import com.kingdee.eas.hr.ats.takeWorkLimit.impl.GenerateTakeWorkLimit;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.formulaplatform.UpdateTypeEnum;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class HolidayLimitControllerBean
extends AbstractHolidayLimitControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.app.HolidayLimitControllerBean");

    @Override
    protected void _generate(Context ctx, String adminOrgUnitNum, String personNum, String holidayTypeName, String existedDealType) throws BOSException, EASBizException {
        if (this.hasRunningJob(ctx, MLUtile.getRes(AtsHolidayResEnum.GenerateLimitAuto, ctx))) {
            String content = MLUtile.getRes(AtsNounCommonResEnum.CancelForSameRunningMission, ctx);
            ExecutorService executorService = Executors.newCachedThreadPool();
            executorService.execute(new UpdateJobInstStateAndExceptionThread(ctx, content, "Aborted"));
            return;
        }
        String serviceName = "generateHolidayLimitOSF";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("adminOrgUnitNum", adminOrgUnitNum);
        param.put("personNum", personNum);
        param.put("holidayTypeName", holidayTypeName);
        param.put("existedDealType", existedDealType);
        OSFAppUtil osfUtil = new OSFAppUtil();
        OSFAppUtil.callService((Context)ctx, (String)serviceName, param);
        LimitFormulaExecutor executor = new LimitFormulaExecutor();
        executor.getFormulaCtx().setUpdateType(LimitFormulaExecutor.getUpdateTypeEnum(existedDealType));
        executor.setAdminOrgUnitNum(adminOrgUnitNum).setHolidayTypeName(holidayTypeName).setPersonsNum(personNum).setCycleDate(Date.getDateInst()).execute(ctx);
    }

    @Override
    protected void _generateForUpdate(Context ctx, String adminOrgUnitNum, String personNum, String holidayTypeName) throws BOSException, EASBizException {
        if (this.hasRunningJob(ctx, MLUtile.getRes(AtsHolidayResEnum.UpdateHolidayLimit, ctx))) {
            String content = MLUtile.getRes(AtsNounCommonResEnum.CancelForSameRunningMission, ctx);
            ExecutorService executorService = Executors.newCachedThreadPool();
            executorService.execute(new UpdateJobInstStateAndExceptionThread(ctx, content, "Aborted"));
            return;
        }
        HashMap<Object, Object> param = new HashMap<Object, Object>();
        param.put("adminOrgUnitNum", adminOrgUnitNum);
        param.put("personNum", personNum);
        param.put("holidayTypeName", holidayTypeName);
        param.put("existedDealType", "1");
        param.put("transaction", "transaction");
        GenHolidayLimitManager manager = new GenHolidayLimitManager();
        manager.generateUpdateHolidayLimit(ctx, param);
        LimitFormulaExecutor executor = new LimitFormulaExecutor();
        executor.getFormulaCtx().setUpdateType(UpdateTypeEnum.UPDATE_ONLY);
        executor.setAdminOrgUnitNum(adminOrgUnitNum).setHolidayTypeName(holidayTypeName).setPersonsNum(personNum).setCycleDate(Date.getDateInst()).execute(ctx);
    }

    @Override
    protected void _generateTW(Context ctx, String adminOrgUnitNum, String personNum, String forwardDay) throws BOSException, EASBizException {
        if (this.hasRunningJob(ctx, MLUtile.getRes(AtsOverTimeBillResEnum.OTToTakeWorkLimit, ctx))) {
            String content = MLUtile.getRes(AtsNounCommonResEnum.CancelForSameRunningMission, ctx);
            ExecutorService executorService = Executors.newCachedThreadPool();
            executorService.execute(new UpdateJobInstStateAndExceptionThread(ctx, content, "Aborted"));
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("adminOrgUnitNum", adminOrgUnitNum);
        param.put("personNum", personNum);
        param.put("forwardDay", forwardDay);
        GenerateTakeWorkLimit service = new GenerateTakeWorkLimit(ctx);
        service.generateTakeWorkLimitBackGround(ctx, param);
        LimitFormulaExecutor executor = new LimitFormulaExecutor();
        executor.getFormulaCtx().setUpdateType(UpdateTypeEnum.OVERRIDE_ADD);
        executor.setAdminOrgUnitNum(adminOrgUnitNum).setHolidayType("+ZM5jTmrS0KHCjDSYGcFLf0tUpg=").setPersonsNum(personNum).setCycleDate(Date.getDateInst()).execute(ctx);
    }

    private boolean hasRunningJob(Context ctx, String name) {
        String sql = "select * from T_JOB_INST where ftitle like '%" + name + "%' and fstate = 'Running' and fjobinstid <> '" + ctx.get((Object)"jobInstId") + "'";
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            return rowSet.next();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    protected void _reHolidayLimit(Context ctx) throws BOSException {
    }

    @Override
    protected void _transLimitForUpdate(Context ctx, String personNum, String isResEnter) throws BOSException, EASBizException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("personNum", personNum);
        param.put("isResEnter", isResEnter);
        GenHolidayLimitManager manager = new GenHolidayLimitManager();
        manager.transLimitForupdate(ctx, param);
    }

    public String validateLeaveBill(Context ctx, String personId, String holidayTypeId) throws EASBizException, BOSException {
        String errorString = "";
        String personName = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId)).getName();
        AtsHolidayFileCollection holidayFileColl = new AtsHolidayFileCollection();
        holidayFileColl = AtsHolidayFileFactory.getLocalInstance(ctx).getAtsHolidayFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
        if (holidayFileColl.size() == 0) {
            errorString = "error";
            return errorString;
        }
        if (holidayFileColl.get(0).getHolidayPolicySet() == null) {
            errorString = "error";
            return errorString;
        }
        HolidayPolicyInfo holidayPolicyInfo = null;
        try {
            holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo("  where holidayPolicySet = '" + holidayFileColl.get(0).getHolidayPolicySet().getId().toString() + "' and holidayType='" + holidayTypeId + "' ");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (holidayPolicyInfo == null) {
            errorString = "error";
            return errorString;
        }
        return errorString;
    }
}

