/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.BizDataSynchAssistInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.IAttendanceFile;
import com.kingdee.eas.hr.ats.IScheduleShift;
import com.kingdee.eas.hr.ats.IScheduleShiftItem;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.SchlShiftSrcTypeEnum;
import com.kingdee.eas.hr.ats.SchlShiftUnitEnum;
import com.kingdee.eas.hr.ats.WorkCalendarCollection;
import com.kingdee.eas.hr.ats.WorkCalendarFactory;
import com.kingdee.eas.hr.ats.WorkCalendarInfo;
import com.kingdee.eas.hr.ats.WorkCalendarItemCollection;
import com.kingdee.eas.hr.ats.WorkCalendarItemInfo;
import com.kingdee.eas.hr.ats.app.AbstractScheduleShiftControllerBean;
import com.kingdee.eas.hr.ats.helper.AtsShiftHelper;
import com.kingdee.eas.hr.ats.helper.ScheduleShiftItemHelper;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.ScheduleShiftUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.workShift.plan.autoSchedule.AutoScheduleManager;
import com.kingdee.eas.hr.ats.workShift.plan.matchSchedule.MatchScheduleManager;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.util.DateTimeUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ScheduleShiftControllerBean
extends AbstractScheduleShiftControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.app.ScheduleShiftControllerBean");
    private static Set<String> attendanceFileSet = new HashSet<String>();

    @Override
    protected void _doManualSchl(Context ctx, java.util.Date startDate, String effctDayTypeCode, SchlShiftUnitEnum schlShiftUnit, String cntValue) throws BOSException, EASBizException {
        this.doSchl(ctx, SchlShiftSrcTypeEnum.manSchlShift, effctDayTypeCode, startDate, schlShiftUnit, cntValue, "0", "1", "0");
    }

    @Override
    protected void _doSysSchl(Context ctx, String effctDayTypeCode, String schlShiftUnit, String cntValue, String preDays, String enableAutoSchedual, String autoDeleteSchedual) throws BOSException, EASBizException {
        if ("0".equals(enableAutoSchedual) && "0".equals(autoDeleteSchedual)) {
            return;
        }
        SchlShiftUnitEnum defaultSchlShiftUnitEnum = SchlShiftUnitEnum.t;
        if ("1".equals(schlShiftUnit)) {
            defaultSchlShiftUnitEnum = SchlShiftUnitEnum.t;
        } else if ("2".equals(schlShiftUnit)) {
            defaultSchlShiftUnitEnum = SchlShiftUnitEnum.w;
        } else if ("3".equals(schlShiftUnit)) {
            defaultSchlShiftUnitEnum = SchlShiftUnitEnum.m;
        }
        this.doSchl(ctx, SchlShiftSrcTypeEnum.sysSchlShift, effctDayTypeCode, null, defaultSchlShiftUnitEnum, cntValue, preDays, enableAutoSchedual, autoDeleteSchedual);
        if (StringUtils.isEmpty((CharSequence)autoDeleteSchedual) || "1".equals(autoDeleteSchedual)) {
            BizDataSynchAssistInfo bizDataSynchAssistInfo = ScheduleShiftUtils.getBizDataSynchAssistInfo(ctx);
            ScheduleShiftUtils.updateBizDataSynchAssistLastTime(ctx, bizDataSynchAssistInfo, new Timestamp(System.currentTimeMillis()));
        }
    }

    private void deleteExistedSchlShift(Context ctx, SchlShiftSrcTypeEnum srcTypeEnum, Map<Integer, Integer> dayTypeSet, Timestamp startDate_, Timestamp endDate_) throws Exception {
        if (srcTypeEnum == null) {
            srcTypeEnum = SchlShiftSrcTypeEnum.sysSchlShift;
        }
        Object[] params = new Object[]{startDate_, endDate_};
        String srcTypeString = "";
        srcTypeString = srcTypeEnum == SchlShiftSrcTypeEnum.manSchlShift ? "" : " and T_HR_ATS_ScheduleShift.FSRCTYPE = '" + srcTypeEnum.getValue() + "' ";
        String dayTypeString = "";
        if (srcTypeEnum == SchlShiftSrcTypeEnum.sysSchlShift) {
            dayTypeString = "";
        } else if (!dayTypeSet.isEmpty()) {
            dayTypeString = " and T_HR_ATS_ScheduleShift.FDAYTYPE in (";
            Iterator<Integer> it1 = dayTypeSet.keySet().iterator();
            while (it1.hasNext()) {
                dayTypeString = dayTypeString + it1.next() + ",";
            }
            dayTypeString = dayTypeString.substring(0, dayTypeString.length() - 1);
            dayTypeString = dayTypeString + ") ";
        }
        String sql1 = " delete  from T_HR_ATS_ScheduleShiftItem     where exists(select 1 from T_HR_ATS_ScheduleShift   where T_HR_ATS_ScheduleShift.fid=T_HR_ATS_ScheduleShiftItem.fgroupid " + srcTypeString + dayTypeString + " and T_HR_ATS_ScheduleShift.FATTENDDATE between ? and ? ) ";
        String sql2 = " delete  from T_HR_ATS_ScheduleShift  where 1=1 " + srcTypeString + dayTypeString + " and T_HR_ATS_ScheduleShift.FATTENDDATE between ? and ? ";
        DbUtil.execute((Context)ctx, (String)sql1, (Object[])params);
        DbUtil.execute((Context)ctx, (String)sql2, (Object[])params);
    }

    private Set<String> getExistedSchlShiftMap(Context ctx, List attendanceFileList, java.util.Date startDate, java.util.Date endDate) throws Exception {
        String fattendanceFileId = "''";
        for (Object obj : attendanceFileList) {
            fattendanceFileId = fattendanceFileId + ",'" + ((AttendanceFileInfo)obj).getId().toString() + "'";
        }
        HashSet<String> existedSchlShiftMap = new HashSet<String>();
        String sql = " select shift.fid,shift.fattendfileid,shift.fattenddate,shift.fproposerid,shift.fdaytype from t_hr_ats_scheduleshift shift  where shift.fattenddate between ? and ? and shift.fattendfileid in(" + fattendanceFileId + ")";
        Object[] params = new Object[]{new Date(startDate.getTime()), new Date(endDate.getTime())};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        if (rowSet != null) {
            while (rowSet.next()) {
                Date sqlDate = rowSet.getDate("fattenddate");
                String fattendfileid = rowSet.getString("fattendfileid");
                if (StringUtils.isEmpty((CharSequence)fattendfileid)) continue;
                String key = fattendfileid + "_" + this.dateShortToString(new java.util.Date(sqlDate.getTime()));
                existedSchlShiftMap.add(key);
            }
        }
        return existedSchlShiftMap;
    }

    private void doSchl(Context ctx, SchlShiftSrcTypeEnum srcTypeEnum, String effctDayTypeCode, java.util.Date schlStartDate, SchlShiftUnitEnum schlShiftUnit, String cntValue, String preDays, String enableAutoSchedual, String autoDeleteSchedual) throws BOSException, EASBizException {
        EntityViewInfo evi;
        logger.error((Object)("-----execute transaction start time\uff1a" + AtsDateUtils.dateLongToString(new java.util.Date()) + "-----\n"));
        int cntValueFromStr = 1;
        if (StringUtils.isEmpty((CharSequence)cntValue)) {
            cntValue = "1";
        }
        cntValueFromStr = (cntValueFromStr = Integer.parseInt(cntValue)) < 0 ? 0 : cntValueFromStr;
        int preDaysFromStr = 0;
        if (StringUtils.isEmpty((CharSequence)preDays)) {
            preDays = "0";
        }
        preDaysFromStr = (preDaysFromStr = Integer.parseInt(preDays)) > 40 ? 40 : preDaysFromStr;
        Map<String, AtsShiftInfo> treeMap = AtsShiftHelper.getAllAtsShiftKeyId(ctx);
        int length = 100;
        int start = 0;
        IAttendanceFile attendanceFile = AttendanceFileFactory.getLocalInstance(ctx);
        int totalRecords = attendanceFile.getCount(evi = this.getAttendanceFileEntityViewInfo());
        if (length + start > totalRecords) {
            length = totalRecords - start;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        Calendar startCalendar_final = Calendar.getInstance();
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        startCalendar.setTimeInMillis(startCalendar_final.getTimeInMillis() + 86400000L);
        endCalendar.setTimeInMillis(startCalendar_final.getTimeInMillis());
        if (schlStartDate != null) {
            try {
                startCalendar_final.setTime(schlStartDate);
                startCalendar.setTimeInMillis(startCalendar_final.getTimeInMillis() + 86400000L);
                endCalendar.setTimeInMillis(startCalendar_final.getTimeInMillis());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int n = cntValueFromStr = cntValueFromStr < 1 ? 1 : cntValueFromStr;
        if (schlShiftUnit == null) {
            endCalendar.add(5, 1 * cntValueFromStr);
        } else if ("1".equals(schlShiftUnit.getValue())) {
            endCalendar.add(5, 1 * cntValueFromStr);
        } else if ("2".equals(schlShiftUnit.getValue())) {
            endCalendar.add(5, 7 * cntValueFromStr);
        } else if ("3".equals(schlShiftUnit.getValue())) {
            endCalendar.add(2, cntValueFromStr);
        } else {
            endCalendar.add(2, 3);
        }
        if (preDaysFromStr >= 0) {
            startCalendar.add(5, -preDaysFromStr - 1);
        }
        long days = (endCalendar.getTimeInMillis() - startCalendar.getTimeInMillis()) / 86400000L + 1L;
        java.util.Date startDate = startCalendar.getTime();
        java.util.Date endDate = endCalendar.getTime();
        Timestamp startDate_ = new Timestamp(startDate.getTime());
        Timestamp endDate_ = new Timestamp(endDate.getTime());
        try {
            startDate_ = new Timestamp(sdf.parse(sdf2.format(startDate) + " 00:00:00").getTime());
            endDate_ = new Timestamp(sdf.parse(sdf2.format(endDate) + " 23:59:59").getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (srcTypeEnum == null) {
            srcTypeEnum = SchlShiftSrcTypeEnum.sysSchlShift;
        }
        Map<Integer, Integer> dayTypeSet = this.getDayTypeSet(effctDayTypeCode);
        try {
            Calendar curCalendar_final = Calendar.getInstance();
            Calendar curCalendar = Calendar.getInstance();
            curCalendar.setTimeInMillis(curCalendar_final.getTimeInMillis() + 86400000L);
            java.util.Date curStartDate = curCalendar.getTime();
            Timestamp curStartDate_ = new Timestamp(curStartDate.getTime());
            try {
                curStartDate_ = new Timestamp(sdf.parse(sdf2.format(curStartDate) + " 00:00:00").getTime());
                if (StringUtils.isEmpty((CharSequence)enableAutoSchedual) || "1".equals(enableAutoSchedual)) {
                    this.deleteExistedSchlShift(ctx, srcTypeEnum, dayTypeSet, curStartDate_, endDate_);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Calendar tempCalendar = Calendar.getInstance();
            long lastExcuteTime = this.getLastsynchtime(ctx);
            while (start + length <= totalRecords) {
                List attendanceFileList = this.getAttendanceFileBatch(attendanceFile, evi, start, length);
                ArrayList<String> personIdList = new ArrayList<String>(1000);
                int size = attendanceFileList.size();
                for (int i = 0; i < size; ++i) {
                    personIdList.add(((AttendanceFileInfo)attendanceFileList.get(i)).getProposer().getId().toString());
                }
                String personIdStr = "";
                if (personIdList.size() > 0) {
                    personIdStr = AtsUtil.getStrFromList(personIdList);
                    personIdStr = personIdStr.substring(1, personIdStr.length() - 1);
                }
                Map<String, AttendanceFileInfo> fileInfoObject = AtsServerUtils.getAttendanceFileInfoByPersonId(ctx, personIdStr, AtsDateUtils.dateShortToString(startDate), AtsDateUtils.dateShortToString(endDate));
                List<Map<String, java.util.Date>> enterDateAndLeftDateList = this.getEnterDateAndLeftDate(ctx, attendanceFileList);
                if (StringUtils.isEmpty((CharSequence)autoDeleteSchedual) || "1".equals(autoDeleteSchedual)) {
                    this.deleteScheduleShiftAfterOffDate(ctx, enterDateAndLeftDateList, attendanceFileList, lastExcuteTime);
                }
                if (StringUtils.isEmpty((CharSequence)enableAutoSchedual) || "1".equals(enableAutoSchedual)) {
                    ArrayList<AttendanceFileInfo> fileHisList = new ArrayList<AttendanceFileInfo>(100);
                    for (Map.Entry<String, AttendanceFileInfo> entry : fileInfoObject.entrySet()) {
                        fileHisList.add(entry.getValue());
                    }
                    Set<String> workCalendarIdSet = this.getWorkCalendarIdSet(fileHisList);
                    if (workCalendarIdSet != null && !workCalendarIdSet.isEmpty()) {
                        Map<String, Object> workCalendarItemMap = null;
                        Set<String> existedSchlShiftMap = null;
                        if (days <= 10L) {
                            workCalendarItemMap = this.getWorkCalendarItem(ctx, workCalendarIdSet, startDate_, endDate_);
                            existedSchlShiftMap = this.getExistedSchlShiftMap(ctx, attendanceFileList, startDate_, endDate_);
                            this.saveSysSchl(ctx, srcTypeEnum, dayTypeSet, attendanceFileList, fileInfoObject, workCalendarItemMap, existedSchlShiftMap, treeMap, enterDateAndLeftDateList);
                        } else {
                            java.util.Date tempDate_;
                            java.util.Date tempDate;
                            int j = 0;
                            while ((long)(j + 10) <= days) {
                                tempCalendar.setTimeInMillis(startCalendar.getTimeInMillis() + 777600000L);
                                tempDate_ = tempDate = tempCalendar.getTime();
                                try {
                                    tempDate_ = sdf.parse(sdf2.format(tempDate) + " 23:59:59");
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                workCalendarItemMap = this.getWorkCalendarItem(ctx, workCalendarIdSet, startDate_, tempDate_);
                                existedSchlShiftMap = this.getExistedSchlShiftMap(ctx, attendanceFileList, startDate_, endDate_);
                                this.saveSysSchl(ctx, srcTypeEnum, dayTypeSet, attendanceFileList, fileInfoObject, workCalendarItemMap, existedSchlShiftMap, treeMap, enterDateAndLeftDateList);
                                startCalendar.setTimeInMillis(tempCalendar.getTimeInMillis() + 86400000L);
                                startDate = startCalendar.getTime();
                                try {
                                    startDate_ = new Timestamp(sdf.parse(sdf2.format(startDate) + " 00:00:00").getTime());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                j += 10;
                            }
                            if ((long)j != days) {
                                tempCalendar.setTimeInMillis(startCalendar.getTimeInMillis() + (days - (long)j - 1L) * 24L * 60L * 60L * 1000L);
                                tempDate_ = tempDate = tempCalendar.getTime();
                                try {
                                    tempDate_ = sdf.parse(sdf2.format(tempDate) + " 23:59:59");
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                workCalendarItemMap = this.getWorkCalendarItem(ctx, workCalendarIdSet, startDate_, tempDate_);
                                existedSchlShiftMap = this.getExistedSchlShiftMap(ctx, attendanceFileList, startDate_, endDate_);
                                this.saveSysSchl(ctx, srcTypeEnum, dayTypeSet, attendanceFileList, fileInfoObject, workCalendarItemMap, existedSchlShiftMap, treeMap, enterDateAndLeftDateList);
                            }
                        }
                    }
                }
                if ((start += length) >= totalRecords) {
                    return;
                }
                if (start + length >= totalRecords) {
                    length = totalRecords - start;
                }
                Calendar temp_startCalendar_final = Calendar.getInstance();
                Calendar tempStartDate = Calendar.getInstance();
                tempStartDate.setTimeInMillis(temp_startCalendar_final.getTimeInMillis() + 86400000L);
                if (preDaysFromStr >= 0) {
                    tempStartDate.add(5, -preDaysFromStr - 1);
                }
                startCalendar.setTimeInMillis(tempStartDate.getTimeInMillis());
                startDate = startCalendar.getTime();
                try {
                    startDate_ = new Timestamp(sdf.parse(sdf2.format(startDate) + " 00:00:00").getTime());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                logger.error((Object)(MLUtile.getRes((ResourceEnum)AtsFileResEnum.ExecuteByPage, ctx, 100) + AtsDateUtils.dateLongToString(new java.util.Date()) + "----\n"));
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\n-------------auto scheduleshit BOSException begin----------------\n");
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)"\n-------------auto scheduleshit EASBizException begin----------------\n");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"\n-------------auto scheduleshit Exception begin----------------\n");
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        logger.error((Object)("-----transaction exucet end time\uff1a " + AtsDateUtils.dateLongToString(new java.util.Date()) + "-----\n"));
    }

    private Set<String> getAllAttendanceFile(Context ctx) {
        HashSet<String> set = new HashSet<String>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo orgfilterInfo = new FilterInfo();
        java.util.Date effectDate = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
        orgfilterInfo.getFilterItems().add(new FilterItemInfo("EMPPOSORGRELATION.EFFDT", (Object)effectDate, CompareType.LESS_EQUALS));
        orgfilterInfo.getFilterItems().add(new FilterItemInfo("EMPPOSORGRELATION.LEFFDT", (Object)effectDate, CompareType.GREATER));
        orgfilterInfo.getFilterItems().add(new FilterItemInfo("PRIMARYPOSITION.EFFDT", (Object)effectDate, CompareType.LESS_EQUALS));
        orgfilterInfo.getFilterItems().add(new FilterItemInfo("PRIMARYPOSITION.LEFFDT", (Object)effectDate, CompareType.GREATER));
        orgfilterInfo.getFilterItems().add(new FilterItemInfo("EMPPOSORGRELATION.assignType", (Object)1, CompareType.EQUALS));
        orgfilterInfo.getFilterItems().add(new FilterItemInfo("EMPPOSORGRELATION.isInner", (Object)1, CompareType.EQUALS));
        orgfilterInfo.getFilterItems().add(new FilterItemInfo("PERSON.EMPLOYEETYPE.ISINCOUNT", (Object)1, CompareType.EQUALS));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(selectors);
        viewInfo.setFilter(orgfilterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.ats.app", "PersonExistAttdFileQuery"));
        iqec.setObjectView(viewInfo);
        try {
            IRowSet rowSet = iqec.executeQuery();
            while (rowSet.next()) {
                String id = rowSet.getString("id");
                set.add(id);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return set;
    }

    private Integer getAdvcBySchlShiftSrcType(SchlShiftSrcTypeEnum srcTypeEnum) {
        if (srcTypeEnum == SchlShiftSrcTypeEnum.sysSchlShift) {
            return 1;
        }
        if (srcTypeEnum == SchlShiftSrcTypeEnum.manSchlShift) {
            return 2;
        }
        return 1;
    }

    private void saveSysSchl(Context ctx, SchlShiftSrcTypeEnum srcTypeEnum, Map<Integer, Integer> dayTypeSet, List attendanceFileList, Map<String, AttendanceFileInfo> fileHisMap, Map<String, Object> workCalendarItemMap, Set<String> existedSchlShiftMap, Map<String, AtsShiftInfo> allShiftMap, List<Map<String, java.util.Date>> enterDateAndLeftDateList) throws BOSException, EASBizException {
        if (attendanceFileList == null || workCalendarItemMap == null || attendanceFileList.isEmpty() || workCalendarItemMap.isEmpty()) {
            return;
        }
        IScheduleShift scheduleShift = ScheduleShiftFactory.getLocalInstance(ctx);
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < attendanceFileList.size(); ++i) {
            WorkCalendarItemCollection workCalendarItemList;
            AttendanceFileInfo attendanceFileInfo = (AttendanceFileInfo)attendanceFileList.get(i);
            String personId = "";
            if (attendanceFileInfo == null || attendanceFileInfo.getProposer() == null || attendanceFileInfo.getProposer().getId() == null) continue;
            personId = attendanceFileInfo.getProposer().getId().toString();
            HolidayPolicySetInfo hlpcSetInfo = null;
            AttencePolicyInfo attencePolicyInfo = null;
            WorkCalendarInfo workCalendarInfo = null;
            AttendanceFileInfo cloneaAttendanceFileInfo = (AttendanceFileInfo)attendanceFileInfo.clone();
            hlpcSetInfo = attendanceFileInfo.getHolidayPolicySet();
            attencePolicyInfo = attendanceFileInfo.getAttencePolicy();
            if (attencePolicyInfo != null) {
                workCalendarInfo = attencePolicyInfo.getWorkCalendar();
            }
            if (workCalendarInfo == null || workCalendarInfo.getId() == null || (workCalendarItemList = (WorkCalendarItemCollection)((Object)workCalendarItemMap.get(workCalendarInfo.getId().toString()))) == null || workCalendarItemList.isEmpty()) continue;
            java.util.Date enterDate = enterDateAndLeftDateList.get(0).get(personId);
            java.util.Date leftDate = enterDateAndLeftDateList.get(1).get(personId);
            for (int j = 0; j < workCalendarItemList.size(); ++j) {
                String key;
                WorkCalendarItemInfo workCalendarItemInfo = workCalendarItemList.get(j);
                String attKey = personId + "_" + AtsDateUtils.dateShortToString(workCalendarItemInfo.getDate());
                if (fileHisMap.get(attKey) == null || "0".equals((attendanceFileInfo = fileHisMap.get(attKey)).getIsAttendance().getValue()) || "0".equals(attendanceFileInfo.getIsAutoShift().getValue())) continue;
                hlpcSetInfo = attendanceFileInfo.getHolidayPolicySet();
                attencePolicyInfo = attendanceFileInfo.getAttencePolicy();
                WorkCalendarItemInfo workCalendarItemInfoHIS = null;
                WorkCalendarItemCollection workCalendarItemListHIS = (WorkCalendarItemCollection)((Object)workCalendarItemMap.get(attencePolicyInfo.getWorkCalendar().getId().toString()));
                int size = workCalendarItemListHIS.size();
                for (int k = 0; k < size; ++k) {
                    if (workCalendarItemInfo.getDate().getTime() != workCalendarItemListHIS.get(k).getDate().getTime()) continue;
                    workCalendarItemInfoHIS = workCalendarItemListHIS.get(k);
                    break;
                }
                if (workCalendarItemInfoHIS == null) continue;
                workCalendarItemInfo = workCalendarItemInfoHIS;
                if (leftDate != null && enterDate != null && leftDate.getTime() > enterDate.getTime() && (workCalendarItemInfo.getDate().getTime() > leftDate.getTime() || workCalendarItemInfo.getDate().getTime() < enterDate.getTime()) || enterDate != null && leftDate == null && workCalendarItemInfo.getDate().getTime() < enterDate.getTime() || leftDate != null && enterDate != null && leftDate.getTime() < enterDate.getTime() && workCalendarItemInfo.getDate().getTime() > leftDate.getTime() && workCalendarItemInfo.getDate().getTime() < enterDate.getTime() || existedSchlShiftMap.contains(key = cloneaAttendanceFileInfo.getId().toString() + "_" + this.dateShortToString(workCalendarItemInfo.getDate()))) continue;
                ScheduleShiftInfo scheduleShiftInfo = new ScheduleShiftInfo();
                AtsShiftInfo validShift = attendanceFileInfo.getAtsShift();
                validShift = validShift == null ? new AtsShiftInfo() : allShiftMap.get(validShift.getId().toString());
                if (dayTypeSet.get(new Integer(workCalendarItemInfo.getDayType().getValue())) == 1) {
                    scheduleShiftInfo.setDefaultShift(validShift);
                } else {
                    scheduleShiftInfo.setDefaultShift(null);
                }
                scheduleShiftInfo.setCardRule(validShift.getCardRule());
                scheduleShiftInfo.setOtCompens(validShift.getOtCompens());
                scheduleShiftInfo.setShiftType(validShift.getShiftType());
                scheduleShiftInfo.setStandardHour(validShift.getStandardHour());
                scheduleShiftInfo.setIsElastic(validShift.isIsElastic());
                scheduleShiftInfo.setElasticType(validShift.getElasticType());
                scheduleShiftInfo.setElasticDirection(validShift.getElasticDirection());
                scheduleShiftInfo.setElasticValue(validShift.getElasticValue());
                scheduleShiftInfo.setAttendFile(cloneaAttendanceFileInfo);
                scheduleShiftInfo.setHldPlcSet(hlpcSetInfo);
                scheduleShiftInfo.setAttendPolicy(attencePolicyInfo);
                scheduleShiftInfo.setAttendDate(workCalendarItemInfo.getDate());
                scheduleShiftInfo.setDayType(workCalendarItemInfo.getDayType());
                scheduleShiftInfo.setSrcType(srcTypeEnum);
                scheduleShiftInfo.setAdvcValue(this.getAdvcBySchlShiftSrcType(srcTypeEnum));
                scheduleShiftInfo.setProposer(attendanceFileInfo.getProposer());
                scheduleShiftInfo.setAdminOrgUnit(attendanceFileInfo.getAdminOrgUnit());
                scheduleShiftInfo.setHrOrgUnit(attendanceFileInfo.getHrOrgUnit());
                scheduleShiftInfo.setPosition(attendanceFileInfo.getPosition());
                scheduleShiftInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                colls.add((CoreBaseInfo)scheduleShiftInfo);
            }
        }
        if (!colls.isEmpty()) {
            IScheduleShiftItem scheduleShiftItem = ScheduleShiftItemFactory.getLocalInstance(ctx);
            CoreBaseCollection colls2 = new CoreBaseCollection();
            IObjectPK[] pkArr = scheduleShift.saveBatchData(colls);
            int size = colls.size() <= pkArr.length ? colls.size() : pkArr.length;
            for (int k = 0; k < size; ++k) {
                ScheduleShiftInfo scheduleShiftInfo = (ScheduleShiftInfo)colls.get(k);
                if (scheduleShiftInfo.getDefaultShift() == null || scheduleShiftInfo.getDefaultShift().getItems() == null || scheduleShiftInfo.getDefaultShift().getItems().isEmpty()) continue;
                AtsShiftItemCollection atsShiftItemCollection = scheduleShiftInfo.getDefaultShift().getItems();
                java.util.Date atdt = scheduleShiftInfo.getAttendDate();
                String atdtString = this.dateShortToString(atdt);
                Calendar atdtNextDayCal = Calendar.getInstance();
                atdtNextDayCal.setTimeInMillis(atdt.getTime() + 86400000L);
                String atdtNextDayString = this.dateShortToString(atdtNextDayCal.getTime());
                Calendar atdtPreDayCal = Calendar.getInstance();
                atdtPreDayCal.setTimeInMillis(atdt.getTime() - 86400000L);
                String atdtPreDayString = this.dateShortToString(atdtPreDayCal.getTime());
                String preTimeStr = "";
                String preDateTimeStr = "";
                String nextTimeStr = "";
                String nextDateTimeStr = "";
                String restPreTime = "";
                for (int m = 0; m < atsShiftItemCollection.size(); ++m) {
                    AtsShiftItemInfo atsShiftItemInfo = atsShiftItemCollection.get(m);
                    ScheduleShiftItemInfo scheduleShiftItemInfo = new ScheduleShiftItemInfo();
                    scheduleShiftItemInfo.setShiftItem(atsShiftItemInfo);
                    scheduleShiftItemInfo.setGroup(scheduleShiftInfo);
                    scheduleShiftItemInfo.setSegment(atsShiftItemInfo.getSegment());
                    scheduleShiftItemInfo.setPreTime(atsShiftItemInfo.getPreTime());
                    scheduleShiftItemInfo.setPreFloatAdjusted(atsShiftItemInfo.getPreFloatAdjusted());
                    scheduleShiftItemInfo.setPreUnit(atsShiftItemInfo.getPreUnit());
                    scheduleShiftItemInfo.setPreIsPunchCard(atsShiftItemInfo.getPreIsPunchCard());
                    scheduleShiftItemInfo.setNextTime(atsShiftItemInfo.getNextTime());
                    scheduleShiftItemInfo.setNextFloatAdjusted(atsShiftItemInfo.getNextFloatAdjusted());
                    scheduleShiftItemInfo.setNextUnit(atsShiftItemInfo.getNextUnit());
                    scheduleShiftItemInfo.setNextIsPunchCard(atsShiftItemInfo.getNextIsPunchCard());
                    scheduleShiftItemInfo.setSegmentInRest(atsShiftItemInfo.getSegmentInRest());
                    scheduleShiftItemInfo.setAttendanceType(atsShiftItemInfo.getAttendanceType());
                    scheduleShiftItemInfo.setPreTimeDayType(atsShiftItemInfo.getPreTimeDayType());
                    scheduleShiftItemInfo.setNextTimeDayType(atsShiftItemInfo.getNextTimeDayType());
                    preTimeStr = atsShiftItemInfo.getPreTime();
                    int preTimeValue = atsShiftItemInfo.getPreTimeDayType().getValue();
                    preDateTimeStr = ScheduleShiftItemHelper.getRealTimeByType(preTimeValue, atdtString, atdtPreDayString, atdtNextDayString, preTimeStr);
                    scheduleShiftItemInfo.setPreTime(preTimeStr);
                    scheduleShiftItemInfo.setPreDateTime(AtsDateUtils.stringToTimestamp(preDateTimeStr));
                    int nextTimeValue = atsShiftItemInfo.getNextTimeDayType().getValue();
                    nextTimeStr = atsShiftItemInfo.getNextTime();
                    nextDateTimeStr = ScheduleShiftItemHelper.getRealTimeByType(nextTimeValue, atdtString, atdtPreDayString, atdtNextDayString, nextTimeStr);
                    scheduleShiftItemInfo.setNextTime(nextTimeStr);
                    scheduleShiftItemInfo.setNextDateTime(AtsDateUtils.stringToTimestamp(nextDateTimeStr));
                    restPreTime = atsShiftItemInfo.getRestPreTime();
                    String restNextTime = atsShiftItemInfo.getRestNextTime();
                    if (!StringUtils.isEmpty((CharSequence)restPreTime) && !StringUtils.isEmpty((CharSequence)restNextTime)) {
                        scheduleShiftItemInfo.setRestPreTime(restPreTime);
                        scheduleShiftItemInfo.setRestPreDateTime(AtsDateUtils.stringToTimestamp(ScheduleShiftItemHelper.getRealRestTime(preTimeStr, preTimeValue, restPreTime, restNextTime, atdtString, atdtPreDayString, atdtNextDayString, "restPreTime")));
                        scheduleShiftItemInfo.setRestNextTime(restNextTime);
                        scheduleShiftItemInfo.setRestNextDateTime(AtsDateUtils.stringToTimestamp(ScheduleShiftItemHelper.getRealRestTime(preTimeStr, preTimeValue, restPreTime, restNextTime, atdtString, atdtPreDayString, atdtNextDayString, "restNextTime")));
                    }
                    colls2.add((CoreBaseInfo)scheduleShiftItemInfo);
                }
            }
            scheduleShiftItem.saveBatchData(colls2);
        }
    }

    private String dateShortToString(java.util.Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    private Map<Integer, Integer> getDayTypeSet(String effctDayTypeCode) {
        HashMap<Integer, Integer> dayTypeSet = new HashMap<Integer, Integer>();
        if (effctDayTypeCode == null || effctDayTypeCode.length() < 1) {
            dayTypeSet.put(DayTypeEnum.workDay.getValue(), 1);
        } else {
            for (int i = 0; i < effctDayTypeCode.length(); ++i) {
                char c = effctDayTypeCode.charAt(i);
                if (i == 0) {
                    if (c == '0') {
                        dayTypeSet.put(DayTypeEnum.workDay.getValue(), 0);
                        continue;
                    }
                    dayTypeSet.put(DayTypeEnum.workDay.getValue(), 1);
                    continue;
                }
                if (i == 1) {
                    if (c == '0') {
                        dayTypeSet.put(DayTypeEnum.restDay.getValue(), 0);
                        continue;
                    }
                    dayTypeSet.put(DayTypeEnum.restDay.getValue(), 1);
                    continue;
                }
                if (i != 2) continue;
                if (c == '0') {
                    dayTypeSet.put(DayTypeEnum.legalHoliday.getValue(), 0);
                    continue;
                }
                dayTypeSet.put(DayTypeEnum.legalHoliday.getValue(), 1);
            }
        }
        return dayTypeSet;
    }

    private List getAttendanceFileBatch(IAttendanceFile attendanceFile, EntityViewInfo view, int start, int length) throws BOSException {
        return attendanceFile.getPagingList(view, start, length);
    }

    private Set<String> getWorkCalendarIdSet(List attendanceFileList) {
        if (attendanceFileList == null || attendanceFileList.isEmpty()) {
            return null;
        }
        HashSet<String> workCalendarIdSet = new HashSet<String>();
        for (int i = 0; i < attendanceFileList.size(); ++i) {
            WorkCalendarInfo workCalendarInfo;
            AttendanceFileInfo attendanceFileInfo = (AttendanceFileInfo)attendanceFileList.get(i);
            AttencePolicyInfo attencePolicyInfo = attendanceFileInfo.getAttencePolicy();
            if (attencePolicyInfo == null || (workCalendarInfo = attencePolicyInfo.getWorkCalendar()) == null) continue;
            String id = workCalendarInfo.getId().toString();
            workCalendarIdSet.add(id);
        }
        return workCalendarIdSet;
    }

    private Map<String, Object> getWorkCalendarItem(Context ctx, Set<String> workCalendarIdSet, java.util.Date startDate, java.util.Date endDate) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", workCalendarIdSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("items.id"));
        evi.getSelector().add(new SelectorItemInfo("items.date"));
        evi.getSelector().add(new SelectorItemInfo("items.dayType"));
        evi.getSelector().add(new SelectorItemInfo("items.week"));
        WorkCalendarCollection workCalendarCollection = WorkCalendarFactory.getLocalInstance(ctx).getWorkCalendarCollection(evi);
        if (workCalendarCollection != null && !workCalendarCollection.isEmpty()) {
            HashMap<String, Object> workCalendarMap = new HashMap<String, Object>();
            for (int i = 0; i < workCalendarCollection.size(); ++i) {
                WorkCalendarInfo calendarInfo = workCalendarCollection.get(i);
                WorkCalendarItemCollection itemColls = calendarInfo.getItems();
                Iterator it = itemColls.iterator();
                while (it.hasNext()) {
                    WorkCalendarItemInfo itemInfo = (WorkCalendarItemInfo)it.next();
                    if (itemInfo.getDate().getTime() >= startDate.getTime() && itemInfo.getDate().getTime() <= endDate.getTime()) continue;
                    it.remove();
                }
                if (itemColls == null || itemColls.size() <= 0) continue;
                workCalendarMap.put(calendarInfo.getId().toString(), (Object)itemColls);
            }
            return workCalendarMap;
        }
        return null;
    }

    private EntityViewInfo getAttendanceFileEntityViewInfo() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("attendFileState", (Object)AttendFileStateEnum.enable.getValue(), CompareType.EQUALS));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("isAutoShift"));
        evi.getSelector().add(new SelectorItemInfo("fileType"));
        evi.getSelector().add(new SelectorItemInfo("proposer.id"));
        evi.getSelector().add(new SelectorItemInfo("proposer.name"));
        evi.getSelector().add(new SelectorItemInfo("proposer.number"));
        evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
        evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.name"));
        evi.getSelector().add(new SelectorItemInfo("position.id"));
        evi.getSelector().add(new SelectorItemInfo("position.name"));
        evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.id"));
        evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.name"));
        evi.getSelector().add(new SelectorItemInfo("atsShift.id"));
        evi.getSelector().add(new SelectorItemInfo("atsShift.number"));
        evi.getSelector().add(new SelectorItemInfo("atsShift.name"));
        evi.getSelector().add(new SelectorItemInfo("atsShift.cardRule.id"));
        evi.getSelector().add(new SelectorItemInfo("atsShift.cardRule.name"));
        evi.getSelector().add(new SelectorItemInfo("atsShift.otCompens.id"));
        evi.getSelector().add(new SelectorItemInfo("atsShift.otCompens.name"));
        evi.getSelector().add(new SelectorItemInfo("atsShift.shiftType.id"));
        evi.getSelector().add(new SelectorItemInfo("atsShift.shiftType.name"));
        evi.getSelector().add(new SelectorItemInfo("atsShift.standardHour"));
        evi.getSelector().add(new SelectorItemInfo("attencePolicy.id"));
        evi.getSelector().add(new SelectorItemInfo("attencePolicy.number"));
        evi.getSelector().add(new SelectorItemInfo("attencePolicy.name"));
        evi.getSelector().add(new SelectorItemInfo("attencePolicy.leaveIsCal"));
        evi.getSelector().add(new SelectorItemInfo("attencePolicy.workCalendar.id"));
        evi.getSelector().add(new SelectorItemInfo("attencePolicy.workCalendar.number"));
        evi.getSelector().add(new SelectorItemInfo("attencePolicy.workCalendar.name"));
        evi.getSelector().add(new SelectorItemInfo("holidayPolicySet.id"));
        evi.getSelector().add(new SelectorItemInfo("holidayPolicySet.number"));
        evi.getSelector().add(new SelectorItemInfo("holidayPolicySet.name"));
        SorterItemInfo s1 = new SorterItemInfo("id");
        s1.setSortType(SortType.ASCEND);
        evi.getSorter().add(s1);
        return evi;
    }

    @Override
    protected void _scheduleShiftTriggerCal(Context ctx, String attendDate, String adminOrgUnitId, String personIds, String hrOrgUnitId) throws BOSException, EASBizException {
        String serviceName = "scheduleShiftTrigerCalculateOSF";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("attendDate", attendDate);
        param.put("adminOrgUnitId", adminOrgUnitId);
        param.put("personIds", personIds);
        param.put("hrOrgUnitId", hrOrgUnitId);
        Object osfObject = OSFAppUtil.callService((Context)ctx, (String)serviceName, param);
    }

    @Override
    protected void _scheduleImportTriggerCal(Context ctx, String attendDate, String personIds, String hrOrgUnitId) throws BOSException, EASBizException {
        String serviceName = "scheduleImportTrigerCalculateOSF";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("attendDate", attendDate);
        param.put("personIds", personIds);
        param.put("hrOrgUnitId", hrOrgUnitId);
        Object osfObject = OSFAppUtil.callService((Context)ctx, (String)serviceName, param);
    }

    private Map<String, java.util.Date> getEnterDateFromLabor(Context ctx, String personIds) {
        StringBuffer sql = new StringBuffer();
        sql.append("select fpersonid,FEnterDate from T_HR_EmpLaborRelation pp where 1=1 ");
        if (StringUtils.isNotBlank((CharSequence)personIds)) {
            sql.append("and  fpersonid in (").append(personIds).append(")");
        }
        sql.append(" and FCreateTime= (select MAX(FCreateTime) from T_HR_EmpLaborRelation WHERE fpersonid =pp.fpersonid)");
        HashMap<String, java.util.Date> personEnterDate = new HashMap<String, java.util.Date>();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                personEnterDate.put(rowSet.getString("fpersonid"), rowSet.getDate("FEnterDate"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return personEnterDate;
    }

    private List<Map<String, java.util.Date>> getEnterDateAndLeftDate(Context ctx, List attendanceFileList) {
        StringBuffer personIdBuf = new StringBuffer("'");
        for (AttendanceFileInfo file : attendanceFileList) {
            if (file.getProposer() == null || file.getProposer().getId() == null) continue;
            personIdBuf.append(file.getProposer().getId().toString()).append("','");
        }
        String personIds = personIdBuf.substring(0, personIdBuf.length() - 2);
        ArrayList<Map<String, java.util.Date>> list = new ArrayList<Map<String, java.util.Date>>();
        Map<String, java.util.Date> enterDateFromLabor = this.getEnterDateFromLabor(ctx, personIds);
        String osql = "select person.id,leftDate where person.id in (" + personIds + ")";
        try {
            PersonPositionCollection ppCollection = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(osql);
            if (ppCollection != null && !ppCollection.isEmpty()) {
                HashMap<String, java.util.Date> dataMap = new HashMap<String, java.util.Date>();
                HashMap<String, java.util.Date> leftDateMap = new HashMap<String, java.util.Date>();
                HashMap<String, Timestamp> updateDateMap = new HashMap<String, Timestamp>();
                PersonPositionInfo ppInfo = null;
                for (int i = 0; i < ppCollection.size(); ++i) {
                    ppInfo = ppCollection.get(i);
                    String personId = ppInfo.getPerson().getId().toString();
                    java.util.Date dbEnterDate = enterDateFromLabor.get(personId);
                    java.util.Date valueObject = (java.util.Date)dataMap.get(personId);
                    java.util.Date leftDateObject = (java.util.Date)leftDateMap.get(personId);
                    java.util.Date updateDateObject = (java.util.Date)updateDateMap.get(personId);
                    if (valueObject != null) {
                        long dbDateNum;
                        long l = dbDateNum = dbEnterDate == null ? 0L : dbEnterDate.getTime();
                        if (valueObject.getTime() < dbDateNum) {
                            dataMap.put(personId, dbEnterDate);
                        }
                    } else {
                        dataMap.put(personId, dbEnterDate);
                    }
                    if (ppInfo.getLeftDate() != null) {
                        if (leftDateObject != null) {
                            long dbLeftDateNum;
                            java.util.Date dbLeftDate = ppInfo.getLeftDate();
                            long l = dbLeftDateNum = dbLeftDate == null ? 0L : dbLeftDate.getTime();
                            if (valueObject != null && valueObject.getTime() < dbLeftDateNum) {
                                leftDateMap.put(personId, dbLeftDate);
                            }
                        } else {
                            leftDateMap.put(personId, ppInfo.getLeftDate());
                        }
                    }
                    if (ppInfo.getLastUpdateTime() == null) continue;
                    if (updateDateObject != null) {
                        long dbUpdateNum;
                        Timestamp dbUpdateDate = ppInfo.getLastUpdateTime();
                        long l = dbUpdateNum = dbUpdateDate == null ? 0L : ((java.util.Date)dbUpdateDate).getTime();
                        if (updateDateObject.getTime() >= dbUpdateNum) continue;
                        updateDateMap.put(personId, dbUpdateDate);
                        continue;
                    }
                    updateDateMap.put(personId, ppInfo.getLastUpdateTime());
                }
                list.add(dataMap);
                list.add(leftDateMap);
                list.add(updateDateMap);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void deleteScheduleShiftAfterOffDate(Context ctx, List<Map<String, java.util.Date>> enterDateAndLeftDateList, List attendanceFileList, long lastExcuteTime) throws EASBizException, BOSException, ParseException, SQLException {
        SimpleDateFormat formatLong = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat formatShort = new SimpleDateFormat("yyyy-MM-dd");
        lastExcuteTime = formatLong.parse(formatShort.format(lastExcuteTime) + " 00:00:00").getTime();
        String selectSqlOne = null;
        String selectSqlTwo = null;
        HashSet<String> personIds = new HashSet<String>();
        HashMap<String, AttencePolicyInfo> attencePolicyInfoMap = new HashMap<String, AttencePolicyInfo>();
        HashSet<String> scheduleshiftIds = new HashSet<String>();
        Map<String, java.util.Date> dataMap = enterDateAndLeftDateList.get(0);
        HashMap<String, java.util.Date> enterMap = new HashMap<String, java.util.Date>();
        Map<String, java.util.Date> leftDateMap = enterDateAndLeftDateList.get(1);
        Map<String, java.util.Date> updateDateMap = enterDateAndLeftDateList.get(2);
        HashMap enterAndLeftDateMap = new HashMap();
        for (int i = 0; i < attendanceFileList.size(); ++i) {
            AttendanceFileInfo attendanceFileInfo = (AttendanceFileInfo)attendanceFileList.get(i);
            String personId = "";
            if (attendanceFileInfo == null || attendanceFileInfo.getProposer() == null || attendanceFileInfo.getProposer().getId() == null) continue;
            personId = attendanceFileInfo.getProposer().getId().toString();
            personIds.add(personId);
            attencePolicyInfoMap.put(personId, attendanceFileInfo.getAttencePolicy());
        }
        Set<String> dataMapSet = dataMap.keySet();
        Iterator<String> i = dataMapSet.iterator();
        while (i.hasNext()) {
            long l;
            String key = i.next();
            if (dataMap.get(key) == null) continue;
            enterMap.put(key, dataMap.get(key));
            if (leftDateMap.get(key) == null || updateDateMap.get(key) == null || leftDateMap.get(key).getTime() >= dataMap.get(key).getTime() || (l = updateDateMap.get(key).getTime() > leftDateMap.get(key).getTime() ? updateDateMap.get(key).getTime() : leftDateMap.get(key).getTime()) < lastExcuteTime) continue;
            ArrayList<java.util.Date> enterAndLeftDateList = new ArrayList<java.util.Date>();
            enterAndLeftDateList.add(dataMap.get(key));
            enterAndLeftDateList.add(leftDateMap.get(key));
            enterAndLeftDateMap.put((Iterator<Map.Entry<String, java.util.Date>>)((Object)key), enterAndLeftDateList);
            i.remove();
        }
        String personId = "";
        if (!enterAndLeftDateMap.isEmpty()) {
            selectSqlOne = "select fid from t_hr_ats_scheduleshift where FProposerID = ? and FAttendDate < ? and FAttendDate >= ? ";
            selectSqlTwo = "select fid from t_hr_ats_scheduleshift where FProposerID = ? and FAttendDate < ? and FAttendDate > ? ";
            for (Map.Entry<String, java.util.Date> entry : enterAndLeftDateMap.entrySet()) {
                if (entry.getValue() == null || attencePolicyInfoMap.get(personId = entry.getKey()) == null) continue;
                Object[] sqlParam = new Object[]{entry.getKey(), new Date(AtsDateUtils.stringToShortDate(formatShort.format((java.util.Date)((List)((Object)entry.getValue())).get(0))).getTime()), new Date(AtsDateUtils.stringToShortDate(formatShort.format((java.util.Date)((List)((Object)entry.getValue())).get(1))).getTime())};
                if (((AttencePolicyInfo)attencePolicyInfoMap.get(personId)).isLeaveIsCal()) {
                    ScheduleShiftUtils.getScheduleshiftIds(ctx, selectSqlTwo, sqlParam, scheduleshiftIds);
                    continue;
                }
                ScheduleShiftUtils.getScheduleshiftIds(ctx, selectSqlOne, sqlParam, scheduleshiftIds);
            }
        }
        if (!leftDateMap.isEmpty()) {
            selectSqlOne = "select fid from t_hr_ats_scheduleshift where FProposerID = ? and FAttendDate >= ?";
            selectSqlTwo = "select fid from t_hr_ats_scheduleshift where FProposerID = ? and FAttendDate > ?";
            for (Map.Entry<String, java.util.Date> entry : leftDateMap.entrySet()) {
                long maxTime;
                if (entry.getValue() == null || (enterMap.get(personId = entry.getKey()) == null || updateDateMap.get(personId) == null || entry.getValue().getTime() <= ((java.util.Date)enterMap.get(personId)).getTime()) && enterMap.get(personId) != null || (maxTime = updateDateMap.get(personId).getTime() > entry.getValue().getTime() ? updateDateMap.get(personId).getTime() : entry.getValue().getTime()) < lastExcuteTime || attencePolicyInfoMap.get(personId) == null) continue;
                Object[] sqlParam = new Object[]{entry.getKey(), new Date(AtsDateUtils.stringToShortDate(formatShort.format(entry.getValue())).getTime())};
                if (((AttencePolicyInfo)attencePolicyInfoMap.get(personId)).isLeaveIsCal()) {
                    ScheduleShiftUtils.getScheduleshiftIds(ctx, selectSqlTwo, sqlParam, scheduleshiftIds);
                    continue;
                }
                ScheduleShiftUtils.getScheduleshiftIds(ctx, selectSqlOne, sqlParam, scheduleshiftIds);
            }
        }
        if (scheduleshiftIds.size() != 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", scheduleshiftIds, CompareType.INCLUDE));
            ScheduleShiftFactory.getLocalInstance(ctx).delete(filter);
        }
    }

    public long getLastsynchtime(Context ctx) throws BOSException, EASBizException {
        BizDataSynchAssistInfo bizDataSynchAssistInfo = ScheduleShiftUtils.getBizDataSynchAssistInfo(ctx);
        if (bizDataSynchAssistInfo == null) {
            bizDataSynchAssistInfo = ScheduleShiftUtils.updateBizDataSynchAssistLastTime(ctx, bizDataSynchAssistInfo, null);
        }
        long lastExcuteTime = bizDataSynchAssistInfo.getLastsynchtime().getTime();
        return lastExcuteTime;
    }

    @Override
    protected void _autoSchedule(Context ctx, boolean ignoreExecuteDate, String schedulePlanIds) throws BOSException {
        try {
            new AutoScheduleManager(ctx, ignoreExecuteDate).execPlane(schedulePlanIds);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _matchSchedule(Context ctx, String schedulePlanIds) throws BOSException {
        try {
            new MatchScheduleManager(ctx).execPlane(schedulePlanIds);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

