/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app.formula.calculate.data;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataSetGenerator;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataTable;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.Tools;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import net.sourceforge.jtds.jdbc.ClobImpl;
import oracle.sql.CLOB;
import oracle.sql.TIMESTAMP;
import org.apache.log4j.Logger;

public abstract class DataAccess {
    private static Logger logger = Logger.getLogger(DataAccess.class);
    public Connection conn = null;
    private Context ctx;
    private static ThreadLocal<SimpleDateFormat> sdfThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> sdflongThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    private static final void closeCallableStatement(CallableStatement cs) {
        if (cs != null) {
            cs = null;
        }
    }

    public static final void logException(Exception e) {
        logger.error((Object)e.getMessage());
        e.printStackTrace();
    }

    public static final DataTable generateDataTable(String tablename, ResultSet rs) throws Exception {
        ArrayList columns = DataSetGenerator.generateColumns(rs.getMetaData());
        ArrayList datas = DataSetGenerator.generateDatas(rs, columns.size());
        DataTable dt = new DataTable();
        dt.tablename = tablename;
        dt.columns = columns;
        dt.datas = datas;
        dt.emptyrow = DataSetGenerator.generateEmptyRow(columns);
        return dt;
    }

    public void closeAllDBSource(Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            DataAccess.logException(e);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            DataAccess.logException(e);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            DataAccess.logException(e);
        }
    }

    public Connection getConnection() throws SQLException {
        this.ctx = Tools.getInstance().getCtx();
        return EJBFactory.getConnection((Context)this.ctx);
    }

    public Context getCtx() {
        return this.ctx;
    }

    public abstract ResultSet GetCustomInterfaceByGUID(String var1);

    public abstract String GetDataInHtmlDIV(String var1);

    public abstract String GetDataInHtmlDIVEx(String var1);

    public DataTable getDataTable(String sql) {
        return this.getDataTable(sql, "Table1");
    }

    public DataTable getDataTable(String sql, String name) {
        DataTable dt = null;
        IRowSet rs = null;
        try {
            this.ctx = Tools.getInstance().getCtx();
            rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            dt = DataAccess.generateDataTable(name, (ResultSet)rs);
            this.closeAllDBSource(this.conn, null, (ResultSet)rs);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("error SQL\uff1a" + sql));
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeAllDBSource(this.conn, null, (ResultSet)rs);
                throw throwable;
            }
        }
        return dt;
    }

    public static final String stringValue(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            return sdfThreadLocal.get().format(o);
        }
        if (o instanceof TIMESTAMP) {
            try {
                return sdflongThreadLocal.get().format(((TIMESTAMP)o).timestampValue());
            }
            catch (SQLException e) {
                throw new RuntimeException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.ILLEGALTYPE, new Object[]{"TIMESTAMP"})));
            }
        }
        if (o instanceof CLOB) {
            try {
                CLOB clob = (CLOB)o;
                long l = clob.length();
                int i = (int)l;
                return clob.getSubString(1L, i);
            }
            catch (SQLException e) {
                throw new RuntimeException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.ILLEGALTYPE, new Object[]{"CLOB"})));
            }
        }
        if (o instanceof ClobImpl) {
            try {
                ClobImpl clob = (ClobImpl)o;
                long l = clob.length();
                int i = (int)l;
                return clob.getSubString(1L, i);
            }
            catch (SQLException e) {
                throw new RuntimeException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.ILLEGALTYPE, new Object[]{"CLOB"})));
            }
        }
        return o.toString();
    }

    public void executeBatch(ArrayList sqlLists) {
        this.executeBatch(sqlLists.toArray());
    }

    public void executeBatch(Object[] sqlLists) {
        if (sqlLists == null) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        int i = 0;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            conn.setAutoCommit(false);
            for (i = 0; i < sqlLists.length; ++i) {
                stmt.executeUpdate(sqlLists[i].toString());
            }
            conn.commit();
        }
        catch (Exception e) {
            logger.error((Object)("error SQL sqlLists[" + i + "]:" + sqlLists[i].toString()));
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException(e);
        }
        finally {
            this.closeAllDBSource(conn, stmt, rs);
        }
    }

    public static final int intValue(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof BigInteger) {
            return ((BigInteger)o).intValue();
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).intValue();
        }
        throw new RuntimeException((Throwable)((Object)new AtsCommonBizException(AtsCommonBizException.ILLEGALTYPE, new Object[]{o.getClass()})));
    }
}

