/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.app.formula.calculate.data;

import com.kingdee.eas.hr.ats.AtsCalBizException;
import com.kingdee.eas.hr.ats.AtsOtherBizException;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.ColumnAttributes;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataTypes;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Date;

public class DataSetGenerator {
    public static ArrayList generateColumns(ResultSetMetaData rsm) throws Exception {
        try {
            int counter = rsm.getColumnCount();
        }
        catch (Exception e) {
            throw new AtsCalBizException(AtsCalBizException.FETCHCOLUMNERRORINDATACOLLECTION);
        }
        ArrayList<ColumnAttributes> result = new ArrayList<ColumnAttributes>();
        for (int i = 0; i < rsm.getColumnCount(); ++i) {
            ColumnAttributes column = new ColumnAttributes();
            column.setIndex(i);
            column.setName(rsm.getColumnName(i + 1));
            column.setSchemaName(rsm.getSchemaName(i + 1));
            column.setDbtype(rsm.getColumnType(i + 1));
            column.setScale(rsm.getScale(i + 1));
            if (column.getDbtype() == 1 || column.getDbtype() == 12 || column.getDbtype() == -9) {
                column.setType(DataTypes.STRING);
            } else if (column.getDbtype() == 93 || column.getDbtype() == 91) {
                column.setType(DataTypes.DATE);
            } else if (column.getDbtype() == 2) {
                column.setType(DataTypes.FLOAT);
            } else {
                column.setType(DataTypes.INTEGER);
            }
            result.add(column);
        }
        return result;
    }

    protected static Object generateColumnValue(ColumnAttributes column) {
        int type = column.getType();
        Object defaultvalue = column.getDefaultValue();
        boolean isdefaultvalue = defaultvalue != null;
        try {
            Object result = type == DataTypes.BINARY ? (Object)(isdefaultvalue ? (byte[])defaultvalue : new byte[]{}) : (type == DataTypes.DATE ? (isdefaultvalue ? (Object)((Date)defaultvalue).clone() : (Object)new Date()) : (type == DataTypes.FLOAT ? (isdefaultvalue ? (Object)new Float(((Float)defaultvalue).floatValue()) : (Object)new Float(0.0f)) : (type == DataTypes.INTEGER ? (isdefaultvalue ? (Object)new Integer((Integer)defaultvalue) : (Object)new Integer(0)) : (Object)"")));
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException((Throwable)((Object)new AtsOtherBizException(AtsOtherBizException.TYPENOTMATCHDEFALUEVAL, e)));
        }
    }

    public static ArrayList generateEmptyRow(ArrayList columns) {
        if (columns == null || columns.size() == 0) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < columns.size(); ++i) {
            result.add(DataSetGenerator.generateColumnValue((ColumnAttributes)columns.get(i)));
        }
        return result;
    }

    public static ArrayList generateDatas(ResultSet rs, int columnCounter) throws Exception {
        ArrayList result = new ArrayList();
        try {
            while (rs.next()) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (int i = 0; i < columnCounter; ++i) {
                    if (rs.getMetaData().getColumnType(i + 1) == 91) {
                        String s = rs.getString(i + 1);
                        if (s != null && s.endsWith(" 00:00:00.0")) {
                            s = s.replaceAll(" 00:00:00.0", "");
                        }
                        row.add(s);
                        continue;
                    }
                    if (rs.getMetaData().getColumnType(i + 1) == 2004) {
                        Blob blob = rs.getBlob(i + 1);
                        if (blob == null) {
                            row.add(null);
                            continue;
                        }
                        long len = blob.length();
                        byte[] data = blob.getBytes(1L, (int)len);
                        row.add(data);
                        continue;
                    }
                    row.add(rs.getObject(i + 1));
                }
                result.add(row);
            }
        }
        catch (Exception e) {
            throw new AtsCalBizException(AtsCalBizException.FETCHDATAERRORINDATACOLLECTION);
        }
        return result;
    }
}

