/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.biz.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.ColumnAttributes;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataSetGenerator;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataTable;
import com.kingdee.eas.hr.ats.biz.util.AtsBizUtil;
import com.kingdee.eas.hr.ats.calculate.AtsCacheUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigColumnsCollection;
import com.kingdee.shr.baseconfig.StructureConfigFactory;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AttendanceSelfDefinedUtil {
    private static Logger logger = Logger.getLogger(AttendanceSelfDefinedUtil.class);
    public static final String INNERMAP = "innerMap";

    public static Map<String, List<DataTable>> getPersonDataMap(Context ctx, Map<Object, Object> globalMap, String startDate, String endDate, String personIds) {
        String querySql;
        Map<String, List<DataTable>> personDataMap = new HashMap<String, List<DataTable>>();
        Map<String, Object> tableMap = (Map<String, Object>)globalMap.get("tableMap");
        if (null == tableMap) {
            tableMap = AttendanceSelfDefinedUtil.getTableMap(ctx);
        }
        if (StringUtils.isEmpty((String)(querySql = AttendanceSelfDefinedUtil.getQuerySql(ctx, globalMap, startDate, endDate, personIds, tableMap)))) {
            return personDataMap;
        }
        personDataMap = AttendanceSelfDefinedUtil.getDataTableMap(ctx, globalMap, querySql, startDate, endDate, personIds, tableMap);
        return personDataMap;
    }

    public static Map<String, List<DataTable>> getDataTableMap(Context ctx, Map<Object, Object> globalMap, String querySql, String startDate, String endDate, String personIds, Map<String, Object> tableMap) {
        HashMap<String, List<DataTable>> dtListMap = new HashMap<String, List<DataTable>>();
        IRowSet rs = null;
        try {
            querySql = querySql.replaceAll("AND \"LABORRELA\".FStartDateTime<=\"EMPORGRELATION\".FENDDATETIME", "");
            querySql = querySql.replaceAll("AND \"LABORRELA\".FEndDateTime>=\"EMPORGRELATION\".FENDDATETIME", "");
            querySql = querySql.replaceAll("AND \"PP\".FStartDateTime<=\"EMPORGRELATION\".FENDDATETIME", "");
            querySql = querySql.replaceAll("AND \"PP\".FEndDateTime>=\"EMPORGRELATION\".FENDDATETIME", "");
            rs = DbUtil.executeQuery((Context)ctx, (String)querySql);
            ArrayList columns = DataSetGenerator.generateColumns(rs.getMetaData());
            ArrayList datas = DataSetGenerator.generateDatas((ResultSet)rs, columns.size());
            ArrayList<ColumnAttributes> columnsTemp = null;
            ArrayList datasTemp = null;
            ArrayList datasTempList = null;
            String startDateTemp = "";
            String endDateTemp = "";
            String personIDTemp = "";
            for (Object object : datas) {
                ArrayList<DataTable> dataTableList = new ArrayList<DataTable>();
                ArrayList row = (ArrayList)object;
                for (int i = 0; i < row.size(); ++i) {
                    ColumnAttributes col = (ColumnAttributes)columns.get(i);
                    if (col.getName().equalsIgnoreCase("EMPORGRELATION.EFFDT") && (startDateTemp = AtsDateUtils.dateShortToString((Date)row.get(i))).compareTo(startDate) < 0) {
                        startDateTemp = startDate;
                    }
                    if (col.getName().equalsIgnoreCase("EMPORGRELATION.LEFFDT") && (endDateTemp = AtsDateUtils.dateShortToString((Date)row.get(i))).compareTo(endDate) > 0) {
                        endDateTemp = endDate;
                    }
                    if (col.getName().equalsIgnoreCase("PERSON.ID")) {
                        personIDTemp = (String)row.get(i);
                    }
                    String tableKey = col.getName().split("\\.")[0];
                    columnsTemp = new ArrayList<ColumnAttributes>();
                    columnsTemp.add(col);
                    datasTempList = new ArrayList();
                    datasTemp = new ArrayList();
                    datasTemp.add(row.get(i));
                    datasTempList.add(datasTemp);
                    DataTable dt = new DataTable();
                    dt.tablename = (String)tableMap.get(tableKey.toUpperCase());
                    dt.columns = columnsTemp;
                    dt.datas = datasTempList;
                    dt.emptyrow = DataSetGenerator.generateEmptyRow(dt.columns);
                    dataTableList.add(dt);
                }
                AttendanceSelfDefinedUtil.buildDTListMap(ctx, dtListMap, dataTableList, startDateTemp, endDateTemp, personIDTemp);
            }
            for (int i = 0; i < columns.size(); ++i) {
                ColumnAttributes col = (ColumnAttributes)columns.get(i);
                if (null == col.getName() || null == tableMap.get(col.getName().toUpperCase())) continue;
                col.setName((String)tableMap.get(col.getName().toUpperCase()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dtListMap;
    }

    private static void buildDTListMap(Context ctx, Map<String, List<DataTable>> dtListMap, List<DataTable> dataTableList, String startDate, String endDate, String personID) {
        List<String> dateList = AtsDateUtils.getDateList(startDate, endDate);
        for (int i = 0; i < dateList.size(); ++i) {
            dtListMap.put(personID + "_" + dateList.get(i), dataTableList);
        }
    }

    public static String getQuerySql(Context ctx, Map<Object, Object> globalMap, String startDate, String endDate, String personIds, Map<String, Object> tableMap) {
        Map<String, String> selectMapping = (Map<String, String>)globalMap.get("selectMapping");
        if (null == selectMapping) {
            selectMapping = AttendanceSelfDefinedUtil.getSelectMapping(ctx, tableMap);
        }
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setNeedDistinct(false);
        sqlParam.setHistoryMode(false);
        sqlParam.setScheme("001");
        sqlParam.setMultiLanLocale("all");
        String querySqlKey = "selfCal_person_data_" + selectMapping.keySet().toString();
        String querySql = (String)AtsCacheUtil.get(querySqlKey);
        if (StringUtils.isBlank((String)querySql)) {
            try {
                querySql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
                AtsCacheUtil.put(querySqlKey, querySql);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        querySql = querySql + " where \"PERSON\".fid in ( " + personIds + ")  AND \"EMPORGRELATION\".FEFFDT <= {ts '" + endDate + "'} AND \"EMPORGRELATION\".FLEFFDT >= {ts '" + startDate + "'} ORDER BY \"EMPORGRELATION\".FStartDateTime ASC ";
        return querySql;
    }

    public static Map<String, Object> getTableMap(Context ctx) {
        HashMap<String, Object> tableMap = new HashMap<String, Object>();
        HashMap<String, String> innerMap = new HashMap<String, String>();
        tableMap.put(INNERMAP, innerMap);
        String idSql = " select distinct FStructureConfigID from T_HR_StructureConfigColumns  where fid in ( SELECT FactFieldID FROM T_ATS_AtsQueryConfigFiled where FParentID in (SELECT FID FROM T_ATS_AtsQueryConfig where FNumber like 'emp%'))";
        String oql = "where id in (" + idSql + ")";
        try {
            StructureConfigCollection coll = StructureConfigFactory.getLocalInstance((Context)ctx).getStructureConfigCollection(oql);
            StructureConfigColumnsCollection columnColl = null;
            StructureConfigInfo info = null;
            EntityObjectInfo entityObjectInfo = null;
            String tableName = null;
            String propDBName = null;
            PropertyInfo prop = null;
            String clientNumberNumber = null;
            String propDBNameMul = null;
            String mulLocale2 = null;
            Iterator<String> localeIter = null;
            Set<String> mulLanLocales = AtsBizUtil.getMulLanLocaleSet();
            String clientNumber = null;
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)info.getEntityName()));
                tableName = entityObjectInfo.getTable().getName().toUpperCase();
                clientNumber = info.getClientNumber();
                tableMap.put(info.getClientNumber().toUpperCase(), tableName);
                columnColl = info.getColumns();
                for (int j = 0; j < columnColl.size(); ++j) {
                    try {
                        prop = entityObjectInfo.getPropertyByName(columnColl.get(j).getNumber());
                        if (prop == null) {
                            logger.error((Object)(info.getEntityName() + ":" + columnColl.get(j).getNumber() + "---can not find entity property"));
                            continue;
                        }
                        if (prop.getMappingField() == null) {
                            logger.error((Object)(info.getEntityName() + ":" + columnColl.get(j).getNumber() + "---can not find table column"));
                            continue;
                        }
                        propDBName = prop.getMappingField().getName();
                        clientNumberNumber = (info.getClientNumber() + "." + columnColl.get(j).getNumber()).toUpperCase();
                        if (((OwnPropertyInfo)prop).isMultilingual()) {
                            for (String mulLocale2 : mulLanLocales) {
                                propDBNameMul = (propDBName + "_" + mulLocale2).toUpperCase();
                                tableMap.put((clientNumberNumber + "_" + mulLocale2).toUpperCase(), propDBNameMul);
                                innerMap.put(tableName + "_" + propDBNameMul, clientNumberNumber);
                            }
                            propDBName = propDBName + "_" + ctx.getLocale().toString();
                        }
                        tableMap.put(clientNumberNumber, propDBName.toUpperCase());
                        innerMap.put(tableName + "_" + propDBName.toUpperCase(), clientNumberNumber);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableMap;
    }

    public static Map<String, String> getSelectMapping(Context ctx, Map<String, Object> tableMap) {
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        Map innerMap = (Map)tableMap.get(INNERMAP);
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FID, FName" + MLUtile.getMlFlag(ctx) + ", FExpress, FListItem, FListFunc, FListVar, FListTable, FSortSn, FContent, FTableToConfigId ");
        sb.append(" FROM T_HR_ATS_CalFormula where  FIsCal='1' ");
        try {
            IRowSet da = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (da.next()) {
                String listItem = da.getString("FListItem");
                String[] listItemArr = listItem.split(";");
                for (int i = 0; i < listItemArr.length; ++i) {
                    String[] columnItemArr = listItemArr[i].split("~");
                    String key = columnItemArr[1] + "_" + columnItemArr[2];
                    String value = (String)innerMap.get(key.toUpperCase());
                    if (StringUtils.isBlank((String)value)) continue;
                    selectMapping.put(value, value);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        selectMapping.put("PERSON.ID", "PERSON.ID");
        selectMapping.put("EMPORGRELATION.EFFDT", "EMPORGRELATION.EFFDT");
        selectMapping.put("EMPORGRELATION.LEFFDT", "EMPORGRELATION.LEFFDT");
        return selectMapping;
    }
}

