/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.calculate.time.util;

import com.kingdee.eas.hr.ats.AtsTripLengthCalTypeEnum;
import com.kingdee.eas.hr.ats.PunchCardRecordInfo;
import com.kingdee.eas.hr.ats.calculate.time.model.TimeLabelModel;
import com.kingdee.eas.hr.ats.calculate.time.vo.CalTimeVO;
import com.kingdee.eas.hr.ats.result.AttendanceDynamicResInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CalTimeUtil {
    public static boolean isExistsOutSideCard(Map globalMap, String personId, String date, AttendanceDynamicResInfo result) {
        List<PunchCardRecordInfo> punchCardInfoList = CalTimeUtil.getPunchardRecordList(globalMap, personId, date);
        for (int i = 0; i < punchCardInfoList.size(); ++i) {
            PunchCardRecordInfo punchCardRecordInfo = punchCardInfoList.get(i);
            if (!punchCardRecordInfo.isOutSide() || !CalTimeUtil.isResultCardEqualsPunchardCard(result, punchCardRecordInfo.getPunchCardTime())) continue;
            return true;
        }
        return false;
    }

    private static boolean isResultCardEqualsPunchardCard(AttendanceDynamicResInfo result, Timestamp punchCardTime) {
        if (CalTimeUtil.isResultCardEqualsPunchardCard(result.getOneOnTime(), punchCardTime)) {
            return true;
        }
        if (CalTimeUtil.isResultCardEqualsPunchardCard(result.getOneOffTime(), punchCardTime)) {
            return true;
        }
        if (CalTimeUtil.isResultCardEqualsPunchardCard(result.getTwoOnTime(), punchCardTime)) {
            return true;
        }
        if (CalTimeUtil.isResultCardEqualsPunchardCard(result.getTwoOffTime(), punchCardTime)) {
            return true;
        }
        if (CalTimeUtil.isResultCardEqualsPunchardCard(result.getThreeOnTime(), punchCardTime)) {
            return true;
        }
        return CalTimeUtil.isResultCardEqualsPunchardCard(result.getThreeOffTime(), punchCardTime);
    }

    private static boolean isResultCardEqualsPunchardCard(String resultCard, Timestamp punchCardTime) {
        String punchCardTimeStr = AtsDateUtils.timestampToString(punchCardTime);
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)resultCard) && null != punchCardTime && resultCard.substring(0, 16).equals(punchCardTimeStr.substring(0, 16));
    }

    public static List<String> getOutSideCard(Map globalMap, String personId, String date, AttendanceDynamicResInfo result) {
        List<PunchCardRecordInfo> punchCardInfoList = CalTimeUtil.getPunchardRecordList(globalMap, personId, date);
        return CalTimeUtil.getOutSideCard(punchCardInfoList, result);
    }

    public static List<String> getOutSideCard(List<PunchCardRecordInfo> punchCardInfoList, AttendanceDynamicResInfo result) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i = 0; i < punchCardInfoList.size(); ++i) {
            PunchCardRecordInfo punchCardRecordInfo = punchCardInfoList.get(i);
            if (!punchCardRecordInfo.isOutSide() || !CalTimeUtil.isResultCardEqualsPunchardCard(result, punchCardRecordInfo.getPunchCardTime())) continue;
            resultList.add(AtsDateUtils.timestampToString(punchCardRecordInfo.getPunchCardTime()));
        }
        return resultList;
    }

    public static List<String> getInSideCard(Map globalMap, String personId, String date, AttendanceDynamicResInfo result) {
        List<PunchCardRecordInfo> punchCardInfoList = CalTimeUtil.getPunchardRecordList(globalMap, personId, date);
        return CalTimeUtil.getInSideCard(punchCardInfoList, result);
    }

    public static List<String> getInSideCard(List<PunchCardRecordInfo> punchCardInfoList, AttendanceDynamicResInfo result) {
        ArrayList<String> resultCards = new ArrayList<String>();
        CalTimeUtil.addCard(resultCards, result.getOneOnTime());
        CalTimeUtil.addCard(resultCards, result.getOneOffTime());
        CalTimeUtil.addCard(resultCards, result.getTwoOnTime());
        CalTimeUtil.addCard(resultCards, result.getTwoOffTime());
        CalTimeUtil.addCard(resultCards, result.getThreeOnTime());
        CalTimeUtil.addCard(resultCards, result.getThreeOffTime());
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i = 0; i < resultCards.size(); ++i) {
            String card = (String)resultCards.get(i);
            boolean isInSide = false;
            for (int j = 0; j < punchCardInfoList.size(); ++j) {
                PunchCardRecordInfo punchCardRecordInfo = punchCardInfoList.get(j);
                if (punchCardRecordInfo.isOutSide() || !CalTimeUtil.isResultCardEqualsPunchardCard(card, punchCardRecordInfo.getPunchCardTime())) continue;
                isInSide = true;
                break;
            }
            if (!isInSide) continue;
            resultList.add(card);
        }
        return resultList;
    }

    public static void addCard(List<String> resultCards, String card) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)card)) {
            resultCards.add(card);
        }
    }

    public static List<String> getInSideCard(Map globalMap, String personId, String date, String timeCardEarliest, String timeCardLatest) {
        ArrayList<String> resultList = new ArrayList<String>();
        List<PunchCardRecordInfo> punchCardInfoList = CalTimeUtil.getPunchardRecordList(globalMap, personId, date);
        for (int i = 0; i < punchCardInfoList.size(); ++i) {
            PunchCardRecordInfo punchCardRecordInfo = punchCardInfoList.get(i);
            if (!punchCardRecordInfo.isOutSide() && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)timeCardEarliest) && CalTimeUtil.isResultCardEqualsPunchardCard(timeCardEarliest, punchCardRecordInfo.getPunchCardTime())) {
                resultList.add(AtsDateUtils.timestampToString(punchCardRecordInfo.getPunchCardTime()));
                continue;
            }
            if (punchCardRecordInfo.isOutSide() || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)timeCardLatest) || !CalTimeUtil.isResultCardEqualsPunchardCard(timeCardLatest, punchCardRecordInfo.getPunchCardTime())) continue;
            resultList.add(AtsDateUtils.timestampToString(punchCardRecordInfo.getPunchCardTime()));
        }
        return resultList;
    }

    public static List<PunchCardRecordInfo> getPunchardRecordList(Map globalMap, String personId, String date) {
        Map punchCardInfoMap = (Map)globalMap.get("punchCardInfoMap");
        if (AtsCollectionUtile.isEmpty(punchCardInfoMap)) {
            return new ArrayList<PunchCardRecordInfo>();
        }
        Date attdate = AtsDateUtils.stringToShortDate(date);
        String preDay = AtsDateUtils.dateShortToString(AtsDateUtils.getPreDay(attdate, 1));
        String nextDay = AtsDateUtils.dateShortToString(AtsDateUtils.getNextDay(attdate, 1));
        List punchCardInfoList = (List)punchCardInfoMap.get(personId + "_" + date);
        List punchCardInfoPreDayList = (List)punchCardInfoMap.get(personId + "_" + preDay);
        List punchCardInfoNextDayList = (List)punchCardInfoMap.get(personId + "_" + nextDay);
        ArrayList<PunchCardRecordInfo> punchCardInfoListNew = new ArrayList<PunchCardRecordInfo>();
        if (null != punchCardInfoList) {
            punchCardInfoListNew.addAll(punchCardInfoList);
        }
        if (null != punchCardInfoPreDayList && !punchCardInfoPreDayList.isEmpty()) {
            punchCardInfoListNew.addAll(punchCardInfoPreDayList);
        }
        if (null != punchCardInfoNextDayList && !punchCardInfoNextDayList.isEmpty()) {
            punchCardInfoListNew.addAll(punchCardInfoNextDayList);
        }
        for (PunchCardRecordInfo punchCardRecordInfo : punchCardInfoListNew) {
            String punchCardTimeNew = AtsDateUtils.timestampToString(punchCardRecordInfo.getPunchCardTime()).substring(0, 17) + "00";
            punchCardRecordInfo.setPunchCardTime(AtsDateUtils.stringToTimestamp(punchCardTimeNew));
        }
        return punchCardInfoListNew;
    }

    public static boolean isExistsOutSideCard(Map globalMap, String personId, String date, String timeCardEarliest, String timeCardLatest) {
        List<PunchCardRecordInfo> punchCardInfoList = CalTimeUtil.getPunchardRecordList(globalMap, personId, date);
        for (int i = 0; i < punchCardInfoList.size(); ++i) {
            PunchCardRecordInfo punchCardRecordInfo = punchCardInfoList.get(i);
            if (punchCardRecordInfo.isOutSide() && CalTimeUtil.isResultCardEqualsPunchardCard(timeCardEarliest, punchCardRecordInfo.getPunchCardTime())) {
                return true;
            }
            if (!punchCardRecordInfo.isOutSide() || !CalTimeUtil.isResultCardEqualsPunchardCard(timeCardLatest, punchCardRecordInfo.getPunchCardTime())) continue;
            return true;
        }
        return false;
    }

    public static List<TimeLabelModel> assembleTimeIntervalCards(AttendanceDynamicResInfo result, List<String> cards) {
        ArrayList<TimeLabelModel> timeIntervalCards = new ArrayList<TimeLabelModel>();
        if (StringUtils.isNotEmpty((String)result.getOneOnTime()) && StringUtils.isNotEmpty((String)result.getOneOffTime()) && cards.contains(result.getOneOnTime()) && cards.contains(result.getOneOffTime())) {
            timeIntervalCards.add(new TimeLabelModel(AtsDateUtils.stringToTimestamp(result.getOneOnTime()), AtsDateUtils.stringToTimestamp(result.getOneOffTime()), "card"));
        }
        if (StringUtils.isNotEmpty((String)result.getTwoOnTime()) && StringUtils.isNotEmpty((String)result.getTwoOffTime()) && cards.contains(result.getTwoOnTime()) && cards.contains(result.getTwoOffTime())) {
            timeIntervalCards.add(new TimeLabelModel(AtsDateUtils.stringToTimestamp(result.getTwoOnTime()), AtsDateUtils.stringToTimestamp(result.getTwoOffTime()), "card"));
        }
        if (StringUtils.isNotEmpty((String)result.getThreeOnTime()) && StringUtils.isNotEmpty((String)result.getThreeOffTime()) && cards.contains(result.getThreeOnTime()) && cards.contains(result.getThreeOffTime())) {
            timeIntervalCards.add(new TimeLabelModel(AtsDateUtils.stringToTimestamp(result.getThreeOnTime()), AtsDateUtils.stringToTimestamp(result.getThreeOffTime()), "card"));
        }
        return timeIntervalCards;
    }

    public static List<TimeLabelModel> assembleTimeIntervalCards(AttendanceDynamicResInfo result) {
        ArrayList<TimeLabelModel> timeIntervalCards = new ArrayList<TimeLabelModel>();
        if (StringUtils.isNotEmpty((String)result.getOneOnTime()) && StringUtils.isNotEmpty((String)result.getOneOffTime())) {
            timeIntervalCards.add(new TimeLabelModel(AtsDateUtils.stringToTimestamp(result.getOneOnTime()), AtsDateUtils.stringToTimestamp(result.getOneOffTime()), "card"));
        }
        if (StringUtils.isNotEmpty((String)result.getTwoOnTime()) && StringUtils.isNotEmpty((String)result.getTwoOffTime())) {
            timeIntervalCards.add(new TimeLabelModel(AtsDateUtils.stringToTimestamp(result.getTwoOnTime()), AtsDateUtils.stringToTimestamp(result.getTwoOffTime()), "card"));
        }
        if (StringUtils.isNotEmpty((String)result.getThreeOnTime()) && StringUtils.isNotEmpty((String)result.getThreeOffTime())) {
            timeIntervalCards.add(new TimeLabelModel(AtsDateUtils.stringToTimestamp(result.getThreeOnTime()), AtsDateUtils.stringToTimestamp(result.getThreeOffTime()), "card"));
        }
        return timeIntervalCards;
    }

    public static CalTimeVO getInOutSideCardCalTimeVO(AtsTripLengthCalTypeEnum tripLengthCalType, String personId, String date, Map globalMap, AttendanceDynamicResInfo result) {
        CalTimeVO calTimeVO = new CalTimeVO();
        List<TimeLabelModel> timeLabelModels = new ArrayList<TimeLabelModel>();
        boolean isCardIntersect = false;
        switch (tripLengthCalType.getValue()) {
            case 1: {
                break;
            }
            case 2: {
                if (CalTimeUtil.isExistsOutSideCard(globalMap, personId, date, result)) break;
                isCardIntersect = true;
                break;
            }
            case 3: {
                if (CalTimeUtil.isExistsOutSideCard(globalMap, personId, date, result)) {
                    timeLabelModels = CalTimeUtil.assembleTimeIntervalCards(result);
                }
                isCardIntersect = true;
                break;
            }
            case 4: {
                List<String> inSideCards = CalTimeUtil.getOutSideCard(globalMap, personId, date, result);
                timeLabelModels = CalTimeUtil.assembleTimeIntervalCards(result, inSideCards);
                isCardIntersect = true;
                break;
            }
            case 5: {
                List<String> inSideCards = CalTimeUtil.getInSideCard(globalMap, personId, date, result);
                timeLabelModels = CalTimeUtil.assembleTimeIntervalCards(result, inSideCards);
                isCardIntersect = true;
                break;
            }
        }
        calTimeVO.setCardIntersect(isCardIntersect);
        calTimeVO.setTimeLabelModels(timeLabelModels);
        return calTimeVO;
    }
}

