/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.dataLog.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.dataLog.control.LogControlCenter;
import com.kingdee.eas.hr.ats.dataLog.factory.DataLogControlFactory;
import com.kingdee.eas.hr.ats.dataLog.observer.LogObserver;
import com.kingdee.eas.hr.ats.dataLog.observer.impl.AtsBillDataLogObserver;
import com.kingdee.eas.hr.ats.dataLog.observer.impl.AtsLimitDataLogObserver;
import com.kingdee.eas.hr.ats.dataLog.observer.impl.AtsResultDataLogObserver;
import com.kingdee.eas.hr.ats.dataLog.observer.impl.AtsSumDataLogObserver;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataLogUtil {
    public static OperActionEnum getOperAction(Context ctx, String billId) {
        Object operActionSrc = ctx.get((Object)(billId + "_OperAction"));
        if (null != operActionSrc) {
            return OperActionEnum.getEnum((String)operActionSrc);
        }
        return OperActionEnum.other;
    }

    public static OperTypeEnum getOperType(Context ctx, String billId) {
        Object operTypeSrc = ctx.get((Object)(billId + "_OperType"));
        if (null != operTypeSrc) {
            return OperTypeEnum.getEnum((String)operTypeSrc);
        }
        return OperTypeEnum.other;
    }

    public static void addLogObserverToCenter(Context ctx, AtsLeaveBillInfo leaveBill, AtsLeaveBillEntryInfo entry, LogControlCenter logControlCenter, CoreBaseCollection limitCol, boolean isNeedCheck) {
        try {
            if (null != limitCol && !limitCol.isEmpty()) {
                OperTypeEnum operType = DataLogUtil.getOperType(ctx, leaveBill.getId().toString());
                OperActionEnum operAction = DataLogUtil.getOperAction(ctx, leaveBill.getId().toString());
                int size = limitCol.size();
                for (int i = 0; i < size; ++i) {
                    HolidayLimitInfo holidayLimitInfo = (HolidayLimitInfo)limitCol.get(i);
                    AtsLimitDataLogObserver observer = new AtsLimitDataLogObserver();
                    observer.setObjectId(holidayLimitInfo.getId().toString());
                    observer.setBillId(leaveBill.getId().toString());
                    observer.setBillNum(leaveBill.getNumber());
                    observer.setEntryId(entry.getId().toString());
                    observer.setPersonId(entry.getPerson().getId().toString());
                    observer.setOperType(operType);
                    observer.setOperAction(operAction);
                    observer.setHolidayPolicyId(holidayLimitInfo.getHolidayPolicy().getId().toString());
                    observer.setCoreBaseInfo((CoreBaseInfo)holidayLimitInfo);
                    observer.setNeedCheck(isNeedCheck);
                    observer.setCtx(ctx);
                    logControlCenter.addObserver(observer);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addLogObserverToCenter(Context ctx, LogControlCenter logControlCenter, HolidayLimitInfo holidayLimitInfo, OperTypeEnum operType, OperActionEnum operAction, boolean isNeedCheck) {
        try {
            if (null != holidayLimitInfo) {
                AtsLimitDataLogObserver observer = new AtsLimitDataLogObserver();
                observer.setObjectId(holidayLimitInfo.getId().toString());
                observer.setOperType(operType);
                observer.setOperAction(operAction);
                if (null != holidayLimitInfo.getHolidayPolicy()) {
                    observer.setHolidayPolicyId(holidayLimitInfo.getHolidayPolicy().getId().toString());
                }
                observer.setCoreBaseInfo((CoreBaseInfo)holidayLimitInfo);
                if (null != holidayLimitInfo.getProposer()) {
                    observer.setPersonId(holidayLimitInfo.getProposer().getId().toString());
                }
                if (null != holidayLimitInfo.getProposer()) {
                    observer.setPersonId(holidayLimitInfo.getProposer().getId().toString());
                }
                observer.setNeedCheck(isNeedCheck);
                observer.setCtx(ctx);
                logControlCenter.addObserver(observer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addLogObserverToCenter(Context ctx, LogControlCenter logControlCenter, CoreBaseCollection limitCol, OperTypeEnum operType, OperActionEnum operAction, boolean isNeedCheck) {
        if (null != limitCol && !limitCol.isEmpty()) {
            try {
                int size = limitCol.size();
                for (int i = 0; i < size; ++i) {
                    HolidayLimitInfo holidayLimitInfo = (HolidayLimitInfo)limitCol.get(i);
                    AtsLimitDataLogObserver observer = new AtsLimitDataLogObserver();
                    observer.setObjectId(holidayLimitInfo.getId().toString());
                    observer.setOperType(operType);
                    observer.setOperAction(operAction);
                    observer.setPersonId(holidayLimitInfo.getProposer().getId().toString());
                    observer.setHolidayPolicyId(holidayLimitInfo.getHolidayPolicy().getId().toString());
                    observer.setCoreBaseInfo((CoreBaseInfo)holidayLimitInfo);
                    observer.setNeedCheck(isNeedCheck);
                    observer.setCtx(ctx);
                    logControlCenter.addObserver(observer);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean recordLimitLog(Context ctx, Map<String, Object> resultMap) {
        try {
            CoreBaseCollection newColls = new CoreBaseCollection();
            if (null != resultMap.get("UPDATELIMIT")) {
                newColls.addCollection((CoreBaseCollection)resultMap.get("UPDATELIMIT"));
            }
            if (null != resultMap.get("NEWLIMIT")) {
                newColls.addCollection((CoreBaseCollection)resultMap.get("NEWLIMIT"));
            }
            if (null != newColls && !newColls.isEmpty()) {
                Map oldLimitMap = (Map)resultMap.get("oldHolidayLimitMap");
                CoreBaseCollection changedColls = new CoreBaseCollection();
                CoreBaseCollection oldColls = new CoreBaseCollection();
                for (HolidayLimitInfo newLimitInfo : newColls) {
                    HolidayLimitInfo oldLimitInfo = (HolidayLimitInfo)oldLimitMap.get(newLimitInfo.getId().toString());
                    if (null != oldLimitInfo && null != oldLimitInfo.getId() && !StringUtils.isEmpty((String)oldLimitInfo.getId().toString())) {
                        if (newLimitInfo.getStandardLimit().compareTo(oldLimitInfo.getStandardLimit()) == 0 && newLimitInfo.getAddOrSubLimit().compareTo(oldLimitInfo.getAddOrSubLimit()) == 0 && newLimitInfo.getRealLimit().compareTo(oldLimitInfo.getRealLimit()) == 0 && newLimitInfo.getFreezeLimit().compareTo(oldLimitInfo.getFreezeLimit()) == 0 && newLimitInfo.getUsedLimit().compareTo(oldLimitInfo.getUsedLimit()) == 0 && newLimitInfo.getRemainLimit().compareTo(oldLimitInfo.getRemainLimit()) == 0 && newLimitInfo.getPreOverdraftLimit().compareTo(oldLimitInfo.getPreOverdraftLimit()) == 0) continue;
                        oldColls.add((CoreBaseInfo)oldLimitInfo);
                        changedColls.add((CoreBaseInfo)newLimitInfo);
                        continue;
                    }
                    changedColls.add((CoreBaseInfo)newLimitInfo);
                }
                OperActionEnum operAction = OperActionEnum.backgroudTransaction;
                String accessSrc = (String)resultMap.get("accessSrc");
                if (!StringUtils.isEmpty((String)accessSrc) && accessSrc.equals("frontEndGen")) {
                    operAction = OperActionEnum.frontEndGen;
                }
                LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.holidayLimit);
                DataLogUtil.addLogObserverToCenter(ctx, logControlCenter, oldColls, OperTypeEnum.holidayLimit, operAction, false);
                DataLogUtil.addLogObserverToCenter(ctx, logControlCenter, changedColls, OperTypeEnum.holidayLimit, operAction, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void addLogObserverToCenter(Context ctx, String fid, String attendDate, String personId, String oldDesc, String newDesc) {
        try {
            LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.atsResult);
            AtsResultDataLogObserver observer = new AtsResultDataLogObserver();
            observer.setObjectId(fid);
            observer.setPersonId(personId);
            observer.setAttendDate(AtsDateUtils.stringToShortDate(attendDate));
            observer.setOperType(OperTypeEnum.atsResult);
            observer.setOperAction(OperActionEnum.modify);
            observer.setObjectOldDesc("{" + oldDesc + "}");
            observer.setObjectDesc("{" + newDesc + "}");
            observer.setNeedCheck(true);
            observer.setCtx(ctx);
            logControlCenter.addObserver(observer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addLogObserverToCenter(Context ctx, String fid, String attendancePeriodId, String periodName, String personId, String oldDesc, String newDesc) {
        try {
            LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.atsResultSum);
            AtsSumDataLogObserver observer = new AtsSumDataLogObserver();
            observer.setObjectId(fid);
            observer.setPersonId(personId);
            observer.setAttendancePeriodId(attendancePeriodId);
            observer.setPeriodName(periodName);
            observer.setOperType(OperTypeEnum.atsResultSum);
            observer.setOperAction(OperActionEnum.modify);
            observer.setObjectOldDesc("{" + oldDesc + "}");
            observer.setObjectDesc("{" + newDesc + "}");
            observer.setNeedCheck(true);
            observer.setCtx(ctx);
            logControlCenter.addObserver(observer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getNameValueStr(String name, Object value) {
        return "\"" + name + "\":\"" + value + "\"";
    }

    public static void addSumObserversLog(Context ctx, List<String> updateFieldList, List<Object[]> updateParams, Map<String, AtsSumDataLogObserver> valueMap) {
        try {
            StringBuffer logStr = null;
            for (int i = 0; i < updateParams.size(); ++i) {
                logStr = new StringBuffer();
                Object[] values = updateParams.get(i);
                String fid = values[values.length - 1].toString();
                logStr.append(DataLogUtil.getNameValueStr("fid", fid) + ",");
                for (int j = 0; j < updateFieldList.size(); ++j) {
                    String name = updateFieldList.get(j);
                    String value = values[j].toString();
                    logStr.append(DataLogUtil.getNameValueStr(name, value) + ",");
                }
                AtsSumDataLogObserver observer = valueMap.get(fid);
                if (null == observer) continue;
                observer.setObjectDesc("{" + logStr.substring(0, logStr.length() - 2).toString() + "}");
                observer.setNeedCheck(true);
                observer.setCtx(ctx);
            }
            LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.atsResultSum);
            Iterator<AtsSumDataLogObserver> observers = valueMap.values().iterator();
            while (observers.hasNext()) {
                logControlCenter.addObserver(observers.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, AtsSumDataLogObserver> assembleSumDataLogMap(Context ctx, List<String> updateFieldList, Set<String> fids, String tableName, OperTypeEnum operTypeEnum) {
        HashMap<String, AtsSumDataLogObserver> valueMap = new HashMap<String, AtsSumDataLogObserver>();
        try {
            StringBuffer queryStr = new StringBuffer();
            for (int i = 0; i < updateFieldList.size(); ++i) {
                String name = updateFieldList.get(i);
                if (!StringUtils.isEmpty((String)queryStr.toString())) {
                    queryStr.append(",");
                }
                queryStr.append(name);
            }
            StringBuffer querySql = new StringBuffer();
            querySql.append("SELECT " + queryStr.toString().replace("FlastUpdateUserID", "A.FlastUpdateUserID").replace("FlastUpdateTime", "A.FlastUpdateTime") + ",A.FID,A.FPROPOSERID personId,").append(" A.FattendancePeriodId attendancePeriodId,").append(" atsPeriod.fname" + MLUtile.getMlFlag(ctx) + " periodName FROM " + tableName + " A ").append(" INNER JOIN T_HR_ATS_AttendancePeriod atsPeriod on A.FattendancePeriodId = atsPeriod.FID ").append(" where  A.FID IN (").append(AtsUtil.convertSetToString(fids)).append(") AND FSalaryStatus = ").append(2).toString();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            while (rs.next()) {
                String fid = rs.getObject("FID").toString();
                String periodName = rs.getObject("periodName").toString();
                String personId = rs.getObject("personId").toString();
                String attendancePeriodId = rs.getObject("attendancePeriodId").toString();
                StringBuffer oldValStr = new StringBuffer();
                oldValStr.append(DataLogUtil.getNameValueStr("fid", fid) + ",");
                for (String columnName : updateFieldList) {
                    Object columnValue = rs.getObject(columnName);
                    oldValStr.append(DataLogUtil.getNameValueStr(columnName, columnValue) + ",");
                }
                AtsSumDataLogObserver observer = new AtsSumDataLogObserver();
                observer.setObjectId(fid);
                observer.setPersonId(personId);
                observer.setAttendancePeriodId(attendancePeriodId);
                observer.setPeriodName(periodName);
                observer.setOperType(operTypeEnum);
                observer.setOperAction(OperActionEnum.modify);
                observer.setObjectOldDesc("{" + oldValStr.substring(0, oldValStr.length() - 2).toString() + "}");
                observer.setCtx(ctx);
                valueMap.put(fid, observer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return valueMap;
    }

    public static String getResultOldValueStr(Context ctx, String attendDate, String personId, Set<String> columnNo, StringBuffer oldValStr) throws BOSException, SQLException {
        String fid = null;
        try {
            StringBuffer queryStr = new StringBuffer();
            Iterator<String> columnIter = columnNo.iterator();
            while (columnIter.hasNext()) {
                if (!StringUtils.isEmpty((String)queryStr.toString())) {
                    queryStr.append(",");
                }
                queryStr.append(columnIter.next());
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT " + queryStr.toString() + ",FID FROM T_HR_ATS_AttendanceResult where  fproposerId=? and FATTENCEDATE = ? "), (Object[])new Object[]{personId, AtsDateUtils.stringShortToTimestamp(attendDate)});
            if (rs.next()) {
                fid = rs.getObject("FID").toString();
                for (String columnName : columnNo) {
                    Object columnValue = rs.getObject(columnName);
                    if (!StringUtils.isEmpty((String)oldValStr.toString())) {
                        oldValStr.append(",");
                    }
                    oldValStr.append(DataLogUtil.getNameValueStr(columnName, columnValue));
                }
                oldValStr.append("," + DataLogUtil.getNameValueStr("FID", fid));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fid;
    }

    public static void saveSumDataLogBySalary(Context ctx, String attendancePeriodId, String periodName, String logQuerySql, String logResult, String fid, OperActionEnum operAction) {
        try {
            LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.atsResultSum);
            AtsSumDataLogObserver observer = new AtsSumDataLogObserver();
            observer.setObjectId(fid);
            observer.setAttendancePeriodId(attendancePeriodId);
            observer.setPeriodName(periodName);
            observer.setOperType(OperTypeEnum.atsResultSum);
            observer.setOperAction(operAction);
            observer.setObjectOldDesc(logQuerySql);
            observer.setObjectDesc(logResult.replaceAll("'", ""));
            observer.setNeedCheck(true);
            observer.setCtx(ctx);
            logControlCenter.addObserver(observer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveSumDataLogBySalary(Context ctx, String attendancePeriodId, String periodName, String logQuerySql, String logResult, String fid, OperActionEnum operAction, OperTypeEnum operTypeEnum) {
        try {
            LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.atsResultSum);
            AtsSumDataLogObserver observer = new AtsSumDataLogObserver();
            observer.setObjectId(fid);
            observer.setAttendancePeriodId(attendancePeriodId);
            observer.setPeriodName(periodName);
            observer.setOperType(operTypeEnum);
            observer.setOperAction(operAction);
            observer.setObjectOldDesc(logQuerySql);
            observer.setObjectDesc(logResult.replaceAll("'", ""));
            observer.setNeedCheck(true);
            observer.setCtx(ctx);
            logControlCenter.addObserver(observer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addLogObserverListToCenter(Context ctx, LogControlCenter logControlCenter, List<LogObserver> observerList) {
        if (null != observerList && !observerList.isEmpty()) {
            int size = observerList.size();
            for (int i = 0; i < size; ++i) {
                LogObserver logObserver = observerList.get(i);
                logControlCenter.addObserver(logObserver);
            }
        }
    }

    public static boolean deleteDataLogDateAgo(Context ctx, Date date, String tableName) {
        return DataLogUtil.deleteDataLogDateAgo(ctx, date, tableName, "FCreateTime");
    }

    public static boolean deleteDataLogDateAgo(Context ctx, Date date, String tableName, String columnName) {
        try {
            String fid;
            IRowSet rs;
            if (StringUtils.isEmpty((String)columnName)) {
                columnName = "FCreateTime";
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT TOP 1 FID FROM " + tableName + " where  " + columnName + " < ? "), (Object[])new Object[]{new Timestamp(date.getTime())})).next() && !StringUtils.isEmpty((String)(fid = rs.getObject("FID").toString()))) {
                DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName + " where " + columnName + " < ? "), (Object[])new Object[]{new Timestamp(date.getTime())});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void addLogObserverToCenter(Context ctx, AtsLeaveBillEntryInfo oldEntryInfo, AtsLeaveBillEntryInfo entryinfo) {
        try {
            AtsBillDataLogObserver observer = new AtsBillDataLogObserver();
            observer.setObjectId(oldEntryInfo.getId().toString());
            observer.setBillId(oldEntryInfo.getBill().getId().toString());
            observer.setBillNum(oldEntryInfo.getBill().getNumber());
            observer.setPersonId(oldEntryInfo.getPerson().getId().toString());
            observer.setOperType(OperTypeEnum.leaveBill);
            observer.setOperAction(OperActionEnum.submitEffectByCancelLB);
            observer.setObjectOldDesc(JSONUtils.convertObjectToJson((Context)ctx, (Object)oldEntryInfo));
            observer.setObjectDesc(JSONUtils.convertObjectToJson((Context)ctx, (Object)entryinfo));
            observer.setNeedCheck(true);
            observer.setCtx(ctx);
            DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.leaveBill).addObserver(observer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

