/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.function;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AbstractAtsFileBaseInfo;
import com.kingdee.eas.hr.ats.AbstractAttencePolicyInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AttencePolicyExtInfo;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.AttendanceProjectFactory;
import com.kingdee.eas.hr.ats.AttendanceProjectInfo;
import com.kingdee.eas.hr.ats.FillSignCardEntryCollection;
import com.kingdee.eas.hr.ats.FillSignCardEntryInfo;
import com.kingdee.eas.hr.ats.FillSignCardInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.WorkCalendarInfo;
import com.kingdee.eas.hr.ats.WorkCalendarItemInfo;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataRow;
import com.kingdee.eas.hr.ats.calculate.AtsCalculateTimeUtil;
import com.kingdee.eas.hr.ats.calculate.DateInterVal;
import com.kingdee.eas.hr.ats.calculate.state.vo.ShiftTimeVO;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.function.AtsDateVO;
import com.kingdee.eas.hr.ats.function.AtsShiftVO;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.result.AttendanceDynamicResInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.FetchCardUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AtsCalFunctionUtil {
    private static Logger logger = Logger.getLogger(AtsCalFunctionUtil.class);
    public static final String T_HR_ATS_ATTENDANCERESULT_FPROPOSERID = "T_HR_ATS_ATTENDANCERESULT_FPROPOSERID";
    public static final String T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE = "T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE";
    public static final String T_HR_SCMPCALTABLE_FPERSONID = "T_HR_SCMPCALTABLE_FPERSONID";
    public static final String GLOBALMAPKEY = "globalMapKey";
    public static final String PERIODBEGINDATE = "periodBeginDate";
    public static final String PERIODENDDATE = "periodEndDate";
    public static final String DAYTYPE = "DAYTYPE";
    public static final String T_HR_ATS_ATTENDANCERESULTSUM_FPROPOSERID = "T_HR_ATS_ATTENDANCERESULTSUM_FPROPOSERID";
    public static final String STANDARDHOUR = "standardHour";
    public static final String ONESEGMENTINREST = "oneSegmentInRest";
    public static final String TWOSEGMENTINREST = "twoSegmentInRest";
    public static final String THREESEGMENTINREST = "threeSegmentInRest";
    public static final String ONEONEPRERESTTIME = "oneOnePreRestTime";
    public static final String ONEONENEXTRESTTIME = "oneOneNextRestTime";
    public static final String ONEONTIMESCHEDULE = "oneOnTimeSchedule";
    public static final String ONEOFFTIMESCHEDULE = "oneOffTimeSchedule";
    public static final String TWOONTIMESCHEDULE = "twoOnTimeSchedule";
    public static final String TWOOFFTIMESCHEDULE = "twoOffTimeSchedule";
    public static final String THREEONTIMESCHEDULE = "threeOnTimeSchedule";
    public static final String THREEOFFTIMESCHEDULE = "threeOffTimeSchedule";
    public static final String SHIFTSIZE = "shiftSize";
    public static final String SHIFTTIMELIST = "shiftTimeList";
    public static final String TRIPBILLDAYS = "tripBillDays";
    public static final String TRIPBILLHOURS = "tripBillHours";
    public static final int NUM3600000 = 3600000;
    public static final int NUM60000 = 60000;
    public static final int NUM60 = 60;
    public static final String columnMark = "S";
    public static final int CYCLETYPE_MONTH = 0;
    public static final int CYCLETYPE_SEASON = 1;
    public static final int CYCLETYPE_HALFYEAR = 2;
    public static final int CYCLETYPE_YEAR = 3;

    public static double getFillSignTimesByResult(Context ctx, String reasonNumber, Map paramMap) throws EASBizException, BOSException {
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        double total = 0.0;
        List<FillSignCardEntryInfo> fillSignCardEntryList = AtsCalFunctionUtil.requireFillSignCardList(globalMap, currDateStr, personId);
        if (null == fillSignCardEntryList || fillSignCardEntryList.size() <= 0) {
            return total;
        }
        Map<String, Object> resultInfo = AtsCalFunctionUtil.requireAttendResultByParam(globalMap, currDateStr, personId);
        List<Timestamp> cardList = AtsCalFunctionUtil.buliderCardListByAttResult(resultInfo);
        if (null == cardList || cardList.size() <= 0) {
            return total;
        }
        return AtsCalFunctionUtil.countFillSignByResult(fillSignCardEntryList, cardList, reasonNumber);
    }

    private static List<FillSignCardEntryInfo> requireFillSignCardList(Map<String, Object> globalMap, String currDateStr, String personId) {
        if (null == globalMap || StringUtils.isEmpty((String)currDateStr) || StringUtils.isEmpty((String)personId)) {
            return null;
        }
        String preDay = AtsDateUtils.getPreDay(currDateStr);
        String nextDay = AtsDateUtils.getNextDay(currDateStr);
        String[] dataArray = new String[]{preDay, currDateStr, nextDay};
        Map fillSignObject = (Map)globalMap.get("fillSignCardInfosMap");
        if (null == fillSignObject || fillSignObject.size() <= 0) {
            return null;
        }
        ArrayList<FillSignCardEntryInfo> fillSignCardEntryList = new ArrayList<FillSignCardEntryInfo>();
        HashSet<String> fillEntryIdSet = new HashSet<String>();
        for (int index = 0; index < dataArray.length; ++index) {
            List list = (List)fillSignObject.get(AtsCalFunctionUtil.requireGroupKey(personId, dataArray[index]));
            AtsCalFunctionUtil.buildFillSignCardEntryList(list, fillSignCardEntryList, fillEntryIdSet);
        }
        return fillSignCardEntryList;
    }

    private static void buildFillSignCardEntryList(List<FillSignCardInfo> list, List<FillSignCardEntryInfo> fillSignCardEntryList, Set<String> fillEntryIdSet) {
        if (null == list || list.size() <= 0 || null == fillSignCardEntryList || null == fillEntryIdSet) {
            return;
        }
        for (FillSignCardInfo fillSignCardInfo : list) {
            FillSignCardEntryCollection fillSignCardEntryColl = fillSignCardInfo.getEntries();
            String fillId = null == fillSignCardInfo.getId() ? "" : fillSignCardInfo.getId().toString();
            for (int index = 0; index < fillSignCardEntryColl.size(); ++index) {
                FillSignCardEntryInfo fillSignCardEntryInfo = fillSignCardEntryColl.get(index);
                String fillCardTimeStr = AtsDateUtils.dateLongFormatToString(fillSignCardEntryInfo.getFillCardTime());
                String uniqueFlag = fillId + fillCardTimeStr;
                if (fillEntryIdSet.contains(uniqueFlag)) continue;
                fillEntryIdSet.add(uniqueFlag);
                fillSignCardEntryList.add(fillSignCardEntryInfo);
            }
        }
    }

    private static double countFillSignByResult(List<FillSignCardEntryInfo> fillSignCardEntryList, List<Timestamp> cardList, String reasonNumber) {
        double total = 0.0;
        if (null == fillSignCardEntryList || fillSignCardEntryList.size() <= 0 || null == cardList || cardList.size() <= 0) {
            return total;
        }
        block0: for (Timestamp resultCardTime : cardList) {
            for (FillSignCardEntryInfo fillSignCardEntryInfo : fillSignCardEntryList) {
                Timestamp entryCardTime = fillSignCardEntryInfo.getFillCardTime();
                if (entryCardTime.compareTo(resultCardTime) != 0) continue;
                if (StringUtils.isEmpty((String)reasonNumber)) {
                    total += 1.0;
                    continue block0;
                }
                String number = fillSignCardEntryInfo.getReason().getNumber();
                if (!reasonNumber.equals(number)) continue;
                total += 1.0;
                continue block0;
            }
        }
        return total;
    }

    private static List<Timestamp> buliderCardListByAttResult(Map<String, Object> resultInfo) {
        if (null == resultInfo) {
            return null;
        }
        ArrayList<Timestamp> cardList = new ArrayList<Timestamp>();
        for (int index = 1; index <= 6; ++index) {
            String columnNo = columnMark + index;
            Timestamp cardTime = AtsCalFunctionUtil.requireTimeByObj(resultInfo.get(columnNo));
            if (null == cardTime) continue;
            cardList.add(cardTime);
        }
        return cardList;
    }

    public static Timestamp requireTimeByObj(Object obj) {
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        if (obj instanceof String) {
            return AtsDateUtils.stringToTimestamp((String)obj);
        }
        return null;
    }

    private static String requireGroupKey(String personId, String dateStr) {
        return new StringBuffer(personId).append("_").append(dateStr).toString();
    }

    private static Map<String, Object> requireAttendResultByParam(Map globalMap, String currDateStr, String personId) {
        Map calResultInfoMap = (Map)globalMap.get("calResultInfoMap");
        if (null == calResultInfoMap) {
            return null;
        }
        String resultInfoKey = AtsCalFunctionUtil.requireGroupKey(personId, currDateStr);
        Map resultInfo = (Map)calResultInfoMap.get(resultInfoKey);
        if (null == resultInfo) {
            return null;
        }
        return resultInfo;
    }

    public static double getAtsFileHisCalendarDayType(Context ctx, Map paramMap) throws EASBizException, BOSException {
        Map workCalendarItemInfoMap;
        String workCalendarId;
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        double value = -1.0;
        AbstractAtsFileBaseInfo fileInfo = null;
        Map fileInfoObject = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        if (fileInfoObject != null) {
            fileInfo = (AttendanceFileInfo)fileInfoObject.get(personId + "_" + currDateStr);
        }
        String string = workCalendarId = fileInfo != null && fileInfo.getCalendar() != null && fileInfo.getCalendar().getId() != null ? fileInfo.getCalendar().getId().toString() : "";
        if (!StringUtils.isEmpty((String)workCalendarId) && (workCalendarItemInfoMap = (Map)globalMap.get("workItemMap")) != null && workCalendarItemInfoMap.size() > 0) {
            WorkCalendarItemInfo workCalendarItemInfo = (WorkCalendarItemInfo)workCalendarItemInfoMap.get(workCalendarId + "_" + currDateStr);
            value = workCalendarItemInfo != null && workCalendarItemInfo.getDayType() != null ? (double)workCalendarItemInfo.getDayType().getValue() : -1.0;
        }
        return value;
    }

    public static double getAtsFileHisCalendarDayCount(Context ctx, double countType, Map paramMap) throws Exception {
        try {
            int ctType = BigDecimal.valueOf(countType).intValue();
            if (ctType != 0 && ctType != 1 && ctType != 2 && ctType != 3) {
                return -1.0;
            }
            Double countResult = new Double(0.0);
            Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
            Map fileInfoObject = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
            String beginDate = (String)globalMap.get(PERIODBEGINDATE);
            String endDate = (String)globalMap.get(PERIODENDDATE);
            String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULTSUM_FPROPOSERID);
            AttendanceFileInfo attenceFile = (AttendanceFileInfo)fileInfoObject.get(personId + "_" + endDate);
            if (attenceFile == null) {
                attenceFile = (AttendanceFileInfo)fileInfoObject.get(personId + "_" + beginDate);
            }
            if (attenceFile == null) {
                attenceFile = (AttendanceFileInfo)fileInfoObject.get(personId + "_" + HRTimeWebUtils.dateShortToString(new Date()));
            }
            if (attenceFile == null) {
                List<String> datelist = AtsDateUtils.getDateList(beginDate, endDate);
                for (int i = 0; i < datelist.size() && (attenceFile = (AttendanceFileInfo)fileInfoObject.get(personId + "_" + datelist.get(i))) == null; ++i) {
                }
            }
            if (attenceFile != null && attenceFile.getCalendar() != null && null != attenceFile.getCalendar().getId()) {
                String workCalendarId = attenceFile.getCalendar().getId().toString();
                long oneDayTime = 86400000L;
                HashSet<String> timeOriginalSets = new HashSet<String>();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date beginTime = sdf.parse(beginDate);
                Date endTime = sdf.parse(endDate);
                while (beginTime.getTime() <= endTime.getTime()) {
                    timeOriginalSets.add(sdf.format(beginTime));
                    beginTime.setTime(beginTime.getTime() + oneDayTime);
                }
                Map workItemMap = (Map)globalMap.get("workItemMap");
                Iterator iter = timeOriginalSets.iterator();
                while (iter.hasNext()) {
                    String key = workCalendarId + "_" + (String)iter.next();
                    WorkCalendarItemInfo itemInfo = (WorkCalendarItemInfo)workItemMap.get(key);
                    if (itemInfo != null) {
                        switch (ctType) {
                            case 0: {
                                if (0 != itemInfo.getDayType().getValue()) break;
                                countResult = countResult + 1.0;
                                break;
                            }
                            case 1: {
                                if (1 != itemInfo.getDayType().getValue()) break;
                                countResult = countResult + 1.0;
                                break;
                            }
                            case 2: {
                                if (2 != itemInfo.getDayType().getValue()) break;
                                countResult = countResult + 1.0;
                                break;
                            }
                            case 3: {
                                countResult = countResult + 1.0;
                            }
                        }
                        continue;
                    }
                    if (ctType != 3) continue;
                    countResult = countResult + 1.0;
                }
                return countResult;
            }
            return -1.0;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return -1.0;
        }
    }

    public static double getIntersectTimeForLeaveBill(Context ctx, Map paramMap) throws EASBizException, BOSException {
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        String key = personId + "_" + currDateStr;
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        Double intersectTime = 0.0;
        if (null != globalMap) {
            try {
                Map leaveBillEntryMap = (Map)globalMap.get("T_HR_ATS_LeaveBillEntry");
                List leaveBillEntryList = null;
                if (null != leaveBillEntryMap) {
                    leaveBillEntryList = (List)leaveBillEntryMap.get(key);
                }
                Map calResultInfoMap = (Map)globalMap.get("calResultInfoMap");
                String resultInfoKey = MessageFormat.format("{0}{1}{2}", personId, "_", currDateStr);
                if (null != leaveBillEntryList && calResultInfoMap != null) {
                    Date S6DT = null;
                    Date S5DT = null;
                    Date S4DT = null;
                    Date S3DT = null;
                    Date S2DT = null;
                    Date S1DT = null;
                    Map resultInfo = (Map)calResultInfoMap.get(resultInfoKey);
                    if (null != resultInfo) {
                        String S6 = resultInfo.get("S6") != null ? resultInfo.get("S6").toString() : "";
                        String S5 = resultInfo.get("S5") != null ? resultInfo.get("S5").toString() : "";
                        String S4 = resultInfo.get("S4") != null ? resultInfo.get("S4").toString() : "";
                        String S3 = resultInfo.get("S3") != null ? resultInfo.get("S3").toString() : "";
                        String S2 = resultInfo.get("S2") != null ? resultInfo.get("S2").toString() : "";
                        String S1 = resultInfo.get("S1") != null ? resultInfo.get("S1").toString() : "";
                        S6 = S6.contains(".0") ? S6.substring(0, S6.indexOf(".0")) : S6;
                        S5 = S5.contains(".0") ? S5.substring(0, S5.indexOf(".0")) : S5;
                        S4 = S4.contains(".0") ? S4.substring(0, S4.indexOf(".0")) : S4;
                        S3 = S3.contains(".0") ? S3.substring(0, S3.indexOf(".0")) : S3;
                        S2 = S2.contains(".0") ? S2.substring(0, S2.indexOf(".0")) : S2;
                        S1 = S1.contains(".0") ? S1.substring(0, S1.indexOf(".0")) : S1;
                        S6DT = StringUtils.isEmpty((String)S6) ? S6DT : AtsDateUtils.stringToLongDate(S6);
                        S5DT = StringUtils.isEmpty((String)S5) ? S5DT : AtsDateUtils.stringToLongDate(S5);
                        S4DT = StringUtils.isEmpty((String)S4) ? S4DT : AtsDateUtils.stringToLongDate(S4);
                        S3DT = StringUtils.isEmpty((String)S3) ? S3DT : AtsDateUtils.stringToLongDate(S3);
                        S2DT = StringUtils.isEmpty((String)S2) ? S2DT : AtsDateUtils.stringToLongDate(S2);
                        S1DT = StringUtils.isEmpty((String)S1) ? S1DT : AtsDateUtils.stringToLongDate(S1);
                    }
                    Timestamp startTime = null;
                    Timestamp endTime = null;
                    Date shiftBeginTime = null;
                    Date shiftEndTime = null;
                    AtsLeaveBillEntryInfo leaveBillEntryInfo = null;
                    String[] shiftTime = FetchCardUtil.getOnOffShiftSegTime(globalMap, personId, currDateStr);
                    Timestamp[] oneShiftRestTime = FetchCardUtil.getOneShiftRestTime(globalMap, personId, currDateStr);
                    for (int index = 0; index < shiftTime.length; ++index) {
                        if (StringUtils.isEmpty((String)shiftTime[index])) continue;
                        shiftBeginTime = AtsDateUtils.stringToLongDate(shiftTime[index]);
                        shiftEndTime = AtsDateUtils.stringToLongDate(shiftTime[++index]);
                        if (null == leaveBillEntryList) continue;
                        int size = leaveBillEntryList.size();
                        for (int i = 0; i < size; ++i) {
                            leaveBillEntryInfo = (AtsLeaveBillEntryInfo)leaveBillEntryList.get(i);
                            startTime = leaveBillEntryInfo.getRealBeginTime();
                            endTime = leaveBillEntryInfo.getRealEndTime();
                            if (null == leaveBillEntryInfo || startTime == null || endTime == null) continue;
                            intersectTime = intersectTime + AtsCalFunctionUtil.getIntersectTime(startTime, endTime, S1DT, S2DT, shiftBeginTime, shiftEndTime, oneShiftRestTime);
                            intersectTime = intersectTime + AtsCalFunctionUtil.getIntersectTime(startTime, endTime, S3DT, S4DT, shiftBeginTime, shiftEndTime, oneShiftRestTime);
                            intersectTime = intersectTime + AtsCalFunctionUtil.getIntersectTime(startTime, endTime, S5DT, S6DT, shiftBeginTime, shiftEndTime, oneShiftRestTime);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return intersectTime;
    }

    public static double getIntersectTimeForTripBill(Context ctx, Map paramMap) throws EASBizException, BOSException {
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        String key = personId + "_" + currDateStr;
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        Double intersectTime = 0.0;
        if (null != globalMap) {
            try {
                Map tripBillEntryMap = (Map)globalMap.get("T_HR_ATS_TripBillEntry");
                List tripBillEntryList = null;
                if (null != tripBillEntryMap) {
                    tripBillEntryList = (List)tripBillEntryMap.get(key);
                }
                Map calResultInfoMap = (Map)globalMap.get("calResultInfoMap");
                String resultInfoKey = MessageFormat.format("{0}{1}{2}", personId, "_", currDateStr);
                if (null != tripBillEntryList && calResultInfoMap != null) {
                    Date S6DT = null;
                    Date S5DT = null;
                    Date S4DT = null;
                    Date S3DT = null;
                    Date S2DT = null;
                    Date S1DT = null;
                    Map resultInfo = (Map)calResultInfoMap.get(resultInfoKey);
                    if (null != resultInfo) {
                        String S6 = resultInfo.get("S6") != null ? resultInfo.get("S6").toString() : "";
                        String S5 = resultInfo.get("S5") != null ? resultInfo.get("S5").toString() : "";
                        String S4 = resultInfo.get("S4") != null ? resultInfo.get("S4").toString() : "";
                        String S3 = resultInfo.get("S3") != null ? resultInfo.get("S3").toString() : "";
                        String S2 = resultInfo.get("S2") != null ? resultInfo.get("S2").toString() : "";
                        String S1 = resultInfo.get("S1") != null ? resultInfo.get("S1").toString() : "";
                        S6 = S6.contains(".0") ? S6.substring(0, S6.indexOf(".0")) : S6;
                        S5 = S5.contains(".0") ? S5.substring(0, S5.indexOf(".0")) : S5;
                        S4 = S4.contains(".0") ? S4.substring(0, S4.indexOf(".0")) : S4;
                        S3 = S3.contains(".0") ? S3.substring(0, S3.indexOf(".0")) : S3;
                        S2 = S2.contains(".0") ? S2.substring(0, S2.indexOf(".0")) : S2;
                        S1 = S1.contains(".0") ? S1.substring(0, S1.indexOf(".0")) : S1;
                        S6DT = StringUtils.isEmpty((String)S6) ? S6DT : AtsDateUtils.stringToLongDate(S6);
                        S5DT = StringUtils.isEmpty((String)S5) ? S5DT : AtsDateUtils.stringToLongDate(S5);
                        S4DT = StringUtils.isEmpty((String)S4) ? S4DT : AtsDateUtils.stringToLongDate(S4);
                        S3DT = StringUtils.isEmpty((String)S3) ? S3DT : AtsDateUtils.stringToLongDate(S3);
                        S2DT = StringUtils.isEmpty((String)S2) ? S2DT : AtsDateUtils.stringToLongDate(S2);
                        S1DT = StringUtils.isEmpty((String)S1) ? S1DT : AtsDateUtils.stringToLongDate(S1);
                    }
                    Timestamp startTime = null;
                    Timestamp endTime = null;
                    AtsTripBillEntryInfo tripBillEntryInfo = null;
                    Date shiftBeginTime = null;
                    Date shiftEndTime = null;
                    String[] shiftTime = FetchCardUtil.getOnOffShiftSegTime(globalMap, personId, currDateStr);
                    Timestamp[] oneShiftRestTime = FetchCardUtil.getOneShiftRestTime(globalMap, personId, currDateStr);
                    for (int index = 0; index < shiftTime.length; ++index) {
                        if (StringUtils.isEmpty((String)shiftTime[index])) continue;
                        shiftBeginTime = AtsDateUtils.stringToLongDate(shiftTime[index]);
                        shiftEndTime = AtsDateUtils.stringToLongDate(shiftTime[++index]);
                        if (null == tripBillEntryList) continue;
                        int size = tripBillEntryList.size();
                        for (int i = 0; i < size; ++i) {
                            tripBillEntryInfo = (AtsTripBillEntryInfo)tripBillEntryList.get(i);
                            startTime = tripBillEntryInfo.getRealTripStartTime();
                            endTime = tripBillEntryInfo.getRealTripEndTime();
                            if (null == tripBillEntryInfo || startTime == null || endTime == null) continue;
                            intersectTime = intersectTime + AtsCalFunctionUtil.getIntersectTime(startTime, endTime, S1DT, S2DT, shiftBeginTime, shiftEndTime, oneShiftRestTime);
                            intersectTime = intersectTime + AtsCalFunctionUtil.getIntersectTime(startTime, endTime, S3DT, S4DT, shiftBeginTime, shiftEndTime, oneShiftRestTime);
                            intersectTime = intersectTime + AtsCalFunctionUtil.getIntersectTime(startTime, endTime, S5DT, S6DT, shiftBeginTime, shiftEndTime, oneShiftRestTime);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return intersectTime;
    }

    public static Double getIntersectTime(Date startTime, Date endTime, Date cardStartTime, Date cardEndTime, Date onShiftTime, Date offShiftTime, Timestamp[] restTime) {
        Double intersectTime = 0.0;
        Double intersectRestTime = 0.0;
        try {
            Date[] intersectDt = AtsCalFunctionUtil.getIntersectTime(startTime, endTime, cardStartTime, cardEndTime);
            if (null != intersectDt && intersectDt.length == 2) {
                intersectDt = AtsCalFunctionUtil.getIntersectTime(intersectDt[0], intersectDt[1], onShiftTime, offShiftTime);
                Date[] intersectRestDt = null;
                if (null != intersectDt && null != restTime && restTime.length == 2) {
                    intersectRestDt = AtsCalFunctionUtil.getIntersectTime(intersectDt[0], intersectDt[1], restTime[0], restTime[1]);
                }
                if (intersectRestDt != null) {
                    intersectRestTime = AtsDateUtils.getTwoTimeDiffMinutes((Date)intersectRestDt[0], (Date)intersectRestDt[1]);
                }
                if (null != intersectDt) {
                    intersectTime = AtsDateUtils.getTwoTimeDiffMinutes(intersectDt[0], intersectDt[1]);
                    if ((intersectTime = Double.valueOf(intersectTime - intersectRestTime)) < 0.0) {
                        intersectTime = 0.0;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return intersectTime;
    }

    public static Date[] getIntersectTime(Date startTime, Date endTime, Date cardStartTime, Date cardEndTime, Date onShiftTime, Date offShiftTime) {
        Date[] intersectDt = null;
        try {
            if (null != startTime && null != endTime && null != cardStartTime && null != cardEndTime && null != onShiftTime && null != offShiftTime && null != (intersectDt = AtsCalFunctionUtil.getIntersectTime(startTime, endTime, cardStartTime, cardEndTime)) && intersectDt.length == 2) {
                intersectDt = AtsCalFunctionUtil.getIntersectTime(intersectDt[0], intersectDt[1], onShiftTime, offShiftTime);
                return intersectDt;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return intersectDt;
    }

    public static Double getIntersectTime(Date startTime, Date endTime, Date cardStartTime, Date cardEndTime, Timestamp[] restTime) {
        Double intersectTime = 0.0;
        Double intersectRestTime = 0.0;
        try {
            Date[] intersectDt = AtsCalFunctionUtil.getIntersectTime(startTime, endTime, cardStartTime, cardEndTime);
            if (null != intersectDt && intersectDt.length == 2) {
                Date[] intersectRestDt = null;
                if (null != intersectDt && null != restTime && restTime.length == 2) {
                    intersectRestDt = AtsCalFunctionUtil.getIntersectTime(intersectDt[0], intersectDt[1], restTime[0], restTime[1]);
                }
                if (intersectRestDt != null) {
                    intersectRestTime = AtsDateUtils.getTwoTimeDiffMinutes((Date)intersectRestDt[0], (Date)intersectRestDt[1]);
                }
                if (null != intersectDt) {
                    intersectTime = AtsDateUtils.getTwoTimeDiffMinutes(intersectDt[0], intersectDt[1]);
                    if ((intersectTime = Double.valueOf(intersectTime - intersectRestTime)) < 0.0) {
                        intersectTime = 0.0;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return intersectTime;
    }

    public static Date[] getIntersectTime(Date startTime, Date endTime, Date cardStartTime, Date cardEndTime) {
        try {
            if (null != startTime && null != endTime && null != cardStartTime && null != cardEndTime && startTime.compareTo(cardEndTime) <= 0 && endTime.compareTo(cardStartTime) >= 0) {
                double intersectEndTime;
                if (startTime.compareTo(cardStartTime) <= 0 && endTime.compareTo(cardEndTime) >= 0) {
                    return new Date[]{cardStartTime, cardEndTime};
                }
                if (startTime.compareTo(cardStartTime) > 0 && endTime.compareTo(cardEndTime) < 0) {
                    return new Date[]{startTime, endTime};
                }
                double intersectStartTime = AtsDateUtils.getTwoTimeDiffMinutes(startTime, cardEndTime);
                if (intersectStartTime < (intersectEndTime = AtsDateUtils.getTwoTimeDiffMinutes(cardStartTime, endTime))) {
                    return new Date[]{startTime, cardEndTime};
                }
                return new Date[]{cardStartTime, endTime};
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static double getIntersectTimeMinusRestTime(Timestamp beginTime, Timestamp endTime, Timestamp onScheduleTime, Timestamp offScheduleTime, Timestamp preRestTime, Timestamp nextRestTime, BigDecimal segmentInRest) {
        double mixedValue = 0.0;
        Date[] intersectDt = AtsCalFunctionUtil.getIntersectTime(beginTime, endTime, onScheduleTime, offScheduleTime);
        if (intersectDt != null) {
            double restTime = 0.0;
            if (null != preRestTime && null != preRestTime) {
                Date[] intersectRestDt = AtsCalFunctionUtil.getIntersectTime(intersectDt[0], intersectDt[1], preRestTime, nextRestTime);
                restTime = AtsDateUtils.getTwoTimeDiffMinutes(intersectRestDt != null ? intersectRestDt[0] : null, intersectRestDt != null ? intersectRestDt[1] : null);
            } else if (null != segmentInRest && segmentInRest.compareTo(BigDecimal.ZERO) > 0) {
                restTime = segmentInRest.multiply(BigDecimal.valueOf(60000L)).doubleValue();
            }
            mixedValue = AtsDateUtils.getTwoTimeDiffMinutes(intersectDt[0], intersectDt[1]) - restTime;
        }
        return mixedValue;
    }

    public static double getIntersectTimeMinusRestTime(Timestamp beginTime, Timestamp endTime, Timestamp onScheduleTime, Timestamp offScheduleTime, BigDecimal segmentInRest) {
        double mixedValue = 0.0;
        Date[] intersectDt = AtsCalFunctionUtil.getIntersectTime(beginTime, endTime, onScheduleTime, offScheduleTime);
        if (intersectDt != null) {
            double restTime = 0.0;
            if (null != segmentInRest && segmentInRest.compareTo(BigDecimal.ZERO) > 0) {
                restTime = segmentInRest.multiply(BigDecimal.valueOf(60000L)).doubleValue();
            }
            mixedValue = AtsDateUtils.getTwoTimeDiffMinutes(intersectDt[0], intersectDt[1]) - restTime;
        }
        return mixedValue;
    }

    public static double getIntersectTimeMinusRestTime(ShiftTimeVO shiftTime, Date beginTime, Date endTime) {
        return AtsCalFunctionUtil.getIntersectTimeMinusRestTime(shiftTime, new Timestamp(beginTime.getTime()), new Timestamp(endTime.getTime()));
    }

    public static double getIntersectTimeMinusRestTime(ShiftTimeVO shiftTime, Timestamp beginTime, Timestamp endTime) {
        double mixedValue = 0.0;
        Date[] intersectDt = AtsCalFunctionUtil.getIntersectTime(beginTime, endTime, shiftTime.getBeginTime(), shiftTime.getEndTime());
        if (intersectDt != null) {
            double restTime = 0.0;
            if (null != shiftTime.getBeginRestTime() && null != shiftTime.getEndRestTime()) {
                Date[] intersectRestDt = AtsCalFunctionUtil.getIntersectTime(intersectDt[0], intersectDt[1], shiftTime.getBeginRestTime(), shiftTime.getEndRestTime());
                if (null != intersectRestDt) {
                    restTime = AtsDateUtils.getTwoTimeDiffMinutes(intersectRestDt[0], intersectRestDt[1]);
                }
            } else if (null != shiftTime.getSegmentInRest() && shiftTime.getSegmentInRest().compareTo(BigDecimal.ZERO) > 0) {
                restTime = shiftTime.getSegmentInRest().doubleValue();
            }
            mixedValue = AtsDateUtils.getTwoTimeDiffMinutes(intersectDt[0], intersectDt[1]) - restTime;
        }
        return mixedValue;
    }

    /*
     * Unable to fully structure code
     */
    public static int getAtsProjectColumnNo(Context ctx, String projectNum, Map paramMap) {
        columnNo = 0;
        if (StringUtils.isEmpty((String)projectNum)) {
            return columnNo;
        }
        attendanceProjectMap = (Map)((Map)paramMap.get("globalMapKey")).get("T_HR_ATS_AttendanceProject");
        if (null != attendanceProjectMap) {
            atsProjects = attendanceProjectMap.values();
            for (AttendanceProjectInfo atsProject : atsProjects) {
                if (!atsProject.getNumber().equals(projectNum)) continue;
                columnNo = atsProject.getColumnNO();
                break;
            }
        } else {
            try {
                proColl = AttendanceProjectFactory.getLocalInstance(ctx).getAttendanceProjectCollection("where number='" + projectNum + "'");
                if (proColl == null || proColl.size() <= 0) ** GOTO lbl19
                columnNo = proColl.get(0).getColumnNO();
            }
            catch (Exception e1) {
                AtsCalFunctionUtil.logger.error((Object)String.format(" getAtsProjectColumnNo require columnNo Exception : { projectNum :  %s }", new Object[]{projectNum}));
            }
        }
        projectNumClone = "";
        if (0 == columnNo) {
            try {
                projectNumArr = projectNum.toUpperCase().split("S");
                if (projectNumArr.length > 0) {
                    projectNumClone = projectNumArr[projectNumArr.length - 1];
                }
                columnNo = Integer.parseInt(projectNumClone);
            }
            catch (Exception e) {
                AtsCalFunctionUtil.logger.error((Object)String.format(" getAtsProjectColumnNo Integer.parseInt Exception : { projectNumClone :  %s }", new Object[]{projectNumClone}));
            }
        }
        return columnNo;
    }

    public static String getMonthlyStatementDataByDate(Map paramMap) {
        AttendanceFileInfo attFilefo;
        String monthlyStatementDate = null;
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        String currDateStr = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        Map attendancePolicyInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
        Map attendancePeriodInfoMap = (Map)globalMap.get("attendancePeriodInfoListMap");
        String key = personId + "_" + currDateStr;
        String attenceCycleID = "";
        if (attendanceFileInfoMap != null && (attFilefo = (AttendanceFileInfo)attendanceFileInfoMap.get(key)) != null && attFilefo.getAttencePolicy() != null && attFilefo.getAttencePolicy().getId() != null && attendancePolicyInfoMap != null) {
            AttencePolicyInfo poInfo = (AttencePolicyInfo)attendancePolicyInfoMap.get(attFilefo.getAttencePolicy().getId().toString());
            String string = attenceCycleID = poInfo.getAttenceCycle() == null ? "" : poInfo.getAttenceCycle().getId().toString();
        }
        if (attendancePeriodInfoMap != null && StringUtils.isNotBlank((String)attenceCycleID)) {
            List periodInfoList = (List)attendancePeriodInfoMap.get(attenceCycleID);
            Date currentDate = AtsDateUtils.stringToShortDate(currDateStr);
            AttendancePeriodInfo atsPeriodInfo = null;
            int size = periodInfoList.size();
            for (int i = 0; i < size; ++i) {
                atsPeriodInfo = (AttendancePeriodInfo)periodInfoList.get(i);
                Date startDate = atsPeriodInfo.getStartDate();
                Date endDate = atsPeriodInfo.getEndDate();
                if (currentDate.getTime() < startDate.getTime() || currentDate.getTime() > endDate.getTime() || null == atsPeriodInfo.getMonthlyStatementDate()) continue;
                monthlyStatementDate = AtsDateUtils.dateShortToString(atsPeriodInfo.getMonthlyStatementDate());
            }
        }
        return monthlyStatementDate;
    }

    public static String getMonthlyStatementDataByPeriod(Map paramMap) {
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULTSUM_FPROPOSERID);
        Map attendancePeriodInfoMap = (Map)globalMap.get("attendancePeriodInfoListMap");
        String beginStr = (String)globalMap.get(PERIODBEGINDATE);
        String endStr = (String)globalMap.get(PERIODENDDATE);
        String attendPeriodId = (String)globalMap.get("attendPeriodId");
        if (!StringUtils.isEmpty((String)personId) && !StringUtils.isEmpty((String)attendPeriodId)) {
            Collection periodInfoList = attendancePeriodInfoMap.values();
            Date beginDt = AtsDateUtils.stringToShortDate(beginStr);
            Date endDt = AtsDateUtils.stringToShortDate(endStr);
            List atsPeriodList2 = null;
            AttendancePeriodInfo atsPeriodInfo = null;
            Date startDate = null;
            Date endDate = null;
            for (List atsPeriodList2 : periodInfoList) {
                int size = atsPeriodList2.size();
                for (int i = 0; i < size; ++i) {
                    atsPeriodInfo = (AttendancePeriodInfo)atsPeriodList2.get(i);
                    startDate = atsPeriodInfo.getStartDate();
                    endDate = atsPeriodInfo.getEndDate();
                    if (beginDt.getTime() != startDate.getTime() || endDt.getTime() != endDate.getTime() || null == atsPeriodInfo.getMonthlyStatementDate()) continue;
                    return AtsDateUtils.dateShortToString(atsPeriodInfo.getMonthlyStatementDate());
                }
            }
        }
        return null;
    }

    public static BigDecimal getTripBillOutShiftTime(Map paramMap) {
        long intervalTime = 0L;
        String attendDate = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        AttendanceFileInfo attendanceFileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(personId + "_" + attendDate);
        AbstractAttencePolicyInfo attencePolicyInfo = null;
        if (null != attendanceFileInfo && null != attendanceFileInfo.getAttencePolicy()) {
            Map attencePolicyMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
            attencePolicyInfo = (AttencePolicyInfo)attencePolicyMap.get(attendanceFileInfo.getAttencePolicy().getId().toString());
        }
        if (null != attencePolicyInfo && attencePolicyInfo.isIsCalOutShift()) {
            Map atsTripBillObject = (Map)globalMap.get("T_HR_ATS_TripBillEntry");
            ArrayList<Timestamp> tpCalOutBillList = new ArrayList<Timestamp>();
            ArrayList<AtsTripBillEntryInfo> tripBillList = new ArrayList<AtsTripBillEntryInfo>();
            if (null != atsTripBillObject && atsTripBillObject.size() > 0) {
                String preDay = AtsDateUtils.getPreDay(attendDate);
                String nextDay = AtsDateUtils.getNextDay(attendDate);
                String[] dateStr = new String[]{preDay, attendDate, nextDay};
                HashSet<String> billIds = new HashSet<String>();
                for (String date : dateStr) {
                    List tripBillDateList = (List)atsTripBillObject.get(personId + "_" + date);
                    if (null == tripBillDateList || tripBillDateList.size() <= 0) continue;
                    for (AtsTripBillEntryInfo entry : tripBillDateList) {
                        if (entry.isIsAllDay()) continue;
                        if (!billIds.contains(entry.getId().toString())) {
                            tpCalOutBillList.add(entry.getRealTripStartTime());
                            tpCalOutBillList.add(entry.getRealTripEndTime());
                            tripBillList.add(entry);
                        }
                        billIds.add(entry.getId().toString());
                    }
                }
            }
            ArrayList<Timestamp> onOffShiftList = new ArrayList<Timestamp>();
            String[] onOffShift = null;
            Set<String> calOutDate = null;
            Timestamp[] headTailOutTime = null;
            if (tpCalOutBillList.size() > 0) {
                if (attendanceFileInfo.getIsAttendance().getValue().equals("1")) {
                    headTailOutTime = FetchCardUtil.getHeadAndTailOutShiftTime(paramMap);
                    calOutDate = FetchCardUtil.getCalOutShiftDate(tripBillList, attendDate, headTailOutTime);
                    if (calOutDate.contains(attendDate) && tpCalOutBillList.size() > 0) {
                        onOffShift = FetchCardUtil.getOnOffShiftTime(globalMap, personId, attendDate);
                        onOffShiftList.add(AtsDateUtils.stringToTimestamp(onOffShift[0]));
                        onOffShiftList.add(AtsDateUtils.stringToTimestamp(onOffShift[1]));
                    }
                } else {
                    headTailOutTime = FetchCardUtil.getHeadAndTailOutDefaultTime(paramMap, personId, attendDate);
                    calOutDate = FetchCardUtil.getCalOutShiftDate(tripBillList, attendDate, headTailOutTime);
                    if (calOutDate.contains(attendDate) && tpCalOutBillList.size() > 0) {
                        onOffShift = FetchCardUtil.getOnOffShiftTime(globalMap, personId, attendDate);
                        onOffShiftList.add(AtsDateUtils.stringToTimestamp(onOffShift[0]));
                        onOffShiftList.add(AtsDateUtils.stringToTimestamp(onOffShift[1]));
                    }
                }
                if (calOutDate.contains(attendDate) && tpCalOutBillList.size() > 0 && onOffShiftList.size() > 0) {
                    intervalTime = FetchCardUtil.intervalTimeCalOutShift(onOffShiftList, tpCalOutBillList, headTailOutTime);
                }
            }
        }
        return new BigDecimal(intervalTime);
    }

    public static Map<String, BigDecimal> getTripBillShiftTimes(Context ctx, Map<String, Object> scheduleResultMap, String personId, String attendDate, Map<String, Object> paramMap) throws BOSException, UuidException, SQLException {
        HashMap<String, BigDecimal> resMap = new HashMap<String, BigDecimal>();
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        int decimalPlaces = DecimalPlaceUtil.getDecimalPlace(ctx, globalMap);
        Map atsTripBillObject = (Map)globalMap.get("T_HR_ATS_TripBillEntry");
        if (null == atsTripBillObject) {
            return resMap;
        }
        String preDay = AtsDateUtils.getPreDay(attendDate);
        String nextDay = AtsDateUtils.getNextDay(attendDate);
        String[] dateStr = new String[]{preDay, attendDate, nextDay};
        ArrayList tripBillList = new ArrayList();
        HashSet<String> billIds = new HashSet<String>();
        for (String date : dateStr) {
            List tripBillDateList = (List)atsTripBillObject.get(personId + "_" + date);
            if (null == tripBillDateList || tripBillDateList.size() <= 0) continue;
            for (int i = 0; i < tripBillDateList.size(); ++i) {
                if (!billIds.contains(((AtsTripBillEntryInfo)tripBillDateList.get(i)).getId().toString())) {
                    tripBillList.add(tripBillDateList.get(i));
                }
                billIds.add(((AtsTripBillEntryInfo)tripBillDateList.get(i)).getId().toString());
            }
        }
        BigDecimal standardHour = (BigDecimal)scheduleResultMap.get(STANDARDHOUR);
        List shiftTimeList = (List)scheduleResultMap.get(SHIFTTIMELIST);
        Timestamp[] onOffScheduleTime = AtsCalFunctionUtil.getOnOffScheduleTime(shiftTimeList);
        BigDecimal tripBillHoursres = BigDecimal.valueOf(0L);
        if (null != shiftTimeList && shiftTimeList.size() > 0 && tripBillList != null && tripBillList.size() > 0) {
            AtsTripBillEntryInfo tripEntry = null;
            int listSize = tripBillList.size();
            for (int i = 0; i < listSize; ++i) {
                double mixedValue = 0.0;
                tripEntry = (AtsTripBillEntryInfo)tripBillList.get(i);
                Timestamp beginTime = tripEntry.getRealTripStartTime();
                Timestamp endTime = tripEntry.getRealTripEndTime();
                if (beginTime.getTime() <= onOffScheduleTime[0].getTime() && endTime.getTime() >= onOffScheduleTime[1].getTime()) {
                    mixedValue = standardHour.doubleValue();
                    tripBillHoursres = standardHour;
                    break;
                }
                for (int j = 0; j < shiftTimeList.size(); ++j) {
                    double intersectTime = AtsCalFunctionUtil.getIntersectTimeMinusRestTime((ShiftTimeVO)shiftTimeList.get(j), beginTime, endTime);
                    if (!(intersectTime > 0.0)) continue;
                    mixedValue += AtsDateUtils.divide(intersectTime, 60.0, decimalPlaces);
                }
                tripBillHoursres = tripBillHoursres.add(BigDecimal.valueOf(mixedValue));
            }
        }
        tripBillHoursres = DecimalPlaceUtil.decimalPlaceCtrl(ctx, tripBillHoursres, decimalPlaces);
        BigDecimal tripBillDays = BigDecimal.valueOf(0L);
        BigDecimal tripBillHours = BigDecimal.valueOf(0L);
        if (standardHour.doubleValue() != 0.0) {
            tripBillDays = AtsDateUtils.divide(tripBillHoursres, standardHour, decimalPlaces);
            tripBillHours = tripBillHoursres;
        }
        resMap.put(TRIPBILLDAYS, tripBillDays);
        resMap.put(TRIPBILLHOURS, tripBillHours);
        return resMap;
    }

    public static Map<String, Object> getScheduleShiftDetail(Map paramMap) {
        HashMap<String, Object> scheduleMap = new HashMap<String, Object>();
        BigDecimal standardHour = BigDecimal.valueOf(8L);
        AtsShiftInfo shiftInfo = AtsCalFunctionUtil.getAtsShiftInfo(paramMap);
        if (null != shiftInfo && null != shiftInfo.getStandardHour()) {
            standardHour = shiftInfo.getStandardHour();
        }
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String date = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        String oneOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "1,1");
        String oneOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "1,2");
        String twoOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "2,1");
        String twoOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "2,2");
        String threeOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "3,1");
        String threeOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "3,2");
        String oneOnePreRestTime = FetchCardUtil.getShiftRestTime(shiftInfo, date, "1,1");
        String oneOneNextRestTime = FetchCardUtil.getShiftRestTime(shiftInfo, date, "1,2");
        ArrayList<ShiftTimeVO> shiftTimeList = new ArrayList<ShiftTimeVO>();
        int itemSize = 0;
        if (null != shiftInfo && shiftInfo.getItems() != null) {
            AtsShiftItemCollection shiftItems = shiftInfo.getItems();
            itemSize = shiftInfo.getItems().size();
            AtsShiftItemInfo itemInfo = null;
            ShiftTimeVO shiftTime = null;
            for (int i = 0; i < itemSize; ++i) {
                shiftTime = new ShiftTimeVO();
                itemInfo = shiftItems.get(i);
                if (StringUtils.isNotBlank((String)oneOnePreRestTime) && StringUtils.isNotBlank((String)oneOneNextRestTime)) {
                    shiftTime.setBeginRestTime(AtsDateUtils.stringToTimestamp(oneOnePreRestTime));
                    shiftTime.setEndRestTime(AtsDateUtils.stringToTimestamp(oneOneNextRestTime));
                }
                if (null != itemInfo.getSegmentInRest()) {
                    shiftTime.setSegmentInRest(itemInfo.getSegmentInRest());
                }
                if (i == 0) {
                    shiftTime.setBeginTime(AtsDateUtils.stringToTimestamp(oneOnTimeSchedule));
                    shiftTime.setEndTime(AtsDateUtils.stringToTimestamp(oneOffTimeSchedule));
                } else if (i == 1) {
                    shiftTime.setBeginTime(AtsDateUtils.stringToTimestamp(twoOnTimeSchedule));
                    shiftTime.setEndTime(AtsDateUtils.stringToTimestamp(twoOffTimeSchedule));
                } else if (i == 2) {
                    shiftTime.setBeginTime(AtsDateUtils.stringToTimestamp(threeOnTimeSchedule));
                    shiftTime.setEndTime(AtsDateUtils.stringToTimestamp(threeOffTimeSchedule));
                }
                shiftTimeList.add(shiftTime);
            }
        }
        scheduleMap.put(STANDARDHOUR, standardHour);
        scheduleMap.put(SHIFTTIMELIST, shiftTimeList);
        return scheduleMap;
    }

    public static AtsShiftInfo getAtsShiftInfo(Map paramMap) {
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String date = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        if (StringUtils.isEmpty((String)personId)) {
            personId = String.valueOf(paramMap.get("personId"));
        }
        if (StringUtils.isEmpty((String)date)) {
            date = String.valueOf(paramMap.get("attenceDate"));
        }
        String key = personId + "_" + date;
        return AtsCalFunctionUtil.getAtsShiftInfo(paramMap, key);
    }

    public static AtsShiftInfo getAtsShiftInfo(Map paramMap, String key) {
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        if (null == globalMap) {
            globalMap = (Map)paramMap.get("globalMap");
        }
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        Map atsShiftInfoMap = (Map)globalMap.get("T_HR_ATS_Shift");
        Map shiftMap = (Map)globalMap.get("T_HR_ATS_ScheduleShift");
        List scheduleShiftInfoList = (List)shiftMap.get(key);
        ScheduleShiftInfo sheduleshiftinfo = null;
        if (scheduleShiftInfoList != null && scheduleShiftInfoList.size() > 0) {
            sheduleshiftinfo = (ScheduleShiftInfo)scheduleShiftInfoList.get(0);
        }
        return FetchCardUtil.shiftInfoGet(key, sheduleshiftinfo, attendanceFileInfoMap, atsShiftInfoMap);
    }

    public static Timestamp[] getOnOffScheduleTime(List<ShiftTimeVO> shiftTimeList) {
        Timestamp onScheduleTime = null;
        Timestamp offScheduleTime = null;
        if (null != shiftTimeList && shiftTimeList.size() > 0) {
            for (int i = 0; i < shiftTimeList.size(); ++i) {
                ShiftTimeVO shiftTimeVO = shiftTimeList.get(i);
                if (onScheduleTime == null) {
                    onScheduleTime = shiftTimeVO.getBeginTime();
                }
                if (shiftTimeVO.getBeginTime().compareTo(onScheduleTime) < 0) {
                    onScheduleTime = shiftTimeVO.getBeginTime();
                }
                if (offScheduleTime == null) {
                    offScheduleTime = shiftTimeVO.getEndTime();
                }
                if (shiftTimeVO.getEndTime().compareTo(offScheduleTime) <= 0) continue;
                offScheduleTime = shiftTimeVO.getEndTime();
            }
        }
        return new Timestamp[]{onScheduleTime, offScheduleTime};
    }

    public static double getAtsShiftDayType(String currDateStr, Map globalMap, String key) {
        List shiftList;
        double dayType = -1.0;
        boolean hasShift = false;
        Map scheduleShiftItemMap = (Map)globalMap.get("T_HR_ATS_ScheduleShift");
        if (null != scheduleShiftItemMap && null != scheduleShiftItemMap.get(key) && (shiftList = (List)scheduleShiftItemMap.get(key)).size() > 0 && shiftList.get(0) != null && ((ScheduleShiftInfo)shiftList.get(0)).getDayType() != null) {
            dayType = ((ScheduleShiftInfo)shiftList.get(0)).getDayType().getValue();
            hasShift = true;
        }
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        AttendanceFileInfo attendanceFileInfo = null;
        if (null != attendanceFileInfoMap) {
            attendanceFileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(key);
        }
        if (!hasShift && null != attendanceFileInfo && attendanceFileInfo.getIsAttendance().getValue() == "0") {
            Map attendancePolicyInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
            AttencePolicyInfo policy = (AttencePolicyInfo)attendancePolicyInfoMap.get(attendanceFileInfo.getAttencePolicy().getId().toString());
            String workCalendarId = policy != null && policy.getWorkCalendar() != null && policy.getWorkCalendar().getId() != null ? policy.getWorkCalendar().getId().toString() : "";
            Map workCalendarItemInfoMap = (Map)globalMap.get("workItemMap");
            if (workCalendarItemInfoMap != null && workCalendarItemInfoMap.size() > 0 && !StringUtils.isEmpty((String)workCalendarId)) {
                WorkCalendarItemInfo workCalendarItemInfo = (WorkCalendarItemInfo)workCalendarItemInfoMap.get(workCalendarId + "_" + currDateStr);
                dayType = workCalendarItemInfo.getDayType().getValue();
            }
        }
        return dayType;
    }

    public static double getIntersectTimeForTrip(Context ctx, Map paramMap) throws EASBizException, BOSException {
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String attendDate = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        String key = personId + "_" + attendDate;
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        Double intersectTime = 0.0;
        if (null != globalMap) {
            try {
                String[] shiftTime = FetchCardUtil.getOnOffShiftSegTime(globalMap, personId, attendDate);
                List<AtsTripBillEntryInfo> tripBillEntryList = AtsCalFunctionUtil.getEffectiveTripEntry(paramMap, shiftTime);
                Map calResultInfoMap = (Map)globalMap.get("calResultInfoMap");
                if (null != tripBillEntryList && tripBillEntryList.size() > 0 && calResultInfoMap != null) {
                    Date S6DT = null;
                    Date S5DT = null;
                    Date S4DT = null;
                    Date S3DT = null;
                    Date S2DT = null;
                    Date S1DT = null;
                    String resultInfoKey = MessageFormat.format("{0}{1}{2}", personId, "_", attendDate);
                    Map resultInfo = (Map)calResultInfoMap.get(resultInfoKey);
                    if (null != resultInfo) {
                        String S6 = resultInfo.get("S6") != null ? resultInfo.get("S6").toString() : "";
                        String S5 = resultInfo.get("S5") != null ? resultInfo.get("S5").toString() : "";
                        String S4 = resultInfo.get("S4") != null ? resultInfo.get("S4").toString() : "";
                        String S3 = resultInfo.get("S3") != null ? resultInfo.get("S3").toString() : "";
                        String S2 = resultInfo.get("S2") != null ? resultInfo.get("S2").toString() : "";
                        String S1 = resultInfo.get("S1") != null ? resultInfo.get("S1").toString() : "";
                        S6 = S6.contains(".0") ? S6.substring(0, S6.indexOf(".0")) : S6;
                        S5 = S5.contains(".0") ? S5.substring(0, S5.indexOf(".0")) : S5;
                        S4 = S4.contains(".0") ? S4.substring(0, S4.indexOf(".0")) : S4;
                        S3 = S3.contains(".0") ? S3.substring(0, S3.indexOf(".0")) : S3;
                        S2 = S2.contains(".0") ? S2.substring(0, S2.indexOf(".0")) : S2;
                        S1 = S1.contains(".0") ? S1.substring(0, S1.indexOf(".0")) : S1;
                        S6DT = StringUtils.isEmpty((String)S6) ? S6DT : AtsDateUtils.stringToLongDate(S6);
                        S5DT = StringUtils.isEmpty((String)S5) ? S5DT : AtsDateUtils.stringToLongDate(S5);
                        S4DT = StringUtils.isEmpty((String)S4) ? S4DT : AtsDateUtils.stringToLongDate(S4);
                        S3DT = StringUtils.isEmpty((String)S3) ? S3DT : AtsDateUtils.stringToLongDate(S3);
                        S2DT = StringUtils.isEmpty((String)S2) ? S2DT : AtsDateUtils.stringToLongDate(S2);
                        S1DT = StringUtils.isEmpty((String)S1) ? S1DT : AtsDateUtils.stringToLongDate(S1);
                    }
                    Timestamp startTime = null;
                    Timestamp endTime = null;
                    AtsTripBillEntryInfo tripBillEntryInfo = null;
                    Timestamp[] oneShiftRestTime = FetchCardUtil.getOneShiftRestTime(globalMap, personId, attendDate);
                    Timestamp[] twoShiftRestTime = null;
                    Timestamp[] threeShiftRestTime = null;
                    Timestamp[] onOffShiftTime = new Timestamp[]{AtsDateUtils.stringToTimestamp(shiftTime[0]), AtsDateUtils.stringToTimestamp(shiftTime[1])};
                    if (shiftTime.length > 4 && !StringUtils.isEmpty((String)shiftTime[5])) {
                        twoShiftRestTime = new Timestamp[]{AtsDateUtils.stringToTimestamp(shiftTime[1]), AtsDateUtils.stringToTimestamp(shiftTime[2])};
                        threeShiftRestTime = new Timestamp[]{AtsDateUtils.stringToTimestamp(shiftTime[3]), AtsDateUtils.stringToTimestamp(shiftTime[4])};
                        onOffShiftTime = new Timestamp[]{AtsDateUtils.stringToTimestamp(shiftTime[0]), AtsDateUtils.stringToTimestamp(shiftTime[5])};
                    } else if (shiftTime.length > 2 && !StringUtils.isEmpty((String)shiftTime[3])) {
                        twoShiftRestTime = new Timestamp[]{AtsDateUtils.stringToTimestamp(shiftTime[1]), AtsDateUtils.stringToTimestamp(shiftTime[2])};
                        onOffShiftTime = new Timestamp[]{AtsDateUtils.stringToTimestamp(shiftTime[0]), AtsDateUtils.stringToTimestamp(shiftTime[3])};
                    }
                    if (null != tripBillEntryList) {
                        ArrayList<DateInterVal> dateInterValList = new ArrayList<DateInterVal>();
                        int size = tripBillEntryList.size();
                        for (int i = 0; i < size; ++i) {
                            tripBillEntryInfo = tripBillEntryList.get(i);
                            if (tripBillEntryInfo.isIsAllDay()) {
                                startTime = onOffShiftTime[0];
                                endTime = onOffShiftTime[1];
                            } else {
                                startTime = tripBillEntryInfo.getRealTripStartTime();
                                endTime = tripBillEntryInfo.getRealTripEndTime();
                            }
                            if (startTime == null || endTime == null) continue;
                            dateInterValList.add(new DateInterVal(startTime, endTime));
                        }
                        List<DateInterVal> resultList = AtsCalculateTimeUtil.calDateAndSet(dateInterValList);
                        int size2 = tripBillEntryList.size();
                        for (int i = 0; i < size2; ++i) {
                            intersectTime = intersectTime + AtsCalFunctionUtil.getIntersectTime(startTime, endTime, S1DT, S2DT, oneShiftRestTime);
                            intersectTime = intersectTime + AtsCalFunctionUtil.getIntersectTime(startTime, endTime, S3DT, S4DT, twoShiftRestTime);
                            intersectTime = intersectTime + AtsCalFunctionUtil.getIntersectTime(startTime, endTime, S5DT, S6DT, threeShiftRestTime);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return intersectTime;
    }

    private static List<AtsTripBillEntryInfo> getEffectiveTripEntry(Map paramMap, String[] shiftTime) {
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String attendDate = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        String key = personId + "_" + attendDate;
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        Map tripBillEntryMap = (Map)globalMap.get("T_HR_ATS_TripBillEntry");
        ArrayList<AtsTripBillEntryInfo> tripBillEntryList = new ArrayList<AtsTripBillEntryInfo>();
        Timestamp[] shiftTimestamp = new Timestamp[]{AtsDateUtils.stringToTimestamp(shiftTime[0]), AtsDateUtils.stringToTimestamp(shiftTime[0])};
        if (null != tripBillEntryMap) {
            Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
            AttendanceFileInfo attendanceFileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(personId + "_" + attendDate);
            AbstractAttencePolicyInfo attencePolicyInfo = null;
            if (null != attendanceFileInfo && null != attendanceFileInfo.getAttencePolicy()) {
                Map attencePolicyMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
                attencePolicyInfo = (AttencePolicyInfo)attencePolicyMap.get(attendanceFileInfo.getAttencePolicy().getId().toString());
            }
            Timestamp[] headTailOutTime = null;
            if (null != attencePolicyInfo && attencePolicyInfo.isIsCalOutShift()) {
                headTailOutTime = FetchCardUtil.getHeadAndTailOutShiftTime(paramMap);
            }
            String preDay = AtsDateUtils.getPreDay(attendDate);
            String nextDay = AtsDateUtils.getNextDay(attendDate);
            String[] dateStr = new String[]{preDay, attendDate, nextDay};
            HashSet<String> billIds = new HashSet<String>();
            for (String date : dateStr) {
                List tripBillDateList = (List)tripBillEntryMap.get(personId + "_" + date);
                if (null == tripBillDateList || tripBillDateList.size() <= 0) continue;
                for (int i = 0; i < tripBillDateList.size(); ++i) {
                    if (!billIds.contains(((AtsTripBillEntryInfo)tripBillDateList.get(i)).getId().toString())) {
                        if (null != attencePolicyInfo && attencePolicyInfo.isIsCalOutShift() ? null != headTailOutTime && (((AtsTripBillEntryInfo)tripBillDateList.get(i)).getRealTripStartTime().getTime() > headTailOutTime[1].getTime() || ((AtsTripBillEntryInfo)tripBillDateList.get(i)).getRealTripEndTime().getTime() < headTailOutTime[0].getTime()) : null != headTailOutTime && (((AtsTripBillEntryInfo)tripBillDateList.get(i)).getRealTripStartTime().getTime() > shiftTimestamp[1].getTime() || ((AtsTripBillEntryInfo)tripBillDateList.get(i)).getRealTripEndTime().getTime() < shiftTimestamp[0].getTime())) continue;
                        tripBillEntryList.add((AtsTripBillEntryInfo)tripBillDateList.get(i));
                    }
                    billIds.add(((AtsTripBillEntryInfo)tripBillDateList.get(i)).getId().toString());
                }
            }
        }
        return tripBillEntryList;
    }

    public static Double getShiftDaysCount(int ctType, String beginDate, String endDate, String personId, Map<String, List<ScheduleShiftInfo>> shiftItemMap) throws ParseException {
        Double countResult = new Double(0.0);
        long oneDayTime = 86400000L;
        HashSet<String> timeOriginalSets = new HashSet<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date beginTime = sdf.parse(beginDate);
        Date endTime = sdf.parse(endDate);
        while (beginTime.getTime() <= endTime.getTime()) {
            timeOriginalSets.add(sdf.format(beginTime));
            beginTime.setTime(beginTime.getTime() + oneDayTime);
        }
        for (String dateStr : timeOriginalSets) {
            String shiftKey = personId + "_" + dateStr;
            List<ScheduleShiftInfo> scheduleInfoList = shiftItemMap.get(shiftKey);
            if (scheduleInfoList == null || scheduleInfoList.size() <= 0) continue;
            ScheduleShiftInfo info = scheduleInfoList.get(0);
            if (info.getDayType() == null) {
                if (ctType != 3) continue;
                countResult = countResult + 1.0;
                continue;
            }
            switch (ctType) {
                case 0: {
                    if (0 != info.getDayType().getValue()) break;
                    countResult = countResult + 1.0;
                    break;
                }
                case 1: {
                    if (1 != info.getDayType().getValue()) break;
                    countResult = countResult + 1.0;
                    break;
                }
                case 2: {
                    if (2 != info.getDayType().getValue()) break;
                    countResult = countResult + 1.0;
                    break;
                }
                case 3: {
                    countResult = countResult + 1.0;
                }
            }
        }
        return countResult;
    }

    public static double getAttendanceTimeBySpecifiedDate(Context ctx, String beginTimeStr, String endTimeStr, double isSubtractRestTime, double isSubtractLeaveTime, double isSubtractTripTime, Map paramMap) throws EASBizException, BOSException {
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FPROPOSERID);
        String attendDate = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE);
        String key = personId + "_" + attendDate;
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        Double intersectTime = 0.0;
        if (null != globalMap) {
            try {
                Map calResultInfoMap = (Map)globalMap.get("calResultInfoMap");
                String resultInfoKey = MessageFormat.format("{0}{1}{2}", personId, "_", attendDate);
                if (calResultInfoMap != null) {
                    String[] shiftTime = new String[2];
                    Timestamp[] oneShiftRestTime = null;
                    AtsShiftVO atsShiftVO = (AtsShiftVO)globalMap.get("realShiftOnOffTime");
                    if (atsShiftVO != null) {
                        shiftTime[0] = AtsDateUtils.dateLongToString(atsShiftVO.getRealOnTime());
                        shiftTime[1] = AtsDateUtils.dateLongToString(atsShiftVO.getRealOffTime());
                        if (null != atsShiftVO.getRealOnRestTime() && null != atsShiftVO.getRealOffRestTime()) {
                            oneShiftRestTime = new Timestamp[]{atsShiftVO.getRealOnRestTime(), atsShiftVO.getRealOffRestTime()};
                        }
                    } else {
                        shiftTime = FetchCardUtil.getOnOffShiftSegTime(globalMap, personId, attendDate);
                        oneShiftRestTime = FetchCardUtil.getOneShiftRestTime(globalMap, personId, attendDate);
                    }
                    Map resultInfo = (Map)calResultInfoMap.get(resultInfoKey);
                    Date S6DT = AtsCalFunctionUtil.getResultCardDate(resultInfo, "S6");
                    Date S5DT = AtsCalFunctionUtil.getResultCardDate(resultInfo, "S5");
                    Date S4DT = AtsCalFunctionUtil.getResultCardDate(resultInfo, "S4");
                    Date S3DT = AtsCalFunctionUtil.getResultCardDate(resultInfo, "S3");
                    Date S2DT = AtsCalFunctionUtil.getResultCardDate(resultInfo, "S2");
                    Date S1DT = AtsCalFunctionUtil.getResultCardDate(resultInfo, "S1");
                    List<AtsDateVO> paramDateList = AtsCalFunctionUtil.getParamDateList(beginTimeStr, endTimeStr, attendDate);
                    ArrayList<AtsDateVO> dateList = new ArrayList<AtsDateVO>();
                    Double reduceTime = AtsCalFunctionUtil.getInersectTimeByShiftAndResult(paramMap, paramDateList, shiftTime, oneShiftRestTime, S6DT, S5DT, S4DT, S3DT, S2DT, S1DT, dateList);
                    List<AtsDateVO> reduceList = new ArrayList<AtsDateVO>();
                    if (isSubtractLeaveTime == 0.0) {
                        AtsCalFunctionUtil.getReduceListByLeaveBill(key, globalMap, reduceList);
                    }
                    if (isSubtractTripTime == 0.0) {
                        AtsCalFunctionUtil.getReduceListByTripBill(paramMap, shiftTime, reduceList);
                    }
                    if (null != oneShiftRestTime && oneShiftRestTime.length == 2 && isSubtractRestTime == 0.0) {
                        reduceList = AtsCalFunctionUtil.calAndSetByDate(AtsDateUtils.timestampToDate(oneShiftRestTime[0]), AtsDateUtils.timestampToDate(oneShiftRestTime[1]), reduceList);
                    }
                    if (null != dateList && dateList.size() > 0) {
                        for (AtsDateVO dateVO : dateList) {
                            Date beginDt = dateVO.getBeginDate();
                            Date endDt = dateVO.getEndDate();
                            intersectTime = intersectTime + AtsDateUtils.getTwoTimeDiffMinutes(beginDt, endDt);
                            for (AtsDateVO reduceDateVO : reduceList) {
                                Date startTime = reduceDateVO.getBeginDate();
                                Date endTime = reduceDateVO.getEndDate();
                                reduceTime = reduceTime + AtsCalFunctionUtil.getIntersectTime(beginDt, endDt, startTime, endTime, null);
                            }
                        }
                        intersectTime = intersectTime - reduceTime;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return intersectTime;
    }

    private static List<AtsDateVO> getParamDateList(String beginTimeStr, String endTimeStr, String attendDate) {
        ArrayList<AtsDateVO> paramDateList = new ArrayList<AtsDateVO>();
        int beginTimePoint = Integer.parseInt(beginTimeStr);
        int endTimePoint = Integer.parseInt(endTimeStr);
        if (beginTimePoint < 10 && beginTimeStr.length() == 1) {
            beginTimeStr = "0" + beginTimeStr;
        }
        if (endTimePoint < 10 && endTimeStr.length() == 1) {
            endTimeStr = "0" + endTimeStr;
        }
        if (beginTimePoint < endTimePoint) {
            AtsDateVO dateVO = new AtsDateVO();
            dateVO.setBeginDate(AtsDateUtils.stringToLongDate(attendDate + " " + beginTimeStr + ":00:00"));
            dateVO.setEndDate(AtsDateUtils.stringToLongDate(attendDate + " " + endTimeStr + ":00:00"));
            paramDateList.add(dateVO);
        } else {
            String preDay = AtsDateUtils.getPreDay(attendDate) + " " + beginTimeStr + ":00:00";
            String currentEndDay = attendDate + " " + endTimeStr + ":00:00";
            String currentStartDay = attendDate + " " + beginTimeStr + ":00:00";
            String nextDay = AtsDateUtils.getNextDay(attendDate) + " " + endTimeStr + ":00:00";
            AtsDateVO dateVO = new AtsDateVO();
            dateVO.setBeginDate(AtsDateUtils.stringToLongDate(preDay));
            dateVO.setEndDate(AtsDateUtils.stringToLongDate(currentEndDay));
            paramDateList.add(dateVO);
            AtsDateVO dateVOs = new AtsDateVO();
            dateVOs.setBeginDate(AtsDateUtils.stringToLongDate(currentStartDay));
            dateVOs.setEndDate(AtsDateUtils.stringToLongDate(nextDay));
            paramDateList.add(dateVOs);
        }
        return paramDateList;
    }

    private static void getReduceListByTripBill(Map paramMap, String[] shiftTime, List<AtsDateVO> reduceList) {
        List<AtsTripBillEntryInfo> tripBillEntryList = AtsCalFunctionUtil.getEffectiveTripEntry(paramMap, shiftTime);
        if (null != tripBillEntryList) {
            for (AtsTripBillEntryInfo tripBillEntryInfo : tripBillEntryList) {
                AtsDateVO dateVO = new AtsDateVO();
                dateVO.setBeginDate(tripBillEntryInfo.getRealTripStartTime());
                dateVO.setEndDate(tripBillEntryInfo.getRealTripEndTime());
                reduceList.add(dateVO);
            }
        }
    }

    private static void getReduceListByLeaveBill(String key, Map globalMap, List<AtsDateVO> reduceList) {
        Map leaveBillEntryMap = (Map)globalMap.get("T_HR_ATS_LeaveBillEntry");
        List leaveBillEntryList = null;
        if (null != leaveBillEntryMap) {
            leaveBillEntryList = (List)leaveBillEntryMap.get(key);
        }
        if (null != leaveBillEntryList) {
            int size = leaveBillEntryList.size();
            for (int i = 0; i < size; ++i) {
                AtsLeaveBillEntryInfo leaveBillEntryInfo = (AtsLeaveBillEntryInfo)leaveBillEntryList.get(i);
                AtsDateVO dateVO = new AtsDateVO();
                dateVO.setBeginDate(leaveBillEntryInfo.getRealBeginTime());
                dateVO.setEndDate(leaveBillEntryInfo.getRealEndTime());
                reduceList.add(dateVO);
            }
        }
    }

    private static Double getInersectTimeByShiftAndResult(Map paramMap, List<AtsDateVO> paramDateList, String[] shiftTime, Timestamp[] oneShiftRestTime, Date S6DT, Date S5DT, Date S4DT, Date S3DT, Date S2DT, Date S1DT, List<AtsDateVO> dateList) {
        Map<String, Object> scheduleResultMap = AtsCalFunctionUtil.getScheduleShiftDetail(paramMap);
        BigDecimal oneSegmentInRest = BigDecimal.ZERO;
        BigDecimal twoSegmentInRest = BigDecimal.ZERO;
        BigDecimal threeSegmentInRest = BigDecimal.ZERO;
        List shiftTimeList = (List)scheduleResultMap.get(SHIFTTIMELIST);
        if (null != shiftTimeList && shiftTimeList.size() > 0) {
            for (int i = 0; i < shiftTimeList.size(); ++i) {
                if (i == 0) {
                    if (((ShiftTimeVO)shiftTimeList.get(i)).getBeginRestTime() != null || ((ShiftTimeVO)shiftTimeList.get(i)).getEndRestTime() != null) continue;
                    oneSegmentInRest = ((ShiftTimeVO)shiftTimeList.get(i)).getSegmentInRest();
                    continue;
                }
                if (i == 1) {
                    twoSegmentInRest = ((ShiftTimeVO)shiftTimeList.get(i)).getSegmentInRest();
                    continue;
                }
                if (i != 2) continue;
                threeSegmentInRest = ((ShiftTimeVO)shiftTimeList.get(i)).getSegmentInRest();
            }
        }
        Double reduceTime = 0.0;
        for (AtsDateVO paramDate : paramDateList) {
            for (int index = 0; index < shiftTime.length; ++index) {
                AtsDateVO dateVO;
                Date shiftEndTime;
                if (StringUtils.isEmpty((String)shiftTime[index])) continue;
                Date shiftBeginTime = AtsDateUtils.stringToLongDate(shiftTime[index]);
                Date[] intersectRestDt = AtsCalFunctionUtil.getIntersectTime(shiftBeginTime, shiftEndTime = AtsDateUtils.stringToLongDate(shiftTime[++index]), S1DT, S2DT, paramDate.getBeginDate(), paramDate.getEndDate());
                if (null != intersectRestDt) {
                    dateVO = new AtsDateVO();
                    dateVO.setBeginDate(intersectRestDt[0]);
                    dateVO.setEndDate(intersectRestDt[1]);
                    dateList.add(dateVO);
                    if (shiftTime.length == 2) {
                        if (oneShiftRestTime == null && oneSegmentInRest != null) {
                            reduceTime = reduceTime + oneSegmentInRest.doubleValue();
                        }
                    } else if (oneSegmentInRest != null) {
                        reduceTime = reduceTime + oneSegmentInRest.doubleValue();
                    }
                }
                if (null != (intersectRestDt = AtsCalFunctionUtil.getIntersectTime(shiftBeginTime, shiftEndTime, S3DT, S4DT, paramDate.getBeginDate(), paramDate.getEndDate()))) {
                    dateVO = new AtsDateVO();
                    dateVO.setBeginDate(intersectRestDt[0]);
                    dateVO.setEndDate(intersectRestDt[1]);
                    dateList.add(dateVO);
                    if (twoSegmentInRest != null) {
                        reduceTime = reduceTime + twoSegmentInRest.doubleValue();
                    }
                }
                if (null == (intersectRestDt = AtsCalFunctionUtil.getIntersectTime(shiftBeginTime, shiftEndTime, S5DT, S6DT, paramDate.getBeginDate(), paramDate.getEndDate()))) continue;
                dateVO = new AtsDateVO();
                dateVO.setBeginDate(intersectRestDt[0]);
                dateVO.setEndDate(intersectRestDt[1]);
                dateList.add(dateVO);
                if (threeSegmentInRest == null) continue;
                reduceTime = reduceTime + threeSegmentInRest.doubleValue();
            }
        }
        return reduceTime;
    }

    public static List<AtsDateVO> calAndSetByDate(Date startTime, Date endTime, List<AtsDateVO> atsDateVOs) {
        if (endTime == null || startTime == null || endTime.getTime() <= startTime.getTime()) {
            return atsDateVOs;
        }
        if (atsDateVOs == null) {
            atsDateVOs = new ArrayList<AtsDateVO>();
        }
        if (atsDateVOs.size() == 0) {
            AtsDateVO dateInterVal = new AtsDateVO();
            dateInterVal.setBeginDate(startTime);
            dateInterVal.setEndDate(endTime);
            atsDateVOs.add(dateInterVal);
            return atsDateVOs;
        }
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        AtsDateVO dateVONew = new AtsDateVO();
        ArrayList<AtsDateVO> dateVOsNew = new ArrayList<AtsDateVO>();
        for (int index = 0; index < atsDateVOs.size(); ++index) {
            AtsDateVO dateVO = atsDateVOs.get(index);
            if (endTime.getTime() < dateVO.getBeginDate().getTime() || startTime.getTime() > dateVO.getEndDate().getTime()) {
                dateVOsNew.add(dateVO);
                continue;
            }
            indexs.add(index);
            AtsCalFunctionUtil.andSet(dateVO, startTime, endTime);
            if (dateVONew.getBeginDate() == null || dateVONew.getEndDate() == null) {
                dateVONew.setBeginDate(dateVO.getBeginDate());
                dateVONew.setEndDate(dateVO.getEndDate());
                continue;
            }
            AtsCalFunctionUtil.andSet(dateVONew, dateVO.getBeginDate(), dateVO.getEndDate());
        }
        if (indexs.size() > 0) {
            dateVOsNew.add(dateVONew);
        } else {
            AtsDateVO date = new AtsDateVO();
            date.setBeginDate(startTime);
            date.setEndDate(endTime);
            dateVOsNew.add(date);
        }
        return dateVOsNew;
    }

    public static void andSet(AtsDateVO dateInterVal, Date startTime, Date endTime) {
        if (dateInterVal.getBeginDate().getTime() >= startTime.getTime()) {
            dateInterVal.setBeginDate(startTime);
        }
        if (dateInterVal.getEndDate().getTime() <= endTime.getTime()) {
            dateInterVal.setEndDate(endTime);
        }
    }

    public static Date getResultCardDate(DataRow dr, String projectNum) {
        if (null != dr) {
            String projectStr = dr.getValue(projectNum) != null ? dr.getValue(projectNum).toString() : "";
            projectStr = projectStr.contains(".0") ? projectStr.substring(0, projectStr.indexOf(".0")) : projectStr;
            Date cardDate = StringUtils.isEmpty((String)projectStr) ? null : AtsDateUtils.stringToLongDate(projectStr);
            return cardDate;
        }
        return null;
    }

    public static Date getResultCardDate(Map<String, Object> resultInfo, String projectNum) {
        if (null != resultInfo) {
            String projectStr = resultInfo.get(projectNum) != null ? resultInfo.get(projectNum).toString() : "";
            projectStr = projectStr.contains(".0") ? projectStr.substring(0, projectStr.indexOf(".0")) : projectStr;
            Date cardDate = StringUtils.isEmpty((String)projectStr) ? null : AtsDateUtils.stringToLongDate(projectStr);
            return cardDate;
        }
        return null;
    }

    public static double getProjectValueByTypeAndOffset(Context ctx, Map<String, Object> paramMap, int cycleType, int offset, String projectNum, String beginDate, String endDate) {
        double errorValue = -9.99999999E8;
        int columnNo = AtsCalFunctionUtil.getAtsProjectColumnNo(ctx, projectNum, paramMap);
        if (0 == columnNo) {
            logger.error((Object)"-------getProjectValueByTypeAndOffset error not found columnNo");
            return errorValue;
        }
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        Map attendancePolicyInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
        Map attendancePeriodInfoMap = (Map)globalMap.get("attendancePeriodInfoListMap");
        String personId = (String)paramMap.get(T_HR_ATS_ATTENDANCERESULTSUM_FPROPOSERID);
        String attenceCycleID = "";
        AttendanceFileInfo attenceFile = AtsCalFunctionUtil.getAttendanceFileInfo(attendanceFileInfoMap, personId, beginDate, endDate);
        if (attenceFile != null && attenceFile.getAttencePolicy() != null && attenceFile.getAttencePolicy().getId() != null && attendancePolicyInfoMap != null) {
            AttencePolicyInfo poInfo = (AttencePolicyInfo)attendancePolicyInfoMap.get(attenceFile.getAttencePolicy().getId().toString());
            attenceCycleID = poInfo.getAttenceCycle() == null ? "" : poInfo.getAttenceCycle().getId().toString();
        }
        Date beginDatePram = AtsDateUtils.stringToShortDate(beginDate);
        Date endDatePram = AtsDateUtils.stringToShortDate(endDate);
        String currentPeriodName = null;
        int periodSize = 0;
        int currentIndex = 0;
        try {
            if (attendancePeriodInfoMap != null && StringUtils.isNotBlank((String)attenceCycleID)) {
                List periodInfoList = (List)attendancePeriodInfoMap.get(attenceCycleID);
                periodSize = periodInfoList.size();
                int size = periodSize;
                for (int i = 0; i < size; ++i) {
                    AttendancePeriodInfo periodInfo = (AttendancePeriodInfo)periodInfoList.get(i);
                    Date startDt = ((AttendancePeriodInfo)periodInfoList.get(i)).getStartDate();
                    Date endDt = ((AttendancePeriodInfo)periodInfoList.get(i)).getEndDate();
                    if (beginDatePram.compareTo(startDt) != 0 || endDatePram.compareTo(endDt) != 0) continue;
                    currentPeriodName = periodInfo.getName();
                    currentIndex = i;
                }
                currentPeriodName = currentPeriodName == null ? "" : currentPeriodName;
                String periodBegin = null;
                String periodEnd = null;
                String startDt = null;
                switch (cycleType) {
                    case 0: {
                        if (currentIndex + offset < 0 || currentIndex + offset > periodSize - 1) {
                            return -1.0;
                        }
                        AttendancePeriodInfo periodInfo = (AttendancePeriodInfo)periodInfoList.get(currentIndex + offset);
                        periodBegin = periodInfo.getName();
                        periodEnd = periodInfo.getName();
                        break;
                    }
                    case 1: {
                        String currentYear = currentPeriodName.substring(0, 4);
                        int month = Integer.valueOf(currentPeriodName.substring(4, 6));
                        Date dateStart = beginDatePram;
                        dateStart = AtsCalFunctionUtil.getSeasonDataBegin(currentYear, month);
                        startDt = AtsCalFunctionUtil.getNextMonthStartDate(dateStart, offset * 3);
                        periodBegin = startDt.substring(0, 7).replace("-", "");
                        periodEnd = AtsCalFunctionUtil.getNextMonthStartDate(AtsDateUtils.stringToShortDate(startDt), 2).substring(0, 7).replace("-", "");
                        break;
                    }
                    case 2: {
                        String currentYear = currentPeriodName.substring(0, 4);
                        int month = Integer.valueOf(currentPeriodName.substring(4, 6));
                        Date dateStart = AtsCalFunctionUtil.getHalfYearDataBegin(currentYear, month);
                        startDt = AtsCalFunctionUtil.getNextMonthStartDate(dateStart, offset * 6);
                        periodBegin = startDt.substring(0, 7).replace("-", "");
                        periodEnd = AtsCalFunctionUtil.getNextMonthStartDate(AtsDateUtils.stringToShortDate(startDt), 5).substring(0, 7).replace("-", "");
                        break;
                    }
                    case 3: {
                        String currentYear = currentPeriodName.substring(0, 4);
                        periodBegin = Integer.valueOf(currentYear) + offset + "01";
                        periodEnd = Integer.valueOf(currentYear) + offset + "12";
                        break;
                    }
                }
                return AtsCalFunctionUtil.getSumValue(ctx, columnNo, personId, periodBegin, periodEnd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("-------getProjectValueByTypeAndOffset error periodSize:" + periodSize + ",currentIndex+offset=" + (currentIndex + offset)));
            return errorValue;
        }
        return errorValue;
    }

    private static double getSumValue(Context ctx, int columnNo, String personId, String periodBegin, String periodEnd) throws BOSException, SQLException {
        double sumValue;
        block4: {
            sumValue = 0.0;
            if (StringUtils.isEmpty((String)periodBegin) || StringUtils.isEmpty((String)periodEnd)) break block4;
            if (periodBegin.equals(periodEnd)) {
                StringBuffer sb = new StringBuffer();
                sb.append("SELECT SUM(S").append(columnNo).append(") SNO FROM T_HR_ATS_ATTENDANCERESULTSUM S ");
                sb.append(" INNER JOIN T_HR_ATS_ATTENDANCEPERIOD P ON S.FATTENDANCEPERIODID = P.FID ");
                sb.append(" WHERE FPROPOSERID=? AND P.FNAME" + MLUtile.getMlFlag(ctx) + " = ?  ");
                Object[] params = new Object[]{personId, periodBegin};
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
                while (rs.next()) {
                    sumValue = rs.getBigDecimal("SNO") == null ? 0.0 : rs.getBigDecimal("SNO").doubleValue();
                }
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append("SELECT SUM(S").append(columnNo).append(")  SNO FROM T_HR_ATS_ATTENDANCERESULTSUM S ");
                sb.append(" INNER JOIN T_HR_ATS_ATTENDANCEPERIOD P ON S.FATTENDANCEPERIODID = P.FID ");
                sb.append(" WHERE FPROPOSERID=? AND P.FNAME" + MLUtile.getMlFlag(ctx) + " >= ? AND P.FNAME" + MLUtile.getMlFlag(ctx) + " <= ? ");
                Object[] params = new Object[]{personId, periodBegin, periodEnd};
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
                while (rs.next()) {
                    sumValue = rs.getBigDecimal("SNO") == null ? 0.0 : rs.getBigDecimal("SNO").doubleValue();
                }
            }
        }
        return sumValue;
    }

    private static Date getSeasonDataBegin(String currentYear, int month) {
        Date dateStart = null;
        if (month >= 1 && month <= 3) {
            dateStart = AtsDateUtils.stringToShortDate(currentYear + "-01-01");
        } else if (month >= 4 && month <= 6) {
            dateStart = AtsDateUtils.stringToShortDate(currentYear + "-04-01");
        } else if (month >= 7 && month <= 9) {
            dateStart = AtsDateUtils.stringToShortDate(currentYear + "-07-01");
        } else if (month >= 10 && month <= 12) {
            dateStart = AtsDateUtils.stringToShortDate(currentYear + "-10-01");
        }
        return dateStart;
    }

    private static Date getHalfYearDataBegin(String currentYear, int month) {
        Date dateStart = null;
        if (month >= 1 && month <= 6) {
            dateStart = AtsDateUtils.stringToShortDate(currentYear + "-01-01");
        } else if (month >= 7 && month <= 12) {
            dateStart = AtsDateUtils.stringToShortDate(currentYear + "-07-01");
        }
        return dateStart;
    }

    public static String getNextMonthStartDate(Date date, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, month);
        date = calendar.getTime();
        return AtsDateUtils.dateShortFormatToStr(date);
    }

    public static AttendanceFileInfo getAttendanceFileInfo(Map<String, AttendanceFileInfo> attendanceFileInfoMap, String personId, String beginDate, String endDate) {
        AttendanceFileInfo attenceFile = null;
        if (attendanceFileInfoMap != null) {
            attenceFile = attendanceFileInfoMap.get(personId + "_" + endDate);
            if (attenceFile == null) {
                attenceFile = attendanceFileInfoMap.get(personId + "_" + beginDate);
            }
            if (attenceFile == null) {
                attenceFile = attendanceFileInfoMap.get(personId + "_" + AtsDateUtils.dateShortFormatToStr(new Date()));
            }
            if (attenceFile == null) {
                List<String> datelist = AtsDateUtils.getDateList(beginDate, endDate);
                for (int i = 0; i < datelist.size() && (attenceFile = attendanceFileInfoMap.get(personId + "_" + datelist.get(i))) == null; ++i) {
                }
            }
        }
        return attenceFile;
    }

    public static AttencePolicyInfo getAttencePolicyInfoByResultCal(Map globalMap, String personId, String date) {
        Map fileInfoObject = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        AttendanceFileInfo attenceFile = (AttendanceFileInfo)fileInfoObject.get(personId + "_" + date);
        if (null == attenceFile || null == attenceFile.getAttencePolicy()) {
            return null;
        }
        Map policyInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
        AttencePolicyInfo attencePolicy = (AttencePolicyInfo)policyInfoMap.get(attenceFile.getAttencePolicy().getId().toString());
        return attencePolicy;
    }

    public static AttencePolicyExtInfo getAttencePolicyExtInfoByResultCal(Map globalMap, String personId, String date) {
        AttencePolicyInfo attencePolicy = AtsCalFunctionUtil.getAttencePolicyInfoByResultCal(globalMap, personId, date);
        Map policyExtInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicyExt");
        AttencePolicyExtInfo attencePolicyExtInfo = null;
        if (null != attencePolicy && null != policyExtInfoMap && policyExtInfoMap.size() > 0) {
            attencePolicyExtInfo = (AttencePolicyExtInfo)policyExtInfoMap.get(attencePolicy.getId().toString());
        }
        return attencePolicyExtInfo;
    }

    public static AttendanceDynamicResInfo getAttendanceDynamicResInfo(Map globalMap, String personId, String currDateStr) {
        AttendanceDynamicResInfo dynamicResInfo = new AttendanceDynamicResInfo();
        Map calResultInfoMap = (Map)globalMap.get("calResultInfoMap");
        String resultInfoKey = MessageFormat.format("{0}{1}{2}", personId, "_", currDateStr);
        if (null != calResultInfoMap && null != calResultInfoMap.get(resultInfoKey)) {
            Map resultInfo = (Map)calResultInfoMap.get(resultInfoKey);
            String S6 = resultInfo.get("S6") != null ? resultInfo.get("S6").toString() : "";
            String S5 = resultInfo.get("S5") != null ? resultInfo.get("S5").toString() : "";
            String S4 = resultInfo.get("S4") != null ? resultInfo.get("S4").toString() : "";
            String S3 = resultInfo.get("S3") != null ? resultInfo.get("S3").toString() : "";
            String S2 = resultInfo.get("S2") != null ? resultInfo.get("S2").toString() : "";
            String S1 = resultInfo.get("S1") != null ? resultInfo.get("S1").toString() : "";
            S6 = S6.contains(".0") ? S6.substring(0, S6.indexOf(".0")) : S6;
            S5 = S5.contains(".0") ? S5.substring(0, S5.indexOf(".0")) : S5;
            S4 = S4.contains(".0") ? S4.substring(0, S4.indexOf(".0")) : S4;
            S3 = S3.contains(".0") ? S3.substring(0, S3.indexOf(".0")) : S3;
            S2 = S2.contains(".0") ? S2.substring(0, S2.indexOf(".0")) : S2;
            S1 = S1.contains(".0") ? S1.substring(0, S1.indexOf(".0")) : S1;
            dynamicResInfo.setOneOnTime(S1);
            dynamicResInfo.setOneOffTime(S2);
            dynamicResInfo.setTwoOnTime(S3);
            dynamicResInfo.setTwoOffTime(S4);
            dynamicResInfo.setThreeOnTime(S5);
            dynamicResInfo.setThreeOffTime(S6);
        }
        return dynamicResInfo;
    }

    public static WorkCalendarItemInfo getWorkCalendarItemInfo(Map paramMap, String personId, String attenceDate) {
        Map workItemMap;
        WorkCalendarItemInfo workiteminfo;
        String key = personId + "_" + attenceDate;
        Map globalMap = (Map)paramMap.get(GLOBALMAPKEY);
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        AttendanceFileInfo attendanceFileInfo = (AttendanceFileInfo)attendanceFileInfoMap.get(key);
        Map attendancePolicyInfoMap = (Map)globalMap.get("T_HR_ATS_AttencePolicy");
        AttencePolicyInfo poInfo = (AttencePolicyInfo)attendancePolicyInfoMap.get(attendanceFileInfo.getAttencePolicy().getId().toString());
        WorkCalendarInfo calendarInfo = poInfo.getWorkCalendar();
        if (attendanceFileInfo.getCalendar() != null && attendanceFileInfo.getCalendar().getId() != null) {
            calendarInfo = attendanceFileInfo.getCalendar();
        }
        WorkCalendarItemInfo itemInfo = null;
        if (calendarInfo == null) {
            calendarInfo = (WorkCalendarInfo)paramMap.get("defaultWorkCalInfo");
        }
        if (calendarInfo != null && (workiteminfo = (WorkCalendarItemInfo)(workItemMap = (Map)globalMap.get("workItemMap")).get(calendarInfo.getId().toString() + "_" + attenceDate)) != null) {
            itemInfo = (WorkCalendarItemInfo)workiteminfo.clone();
        }
        return itemInfo;
    }
}

