/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.ChangeTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitChangeType;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitDetailCollection;
import com.kingdee.eas.hr.ats.HolidayLimitDetailFactory;
import com.kingdee.eas.hr.ats.HolidayLimitDetailInfo;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.IHolidayLimit;
import com.kingdee.eas.hr.ats.IHolidayLimitDetail;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.app.HolidayLimitDetailControllerBean;
import com.kingdee.eas.hr.ats.dataLog.control.LogControlCenter;
import com.kingdee.eas.hr.ats.dataLog.factory.DataLogControlFactory;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogUtil;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.IDecimalPlaceStrategy;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationSystem;
import com.kingdee.eas.hr.ats.holidayLimit.AbstractBaseRockBackLimit;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.AtsLockUtil;
import com.kingdee.eas.hr.ats.lightapp.util.AtsLeaveBillLimit;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CoreBaseRockBackLimit
extends AbstractBaseRockBackLimit {
    private static final Logger logger1 = Logger.getLogger(CoreBaseRockBackLimit.class);
    private int changeType;
    private IDecimalPlaceStrategy decimalPlacesSystem = new DecimalPlaceOperationSystem();

    public CoreBaseRockBackLimit(Context ctx, String billId, int changeType) throws EASBizException, BOSException {
        super(ctx, billId);
        this.setChangeType(changeType);
        if (null == this.decimalPlacesSystem) {
            this.decimalPlacesSystem = new DecimalPlaceOperationSystem();
        }
    }

    public CoreBaseRockBackLimit(Context ctx, AtsLeaveBillInfo leaveBillInfo, int changeType) throws EASBizException, BOSException {
        super(ctx, leaveBillInfo);
        this.setChangeType(changeType);
        if (null == this.decimalPlacesSystem) {
            this.decimalPlacesSystem = new DecimalPlaceOperationSystem();
        }
    }

    public int getChangeType() {
        return this.changeType;
    }

    public void setChangeType(int changeType) {
        this.changeType = changeType;
    }

    @Override
    public void baseRockBackLimit(final Context ctx, final AtsLeaveBillInfo atsLeaveBillInfo) throws BOSException, EASBizException {
        final String billId = atsLeaveBillInfo.getId().toString();
        AtsLockUtil.executeWithNotBlock(ctx, billId, new Runnable(){

            @Override
            public void run() {
                try {
                    HolidayLimitDetailCollection holidayLimitDetailCol = CoreBaseRockBackLimit.this.getHolidayLimitDetailCollectionByBillId(ctx, atsLeaveBillInfo.getId().toString(), CoreBaseRockBackLimit.this.getChangeType());
                    Map<String, List<HolidayLimitDetailInfo>> holidayLimitDetailMap = CoreBaseRockBackLimit.this.getHolidaylimitDetailMap(holidayLimitDetailCol);
                    Map<String, HolidayLimitInfo> holidayLimitMap = CoreBaseRockBackLimit.this.getHolidaylimitInfoMap(ctx, holidayLimitDetailCol);
                    AtsLeaveBillEntryCollection atsLeaveBillEntryCollection = atsLeaveBillInfo.getEntries();
                    int size = atsLeaveBillEntryCollection.size();
                    IHolidayLimit iHolidayLimit = HolidayLimitFactory.getLocalInstance(ctx);
                    IHolidayLimitDetail iHolidayLimitDetail = HolidayLimitDetailFactory.getLocalInstance(ctx);
                    LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.holidayLimit);
                    CoreBaseCollection oldLimitColl = null;
                    if (!holidayLimitDetailCol.isEmpty() && holidayLimitDetailCol.size() > 0) {
                        for (int i = 0; i < size; ++i) {
                            AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = atsLeaveBillEntryCollection.get(i);
                            String personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
                            String leaveBillEntryId = atsLeaveBillEntryInfo.getId().toString();
                            String policyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
                            HolidayPolicyInfo holidayPolicyInfo = AtsServerUtils.getHolidayPolicyInfoById(ctx, policyId);
                            List<HolidayLimitDetailInfo> limitDetailList = holidayLimitDetailMap.get(leaveBillEntryId);
                            CoreBaseCollection limitCol = new CoreBaseCollection();
                            HashSet<String> holidayLimitDetailSet = new HashSet<String>();
                            HashSet<String> holidayLimitInfoSet = new HashSet<String>();
                            if (limitDetailList != null && !limitDetailList.isEmpty()) {
                                oldLimitColl = CoreBaseRockBackLimit.this.RockBackDeductLimit(ctx, limitDetailList, holidayLimitMap, limitCol, holidayLimitInfoSet, holidayLimitDetailSet, CoreBaseRockBackLimit.this.changeType);
                            }
                            if (!limitCol.isEmpty()) {
                                limitCol.sort("cyclebegindate");
                                limitCol.sort("delaydate");
                                CoreBaseRockBackLimit.this.RockBackOverDraftLimit(ctx, limitCol, holidayLimitInfoSet, holidayPolicyInfo, personId, billId, leaveBillEntryId, CoreBaseRockBackLimit.this.changeType, atsLeaveBillInfo.getHrOrgUnit().getId().toString());
                            }
                            if (!limitCol.isEmpty()) {
                                AtsLeaveBillLimit limit = new AtsLeaveBillLimit();
                                limit.recordHolidayLimit(ctx, limitCol, ChangeTypeEnum.billUpdate, atsLeaveBillInfo.getNumber());
                                iHolidayLimit.update(limitCol);
                                DataLogUtil.addLogObserverToCenter(ctx, atsLeaveBillInfo, atsLeaveBillEntryInfo, logControlCenter, oldLimitColl, false);
                                DataLogUtil.addLogObserverToCenter(ctx, atsLeaveBillInfo, atsLeaveBillEntryInfo, logControlCenter, limitCol, true);
                            }
                            if (holidayLimitDetailSet.isEmpty()) continue;
                            String hql = "where id in (" + AtsUtil.convertSetToString(holidayLimitDetailSet) + ")";
                            iHolidayLimitDetail.delete(hql);
                        }
                    }
                }
                catch (Exception e) {
                    logger1.error((Object)"catch a exception", (Throwable)e);
                    throw new RuntimeException(e.getMessage());
                }
            }
        });
    }

    public void baseRockBackLimit(Context ctx, AtsLeaveBillEntryInfo atsLeaveBillEntryInfos, String hrOrgUnit) throws BOSException, EASBizException {
        HolidayLimitDetailCollection holidayLimitDetailCol = this.getHolidayLimitDetailCollectionByBillNewId(ctx, atsLeaveBillEntryInfos.getId().toString(), this.getChangeType());
        Map<String, List<HolidayLimitDetailInfo>> holidayLimitDetailMap = this.getHolidaylimitDetailMap(holidayLimitDetailCol);
        Map<String, HolidayLimitInfo> holidayLimitMap = this.getHolidaylimitInfoMap(ctx, holidayLimitDetailCol);
        AtsLeaveBillEntryCollection atsLeaveBillEntryCollection = new AtsLeaveBillEntryCollection();
        atsLeaveBillEntryCollection.add(atsLeaveBillEntryInfos);
        int size = atsLeaveBillEntryCollection.size();
        String billEntryId = atsLeaveBillEntryInfos.getId().toString();
        IHolidayLimit iHolidayLimit = HolidayLimitFactory.getLocalInstance(ctx);
        IHolidayLimitDetail iHolidayLimitDetail = HolidayLimitDetailFactory.getLocalInstance(ctx);
        LogControlCenter logControlCenter = DataLogControlFactory.getInstance().createLogControlCenter(OperTypeEnum.holidayLimit);
        CoreBaseCollection oldLimitColl = null;
        if (!holidayLimitDetailCol.isEmpty() && holidayLimitDetailCol.size() > 0) {
            for (int i = 0; i < size; ++i) {
                AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = atsLeaveBillEntryCollection.get(i);
                String personId = atsLeaveBillEntryInfo.getPerson().getId().toString();
                String leaveBillEntryId = atsLeaveBillEntryInfo.getId().toString();
                String policyId = atsLeaveBillEntryInfo.getPolicy().getId().toString();
                HolidayPolicyInfo holidayPolicyInfo = AtsServerUtils.getHolidayPolicyInfoById(ctx, policyId);
                List<HolidayLimitDetailInfo> limitDetailList = holidayLimitDetailMap.get(leaveBillEntryId);
                CoreBaseCollection limitCol = new CoreBaseCollection();
                HashSet<String> holidayLimitDetailSet = new HashSet<String>();
                HashSet<String> holidayLimitInfoSet = new HashSet<String>();
                if (limitDetailList != null && !limitDetailList.isEmpty()) {
                    oldLimitColl = this.RockBackDeductLimit(ctx, limitDetailList, holidayLimitMap, limitCol, holidayLimitInfoSet, holidayLimitDetailSet, this.changeType);
                }
                if (!limitCol.isEmpty()) {
                    limitCol.sort("cyclebegindate");
                    limitCol.sort("delaydate");
                    this.RockBackOverDraftLimit(ctx, limitCol, holidayLimitInfoSet, holidayPolicyInfo, personId, billEntryId, leaveBillEntryId, this.changeType, hrOrgUnit);
                }
                if (!limitCol.isEmpty()) {
                    iHolidayLimit.update(limitCol);
                }
                if (holidayLimitDetailSet.isEmpty()) continue;
                String hql = "where id in (" + AtsUtil.convertSetToString(holidayLimitDetailSet) + ")";
                iHolidayLimitDetail.delete(hql);
            }
        }
    }

    public HolidayLimitDetailCollection getHolidayLimitDetailCollectionByBillId(Context ctx, String billId, int changeType) {
        String oql = "where LeaveBill = '" + billId + "' and changeType = " + changeType + "";
        HolidayLimitDetailCollection holidayLimitDetailCol = null;
        try {
            holidayLimitDetailCol = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailCollection(oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return holidayLimitDetailCol;
    }

    public HolidayLimitDetailCollection getHolidayLimitDetailCollectionByBillNewId(Context ctx, String billId, int changeType) {
        String oql = "where LeaveBillEntry = '" + billId + "' and changeType = " + changeType + "";
        HolidayLimitDetailCollection holidayLimitDetailCol = null;
        try {
            holidayLimitDetailCol = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailCollection(oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return holidayLimitDetailCol;
    }

    public Map<String, List<HolidayLimitDetailInfo>> getHolidaylimitDetailMap(HolidayLimitDetailCollection HolidayLimitDetailCol) {
        HashMap<String, List<HolidayLimitDetailInfo>> limitDetailMap = new HashMap<String, List<HolidayLimitDetailInfo>>();
        int size = HolidayLimitDetailCol.size();
        for (int i = 0; i < size; ++i) {
            List<HolidayLimitDetailInfo> limitDetailList;
            HolidayLimitDetailInfo holidayLimitDetailInfo = HolidayLimitDetailCol.get(i);
            String personId = holidayLimitDetailInfo.getProposer().getId().toString();
            if (holidayLimitDetailInfo.getLeaveBillEntry() == null) continue;
            String leaveBillEntryId = holidayLimitDetailInfo.getLeaveBillEntry().getId().toString();
            if (limitDetailMap.containsKey(leaveBillEntryId)) {
                limitDetailList = (List)limitDetailMap.get(leaveBillEntryId);
                limitDetailList.add(holidayLimitDetailInfo);
                continue;
            }
            limitDetailList = new ArrayList();
            limitDetailList.add(holidayLimitDetailInfo);
            limitDetailMap.put(leaveBillEntryId, limitDetailList);
        }
        return limitDetailMap;
    }

    public CoreBaseCollection RockBackDeductLimit(Context ctx, List<HolidayLimitDetailInfo> limitDetailList, Map<String, HolidayLimitInfo> holidayLimitMap, CoreBaseCollection limitCol, Set<String> holidayLimitInfoSet, Set<String> holidayLimitDetailSet, int changeType) {
        CoreBaseCollection oldLimitColl = new CoreBaseCollection();
        int detailList = limitDetailList.size();
        for (int i = 0; i < detailList; ++i) {
            HolidayLimitDetailInfo holidayLimitDetailInfo = limitDetailList.get(i);
            String limitDetailId = holidayLimitDetailInfo.getId().toString();
            int limitChangeType = holidayLimitDetailInfo.getChangeType().getValue();
            if (holidayLimitDetailInfo.getHolidayLimit() != null && changeType == limitChangeType && holidayLimitMap.containsKey(limitDetailId)) {
                HolidayLimitInfo holidayLimitInfo = holidayLimitMap.get(limitDetailId);
                oldLimitColl.add((CoreBaseInfo)((HolidayLimitInfo)holidayLimitInfo.clone()));
                BigDecimal changeBig = holidayLimitDetailInfo.getChangeValue();
                if (changeType == 6) {
                    holidayLimitInfo.setFreezeLimit(this.decimalPlacesSystem.precisionConvert(ctx, holidayLimitInfo.getFreezeLimit().subtract(changeBig), RoundingMode.HALF_UP));
                    holidayLimitInfo.setRemainLimit(this.decimalPlacesSystem.precisionConvert(ctx, holidayLimitInfo.getRemainLimit().add(changeBig), RoundingMode.HALF_UP));
                } else if (changeType == 4) {
                    holidayLimitInfo.setUsedLimit(this.decimalPlacesSystem.precisionConvert(ctx, holidayLimitInfo.getUsedLimit().subtract(changeBig), RoundingMode.HALF_UP));
                    holidayLimitInfo.setRemainLimit(this.decimalPlacesSystem.precisionConvert(ctx, holidayLimitInfo.getRemainLimit().add(changeBig), RoundingMode.HALF_UP));
                }
                limitCol.add((CoreBaseInfo)holidayLimitInfo);
                holidayLimitInfoSet.add(holidayLimitInfo.getId().toString());
            }
            holidayLimitDetailSet.add(limitDetailId);
        }
        return oldLimitColl;
    }

    public void RockBackOverDraftLimit(Context ctx, CoreBaseCollection limitCol, Set<String> holidayLimitInfoSet, HolidayPolicyInfo holidayPolicyInfo, String personId, String bill, String entryBillId, int changeType, String hrOrgUnitId) throws BOSException, EASBizException {
        HolidayLimitInfo LastholidayLimitInfo = (HolidayLimitInfo)limitCol.get(limitCol.size() - 1);
        Date beginDate = LastholidayLimitInfo.getCycleBeginDate();
        String holidayPolicyId = holidayPolicyInfo.getId().toString();
        String holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
        String overDaftOql = "where hrOrgUnit.id='" + hrOrgUnitId + "' and holidayPolicy.holidayType='" + holidayTypeId + "' and proposer = '" + personId + "' and cyclebegindate >'" + beginDate + "'";
        HolidayLimitCollection overdraftLimitCol = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(overDaftOql);
        overdraftLimitCol.sort("cyclebegindate");
        HolidayLimitInfo holidayLimitInfoTemp = LastholidayLimitInfo;
        if (!overdraftLimitCol.isEmpty()) {
            for (int i = 0; i < overdraftLimitCol.size(); ++i) {
                HolidayLimitInfo overdraftLimitInfo = overdraftLimitCol.get(i);
                if (holidayLimitInfoTemp.getRemainLimit().compareTo(new BigDecimal(0)) == -1) {
                    BigDecimal preOverdraftRealVal = holidayLimitInfoTemp.getRemainLimit().multiply(new BigDecimal(-1));
                    BigDecimal preOverdraftVal = overdraftLimitInfo.getPreOverdraftLimit();
                    BigDecimal diffVal = preOverdraftVal.subtract(preOverdraftRealVal);
                    overdraftLimitInfo.setPreOverdraftLimit(preOverdraftRealVal);
                    overdraftLimitInfo.setRemainLimit(overdraftLimitInfo.getRemainLimit().add(diffVal));
                } else {
                    BigDecimal preOverdraftVal = overdraftLimitInfo.getPreOverdraftLimit();
                    overdraftLimitInfo.setPreOverdraftLimit(new BigDecimal(0));
                    overdraftLimitInfo.setRemainLimit(overdraftLimitInfo.getRemainLimit().add(preOverdraftVal));
                }
                holidayLimitInfoTemp = overdraftLimitInfo;
                holidayLimitInfoSet.add(overdraftLimitInfo.getId().toString());
                limitCol.add((CoreBaseInfo)overdraftLimitInfo);
            }
        }
        if (!holidayLimitInfoSet.isEmpty()) {
            this.UpdateOverDraftLimitDetail(ctx, holidayLimitInfoTemp, holidayLimitInfoSet, personId, bill, entryBillId, holidayPolicyInfo, changeType);
        }
    }

    public void UpdateOverDraftLimitDetail(Context ctx, HolidayLimitInfo holidayLimitInfoTemp, Set<String> holidayLimitInfoSet, String personId, String bill, String entryBillId, HolidayPolicyInfo holidayPolicyInfo, int changeType) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("holidayLimit.id", holidayLimitInfoSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("changeType", (Object)changeType));
        evi.setFilter(fi);
        HolidayLimitDetailCollection holidayLimitDetailCollection = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailCollection(evi);
        HashSet<String> leaveEntrySet = new HashSet<String>();
        for (int i = 0; i < holidayLimitDetailCollection.size(); ++i) {
            if (holidayLimitDetailCollection.get(i).getLeaveBillEntry() == null) continue;
            leaveEntrySet.add(holidayLimitDetailCollection.get(i).getLeaveBillEntry().getId().toString());
        }
        if (!leaveEntrySet.isEmpty()) {
            IHolidayLimitDetail iHolidayLimitDetailOverdraft = HolidayLimitDetailFactory.getLocalInstance(ctx);
            iHolidayLimitDetailOverdraft.delete("where leavebillentry.id in(" + AtsUtil.convertSetToString(leaveEntrySet) + ") and proposer ='" + personId + "' and changeType=" + 7);
            if (holidayLimitInfoTemp.getRemainLimit().compareTo(new BigDecimal(0)) == -1) {
                if (leaveEntrySet.contains(entryBillId)) {
                    leaveEntrySet.remove(entryBillId);
                }
                AtsLeaveBillCollection atsLeaveBillcol = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillCollection(" where id in(" + AtsUtil.convertSetToString(leaveEntrySet) + ")");
                atsLeaveBillcol.sort("lastUpdateTime");
                BigDecimal preOverdraftRealVal = holidayLimitInfoTemp.getRemainLimit().multiply(new BigDecimal(-1));
                String holidayLimitId = holidayLimitInfoTemp.getId().toString();
                CoreBaseCollection colls = new CoreBaseCollection();
                for (int i = atsLeaveBillcol.size() - 1; i >= 0; --i) {
                    AtsLeaveBillInfo atsLeaveBillInfoOverdraft = atsLeaveBillcol.get(i);
                    int entrySize = atsLeaveBillInfoOverdraft.getEntries().size();
                    for (int j = 0; j < entrySize; ++j) {
                        AtsLeaveBillEntryInfo atsLeaveBillEntryInfo = atsLeaveBillInfoOverdraft.getEntries().get(j);
                        String proposerId = atsLeaveBillEntryInfo.getPerson().getId().toString();
                        if (!personId.equals(proposerId)) continue;
                        BigDecimal RealLeaveLength = atsLeaveBillEntryInfo.getRealLeaveLength();
                        HashMap<String, Object> overdraftMap = new HashMap<String, Object>();
                        overdraftMap.put("holidayLimitId", holidayLimitId);
                        overdraftMap.put("personId", personId);
                        overdraftMap.put("holidayPolicyUnit", (Object)holidayPolicyInfo.getUnit());
                        overdraftMap.put("billInfo", atsLeaveBillInfoOverdraft);
                        HolidayLimitDetailInfo detailInfo = null;
                        if (preOverdraftRealVal.compareTo(RealLeaveLength) != 1) {
                            preOverdraftRealVal = this.decimalPlacesSystem.precisionConvert(ctx, preOverdraftRealVal, RoundingMode.HALF_UP);
                            overdraftMap.put("changeValue", preOverdraftRealVal);
                            detailInfo = this.insertDataInfoToHolildayLimitDetail(ctx, overdraftMap, atsLeaveBillInfoOverdraft, atsLeaveBillEntryInfo, HolidayLimitChangeType.overdraft);
                            colls.add((CoreBaseInfo)detailInfo);
                        } else {
                            RealLeaveLength = this.decimalPlacesSystem.precisionConvert(ctx, RealLeaveLength, RoundingMode.HALF_UP);
                            overdraftMap.put("changeValue", RealLeaveLength);
                            detailInfo = this.insertDataInfoToHolildayLimitDetail(ctx, overdraftMap, atsLeaveBillInfoOverdraft, atsLeaveBillEntryInfo, HolidayLimitChangeType.overdraft);
                            colls.add((CoreBaseInfo)detailInfo);
                        }
                        preOverdraftRealVal = preOverdraftRealVal.subtract(RealLeaveLength);
                        break;
                    }
                    if (preOverdraftRealVal.compareTo(new BigDecimal(0)) != 1) break;
                }
                if (!colls.isEmpty()) {
                    HolidayLimitDetailControllerBean holidayLimitDetailControllerBean = new HolidayLimitDetailControllerBean();
                    holidayLimitDetailControllerBean.addnewBatchData(ctx, colls);
                }
            }
        }
    }

    public Map<String, HolidayLimitInfo> getHolidaylimitInfoMap(Context ctx, HolidayLimitDetailCollection HolidayLimitDetailCol) throws BOSException {
        HashSet<String> holidayLimitSet = new HashSet<String>();
        HashMap<String, HolidayLimitInfo> holidayLimit = new HashMap<String, HolidayLimitInfo>();
        int size = HolidayLimitDetailCol.size();
        HashMap<String, String> holidayLimitMap = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            HolidayLimitDetailInfo holidayLimitDetailInfo = HolidayLimitDetailCol.get(i);
            HolidayLimitInfo holidayLimitInfo = holidayLimitDetailInfo.getHolidayLimit();
            if (null == holidayLimitInfo) continue;
            String limitId = holidayLimitInfo.getId().toString();
            holidayLimitSet.add(limitId);
            holidayLimitMap.put(holidayLimitDetailInfo.getId().toString(), limitId);
        }
        String oql = "where id in (" + AtsUtil.convertSetToString(holidayLimitSet) + ")";
        HolidayLimitCollection holidayLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(oql);
        int colSize = holidayLimitCollection.size();
        block1: for (int j = 0; j < size; ++j) {
            HolidayLimitDetailInfo holidayLimitDetailInfo = HolidayLimitDetailCol.get(j);
            HolidayLimitInfo holidayLimitInfoTemp = holidayLimitDetailInfo.getHolidayLimit();
            for (int i = 0; i < colSize; ++i) {
                HolidayLimitInfo holidayLimitInfo = holidayLimitCollection.get(i);
                if (null == holidayLimitInfoTemp || !holidayLimitInfoTemp.getId().toString().equals(holidayLimitInfo.getId().toString())) continue;
                holidayLimit.put(holidayLimitDetailInfo.getId().toString(), holidayLimitInfo);
                continue block1;
            }
        }
        return holidayLimit;
    }
}

