/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit.generate.preparedata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyCollection;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.HolidayRuleCollection;
import com.kingdee.eas.hr.ats.HolidayRuleConditionCollection;
import com.kingdee.eas.hr.ats.HolidayRuleConditionFactory;
import com.kingdee.eas.hr.ats.HolidayRuleConditionGroupCollection;
import com.kingdee.eas.hr.ats.HolidayRuleConditionGroupFactory;
import com.kingdee.eas.hr.ats.HolidayRuleConditionGroupInfo;
import com.kingdee.eas.hr.ats.HolidayRuleConditionInfo;
import com.kingdee.eas.hr.ats.HolidayRuleFactory;
import com.kingdee.eas.hr.ats.HolidayRuleInfo;
import com.kingdee.eas.hr.ats.HolidayRuleItemCollection;
import com.kingdee.eas.hr.ats.HolidayRuleItemFactory;
import com.kingdee.eas.hr.ats.HolidayRuleItemInfo;
import com.kingdee.eas.hr.ats.HolidayTypeCollection;
import com.kingdee.eas.hr.ats.HolidayTypeFactory;
import com.kingdee.eas.hr.ats.HolidayTypeInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.base.EmpLaborRelationCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.emp.PersonOtherInfoCollection;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class InitHolidayLimitData {
    public static Map<String, HolidayTypeInfo> getHolidayTypeInfoMap(Context ctx, Map param) {
        HashMap<String, HolidayTypeInfo> holidayTypeMap = new HashMap<String, HolidayTypeInfo>();
        try {
            String holidayTypeName = (String)param.get("holidayTypeName");
            StringBuffer hql = new StringBuffer();
            hql.append("select id,number,name");
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)holidayTypeName)) {
                hql.append(" where name in ('" + holidayTypeName.trim().replaceAll(",", "','").replaceAll("\uff0c", "','") + "')");
            }
            HolidayTypeCollection holidayTypeCollection = HolidayTypeFactory.getLocalInstance(ctx).getHolidayTypeCollection(hql.toString());
            int holidayTypeNum = holidayTypeCollection.size();
            for (int i = 0; i < holidayTypeNum; ++i) {
                HolidayTypeInfo holidayTypeInfo = holidayTypeCollection.get(i);
                holidayTypeMap.put(holidayTypeInfo.getId().toString(), holidayTypeInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return holidayTypeMap;
    }

    public static HolidayTypeCollection getHolidayTypeColl(Context ctx, Map param) {
        HolidayTypeCollection holidayTypeCollection = null;
        try {
            String holidayTypeName = (String)param.get("holidayTypeName");
            String holidayType = (String)param.get("holidayType");
            StringBuffer hql = new StringBuffer();
            hql.append("select id,number,name,isSysPreset,remark");
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)holidayTypeName)) {
                hql.append(" where name in ('" + holidayTypeName.trim().replaceAll(",", "','").replaceAll("\uff0c", "','") + "')");
            } else if (!org.apache.commons.lang.StringUtils.isEmpty((String)holidayType)) {
                hql.append(" where id = '" + holidayType + "'");
            }
            holidayTypeCollection = HolidayTypeFactory.getLocalInstance(ctx).getHolidayTypeCollection(hql.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return holidayTypeCollection;
    }

    public static Map<String, HolidayRuleInfo> getHolidayRuleMap(Context ctx) {
        HashMap<String, HolidayRuleInfo> holidayRuleInfoMap = new HashMap<String, HolidayRuleInfo>();
        try {
            HolidayRuleCollection holidayRuleCol = HolidayRuleFactory.getLocalInstance(ctx).getHolidayRuleCollection();
            for (int i = 0; i < holidayRuleCol.size(); ++i) {
                HolidayRuleInfo holidayRuleInfo = holidayRuleCol.get(i);
                holidayRuleInfoMap.put(holidayRuleInfo.getId().toString(), holidayRuleInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return holidayRuleInfoMap;
    }

    public static Map<String, PersonPositionInfo> getPersonPositionInfoMap(Context ctx, String personIds) {
        HashMap<String, PersonPositionInfo> personPositionMap = new HashMap<String, PersonPositionInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("adjustCoValue"));
        evi.getSelector().add(new SelectorItemInfo("adjustGroupVal"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        evi.getSelector().add(new SelectorItemInfo("person.number"));
        evi.getSelector().add(new SelectorItemInfo("person.name"));
        evi.getSelector().add(new SelectorItemInfo("personDep.id"));
        evi.getSelector().add(new SelectorItemInfo("personDep.number"));
        evi.getSelector().add(new SelectorItemInfo("personDep.name"));
        evi.getSelector().add(new SelectorItemInfo("primaryPosition.id"));
        evi.getSelector().add(new SelectorItemInfo("primaryPosition.number"));
        evi.getSelector().add(new SelectorItemInfo("primaryPosition.name"));
        evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.id"));
        evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.number"));
        evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.name"));
        evi.getSelector().add(new SelectorItemInfo("joinGroupDate"));
        evi.getSelector().add(new SelectorItemInfo("joinDate"));
        evi.getSelector().add(new SelectorItemInfo("leftDate"));
        evi.getSelector().add(new SelectorItemInfo("entryDate"));
        evi.getSelector().add(new SelectorItemInfo("tryoutMonth"));
        evi.getSelector().add(new SelectorItemInfo("formalDate"));
        evi.getSelector().add(new SelectorItemInfo("enterDate"));
        evi.getSelector().add(new SelectorItemInfo("jobStartDate"));
        evi.getSelector().add(new SelectorItemInfo("workTime"));
        evi.getSelector().add(new SelectorItemInfo("newWorkTime"));
        evi.getSelector().add(new SelectorItemInfo("person.employeeType.isInCount"));
        fi.getFilterItems().add(new FilterItemInfo("person.id", AtsUtil.getSetFromStringArr(personIds.split(",")), CompareType.INCLUDE));
        evi.setFilter(fi);
        try {
            PersonPositionCollection personPositionCollection = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(evi);
            int size = personPositionCollection.size();
            for (int i = 0; i < size; ++i) {
                PersonPositionInfo personPositionInfo = personPositionCollection.get(i);
                personPositionMap.put(personPositionInfo.getPerson().getId().toString(), personPositionInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return personPositionMap;
    }

    public static Map<String, EmpLaborRelationInfo> getEmpLaborRelationInfoMap(Context ctx, String personIds) {
        HashMap<String, EmpLaborRelationInfo> empLaborRelationMap = new HashMap<String, EmpLaborRelationInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.id", AtsUtil.getSetFromStringArr(personIds.split(",")), CompareType.INCLUDE));
        evi.setFilter(fi);
        try {
            EmpLaborRelationCollection empLaboRelaColl = EmpLaborRelationFactory.getLocalInstance((Context)ctx).getEmpLaborRelationCollection(evi);
            for (int i = 0; i < empLaboRelaColl.size(); ++i) {
                EmpLaborRelationInfo empLaborRelationInfo = empLaboRelaColl.get(i);
                empLaborRelationMap.put(empLaborRelationInfo.getPerson().getId().toString(), empLaborRelationInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return empLaborRelationMap;
    }

    public static Map<String, PersonOtherInfoInfo> getPersonOtherInfoMap(Context ctx, String personIds) {
        HashMap<String, PersonOtherInfoInfo> personOtherInfoMap = new HashMap<String, PersonOtherInfoInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.getSelector().add(new SelectorItemInfo("jobStartDate"));
        evi.getSelector().add(new SelectorItemInfo("adjustSerVal"));
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        fi.getFilterItems().add(new FilterItemInfo("person.id", AtsUtil.getSetFromStringArr(personIds.split(",")), CompareType.INCLUDE));
        evi.setFilter(fi);
        try {
            PersonOtherInfoCollection personOtherColl = PersonOtherInfoFactory.getLocalInstance((Context)ctx).getPersonOtherInfoCollection(evi);
            for (int i = 0; i < personOtherColl.size(); ++i) {
                PersonOtherInfoInfo personOtherInfo = personOtherColl.get(i);
                personOtherInfoMap.put(personOtherInfo.getPerson().getId().toString(), personOtherInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return personOtherInfoMap;
    }

    public static Map<String, EmpPosOrgRelationInfo> getEmpPosOrgRelationInfoMap(Context ctx, String personIds) {
        HashMap<String, EmpPosOrgRelationInfo> empPosOrgRelationMap = new HashMap<String, EmpPosOrgRelationInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.id", AtsUtil.getSetFromStringArr(personIds.split(",")), CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("isInner", (Object)1, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("action.id", (Object)"DawAAAApC9TmaL7Z", CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("leffdt", (Object)AtsDateUtils.stringToShortDate("2199-12-31"), CompareType.GREATER_EQUALS));
        evi.setFilter(fi);
        try {
            EmpPosOrgRelationCollection empPosOrgelaColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(evi);
            for (int i = 0; i < empPosOrgelaColl.size(); ++i) {
                EmpPosOrgRelationInfo empPosOrgRelationInfo = empPosOrgelaColl.get(i);
                empPosOrgRelationMap.put(empPosOrgRelationInfo.getPerson().getId().toString(), empPosOrgRelationInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return empPosOrgRelationMap;
    }

    public static Map<String, AtsHolidayFileHisInfo> getAtsHolidayFileHisInfoMap(Context ctx, AtsHolidayFileHisCollection atsHolidayFileHisColl, String cycleDate) {
        Date cycleDt = AtsDateUtils.stringToShortDate(cycleDate);
        HashMap<String, AtsHolidayFileHisInfo> atsHolidayFileHisMap = new HashMap<String, AtsHolidayFileHisInfo>();
        try {
            if (null != atsHolidayFileHisColl) {
                for (int i = 0; i < atsHolidayFileHisColl.size(); ++i) {
                    AtsHolidayFileHisInfo hisInfo = atsHolidayFileHisColl.get(i);
                    String personId = hisInfo.getProposer().getId().toString();
                    String hrOrgUnitId = hisInfo.getHrOrgUnit().getId().toString();
                    if (hisInfo.getEFFDT().getTime() > cycleDt.getTime() || hisInfo.getLEFFDT().getTime() < cycleDt.getTime()) continue;
                    atsHolidayFileHisMap.put(personId + "_" + cycleDate, hisInfo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return atsHolidayFileHisMap;
    }

    public static Map<String, AtsHolidayFileHisCollection> getAtsHolidayFileHisInfoColl(Context ctx, AtsHolidayFileHisCollection atsHolidayFileHisColl) {
        HashMap<String, AtsHolidayFileHisCollection> atsHolidayFileHisMap = new HashMap<String, AtsHolidayFileHisCollection>();
        try {
            if (null != atsHolidayFileHisColl) {
                for (int i = 0; i < atsHolidayFileHisColl.size(); ++i) {
                    AtsHolidayFileHisInfo atsHolidayFileHisInfo = atsHolidayFileHisColl.get(i);
                    String personId = atsHolidayFileHisInfo.getProposer().getId().toString();
                    AtsHolidayFileHisCollection coll = (AtsHolidayFileHisCollection)((Object)atsHolidayFileHisMap.get(personId));
                    if (coll == null) {
                        coll = new AtsHolidayFileHisCollection();
                        coll.add(atsHolidayFileHisInfo);
                        atsHolidayFileHisMap.put(personId, coll);
                        continue;
                    }
                    coll.add(atsHolidayFileHisInfo);
                    atsHolidayFileHisMap.put(personId, coll);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return atsHolidayFileHisMap;
    }

    public static AtsHolidayFileHisCollection getAtsHolidayFileHisCollection(Context ctx, Map<Object, Object> params) {
        String personIds = String.valueOf(params.get("personIds"));
        String cycleDate = String.valueOf(params.get("cycleDate"));
        String hrOrgUnit = String.valueOf(params.get("hrOrgUnit"));
        String adminOrgUnit = String.valueOf(params.get("adminOrgUnit"));
        EntityViewInfo evi = null;
        FilterInfo fi = null;
        AtsHolidayFileHisCollection atsHolidayFileHisCollection = null;
        try {
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)hrOrgUnit)) {
                evi = new EntityViewInfo();
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnit, CompareType.INCLUDE));
            }
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)personIds)) {
                evi = new EntityViewInfo();
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)personIds, CompareType.INCLUDE));
                fi.getFilterItems().add(new FilterItemInfo("attendFileState", (Object)"1", CompareType.EQUALS));
                evi.setFilter(fi);
                evi.setSelector(InitHolidayLimitData.getAtsHolidayFileHisSelector());
            } else if (!org.apache.commons.lang.StringUtils.isEmpty((String)adminOrgUnit)) {
                AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnit));
                evi = new EntityViewInfo();
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)(adminOrgUnitInfo.getLongNumber() + "%"), CompareType.LIKE));
                fi.getFilterItems().add(new FilterItemInfo("attendFileState", (Object)"1", CompareType.EQUALS));
                evi.setFilter(fi);
                evi.setSelector(InitHolidayLimitData.getAtsHolidayFileHisSelector());
            } else {
                evi = new EntityViewInfo();
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("attendFileState", (Object)"1", CompareType.EQUALS));
                evi.setFilter(fi);
                evi.setSelector(InitHolidayLimitData.getAtsHolidayFileHisSelector());
            }
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)cycleDate)) {
                fi = evi.getFilter();
                fi.getFilterItems().add(new FilterItemInfo("effdt", (Object)AtsDateUtils.stringToShortDate(cycleDate), CompareType.LESS_EQUALS));
                fi.getFilterItems().add(new FilterItemInfo("leffdt", (Object)AtsDateUtils.stringToShortDate(cycleDate), CompareType.GREATER_EQUALS));
                evi.setFilter(fi);
            }
            atsHolidayFileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection(evi);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return atsHolidayFileHisCollection;
    }

    private static SelectorItemCollection getAtsHolidayFileHisSelector() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("attendFileState"));
        selectors.add(new SelectorItemInfo("proposer.id"));
        selectors.add(new SelectorItemInfo("proposer.number"));
        selectors.add(new SelectorItemInfo("proposer.name"));
        selectors.add(new SelectorItemInfo("effdt"));
        selectors.add(new SelectorItemInfo("leffdt"));
        selectors.add(new SelectorItemInfo("adminOrgUnit.id"));
        selectors.add(new SelectorItemInfo("adminOrgUnit.name"));
        selectors.add(new SelectorItemInfo("adminOrgUnit.number"));
        selectors.add(new SelectorItemInfo("adminOrgUnit.displayName"));
        selectors.add(new SelectorItemInfo("position.id"));
        selectors.add(new SelectorItemInfo("hrOrgUnit.id"));
        selectors.add(new SelectorItemInfo("hrOrgUnit.name"));
        selectors.add(new SelectorItemInfo("holidayPolicySet.id"));
        selectors.add(new SelectorItemInfo("holidayPolicySet.number"));
        selectors.add(new SelectorItemInfo("holidayPolicySet.name"));
        selectors.add(new SelectorItemInfo("holidayPolicySet.state"));
        return selectors;
    }

    public static Map<String, HolidayPolicyCollection> getHolidayPolicyMap(Context ctx, AtsHolidayFileHisCollection atsHolidayFileHisCollection) {
        HashSet<String> hldsetidSet = new HashSet<String>();
        for (int i = 0; i < atsHolidayFileHisCollection.size(); ++i) {
            HolidayPolicySetInfo holPolicyInfo = atsHolidayFileHisCollection.get(i).getHolidayPolicySet();
            if (holPolicyInfo == null) continue;
            hldsetidSet.add(holPolicyInfo.getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("holidayPolicySet.id", hldsetidSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("holidayPolicySet.id"));
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("holidayType.id"));
        evi.getSelector().add(new SelectorItemInfo("holidayType.number"));
        evi.getSelector().add(new SelectorItemInfo("holidayType.name"));
        evi.getSelector().add(new SelectorItemInfo("holidayRule.id"));
        evi.getSelector().add(new SelectorItemInfo("holidayRule.name"));
        evi.getSelector().add(new SelectorItemInfo("unit"));
        evi.getSelector().add(new SelectorItemInfo("enablePeriod"));
        evi.getSelector().add(new SelectorItemInfo("periodLength"));
        evi.getSelector().add(new SelectorItemInfo("periodLengthUnit"));
        evi.getSelector().add(new SelectorItemInfo("enableMinAmt"));
        evi.getSelector().add(new SelectorItemInfo("minAmt"));
        evi.getSelector().add(new SelectorItemInfo("minAmtValueMtd"));
        evi.getSelector().add(new SelectorItemInfo("isFillHoliday"));
        evi.getSelector().add(new SelectorItemInfo("fillHolidayAmount"));
        evi.getSelector().add(new SelectorItemInfo("fillHolidayAmountUnit"));
        evi.getSelector().add(new SelectorItemInfo("isCancelLeave"));
        evi.getSelector().add(new SelectorItemInfo("cancelLeaveAmount"));
        evi.getSelector().add(new SelectorItemInfo("cancelLeaveAmountUnit"));
        evi.getSelector().add(new SelectorItemInfo("limitGrantStyle"));
        evi.getSelector().add(new SelectorItemInfo("isOver"));
        evi.getSelector().add(new SelectorItemInfo("isOverAutoSub"));
        evi.getSelector().add(new SelectorItemInfo("isIncludeLegal"));
        evi.getSelector().add(new SelectorItemInfo("isIncludeRest"));
        evi.getSelector().add(new SelectorItemInfo("isCtrlLimit"));
        evi.getSelector().add(new SelectorItemInfo("isCanModifyLimit"));
        evi.getSelector().add(new SelectorItemInfo("remark"));
        evi.getSelector().add(new SelectorItemInfo("isSysPreset"));
        evi.getSelector().add(new SelectorItemInfo("enable"));
        evi.getSelector().add(new SelectorItemInfo("isPiecewiseCal"));
        SorterItemInfo st1 = new SorterItemInfo("holidayPolicySet.id");
        st1.setSortType(SortType.ASCEND);
        evi.getSorter().add(st1);
        HashMap<String, HolidayPolicyCollection> holidayPolicyMap = new HashMap<String, HolidayPolicyCollection>();
        try {
            HolidayPolicyCollection holidayPolicyCollection = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection(evi);
            for (int i = 0; i < holidayPolicyCollection.size(); ++i) {
                HolidayPolicyInfo holidayPolicyInfo = holidayPolicyCollection.get(i);
                String policySetId = holidayPolicyInfo.getHolidayPolicySet().getId().toString();
                HolidayPolicyCollection holidayPolicyColl = (HolidayPolicyCollection)((Object)holidayPolicyMap.get(policySetId));
                if (null != holidayPolicyColl) {
                    holidayPolicyColl.add(holidayPolicyInfo);
                    continue;
                }
                holidayPolicyColl = new HolidayPolicyCollection();
                holidayPolicyColl.add(holidayPolicyInfo);
                holidayPolicyMap.put(policySetId, holidayPolicyColl);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return holidayPolicyMap;
    }

    public static void getExistsHolidayLimitMap(Context ctx, Map<Object, Object> params, Map<Object, Object> globalMap) {
        String personIds = String.valueOf(params.get("personIds"));
        String holidayTypeIds = StringUtils.cnulls((String)((String)params.get("holidayTypeIds")));
        String cycleDate = String.valueOf(params.get("cycleDate"));
        HashMap<String, HolidayLimitInfo> existedHolidayLimitMap = new HashMap<String, HolidayLimitInfo>();
        HashMap<String, HolidayLimitInfo> existedParentalLeaveHolidaylimitMap = new HashMap<String, HolidayLimitInfo>();
        if (org.apache.commons.lang.StringUtils.isEmpty((String)personIds) || org.apache.commons.lang.StringUtils.isEmpty((String)cycleDate)) {
            globalMap.put("existedHolidayLimitMap", existedHolidayLimitMap);
            globalMap.put("existedParentalLeaveHolidayLimitMap", existedParentalLeaveHolidaylimitMap);
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add(new SelectorItemInfo("id"));
        selectorColl.add(new SelectorItemInfo("number"));
        selectorColl.add(new SelectorItemInfo("name"));
        selectorColl.add(new SelectorItemInfo("proposer.id"));
        selectorColl.add(new SelectorItemInfo("proposer.number"));
        selectorColl.add(new SelectorItemInfo("proposer.name"));
        selectorColl.add(new SelectorItemInfo("standardLimit"));
        selectorColl.add(new SelectorItemInfo("realLimit"));
        selectorColl.add(new SelectorItemInfo("addOrSubLimit"));
        selectorColl.add(new SelectorItemInfo("usedLimit"));
        selectorColl.add(new SelectorItemInfo("freezeLimit"));
        selectorColl.add(new SelectorItemInfo("remainLimit"));
        selectorColl.add(new SelectorItemInfo("preOverdraftLimit"));
        selectorColl.add(new SelectorItemInfo("leftConvertLimit"));
        selectorColl.add(new SelectorItemInfo("status"));
        selectorColl.add(new SelectorItemInfo("hrOrgUnit.id"));
        selectorColl.add(new SelectorItemInfo("holidayPolicy.holidayType.id"));
        selectorColl.add(new SelectorItemInfo("childId"));
        selectorColl.add(new SelectorItemInfo("isLeftConvert"));
        selectorColl.add(new SelectorItemInfo("leftCycleEndDate"));
        selectorColl.add(new SelectorItemInfo("leftDelayDate"));
        evi.setSelector(selectorColl);
        fi.getFilterItems().add(new FilterItemInfo("proposer.id", AtsUtil.getSetFromStringArr(personIds.split(",")), CompareType.INCLUDE));
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)holidayTypeIds)) {
            fi.getFilterItems().add(new FilterItemInfo("holidayPolicy.holidayType.id", AtsUtil.getSetFromStringArr(holidayTypeIds.split(",")), CompareType.INCLUDE));
        }
        fi.getFilterItems().add(new FilterItemInfo("cycleBeginDate", (Object)AtsDateUtils.stringToShortDate(cycleDate), CompareType.LESS_EQUALS));
        if (null != params.get("isTrial") && ((Boolean)params.get("isTrial")).booleanValue()) {
            InitHolidayLimitData.setTrialFilterInfo(cycleDate, fi);
        } else {
            fi.getFilterItems().add(new FilterItemInfo("cycleEndDate", (Object)AtsDateUtils.stringToShortDate(cycleDate), CompareType.GREATER_EQUALS));
        }
        evi.setFilter(fi);
        try {
            HolidayLimitCollection existsLimitCollection = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(evi);
            for (int i = 0; i < existsLimitCollection.size(); ++i) {
                HolidayLimitInfo holidayLimitInfo = existsLimitCollection.get(i);
                PersonInfo personInfo = holidayLimitInfo.getProposer();
                if (personInfo == null || null == holidayLimitInfo.getHolidayPolicy() || null == holidayLimitInfo.getHrOrgUnit() || null == holidayLimitInfo.getHolidayPolicy().getHolidayType()) continue;
                StringBuilder key = new StringBuilder(personInfo.getId().toString() + holidayLimitInfo.getHolidayPolicy().getHolidayType().getId() + holidayLimitInfo.getHrOrgUnit().getId().toString());
                if ("4F7rXAuSEFjgUzsFEqwuZ/0tUpg=".equals(holidayLimitInfo.getHolidayPolicy().getHolidayType().getId().toString())) {
                    if (org.apache.commons.lang.StringUtils.isBlank((String)holidayLimitInfo.getChildId())) continue;
                    key.append(holidayLimitInfo.getChildId());
                    existedParentalLeaveHolidaylimitMap.put(key.toString(), holidayLimitInfo);
                    continue;
                }
                existedHolidayLimitMap.put(key.toString(), holidayLimitInfo);
            }
            globalMap.put("existedHolidayLimitMap", existedHolidayLimitMap);
            globalMap.put("existedParentalLeaveHolidayLimitMap", existedParentalLeaveHolidaylimitMap);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private static void setTrialFilterInfo(String cycleDate, FilterInfo fi) {
        try {
            FilterInfo trialFilter = new FilterInfo();
            trialFilter.getFilterItems().add(new FilterItemInfo("cycleEndDate", (Object)AtsDateUtils.stringToShortDate(cycleDate), CompareType.GREATER_EQUALS));
            trialFilter.getFilterItems().add(new FilterItemInfo("leftCycleEndDate", (Object)AtsDateUtils.stringToShortDate(cycleDate), CompareType.GREATER_EQUALS));
            trialFilter.setMaskString("(#0 or #1)");
            fi.mergeFilter(trialFilter, "and");
        }
        catch (Exception e) {
            e.printStackTrace();
            fi.getFilterItems().add(new FilterItemInfo("cycleEndDate", (Object)AtsDateUtils.stringToShortDate(cycleDate), CompareType.GREATER_EQUALS));
        }
    }

    public static Map<String, HolidayLimitInfo> getPreHolidayLimit(Context ctx, String tempTableName, String holidayLimitIdStr) {
        String queryIdStr = null;
        queryIdStr = !org.apache.commons.lang.StringUtils.isEmpty((String)tempTableName) ? " exists (select 1 from " + tempTableName + " tmpt where L.fid =tmpt.fid) " : " L.FID IN (" + holidayLimitIdStr + ") ";
        HashMap<String, HolidayLimitInfo> holidayLimitMap = new HashMap<String, HolidayLimitInfo>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select FID, HL.Fproposerid,FYEAR,FstandardLimit,FrealLimit,FaddOrSubLimit,FusedLimit,freezeLimit ,FremainLimit ,fpreoverdraftlimit ").append(" from t_Hr_Ats_Holidaylimit HL ").append(" INNER JOIN (select DateAdd(dd,-1,fcyclebegindate) AS cyclebegindate, ").append(" FHRORGUNITID,fproposerid,fholidaypolicyid  ").append(" from t_Hr_Ats_Holidaylimit L   ").append(" WHERE " + queryIdStr).append(" )TMP ").append(" ON HL.FHRORGUNITID = TMP.FHRORGUNITID AND HL.fproposerid = TMP.fproposerid AND HL.fholidaypolicyid = TMP.fholidaypolicyid ").append(" and HL.fcycleENDdate = TMP.cyclebegindate ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                HolidayLimitInfo limitInfo = new HolidayLimitInfo();
                PersonInfo personInfo = new PersonInfo();
                String proposerid = rs.getString("Fproposerid");
                limitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                personInfo.setId(BOSUuid.read((String)proposerid));
                limitInfo.setProposer(personInfo);
                limitInfo.setYear(rs.getInt("FYEAR"));
                limitInfo.setStandardLimit(rs.getBigDecimal("FstandardLimit"));
                limitInfo.setRealLimit(rs.getBigDecimal("FrealLimit"));
                limitInfo.setAddOrSubLimit(rs.getBigDecimal("FaddOrSubLimit"));
                limitInfo.setUsedLimit(rs.getBigDecimal("FusedLimit"));
                limitInfo.setFreezeLimit(rs.getBigDecimal("freezeLimit"));
                limitInfo.setRemainLimit(rs.getBigDecimal("FremainLimit"));
                limitInfo.setPreOverdraftLimit(rs.getBigDecimal("fpreoverdraftlimit"));
                if (null != holidayLimitMap.get(proposerid)) {
                    System.out.println("personID:" + proposerid + " find  multi pre cycle record");
                    continue;
                }
                holidayLimitMap.put(proposerid, limitInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return holidayLimitMap;
    }

    public static Map<String, HolidayRuleConditionGroupCollection> initPrepareRuleConditionGroupMap(Context ctx) {
        HashMap<String, HolidayRuleConditionGroupCollection> ruleConditionGroupMap = new HashMap<String, HolidayRuleConditionGroupCollection>();
        try {
            HolidayRuleConditionGroupCollection conditionGroupColl = HolidayRuleConditionGroupFactory.getLocalInstance(ctx).getHolidayRuleConditionGroupCollection("select id,group.id ");
            for (int i = 0; i < conditionGroupColl.size(); ++i) {
                HolidayRuleInfo holidayRuleInfo = conditionGroupColl.get(i).getGroup();
                HolidayRuleConditionGroupInfo ruleConditionGroupInfo = conditionGroupColl.get(i);
                String ruleId = holidayRuleInfo.getId().toString();
                if (ruleConditionGroupMap.containsKey(ruleId)) {
                    ((HolidayRuleConditionGroupCollection)((Object)ruleConditionGroupMap.get(ruleId))).add(ruleConditionGroupInfo);
                    continue;
                }
                HolidayRuleConditionGroupCollection tempCol = new HolidayRuleConditionGroupCollection();
                tempCol.add(ruleConditionGroupInfo);
                ruleConditionGroupMap.put(ruleId, tempCol);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return ruleConditionGroupMap;
    }

    public static Map<String, HolidayRuleConditionCollection> initPrepareConditionItemsMap(Context ctx) {
        HashMap<String, HolidayRuleConditionCollection> ruleConditionMap = new HashMap<String, HolidayRuleConditionCollection>();
        try {
            HolidayRuleConditionCollection conditionColl = HolidayRuleConditionFactory.getLocalInstance(ctx).getHolidayRuleConditionCollection();
            for (int i = 0; i < conditionColl.size(); ++i) {
                HolidayRuleConditionGroupInfo holidayRuleConditionGroupInfo = conditionColl.get(i).getGroup();
                HolidayRuleConditionInfo ruleConditionInfo = conditionColl.get(i);
                String ruleConditionGroupId = holidayRuleConditionGroupInfo.getId().toString();
                if (ruleConditionMap.containsKey(ruleConditionGroupId)) {
                    ((HolidayRuleConditionCollection)((Object)ruleConditionMap.get(ruleConditionGroupId))).add(ruleConditionInfo);
                    continue;
                }
                HolidayRuleConditionCollection tempCol = new HolidayRuleConditionCollection();
                tempCol.add(ruleConditionInfo);
                ruleConditionMap.put(ruleConditionGroupId, tempCol);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return ruleConditionMap;
    }

    public static Map<String, HolidayRuleItemCollection> initPrepareConditionRuleItemsMap(Context ctx) {
        HashMap<String, HolidayRuleItemCollection> ruleItemCollectionMap = new HashMap<String, HolidayRuleItemCollection>();
        try {
            HolidayRuleItemCollection ruleItemCollection = HolidayRuleItemFactory.getLocalInstance(ctx).getHolidayRuleItemCollection();
            for (int i = 0; i < ruleItemCollection.size(); ++i) {
                HolidayRuleConditionGroupInfo holidayRuleConditionGroupInfo = ruleItemCollection.get(i).getCondition();
                String ruleConditionGroupId = holidayRuleConditionGroupInfo.getId().toString();
                HolidayRuleItemInfo ruleItemInfo = ruleItemCollection.get(i);
                if (ruleItemCollectionMap.containsKey(ruleConditionGroupId)) {
                    ((HolidayRuleItemCollection)((Object)ruleItemCollectionMap.get(ruleConditionGroupId))).add(ruleItemInfo);
                    continue;
                }
                HolidayRuleItemCollection tempCol = new HolidayRuleItemCollection();
                tempCol.add(ruleItemInfo);
                ruleItemCollectionMap.put(ruleConditionGroupId, tempCol);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return ruleItemCollectionMap;
    }

    public static boolean isYearHoliday(HolidayTypeInfo ht) {
        if (ht == null) {
            return false;
        }
        if (null == ht.getId() || org.apache.commons.lang.StringUtils.isEmpty((String)ht.getId().toString())) {
            return false;
        }
        return "3T54RtSQRIqAL6cffMh60P0tUpg=".equals(ht.getId().toString().trim());
    }

    public static boolean isParentalHoliday(HolidayTypeInfo ht) {
        if (ht == null) {
            return false;
        }
        if (null == ht.getId() || org.apache.commons.lang.StringUtils.isEmpty((String)ht.getId().toString())) {
            return false;
        }
        return "4F7rXAuSEFjgUzsFEqwuZ/0tUpg=".equals(ht.getId().toString().trim());
    }

    public static Map<String, EmpPosOrgRelationInfo> getEmpPosOrgRelationMap(Context ctx, String personIds) {
        HashMap<String, EmpPosOrgRelationInfo> empPosOrgRelationMap = new HashMap<String, EmpPosOrgRelationInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selectColl = new SelectorItemCollection();
        selectColl.add(new SelectorItemInfo("id"));
        selectColl.add(new SelectorItemInfo("person.id"));
        selectColl.add(new SelectorItemInfo("effdt"));
        selectColl.add(new SelectorItemInfo("leffdt"));
        selectColl.add(new SelectorItemInfo("action.id"));
        selectColl.add(new SelectorItemInfo("parent.id"));
        selectColl.add(new SelectorItemInfo("parent.action.id"));
        selectColl.add(new SelectorItemInfo("parent.effdt"));
        selectColl.add(new SelectorItemInfo("parent.leffdt"));
        evi.setSelector(selectColl);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.id", AtsUtil.getSetFromStringArr(personIds.split(",")), CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("isInner", (Object)1, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("action.id", (Object)"DawAAAApC9TmaL7Z", CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("leffdt", (Object)AtsDateUtils.stringToShortDate("2199-12-31"), CompareType.GREATER_EQUALS));
        evi.setFilter(fi);
        try {
            EmpPosOrgRelationCollection empPosOrgelaColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(evi);
            for (int i = 0; i < empPosOrgelaColl.size(); ++i) {
                EmpPosOrgRelationInfo empPosOrgRelationInfo = empPosOrgelaColl.get(i);
                empPosOrgRelationMap.put(empPosOrgRelationInfo.getPerson().getId().toString(), empPosOrgRelationInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return empPosOrgRelationMap;
    }
}

