/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.ats.lightapp.util.SerialID;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.util.CnToSpell;
import com.kingdee.shr.base.syssetting.OrgType;
import com.kingdee.shr.base.syssetting.api.bean.SHRCodingRule;
import com.kingdee.shr.base.syssetting.api.codingrule.ShrCodeRuleAdaptConfig;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.util.Configuration;
import com.kingdee.util.LocaleUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NumberCodeRule {
    public static final String NUMBER = "number";
    public static final int DUMP_MAX_COUNT = 1000;
    private static Map<Class, String> custonNumberPatterm = new HashMap<Class, String>();

    public static String readCodeRuleNumber(IObjectValue model, String mainOrgID, Context ctx) throws EASBizException {
        block5: {
            boolean hasCodingRule = NumberCodeRule.hasCodingRule(model, mainOrgID, ctx);
            if (hasCodingRule) {
                try {
                    return NumberCodeRule.getCodingNumber(ctx, model, mainOrgID);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    break block5;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    break block5;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block5;
                }
            }
            return null;
        }
        return null;
    }

    public static boolean hasCodingRule(IObjectValue model, String orgId, Context ctx) {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (orgId != null && orgId.trim().length() > 0 && iCodingRuleManager.isExist(model, orgId)) {
                return true;
            }
            String companyId = NumberCodeRule.getNextCompanyId(ctx);
            return companyId != null && companyId.trim().length() > 0 && iCodingRuleManager.isExist(model, companyId);
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    public static String getNextCompanyId(Context ctx) throws BOSException, EASBizException {
        OrgUnitInfo mainOrg = (OrgUnitInfo)ctx.get((Object)com.kingdee.eas.basedata.org.OrgType.ControlUnit);
        if (null == mainOrg || StringUtils.isEmpty((CharSequence)mainOrg.getString("id"))) {
            return "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        return mainOrg.getString("id");
    }

    public static String getMainOrgByCu(Context ctx) {
        String orgId;
        OrgUnitInfo mainOrg = (OrgUnitInfo)ctx.get((Object)com.kingdee.eas.basedata.org.OrgType.HRO);
        String string = orgId = mainOrg == null ? "" : mainOrg.getString("id");
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        return orgId;
    }

    public static String getCodingNumber(Context ctx, IObjectValue numberFromModel, String mainOrgID) throws BOSException, EASBizException {
        String realOrgId = mainOrgID;
        realOrgId = StringUtils.isEmpty((CharSequence)mainOrgID) ? NumberCodeRule.getNextCompanyId(ctx) : NumberCodeRule.getRealOrgId(ctx, numberFromModel, mainOrgID);
        SHRCodingRule shrCodingRule = new SHRCodingRule();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = null;
        String propertyName = NumberCodeRule.getCodingRuleProperty(numberFromModel.getBOSType().toString());
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(numberFromModel, realOrgId);
        shrCodingRule.setExist(ruleStatus.isExist());
        shrCodingRule.setPropertyName(propertyName);
        if (ruleStatus.isExist()) {
            number = iCodingRuleManager.readNumber(numberFromModel, realOrgId);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(propertyName, (Object)number, CompareType.EQUALS));
            ICoreBase iCoreBase = BaseMetaDataUtil.getBizInterface((Context)ctx, (BOSObjectType)numberFromModel.getBOSType());
            int count = 0;
            while (iCoreBase.exists(filter)) {
                number = ruleStatus.isAddNoBreak() ? iCodingRuleManager.getNonbreakNumber(numberFromModel, realOrgId) : iCodingRuleManager.getNumber(numberFromModel, realOrgId);
                if (count >= 1000) break;
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo(propertyName, (Object)number, CompareType.EQUALS));
                ++count;
            }
            shrCodingRule.setAddNoBreak(ruleStatus.isAddNoBreak());
            shrCodingRule.setAddView(ruleStatus.isAddView());
            shrCodingRule.setModifiable(ruleStatus.isModifiable());
            shrCodingRule.setUseIntermitNumber(ruleStatus.isUseIntermitNumber());
            shrCodingRule.setUserSelect(ruleStatus.isUserSelect());
            shrCodingRule.setCodingRuleNumber(number);
        }
        return number;
    }

    public static String getCodeRuleNumber(Context ctx, IObjectValue model, String mainOrgID) throws BOSException, EASBizException {
        boolean hasCodingRule = NumberCodeRule.hasCodingRule(model, mainOrgID, ctx);
        if (hasCodingRule) {
            String num;
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String number = null;
            if (iCodingRuleManager.isExist(model, mainOrgID) && (num = iCodingRuleManager.getNumber(model, mainOrgID)) != null) {
                number = num;
            }
            return number;
        }
        return null;
    }

    private static String getRealOrgId(Context ctx, IObjectValue numberFromModel, String mainOrgID) {
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(numberFromModel.getBOSType());
        String extendPropertyOrgType = entityObjectInfo.getExtendedProperty("OrgType");
        String realOrgId = null;
        if (StringUtils.isEmpty((CharSequence)extendPropertyOrgType)) {
            return mainOrgID;
        }
        if ("ControlUnit".equals(extendPropertyOrgType)) {
            try {
                FullOrgUnitInfo full = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgID));
                realOrgId = null != full ? full.getCU().getId().toString() : mainOrgID;
            }
            catch (EASBizException e) {
                e.printStackTrace();
                realOrgId = mainOrgID;
            }
            catch (BOSException e) {
                e.printStackTrace();
                realOrgId = mainOrgID;
            }
            return realOrgId;
        }
        return mainOrgID;
    }

    public static String getCodingRuleProperty(String bosType) {
        String number = ShrCodeRuleAdaptConfig.getInstance().getCodingRuleAdaptConfig(bosType);
        if (StringUtils.isEmpty((CharSequence)number)) {
            number = NUMBER;
        }
        return number;
    }

    public static CoreBaseInfo setNumber(Context ctx, CoreBaseInfo coreBaseInfo) throws EASBizException, BOSException {
        if (StringUtils.isNotBlank((CharSequence)coreBaseInfo.getString(NUMBER))) {
            return coreBaseInfo;
        }
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        String orgUnitId = StringUtils.defaultString((String)CoreBaseUtile.getId(orgUnitInfo), (String)"00000000-0000-0000-0000-000000000000CCE7AED4");
        if (NumberCodeRule.hasCodingRule((IObjectValue)coreBaseInfo, orgUnitId, ctx)) {
            NumberCodeRule.getCodingNumber(ctx, (IObjectValue)coreBaseInfo, orgUnitId);
        }
        NumberCodeRule.setNumberByCustom(ctx, coreBaseInfo);
        return coreBaseInfo;
    }

    public static CoreBaseInfo setNumberByCustom(Context ctx, CoreBaseInfo coreBaseInfo) throws EASBizException, BOSException {
        if (StringUtils.isNotBlank((CharSequence)coreBaseInfo.getString(NUMBER))) {
            return coreBaseInfo;
        }
        String number = String.format("%s-%s-%08d", NumberCodeRule.getCustonNumberPatterm(ctx, coreBaseInfo), Date.formateDateNum(), SerialID.getAndIncrement());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(NUMBER, (Object)number));
        if (AtsEntityUtile.getBizInterface(ctx, coreBaseInfo).exists(filterInfo)) {
            return NumberCodeRule.setNumberByCustom(ctx, coreBaseInfo);
        }
        coreBaseInfo.put(NUMBER, (Object)number);
        return coreBaseInfo;
    }

    public static String getCustonNumberPatterm(Context ctx, CoreBaseInfo coreBaseInfo) throws EASBizException, BOSException {
        if (coreBaseInfo == null) {
            return "RAND";
        }
        String patterm = custonNumberPatterm.get(coreBaseInfo.getClass());
        if (patterm == null) {
            EntityObjectInfo entityObj = AtsEntityUtile.getEntityObj(ctx, coreBaseInfo);
            if (entityObj == null) {
                return "RAND";
            }
            Map<String, Locale> supportLang = NumberCodeRule.getSupportLang();
            String name = entityObj.getAlias(LocaleUtils.locale_zh_CN);
            if (StringUtils.isBlank((CharSequence)name) && supportLang.containsValue(LocaleUtils.locale_zh_TW)) {
                name = entityObj.getAlias(LocaleUtils.locale_zh_TW);
            }
            if (StringUtils.isBlank((CharSequence)name) && supportLang.containsValue(LocaleUtils.locale_en_US)) {
                name = entityObj.getAlias(LocaleUtils.locale_en_US);
            }
            if (StringUtils.isBlank((CharSequence)name) && supportLang.size() > 0) {
                name = entityObj.getAlias(supportLang.values().iterator().next());
            }
            patterm = CnToSpell.getSpell((String)name, (boolean)true);
            patterm = NumberCodeRule.registCustomNumberPatterm(coreBaseInfo, StringUtils.defaultString((String)patterm, (String)entityObj.getName()));
        }
        return patterm == null ? null : patterm.toUpperCase(LocaleUtils.locale_en_US);
    }

    public static String registCustomNumberPatterm(Object pattermObj, String patterm) {
        if (pattermObj != null && StringUtils.isNotBlank((CharSequence)patterm)) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{patterm})) {
                patterm = StringUtils.remove((String)patterm, (char)' ');
            }
            custonNumberPatterm.put(pattermObj instanceof Class ? (Class<?>)pattermObj : pattermObj.getClass(), patterm.toUpperCase());
        }
        return patterm;
    }

    public static Map<String, Locale> getSupportLang() {
        Map properties = Configuration.getInstance().getConfigItem("supportlanguage").getProperties();
        if (AtsCollectionUtile.isEmpty(properties)) {
            return Collections.emptyMap();
        }
        HashMap<String, Locale> localMap = new HashMap<String, Locale>(properties.size());
        for (Map.Entry localeEntry : properties.entrySet()) {
            String[] locals = StringUtils.split((String)((String)localeEntry.getKey()), (char)'#');
            if (locals == null || locals.length < 2) continue;
            Locale locale = LocaleUtils.getLocale((String)locals[0]);
            localMap.put(LocaleUtils.getShortCode((Locale)locale), LocaleUtils.getLocale((String)locals[1]));
        }
        return localMap;
    }
}

