/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sqlParam;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.DbUtile;
import com.kingdee.eas.hr.ats.util.common.tempTableUtile;
import com.kingdee.eas.hr.ats.vo.common.AtsCtx;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class AtsSqlParam
extends AtsCtx {
    boolean initialed;
    protected boolean useTempTable;
    protected String tempTableName;
    protected Set<String> selectFields = new LinkedHashSet<String>(4);
    protected StringBuffer ASPSql = new StringBuffer();

    public AtsSqlParam() {
        this.initSelector();
    }

    public StringBuffer getSql() {
        if (this.initialed) {
            return this.ASPSql;
        }
        this.ASPSql.append(this.getSelector());
        this.initSql();
        this.initialed = true;
        if (this.useTempTable && this.ctx != null) {
            try {
                String tempTable = tempTableUtile.createTableWithFirstIndex(this.ctx, this.ASPSql.toString());
                this.ASPSql.setLength(0);
                this.ASPSql.append("select * from ").append(tempTable);
            }
            catch (Exception e) {
                AtsLog.getLog().error((Object)("create temp table error:" + e.getMessage()), (Throwable)e);
                this.ASPSql.setLength(0);
            }
        }
        return this.ASPSql;
    }

    public void releaseTempTable() {
        if (this.tempTableName != null) {
            tempTableUtile.releaseTable(this.ctx, this.tempTableName);
        }
    }

    protected abstract void initSelector();

    protected String getSelector() {
        StringBuffer selector = new StringBuffer("select ");
        for (String field : this.selectFields) {
            selector.append(field).append(",");
        }
        selector.setLength(selector.length() - 1);
        return selector.toString();
    }

    public IRowSet getRowSet() throws BOSException {
        return DbUtile.executeQuery(this.ctx, this.getSql().toString());
    }

    public List<String> getIds() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            IRowSet rowSet = this.getRowSet();
            while (rowSet.next()) {
                result.add(rowSet.getString("fid"));
            }
        }
        catch (Exception e) {
            AtsLog.getLog().error((Object)e);
        }
        return result;
    }

    public boolean isInitialed() {
        return this.initialed;
    }

    public AtsSqlParam setInitialed(boolean initialed) {
        this.initialed = initialed;
        return this;
    }

    public boolean isUseTempTable() {
        return this.useTempTable;
    }

    public AtsSqlParam setUseTempTable(boolean userTempTable) {
        this.useTempTable = userTempTable;
        return this;
    }

    public Set<String> getSelectFields() {
        return this.selectFields;
    }

    public AtsSqlParam setSelectFields(Set<String> selectFields) {
        this.selectFields = selectFields;
        return this;
    }

    public AtsSqlParam addSelectField(String field) {
        if (StringUtils.isNotBlank((String)field)) {
            this.selectFields.add(field);
        }
        return this;
    }

    public AtsSqlParam addSelectField(String ... fields) {
        if (fields != null) {
            for (String field : fields) {
                this.addSelectField(field);
            }
        }
        return this;
    }

    public AtsSqlParam addSelectField(Collection<? extends Object> fields) {
        if (fields != null) {
            for (Object object : fields) {
                if (object == null) continue;
                this.addSelectField(object.toString());
            }
        }
        return this;
    }

    public AtsSqlParam removeSelectFields() {
        this.selectFields.clear();
        return this;
    }

    public AtsSqlParam removeSelectFields(String ... fields) {
        if (fields != null) {
            for (String field : fields) {
                this.selectFields.remove(field);
            }
        }
        return this;
    }

    public AtsSqlParam removeSelectFields(String field) {
        this.selectFields.remove(field);
        return this;
    }

    public String toString() {
        boolean initialedTemp = this.initialed;
        String sql = this.getSql().toString();
        this.initialed = initialedTemp;
        return sql;
    }

    protected abstract void initSql();
}

