/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.backCal.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.sum.backCal.save.AtsSumBackCalSave;
import com.kingdee.eas.hr.ats.sum.backCal.service.AtsSumBackCalService;
import com.kingdee.eas.hr.ats.sum.backCal.util.AtsSumBackCalHelper;
import com.kingdee.eas.hr.ats.sum.backCal.vo.AtsSumBackCalVO;
import com.kingdee.eas.hr.ats.sum.util.AtsResultToSumHelper;
import com.kingdee.eas.hr.ats.sum.util.AtsResultToSumPersonHelper;
import com.kingdee.eas.hr.ats.sum.util.AtsSumSalaryUtil;
import com.kingdee.eas.hr.ats.util.common.DbUtile;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AtsSumBackCalCommon
implements AtsSumBackCalService {
    private static Logger logger = Logger.getLogger(AtsResultToSumPersonHelper.class);
    public static final int PERSONQUERY_PAGECOUNT = 500;
    public static final int PERSON_PAGECOUNT = 1000;
    public static final int THREAD_PERSON_PER_COUNT = 200;
    public static final int MAX_THREAD_SIZE = 3;

    @Override
    public String prepareTempTable(Context ctx, AtsSumBackCalVO backCalVO) {
        String tempTableName = null;
        try {
            tempTableName = AtsSumBackCalHelper.createResultToSumTempTable(ctx, backCalVO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tempTableName;
    }

    @Override
    public String getSelector(Context ctx, String param) {
        return AtsResultToSumHelper.getSelector(ctx, param);
    }

    @Override
    public Map<String, String> getColumnMap(Context ctx, String selector) {
        return AtsResultToSumHelper.getColumnMap(selector);
    }

    @Override
    public List<String> getKeyList(Context ctx, String tableName, Map<String, String> columnMap) {
        return AtsResultToSumHelper.getCellNameByTableName(ctx, tableName, columnMap);
    }

    @Override
    public String prepareSumKeyTmpTable(Context ctx, List<LinkedHashMap<String, Object>> rowList) {
        return AtsResultToSumHelper.createResultToSumKeyTmpTable(ctx, rowList);
    }

    @Override
    public Set<String> getExistedSumRecordSet(Context ctx, AtsSumBackCalVO backCalVO, List<LinkedHashMap<String, Object>> sumRowLinkedList, String sumKeyTmpTable) {
        return AtsSumBackCalHelper.getExistedSumRecordInfo(ctx, backCalVO, sumRowLinkedList, sumKeyTmpTable);
    }

    @Override
    public boolean setDetailToSumRecord(Context ctx, String sumKeyTmpTable, AtsSumBackCalVO backCalVO, List<LinkedHashMap<String, Object>> sumRowLinkedList, Map<String, String> columnMap) {
        AtsSumBackCalHelper.setGridAttendResultSumInfo(ctx, sumKeyTmpTable, backCalVO, sumRowLinkedList, columnMap);
        return true;
    }

    @Override
    public Map<String, Object> sum(Context ctx, List<LinkedHashMap<String, Object>> sumRowLinkedList, List<String> keyList, Set<String> existSumRecords, AtsSumBackCalVO backCalVO) {
        return new AtsSumBackCalSave().submitAttendResultSumRecordData(ctx, sumRowLinkedList, keyList, existSumRecords, backCalVO);
    }

    @Override
    public boolean saveSumRecord(Context ctx, Map<String, Object> resultMap, List<String> keyList) {
        String updateSumSqlTemplate = AtsSumBackCalSave.genUpdateSumSqlTemplate(ctx, keyList);
        String insertSumSqlTemplate = AtsSumBackCalSave.genInsertSumSqlTemplate(ctx, keyList);
        List insertSumParams = null;
        List updateSumParams = null;
        try {
            insertSumParams = (List)resultMap.get("INSERT_SUM_PARAMS");
            if (null != insertSumParams && insertSumParams.size() > 0) {
                DbUtile.executeBatch(ctx, insertSumSqlTemplate, insertSumParams);
            }
            if (null != (updateSumParams = (List)resultMap.get("UPDATE_SUM_PARAMS")) && updateSumParams.size() > 0) {
                DbUtile.executeBatch(ctx, updateSumSqlTemplate, updateSumParams);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("PAGE: RESULTTOSUM insert batch sql failed,insertSumSqlTemplate:" + insertSumSqlTemplate + "\n insertSumParams:" + (null == insertSumParams ? "null" : insertSumParams.toString())));
            logger.error((Object)("PAGE: RESULTTOSUM update batch sql failed,updateSumSqlTemplate:" + updateSumSqlTemplate + "\n updateSumParams:" + (null == updateSumParams ? "null" : updateSumParams.toString())));
        }
        return true;
    }

    @Override
    public Map<String, Object> assembleMsg(Context ctx, Map<String, Object> batchMsgMap, Map<String, Object> resultMap) {
        AtsSumSalaryUtil.initMsgMap(resultMap);
        AtsSumSalaryUtil.putMsgToResultMap(resultMap, batchMsgMap);
        return resultMap;
    }

    @Override
    public List<LinkedHashMap<String, Object>> getSumRowLinkedList(Context ctx, AtsSumBackCalVO backCalVO, IRowSet sumKeyRows) {
        return null;
    }

    @Override
    public List<LinkedHashMap<String, Object>> getSumRowLinkedListBySelected(Context ctx, AtsSumBackCalVO backCalVO) {
        return null;
    }
}

