/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.service.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.hr.ats.AtsFormulaResEnum;
import com.kingdee.eas.hr.ats.AtsHolidayFileInfo;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.AttendanceProjectInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.WorkCalendarInfo;
import com.kingdee.eas.hr.ats.WorkCalendarItemInfo;
import com.kingdee.eas.hr.ats.app.formula.calculate.ResultCal;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataRow;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.DataTable;
import com.kingdee.eas.hr.ats.biz.util.AttendanceSelfDefinedUtil;
import com.kingdee.eas.hr.ats.sum.service.formula.CalculateDynaCustomerResultThread;
import com.kingdee.eas.hr.ats.sum.util.AtsResultToSumHelper;
import com.kingdee.eas.hr.ats.sum.util.AtsSumSalaryUtil;
import com.kingdee.eas.hr.ats.util.AtsBaseUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.AtsServerCalUtils;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CalculateDynaCustomerResult {
    private static Logger logger = Logger.getLogger(CalculateDynaCustomerResult.class);
    private static final int batchSize = 100;

    public void calculateSumResult(Context ctx, Map<String, String> filterItems, String dynamicSQL, String tableAlias) throws Exception {
        long startTime = System.currentTimeMillis();
        String tempTableName = null;
        try {
            String indexSql;
            dynamicSQL = dynamicSQL.indexOf("order by") > 0 ? "SELECT " + tableAlias + ".* " + dynamicSQL.substring(dynamicSQL.indexOf("FROM"), dynamicSQL.indexOf("order by")) + " order by " + tableAlias + ".FID desc" : "SELECT " + tableAlias + ".* " + dynamicSQL.substring(dynamicSQL.indexOf("FROM")) + " order by " + tableAlias + ".FID desc";
            int totalCount = this.getCount(ctx, dynamicSQL);
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
            String tempSql = "select * into " + tempTableName + " from (" + dynamicSQL.replace("order by " + tableAlias + ".FID desc", "") + " ) T ;  ";
            DbUtil.execute((Context)ctx, (String)tempSql);
            String dbType = ContextUtil.getDbType((Context)ctx);
            if (!StringUtils.isEmpty((String)dbType) && (dbType.equalsIgnoreCase("Oracle") || dbType.startsWith("Oracle"))) {
                indexSql = "create index " + tempTableName + " on " + tempTableName + "  (FID DESC);";
                DbUtil.execute((Context)ctx, (String)indexSql);
            } else {
                indexSql = "create index IX" + tempTableName + " on " + tempTableName + "  (FID DESC);";
                DbUtil.execute((Context)ctx, (String)indexSql);
            }
            int loopTimes = 1;
            loopTimes = totalCount % 100 == 0 ? totalCount / 100 : totalCount / 100 + 1;
            System.out.println("Call calculateSumResult totalCount:" + totalCount);
            String beginDate = filterItems.get("beginDate").substring(0, 10);
            String endDate = filterItems.get("endDate").substring(0, 10);
            filterItems.put("beginDate", beginDate);
            filterItems.put("endDate", endDate);
            HashMap<Object, Object> globalMap = new HashMap<Object, Object>();
            globalMap.put("periodBeginDate", beginDate);
            globalMap.put("periodEndDate", endDate);
            globalMap.put("attendPeriodId", filterItems.get("attendPeriodId"));
            this.preparedGlobalMap(ctx, globalMap, beginDate, endDate);
            if (totalCount < 500) {
                ArrayList<String> sqls = new ArrayList<String>();
                for (int loop = 1; loop <= loopTimes; ++loop) {
                    String afterPagingSql = this.getAfterPagingSql(ctx, "select * from " + tempTableName + " order by fid desc", 100, loop, totalCount);
                    Map<String, Object> attResultInfosMap = AtsResultToSumHelper.getDynamicAttendanceResultSum(ctx, afterPagingSql);
                    globalMap.put("T_HR_ATS_AttendanceResultSum", attResultInfosMap);
                    Map resMap = (Map)attResultInfosMap.get("datas");
                    globalMap.put("personIdsForSumResult", Arrays.asList(resMap.keySet().toArray()));
                    String personIds = AtsServerCalUtils.getPersonIds(Arrays.asList(resMap.keySet().toArray()));
                    Map<String, AttendanceFileInfo> fileInfoObject = AtsResultToSumHelper.getAttendanceFileInfoByPersonId(ctx, personIds, filterItems);
                    globalMap.put("T_HR_ATS_AttendanceFile", fileInfoObject);
                    Map<String, AtsHolidayFileInfo> holFileInfoObject = AtsResultToSumHelper.getHolidayFileInfoByPersonId(ctx, personIds, filterItems);
                    globalMap.put("T_HR_ATS_HolidayFile", holFileInfoObject);
                    AtsScheduleShiftUtil.getAllScheduleShiftMapByPriority(globalMap, ctx, personIds, beginDate, endDate);
                    Map<String, List<DataTable>> personDataMap = AttendanceSelfDefinedUtil.getPersonDataMap(ctx, globalMap, beginDate, endDate, personIds);
                    globalMap.put("personDataMap", personDataMap);
                    Map<String, AttendanceProjectInfo> attendanceProjectMap = AtsSumSalaryUtil.getAttendanceProject(ctx);
                    globalMap.put("T_HR_ATS_AttendanceProject", attendanceProjectMap);
                    globalMap.put("attendPolicyId", filterItems.get("attendPolicyId"));
                    for (String proposerId : resMap.keySet()) {
                        List rws = (List)resMap.get(proposerId);
                        for (DataRow rw : rws) {
                            String condition = "FID ='" + rw.getString("FID") + "'";
                            ResultCal resultCal = new ResultCal(ctx, "T_HR_ATS_AttendanceResultSum", beginDate, endDate, condition, globalMap);
                            resultCal.run(filterItems.get("attendPolicyId"), proposerId, globalMap, rw.getString("FID"), sqls);
                        }
                    }
                }
            } else {
                LinkedBlockingQueue<Integer> queue = new LinkedBlockingQueue<Integer>();
                for (int loop = 1; loop <= loopTimes; ++loop) {
                    queue.put(loop);
                }
                ExecutorService pool = Executors.newCachedThreadPool();
                for (int i = 0; i < 5; ++i) {
                    pool.execute(new CalculateDynaCustomerResultThread(ctx, tempTableName, totalCount, queue, filterItems, globalMap));
                }
                pool.shutdown();
                while (!pool.isTerminated()) {
                    Thread.sleep(2000L);
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Call calculateSumResult() error!" + MLUtile.getRes(AtsFormulaResEnum.CallFail, ctx)));
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                if (StringUtils.isNotEmpty(tempTableName)) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                }
                throw throwable;
            }
        }
        if (StringUtils.isNotEmpty((String)tempTableName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        }
        logger.error((Object)("Call calculateSumResult cost" + MLUtile.getRes((ResourceEnum)AtsFormulaResEnum.CostTime, ctx, System.currentTimeMillis() - startTime)));
    }

    public String getAfterPagingSql(Context ctx, String sql, int rows, int page, int totalCount) throws SQLException {
        int length = rows;
        int dbType = AtsBaseUtils.getDbType(ctx);
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        PagingHelper pageHelper = new PagingHelper();
        String afterPagingSql = pageHelper.getPagingSqlNoOptmize(dbType, sql, (page - 1) * rows, length);
        return afterPagingSql;
    }

    private int getCount(Context ctx, String sql) {
        int totalCount = 0;
        try {
            String sqlt = "select count(1) " + sql.substring(sql.indexOf("FROM"), sql.indexOf("order"));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlt);
            totalCount = this.getTotalCount(rowSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return totalCount;
    }

    private int getTotalCount(IRowSet rowSet) throws SQLException {
        int totalCount = 0;
        while (rowSet.next()) {
            totalCount = rowSet.getInt(1);
        }
        return totalCount;
    }

    public void preparedGlobalMap(Context ctx, Map<Object, Object> globalMap, String beginDate, String endDate) throws BOSException, UuidException, SQLException {
        Map<String, HolidayPolicySetInfo> holidayPolicySetMap = AtsSumSalaryUtil.getAllHolidayPolicySet(ctx);
        globalMap.put("T_HR_ATS_HolidayPolicySet", holidayPolicySetMap);
        Map<String, HolidayPolicyInfo> holidayPolicyMap = AtsServerUtils.getAllHolidayPolicyInfo(ctx);
        globalMap.put("T_HR_ATS_HolidayPolicy", holidayPolicyMap);
        Map<String, AttencePolicyInfo> policyInfoMap = AtsSumSalaryUtil.getAttendancePolicyInfos(ctx);
        globalMap.put("T_HR_ATS_AttencePolicy", policyInfoMap);
        Map<String, AtsShiftInfo> atsShiftInfoMap = AtsSumSalaryUtil.getAtsShiftInfos(ctx);
        globalMap.put("T_HR_ATS_Shift", atsShiftInfoMap);
        Map<String, WorkCalendarInfo> WorkCalendarInfoMap = AtsSumSalaryUtil.getAllWorkCalendarInfo(ctx);
        globalMap.put("T_HR_ATS_WorkCalendar", WorkCalendarInfoMap);
        Map<String, WorkCalendarItemInfo> workItemMap = AtsServerCalUtils.getWorkCalendarItemInfoByGroupAndDate(ctx, beginDate, endDate);
        globalMap.put("workItemMap", workItemMap);
        Map<String, List<AttendancePeriodInfo>> attendancePeriodInfoListMap = AtsServerCalUtils.getAttendancePeriodInfos(ctx);
        globalMap.put("attendancePeriodInfoListMap", attendancePeriodInfoListMap);
    }
}

