/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.syn.AnalyzeAuthCfg;
import com.kingdee.eas.hr.ats.syn.AnalyzePunchCardSrcCfg;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SynchUtil {
    public static Connection getOuterConnection(String DBtype, String IP, String DB, int port, String username, String password) throws BOSException, SQLException, InterfaceDataBaseException {
        if (DBtype.equalsIgnoreCase("SQLserver")) {
            try {
                Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver").newInstance();
            }
            catch (InstantiationException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (IllegalAccessException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (ClassNotFoundException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            String url = "jdbc:microsoft:sqlserver://" + IP + ":" + port + ";databaseName=" + DB + "";
            DriverManager.setLoginTimeout(300);
            try {
                return DriverManager.getConnection(url, username, password);
            }
            catch (SQLException e1) {
                NumericExceptionSubItem src_conn_error = new NumericExceptionSubItem("001", e1.getMessage());
                throw new InterfaceDataBaseException(src_conn_error);
            }
        }
        if (DBtype.equalsIgnoreCase("oracle")) {
            try {
                Class.forName("oracle.jdbc.driver.OracleDriver").newInstance();
                String url = "jdbc:oracle:thin:@" + IP + ":" + port + ":" + DB + "";
                return DriverManager.getConnection(url, username, password);
            }
            catch (InstantiationException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (IllegalAccessException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (ClassNotFoundException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (SQLException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
        }
        if (DBtype.equalsIgnoreCase("db2")) {
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver").newInstance();
                String url = "jdbc:db2://" + IP + ":" + port + "/" + DB + "";
                Properties props = new Properties();
                props.setProperty("user", username);
                props.setProperty("password", password);
                return DriverManager.getConnection(url, props);
            }
            catch (InstantiationException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (IllegalAccessException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (ClassNotFoundException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
            catch (SQLException e) {
                throw new InterfaceDataBaseException(InterfaceDataBaseException.SRC_CONN_ERROR);
            }
        }
        return null;
    }

    public static EntityObjectInfo getEntityObjectByEntity(Context ctx, String entityName) {
        MetaDataPK entityPk = MetaDataPK.create((String)entityName);
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)entityPk);
    }

    public static Map<String, PersonPositionInfo> GetAllPersonPositionInfo(Context ctx) {
        try {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.getSelector().add(new SelectorItemInfo("person.id"));
            evi.getSelector().add(new SelectorItemInfo("person.number"));
            evi.getSelector().add(new SelectorItemInfo("person.name"));
            evi.getSelector().add(new SelectorItemInfo("personDep.id"));
            evi.getSelector().add(new SelectorItemInfo("personDep.number"));
            evi.getSelector().add(new SelectorItemInfo("personDep.name"));
            evi.getSelector().add(new SelectorItemInfo("primaryPosition.id"));
            evi.getSelector().add(new SelectorItemInfo("primaryPosition.number"));
            evi.getSelector().add(new SelectorItemInfo("primaryPosition.name"));
            evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.id"));
            evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.number"));
            evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.name"));
            SorterItemCollection sortColl = new SorterItemCollection();
            SorterItemInfo sEFFDT = new SorterItemInfo("EFFDT");
            sEFFDT.setSortType(SortType.ASCEND);
            sortColl.add(sEFFDT);
            evi.setSorter(sortColl);
            IPersonPosition personPosition = PersonPositionFactory.getLocalInstance((Context)ctx);
            PersonPositionCollection ppCollection = personPosition.getPersonPositionCollection(evi);
            HashMap<String, PersonPositionInfo> ppMap = new HashMap<String, PersonPositionInfo>();
            for (int i = 0; i < ppCollection.size(); ++i) {
                ppMap.put(ppCollection.get(i).getPerson().getId() == null ? "" : ppCollection.get(i).getPerson().getId().toString(), ppCollection.get(i));
            }
            return ppMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, PersonPositionInfo> GetAllPersonPositionInfo(Context ctx, String personIds) {
        try {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.getSelector().add(new SelectorItemInfo("person.id"));
            evi.getSelector().add(new SelectorItemInfo("person.number"));
            evi.getSelector().add(new SelectorItemInfo("person.name"));
            evi.getSelector().add(new SelectorItemInfo("personDep.id"));
            evi.getSelector().add(new SelectorItemInfo("personDep.number"));
            evi.getSelector().add(new SelectorItemInfo("personDep.name"));
            evi.getSelector().add(new SelectorItemInfo("primaryPosition.id"));
            evi.getSelector().add(new SelectorItemInfo("primaryPosition.number"));
            evi.getSelector().add(new SelectorItemInfo("primaryPosition.name"));
            evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.id"));
            evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.number"));
            evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.name"));
            SorterItemCollection sortColl = new SorterItemCollection();
            SorterItemInfo sEFFDT = new SorterItemInfo("EFFDT");
            sEFFDT.setSortType(SortType.ASCEND);
            sortColl.add(sEFFDT);
            evi.setSorter(sortColl);
            FilterInfo filter = new FilterInfo();
            Set<String> personIdSet = AtsUtil.toSet(personIds);
            filter.getFilterItems().add(new FilterItemInfo("person.id", personIdSet, CompareType.INCLUDE));
            evi.setFilter(filter);
            IPersonPosition personPosition = PersonPositionFactory.getLocalInstance((Context)ctx);
            PersonPositionCollection ppCollection = personPosition.getPersonPositionCollection(evi);
            HashMap<String, PersonPositionInfo> ppMap = new HashMap<String, PersonPositionInfo>();
            for (int i = 0; i < ppCollection.size(); ++i) {
                ppMap.put(ppCollection.get(i).getPerson().getId() == null ? "" : ppCollection.get(i).getPerson().getId().toString(), ppCollection.get(i));
            }
            return ppMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, PersonInfo> GetAllPersonInfo(Context ctx) {
        EntityViewInfo evi = new EntityViewInfo();
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo snumber = new SorterItemInfo("number");
        snumber.setSortType(SortType.ASCEND);
        sortColl.add(snumber);
        SorterItemInfo sEFFDT = new SorterItemInfo("EFFDT");
        sEFFDT.setSortType(SortType.ASCEND);
        sortColl.add(sEFFDT);
        evi.setSorter(sortColl);
        try {
            IPerson person = PersonFactory.getLocalInstance((Context)ctx);
            PersonCollection pCollection = person.getPersonCollection(evi);
            HashMap<String, PersonInfo> pMap = new HashMap<String, PersonInfo>();
            for (int i = 0; i < pCollection.size(); ++i) {
                pMap.put(pCollection.get(i).getNumber() == null ? "" : pCollection.get(i).getNumber().toString(), pCollection.get(i));
            }
            return pMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, PersonInfo> GetAllPersonInfo(Context ctx, String personIds) {
        EntityViewInfo evi = new EntityViewInfo();
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo snumber = new SorterItemInfo("number");
        snumber.setSortType(SortType.ASCEND);
        sortColl.add(snumber);
        SorterItemInfo sEFFDT = new SorterItemInfo("EFFDT");
        sEFFDT.setSortType(SortType.ASCEND);
        sortColl.add(sEFFDT);
        evi.setSorter(sortColl);
        FilterInfo filter = new FilterInfo();
        Set<String> personIdSet = AtsUtil.toSet(personIds);
        filter.getFilterItems().add(new FilterItemInfo("id", personIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        try {
            IPerson person = PersonFactory.getLocalInstance((Context)ctx);
            PersonCollection pCollection = person.getPersonCollection(evi);
            HashMap<String, PersonInfo> pMap = new HashMap<String, PersonInfo>();
            for (int i = 0; i < pCollection.size(); ++i) {
                pMap.put(pCollection.get(i).getNumber() == null ? "" : pCollection.get(i).getNumber().toString(), pCollection.get(i));
            }
            return pMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, PersonInfo> GetAllOpenID2Person(Context ctx) {
        HashMap<String, PersonInfo> map = new HashMap<String, PersonInfo>();
        String sql = " select t_pm_easxtusermap.fpersonid,t_pm_easxtusermap.fxtid,T_BD_Person.FNumber as fnumber,T_BD_Person.fname" + MLUtile.getMlFlag(ctx) + " as fname from t_pm_easxtusermap left join T_BD_Person on t_pm_easxtusermap.fpersonid=T_BD_Person.fid ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String fid = rowSet.getString("fpersonid");
                if (StringUtils.isEmpty((String)fid)) continue;
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)fid));
                personInfo.setName(rowSet.getString("fname"));
                personInfo.setNumber(rowSet.getString("fnumber"));
                map.put(rowSet.getString("fxtid"), personInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, PersonInfo> GetAllOpenID2Person(Context ctx, String personIds) {
        HashMap<String, PersonInfo> map = new HashMap<String, PersonInfo>();
        String sql = " select t_pm_easxtusermap.fpersonid,t_pm_easxtusermap.fxtid,T_BD_Person.FNumber as fnumber,T_BD_Person.fname" + MLUtile.getMlFlag(ctx) + " as fname from t_pm_easxtusermap left join T_BD_Person on t_pm_easxtusermap.fpersonid=T_BD_Person.fid ";
        sql = sql + "where t_pm_easxtusermap.fpersonid in ('" + personIds.replaceAll(",", "','") + "')";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String fid = rowSet.getString("fpersonid");
                if (StringUtils.isEmpty((String)fid)) continue;
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)fid));
                personInfo.setName(rowSet.getString("fname"));
                personInfo.setNumber(rowSet.getString("fnumber"));
                map.put(rowSet.getString("fxtid"), personInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, AttendanceFileInfo> GetAllOpenID2AttendanceFile(Context ctx) {
        HashMap<String, AttendanceFileInfo> map = new HashMap<String, AttendanceFileInfo>();
        String sql = " select t_pm_easxtusermap.fpersonid,t_pm_easxtusermap.fxtid,T_HR_ATS_AttendanceFile.FAdminOrgUnitId AS FAdminOrgUnitId, T_HR_ATS_AttendanceFile.FAttAdminOrgUnitId AS FAttAdminOrgUnitId,T_HR_ATS_AttendanceFile.FHrOrgUnitId AS FHrOrgUnitId, T_HR_ATS_AttendanceFile.FAttendanceNum as FAttendanceNum  from t_pm_easxtusermap left join T_HR_ATS_AttendanceFile on t_pm_easxtusermap.fpersonid=T_HR_ATS_AttendanceFile.fproposerid ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String fid = rowSet.getString("fpersonid");
                if (StringUtils.isEmpty((String)fid)) continue;
                AttendanceFileInfo attendanceFileInfo = new AttendanceFileInfo();
                attendanceFileInfo.setAttendanceNum(rowSet.getString("FAttendanceNum"));
                if (!StringUtils.isEmpty((String)rowSet.getString("FAdminOrgUnitId"))) {
                    AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                    adminOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FAdminOrgUnitId")));
                    attendanceFileInfo.setAdminOrgUnit(adminOrgUnitInfo);
                }
                if (!StringUtils.isEmpty((String)rowSet.getString("FAttAdminOrgUnitId"))) {
                    AdminOrgUnitInfo attAdminOrgUnitInfo = new AdminOrgUnitInfo();
                    attAdminOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FAttAdminOrgUnitId")));
                    attendanceFileInfo.setAttAdminOrgUnit(attAdminOrgUnitInfo);
                }
                if (!StringUtils.isEmpty((String)rowSet.getString("FHrOrgUnitId"))) {
                    HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
                    hrOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FHrOrgUnitId")));
                    attendanceFileInfo.setHrOrgUnit(hrOrgUnitInfo);
                }
                map.put(rowSet.getString("fxtid"), attendanceFileInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, AttendanceFileInfo> GetAllOpenID2AttendanceFile(Context ctx, String personIds) {
        HashMap<String, AttendanceFileInfo> map = new HashMap<String, AttendanceFileInfo>();
        String sql = " select t_pm_easxtusermap.fpersonid,t_pm_easxtusermap.fxtid,T_HR_ATS_AttendanceFile.FAdminOrgUnitId AS FAdminOrgUnitId, T_HR_ATS_AttendanceFile.FAttAdminOrgUnitId AS FAttAdminOrgUnitId,T_HR_ATS_AttendanceFile.FHrOrgUnitId AS FHrOrgUnitId, T_HR_ATS_AttendanceFile.FAttendanceNum as FAttendanceNum  from t_pm_easxtusermap left join T_HR_ATS_AttendanceFile on t_pm_easxtusermap.fpersonid=T_HR_ATS_AttendanceFile.fproposerid ";
        sql = sql + "where t_pm_easxtusermap.fpersonid in ('" + personIds.replaceAll(",", "','") + "')";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String fid = rowSet.getString("fpersonid");
                if (StringUtils.isEmpty((String)fid)) continue;
                AttendanceFileInfo attendanceFileInfo = new AttendanceFileInfo();
                attendanceFileInfo.setAttendanceNum(rowSet.getString("FAttendanceNum"));
                if (!StringUtils.isEmpty((String)rowSet.getString("FAdminOrgUnitId"))) {
                    AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                    adminOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FAdminOrgUnitId")));
                    attendanceFileInfo.setAdminOrgUnit(adminOrgUnitInfo);
                }
                if (!StringUtils.isEmpty((String)rowSet.getString("FAttAdminOrgUnitId"))) {
                    AdminOrgUnitInfo attAdminOrgUnitInfo = new AdminOrgUnitInfo();
                    attAdminOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FAttAdminOrgUnitId")));
                    attendanceFileInfo.setAttAdminOrgUnit(attAdminOrgUnitInfo);
                }
                if (!StringUtils.isEmpty((String)rowSet.getString("FHrOrgUnitId"))) {
                    HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
                    hrOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("FHrOrgUnitId")));
                    attendanceFileInfo.setHrOrgUnit(hrOrgUnitInfo);
                }
                map.put(rowSet.getString("fxtid"), attendanceFileInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, String> GetAllPersonID2OpenID(Context ctx) {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select fpersonid,fopenid from t_bd_hrxuntusermapping";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                map.put(rowSet.getString("fpersonid"), rowSet.getString("fopenid"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Set<String> GetAllCloudAttendPosition(Context ctx) {
        HashSet<String> set = new HashSet<String>();
        String sql = "select fid,fpositionname from T_HR_ATS_CloudAttendPosition ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                set.add(StringUtils.cnulls((String)rowSet.getString("fpositionname")).trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return set;
    }

    public static Map<String, String> GetPerson2OpenId(Context ctx) {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = " select t_pm_easxtusermap.fpersonid,t_pm_easxtusermap.fxtid from t_pm_easxtusermap ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String fid = rowSet.getString("fpersonid");
                if (StringUtils.isEmpty((String)fid)) continue;
                map.put(fid, rowSet.getString("fxtid"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, String> GetPerson2OpenId(Context ctx, String personIds) {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = " select t_pm_easxtusermap.fpersonid,t_pm_easxtusermap.fxtid from t_pm_easxtusermap ";
        sql = sql + "where t_pm_easxtusermap.fpersonid in ('" + personIds.replaceAll(",", "','") + "')";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String fid = rowSet.getString("fpersonid");
                if (StringUtils.isEmpty((String)fid)) continue;
                map.put(fid, rowSet.getString("fxtid"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static String GetCloudHubDNS(Context ctx) throws BOSException {
        Map<String, List<Map<String, String>>> srcListMapAll;
        List<Map<String, String>> openapiList;
        String resultString = "https://kingdee.yunzhijia.com";
        if (SynchUtil.isPrivteCloud() && (openapiList = (srcListMapAll = AnalyzePunchCardSrcCfg.getPunchCardSrcAll()).get("openapis")) != null && openapiList.size() > 0) {
            for (Map<String, String> openapimap : openapiList) {
                if (StringUtils.isEmpty((String)openapimap.get("url"))) continue;
                return openapimap.get("url");
            }
        }
        String sql = "select FSettingMsg from T_XT_SaveSetting ORDER BY FCreateTime DESC";
        try {
            String[] res;
            int to;
            int from;
            String subSetting;
            String setting;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next() && !StringUtils.isEmpty((String)(setting = rowSet.getString("FSettingMsg"))) && !StringUtils.isEmpty((String)(subSetting = setting.substring(from = setting.lastIndexOf("mCloud"), to = setting.indexOf(";", from)))) && (res = subSetting.split("==")).length >= 2) {
                resultString = res[1];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String fileAddr) throws IOException {
        File file = new File(fileAddr);
        if (!file.exists()) {
            return "";
        }
        StringBuffer datas = new StringBuffer();
        try (BufferedReader fr = null;){
            String line;
            fr = new BufferedReader(new FileReader(fileAddr));
            while ((line = fr.readLine()) != null) {
                datas.append(line + "\n");
            }
        }
        return datas.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String fileAddr, OutputStream out) {
        File file = new File(fileAddr);
        if (!file.exists()) {
            return;
        }
        BufferedReader fr = null;
        BufferedWriter bw = null;
        try {
            String line;
            fr = new BufferedReader(new FileReader(fileAddr));
            bw = new BufferedWriter(new OutputStreamWriter(out));
            while ((line = fr.readLine()) != null) {
                bw.write(line);
                bw.newLine();
            }
            bw.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean isPrivteCloud() throws BOSException {
        List<Map<String, String>> authConfigList = AnalyzeAuthCfg.getAuthSrc();
        if (authConfigList == null || authConfigList.size() == 0) {
            throw new BOSException("leak the verify file" + System.getProperty("EAS_HOME") + "/server/properties/hr_ats_authCfg.xml");
        }
        Map<String, String> authConfig = authConfigList.get(0);
        return !"4pfBE6TU5AcRyEAu".equals(authConfig.get("consumerkey"));
    }
}

