/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.fetch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.syn.SynchUtil;
import com.kingdee.eas.hr.ats.syn.SynchronizationContext;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractGetOuterData {
    protected EntityObjectInfo entityObject = null;
    protected Map<String, String> fieldMapping = null;

    protected abstract Map<String, Object> getOuterRowData(IRowSet var1) throws SQLException;

    public IRowSet getDataBySQLNoCloseConn(Connection connection, String sql, Object[] params) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ps = connection.prepareStatement(sql);
        for (int i = 0; params != null && i < params.length; ++i) {
            ps.setObject(i + 1, params[i]);
        }
        rs = ps.executeQuery();
        JdbcRowSet rowset = new JdbcRowSet();
        rowset.populate(rs);
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        return rowset;
    }

    protected Object getOuterData(SynchronizationContext synContext) throws EASBizException, BOSException {
        Statement statement = null;
        ResultSet rs = null;
        Connection outerConn = synContext.getOuterConn();
        Context ctx = synContext.getBosCtx();
        String entityName = synContext.getBizDataSynchConfigInfo().getEntity();
        ArrayList<Map<String, Object>> resultList = null;
        if (!StringUtils.isEmpty((String)entityName)) {
            this.entityObject = SynchUtil.getEntityObjectByEntity(ctx, entityName);
        }
        String sql = this.getSelectOutDataSql(synContext, null);
        this.fieldMapping = this.getFieldMapping(synContext.getBosCtx());
        try {
            statement = outerConn.createStatement();
            int totalcount = 0;
            String tmpSql = "";
            tmpSql = sql.lastIndexOf("order by") > 0 ? sql.substring(0, sql.lastIndexOf("order by")) : sql.toString();
            rs = statement.executeQuery(" select count(*) count1 from (" + tmpSql + ")  dataTable");
            if (rs.next()) {
                totalcount = rs.getInt("count1");
            }
            SQLUtils.cleanup((ResultSet)rs);
            rs = statement.executeQuery(sql.toString());
            int length = 10000;
            int alreadyread = 0;
            resultList = new ArrayList<Map<String, Object>>(totalcount);
            while (alreadyread <= totalcount) {
                JdbcRowSet rowset = new JdbcRowSet();
                rowset.populate(rs, length);
                alreadyread += length;
                Map<String, Object> rowMap = null;
                while (rowset.next()) {
                    rowMap = this.getOuterRowData((IRowSet)rowset);
                    if (rowMap == null) continue;
                    resultList.add(rowMap);
                }
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql5 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement);
        return resultList;
    }

    protected String getBosType() {
        return this.entityObject.getType().toString();
    }

    private Map<String, String> getFieldMapping(Context ctx) {
        if (this.entityObject == null) {
            return null;
        }
        HashMap<String, String> mapping = new HashMap<String, String>();
        PropertyCollection c = this.entityObject.getPropertiesRuntime();
        String key = null;
        String value = null;
        for (int i = 0; i < c.size(); ++i) {
            PropertyInfo property = c.get(i);
            if (property.getMappingField() == null) continue;
            key = property.getName();
            value = "true".equalsIgnoreCase((String)property.getStateManager().getStateValue("isMultilingual")) ? property.getMappingField().getName() + MLUtile.getMlFlag(ctx) : property.getMappingField().getName();
            mapping.put(value.toUpperCase(), key);
        }
        return mapping;
    }

    public Object getOuterData(SynchronizationContext synContext, Map<String, Object> paramMap) throws EASBizException, BOSException {
        return null;
    }

    public Object getOuterData(SynchronizationContext synContext, Object[] params, Map<String, String> topxMap) throws EASBizException, BOSException {
        Connection outerConn = synContext.getOuterConn();
        Context ctx = synContext.getBosCtx();
        String sql = this.getSelectOutDataSql(synContext, topxMap);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try {
            IRowSet rowSet = this.getDataBySQLNoCloseConn(outerConn, sql, params);
            Map<String, Object> rowMap = null;
            while (rowSet.next()) {
                rowMap = this.getOuterRowData(rowSet);
                if (rowMap == null) continue;
                resultList.add(rowMap);
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
        }
        return resultList;
    }

    public int getOuterDataCnt(SynchronizationContext synContext, Object[] params, Map<String, String> topxMap) throws EASBizException, BOSException {
        String cntSql = this.getSelectOutDataCntSql(synContext, topxMap);
        int totalcount = 0;
        try {
            IRowSet rowSet = this.getDataBySQLNoCloseConn(synContext.getOuterConn(), cntSql, params);
            if (rowSet.next()) {
                totalcount = rowSet.getInt("count1");
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : " + cntSql, (Throwable)exc);
        }
        return totalcount;
    }

    protected String getSelectOutDataSql(SynchronizationContext synContext, Map<String, String> topxMap) {
        String sql = synContext.getBizDataSynchConfigInfo().getSql();
        if (topxMap != null && topxMap.size() > 0) {
            for (String topx : topxMap.keySet()) {
                sql = sql.replaceAll(topx, topxMap.get(topx));
            }
        }
        return sql;
    }

    protected String getSelectOutDataCntSql(SynchronizationContext synContext, Map<String, String> topxMap) {
        String sql = "select count(*) as count1 from ( " + synContext.getBizDataSynchConfigInfo().getSql() + " ) ";
        if (topxMap != null && topxMap.size() > 0) {
            for (String topx : topxMap.keySet()) {
                sql = sql.replaceAll(topx, topxMap.get(topx));
            }
        }
        return sql;
    }
}

