/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.punchcard;

import com.alibaba.fastjson.JSON;
import com.kingdee.eas.hr.ats.AtsCludHubResEnum;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.PunchCardRecordFactory;
import com.kingdee.eas.hr.ats.PunchCardRecordInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.SignRecordFactory;
import com.kingdee.eas.hr.ats.SignRecordInfo;
import com.kingdee.eas.hr.ats.syn.punchcard.AbstractPunchCardSynProcessor;
import com.kingdee.eas.hr.ats.syn.punchcard.PunchcardHttpExecutor;
import com.kingdee.eas.hr.ats.syn.synch.ECloudInterface;
import com.kingdee.eas.hr.ats.syn.synch.PunchCardSynEnv;
import com.kingdee.eas.hr.ats.syn.synch.SynHelper;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PunchCardSynProcessor
extends AbstractPunchCardSynProcessor {
    private Logger logger = AtsLog.getPunchcardCloudLog();
    private String syncUrl;
    private PunchcardHttpExecutor httpExecutor;

    @Override
    protected PunchCardSynEnv createPunchCardSynEnv() {
        PunchCardSynEnv punchCardSynEnv = super.createPunchCardSynEnv();
        punchCardSynEnv.setCloudInterface(ECloudInterface.valueOfByUrl(this.getSyncUrl()));
        return punchCardSynEnv;
    }

    @Override
    protected void doSynchronizeByPage(PunchCardSynEnv punchCardSynEnv, String personPageSql) {
        boolean reInitPersonData = personPageSql == null;
        Timestamp curSynStartTimeStamp = (Timestamp)punchCardSynEnv.getWorkDateFrom().clone();
        while (curSynStartTimeStamp.before(punchCardSynEnv.getWorkDateTo())) {
            while (true) {
                if (this.getGlobalException() != null) {
                    return;
                }
                punchCardSynEnv.incTotalPage();
                this.logger.info((Object)("cur batch;total batch :" + punchCardSynEnv.getTotalPage() + ";batch in that day" + AtsDateUtils.dateShortToString(curSynStartTimeStamp) + ":" + punchCardSynEnv.getStart()));
                JSONArray outData = this.getOutData(punchCardSynEnv, curSynStartTimeStamp);
                this.updatePunchCardSynEnv(outData, punchCardSynEnv, reInitPersonData);
                this.saveData(punchCardSynEnv);
                if (reInitPersonData) {
                    punchCardSynEnv.setOpenIds(null);
                }
                if (outData == null || punchCardSynEnv.isNewListInterface() || outData.size() < punchCardSynEnv.getLimit() || punchCardSynEnv.getTotalPage() > 100000) break;
                punchCardSynEnv.setStart(punchCardSynEnv.getStart() + 1);
            }
            if (this.isFetchDataDayByDay()) {
                punchCardSynEnv.setStart(1);
                curSynStartTimeStamp.setTime(AtsCommonUtile.getDayStart(curSynStartTimeStamp).getTime());
                curSynStartTimeStamp.setTime(curSynStartTimeStamp.getTime() + 86400000L);
            } else {
                curSynStartTimeStamp = punchCardSynEnv.getWorkDateTo();
            }
            this.updateAttendanceLog(personPageSql);
        }
    }

    @Override
    protected JSONArray getOutData(PunchCardSynEnv punchCardSynEnv, Timestamp curSynStartTimeStamp) {
        Map<String, Object> paramMap4Get = this.getParamMap4Get(punchCardSynEnv, curSynStartTimeStamp);
        if (this.getHttpExecutor() == null) {
            this.setHttpExecutor(new PunchcardHttpExecutor());
        }
        this.getHttpExecutor().setUrl(this.getSyncUrl());
        this.getHttpExecutor().setParams(paramMap4Get);
        this.getHttpExecutor().setCtx(this.ctx);
        try {
            this.getHttpExecutor().processRequest();
            if (this.getHttpExecutor().isSuccess()) {
                return this.getHttpExecutor().getResult();
            }
        }
        catch (Exception e) {
            this.setGlobalException(e);
            this.add(MLUtile.getRes((ResourceEnum)AtsCludHubResEnum.item10, this.ctx, e.getMessage()));
            this.logger.error((Object)("fetch cloud data error:" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private Map<String, Object> getParamMap4Get(PunchCardSynEnv punchCardSynEnv, Timestamp curSynStartTimeStamp) {
        String startStr;
        String endStr;
        HashMap<String, Object> paramMap4Get = new HashMap<String, Object>();
        if (!punchCardSynEnv.isClockInterface() && StringUtils.isNotEmpty((String)punchCardSynEnv.getOpenIds())) {
            paramMap4Get.put("openIds", punchCardSynEnv.getOpenIds());
        }
        if (punchCardSynEnv.isNewListInterface()) {
            paramMap4Get.put("workDate", AtsCommonUtile.formateDate(curSynStartTimeStamp) + " 00:00:00");
            return paramMap4Get;
        }
        if (this.isFetchDataDayByDay()) {
            Date endDate = AtsCommonUtile.getDayEnd(curSynStartTimeStamp);
            endStr = AtsCommonUtile.formateTime(punchCardSynEnv.getWorkDateTo().before(endDate) ? punchCardSynEnv.getWorkDateTo() : endDate);
            startStr = AtsCommonUtile.formateTime(curSynStartTimeStamp);
        } else {
            endStr = AtsCommonUtile.formateTime(punchCardSynEnv.getWorkDateTo());
            startStr = AtsCommonUtile.formateTime(punchCardSynEnv.getWorkDateFrom());
        }
        paramMap4Get.put(punchCardSynEnv.isClockInterface() ? "beginDate" : "workDateFrom", startStr);
        paramMap4Get.put(punchCardSynEnv.isClockInterface() ? "endDate" : "workDateTo", endStr);
        paramMap4Get.put("start", punchCardSynEnv.getStart());
        paramMap4Get.put("limit", punchCardSynEnv.getLimit());
        return paramMap4Get;
    }

    @Override
    protected void updatePunchCardSynEnv(JSONArray recordsJsonArr, PunchCardSynEnv punchCardSynEnv, boolean initPersonData) {
        this.logger.info((Object)("dataSize=" + (recordsJsonArr == null ? 0 : recordsJsonArr.size())));
        if (recordsJsonArr == null || recordsJsonArr.size() == 0) {
            return;
        }
        punchCardSynEnv.addCloudTotalSize(recordsJsonArr.size());
        if (initPersonData) {
            try {
                com.alibaba.fastjson.JSONArray array = JSON.parseArray((String)recordsJsonArr.toString());
                String openidField = ((com.alibaba.fastjson.JSONObject)array.get(0)).containsKey((Object)"openId") ? "openId" : "userId";
                this.initPunchcardSynEnv(punchCardSynEnv, AtsCollectionUtile.conectProperty(array, openidField), !initPersonData);
            }
            catch (Exception e) {
                this.add(MLUtile.getRes((ResourceEnum)AtsCommonResEnum.InitFail, this.ctx, "punchCardSynEnv", ":" + e.getMessage()));
                this.logger.error((Object)("punchCardSynEnv init error:" + e.getMessage()), (Throwable)e);
                return;
            }
        }
        for (int i = 0; i < recordsJsonArr.size(); ++i) {
            JSONObject json = recordsJsonArr.getJSONObject(i);
            PunchCardRecordInfo crdInfo = SynHelper.assemblePunchCardRecordInfo(json, punchCardSynEnv);
            if (crdInfo.getProposer() == null) {
                punchCardSynEnv.getPersonNotExistData().add((Object)json);
                if (json.containsKey((Object)"openId")) {
                    punchCardSynEnv.getNotFoundPersonSet().add(json.getString("userName") + "[openId:" + json.getString("openId") + "]");
                    continue;
                }
                punchCardSynEnv.getNotFoundPersonSet().add(json.getString("userName") + "[workNum:" + json.getString("workNum") + "]");
                continue;
            }
            if (this.isNormalCard(json)) {
                punchCardSynEnv.addPunchCard(crdInfo);
                continue;
            }
            crdInfo.setOutSide(true);
            SignRecordInfo signRecordInfo = SynHelper.assembleSignRecordInfo(json, punchCardSynEnv);
            if (this.isNoNetPhotoAsNormalCard() && json.containsKey((Object)"approveResult") && StringUtils.isEmpty((String)json.getString("approveResult"))) {
                if (json.containsKey((Object)"photoId") && StringUtils.isNotEmpty((String)json.getString("photoId"))) {
                    if (json.containsKey((Object)"clockInType") && StringUtils.isNotEmpty((String)json.getString("clockInType")) && json.getString("clockInType").equals("photoInner")) {
                        punchCardSynEnv.addPunchCard(crdInfo);
                        continue;
                    }
                    punchCardSynEnv.addSignRcd(signRecordInfo);
                    if (!this.isHandled(json)) continue;
                    punchCardSynEnv.addPunchCard(crdInfo);
                    continue;
                }
                punchCardSynEnv.addSignRcd(signRecordInfo);
                continue;
            }
            punchCardSynEnv.addSignRcd(signRecordInfo);
            if (!this.isHandled(json)) continue;
            punchCardSynEnv.addPunchCard(crdInfo);
        }
    }

    @Override
    protected void initPunchcardSynEnv(PunchCardSynEnv punchCardSynEnv, String ids, boolean idIsPersonId) throws Exception {
        if (StringUtils.isEmpty((String)ids)) {
            return;
        }
        Map<String, String> allPerson2OpenIdMap = SynHelper.GetPerson2OpenId(this.ctx, ids, idIsPersonId);
        StringBuffer openIdsb = new StringBuffer();
        Iterator<Map.Entry<String, String>> it = allPerson2OpenIdMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (StringUtils.isNotEmpty((String)entry.getValue())) {
                openIdsb.append(entry.getValue()).append(",");
                continue;
            }
            it.remove();
        }
        if (openIdsb.length() == 0) {
            punchCardSynEnv.setOpenIds("");
            return;
        }
        punchCardSynEnv.setOpenIds(openIdsb.substring(0, openIdsb.length() - 1));
        Set<String> personIdSet = allPerson2OpenIdMap.keySet();
        punchCardSynEnv.setpMap(SynHelper.GetAllPersonInfo(this.ctx, personIdSet));
        punchCardSynEnv.setPpMap(SynHelper.GetAllPersonPositionInfo(this.ctx, personIdSet));
        punchCardSynEnv.setAllOpenID2PersonMap(SynHelper.GetAllOpenID2Person(this.ctx, personIdSet));
        punchCardSynEnv.setAllOpenID2AttFileMap(SynHelper.GetAllOpenID2AttendanceFile(this.ctx, personIdSet));
        if (punchCardSynEnv.getPunchCardRecord() == null) {
            punchCardSynEnv.setPunchCardRecord(PunchCardRecordFactory.getLocalInstance(this.ctx));
        }
        if (punchCardSynEnv.getSignRecord() == null) {
            punchCardSynEnv.setSignRecord(SignRecordFactory.getLocalInstance(this.ctx));
        }
    }

    private boolean isUnhandle(JSONObject json) {
        JSONObject approveResult;
        if (json != null && json.containsKey((Object)"approveResult") && !json.getString("approveResult").equals("") && (approveResult = json.getJSONObject("approveResult")) != null && approveResult.containsKey((Object)"approveStatus")) {
            return "UNHANDLED".equalsIgnoreCase(approveResult.getString("approveStatus"));
        }
        return false;
    }

    private boolean isHandled(JSONObject json) {
        JSONObject approveResult;
        if (json != null && json.containsKey((Object)"approveResult") && !json.getString("approveResult").equals("") && (approveResult = json.getJSONObject("approveResult")) != null && approveResult.containsKey((Object)"approveStatus")) {
            return "HANDLED".equalsIgnoreCase(approveResult.getString("approveStatus"));
        }
        return false;
    }

    private boolean isNormalCard(JSONObject json) {
        if (json != null && json.containsKey((Object)"positionResult")) {
            return "Normal".equalsIgnoreCase(json.getString("positionResult"));
        }
        if (json != null && json.containsKey((Object)"attendanceQN")) {
            return "0".equalsIgnoreCase(json.getString("attendanceQN"));
        }
        return false;
    }

    @Override
    public PunchcardHttpExecutor getHttpExecutor() {
        return this.httpExecutor;
    }

    @Override
    public void setHttpExecutor(PunchcardHttpExecutor httpExecutor) {
        this.httpExecutor = httpExecutor;
    }

    @Override
    public String getSyncUrl() {
        return this.syncUrl;
    }

    @Override
    public void setSyncUrl(String syncUrl) {
        this.syncUrl = syncUrl;
    }
}

