/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.qyweixin;

import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AuditOpinionEnum;
import com.kingdee.eas.hr.ats.CardStateEnum;
import com.kingdee.eas.hr.ats.ComprehensiveType;
import com.kingdee.eas.hr.ats.PunchCardRecordInfo;
import com.kingdee.eas.hr.ats.PunchCardSourceEnum;
import com.kingdee.eas.hr.ats.PunchCardStateEnum;
import com.kingdee.eas.hr.ats.SignRecordInfo;
import com.kingdee.eas.hr.ats.syn.synch.PunchCardSynEnv;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;

public class QyWeixinParserHelper {
    public static PunchCardRecordInfo assemblePunchCardRecordInfo(JSONObject json, PunchCardSynEnv punchCardSynEnv) {
        PersonPositionInfo ppInfo;
        String openapikey = punchCardSynEnv.getOpenapikey();
        Timestamp nowTimestamp = punchCardSynEnv.getWorkDateTo();
        Map<String, PersonPositionInfo> ppMap = punchCardSynEnv.getPpMap();
        Map<String, PersonInfo> allOpenID2PersonMap = punchCardSynEnv.getAllOpenID2PersonMap();
        Map<String, AttendanceFileInfo> allOpenID2AttFileMap = punchCardSynEnv.getAllOpenID2AttFileMap();
        Map<String, PersonInfo> pMap = punchCardSynEnv.getpMap();
        PunchCardRecordInfo crdInfo = new PunchCardRecordInfo();
        String openID = "";
        String userId = "userid";
        if (json.containsKey((Object)userId)) {
            openID = json.getString(userId);
        }
        crdInfo.setEquipmentNum(openapikey);
        String time = "checkin_time";
        if (json.containsKey((Object)time) && !StringUtils.isEmpty((String)json.getString(time))) {
            crdInfo.setPunchCardTime(new Timestamp((long)json.getInt(time) * 1000L));
        } else {
            crdInfo.setPunchCardTime(Date.getTime(json.getString(time)));
        }
        if (json.containsKey((Object)time) && !StringUtils.isEmpty((String)json.getString(time))) {
            crdInfo.setPunchCardDate(Date.getDate(crdInfo.getPunchCardTime()));
        } else {
            crdInfo.setPunchCardDate(AtsDateUtils.dateShortFormatToDate(new Timestamp(json.getLong(time))));
        }
        String position = "location_detail";
        crdInfo.setPunchCardPlace(json.getString(position));
        crdInfo.setPunchCardSource(PunchCardSourceEnum.qyWeixin);
        String comprehensiveType = "checkin_type";
        if (json.containsKey((Object)comprehensiveType) && !"".equals(json.getString(comprehensiveType).trim())) {
            String comprehensiveTypeTmp = json.getString(comprehensiveType);
            ComprehensiveType type = "\u4e0a\u73ed\u6253\u5361".equals(comprehensiveTypeTmp) ? ComprehensiveType.onWork : ComprehensiveType.offWork;
            crdInfo.setComprehensiveType(type);
        }
        crdInfo.setPunchCardState(PunchCardStateEnum.normal);
        if (crdInfo.getProposer() != null && ppMap != null && (ppInfo = ppMap.get(crdInfo.getProposer().getId().toString())) != null) {
            crdInfo.setHrOrgUnit(ppInfo.getHrOrgUnit());
            crdInfo.setAdminOrgUnit(ppInfo.getPersonDep());
        }
        if (allOpenID2PersonMap != null && allOpenID2PersonMap.containsKey(openID)) {
            crdInfo.setProposer(allOpenID2PersonMap.get(openID));
            if (allOpenID2AttFileMap != null && allOpenID2AttFileMap.containsKey(openID) && allOpenID2AttFileMap.get(openID).getAttendanceNum() != null) {
                crdInfo.setAttendanceNum(allOpenID2AttFileMap.get(openID).getAttendanceNum());
                crdInfo.setHrOrgUnit(allOpenID2AttFileMap.get(openID).getHrOrgUnit());
                crdInfo.setAdminOrgUnit(allOpenID2AttFileMap.get(openID).getAdminOrgUnit());
                crdInfo.setAttAdminOrgUnit(allOpenID2AttFileMap.get(openID).getAttAdminOrgUnit());
            } else {
                crdInfo.setAttendanceNum(crdInfo.getProposer().getNumber());
            }
        }
        crdInfo.setCreateTime(nowTimestamp);
        crdInfo.setLastUpdateTime(nowTimestamp);
        return crdInfo;
    }

    public static SignRecordInfo assembleSignRecordInfo(JSONObject json, PunchCardSynEnv punchCardSynEnv) {
        String comprehensiveType;
        String time;
        String openapikey = punchCardSynEnv.getOpenapikey();
        Map<String, PersonPositionInfo> ppMap = punchCardSynEnv.getPpMap();
        Map<String, PersonInfo> allOpenID2PersonMap = punchCardSynEnv.getAllOpenID2PersonMap();
        HashMap pMap = new HashMap();
        Map<String, AttendanceFileInfo> allOpenID2AttFileMap = punchCardSynEnv.getAllOpenID2AttFileMap();
        SignRecordInfo crdInfo = new SignRecordInfo();
        String openID = "";
        String userId = "userid";
        if (json.containsKey((Object)userId)) {
            openID = json.getString(userId);
        }
        if (json.containsKey((Object)(time = "checkin_time")) && !StringUtils.isEmpty((String)json.getString(time))) {
            crdInfo.setSignTime(new Timestamp((long)json.getInt(time) * 1000L));
        } else {
            crdInfo.setSignTime(Date.getTime(json.getString(time)));
        }
        if (json.containsKey((Object)time) && !StringUtils.isEmpty((String)json.getString(time))) {
            crdInfo.setSignDate(Date.getDate(crdInfo.getSignTime()));
        } else {
            crdInfo.setSignDate(AtsDateUtils.stringToShortDate(json.getString(time)));
        }
        String position = "location_detail";
        crdInfo.setAddress(json.getString(position));
        if (allOpenID2PersonMap != null && allOpenID2PersonMap.containsKey(openID)) {
            crdInfo.setPerson(allOpenID2PersonMap.get(openID));
        }
        if (crdInfo.getPerson() != null) {
            PersonPositionInfo ppInfo;
            if (ppMap != null && (ppInfo = ppMap.get(crdInfo.getPerson().getId().toString())) != null) {
                crdInfo.setHrOrgUnit(ppInfo.getHrOrgUnit());
                crdInfo.setAdminOrg(ppInfo.getPersonDep());
            }
            if (allOpenID2AttFileMap != null && allOpenID2AttFileMap.containsKey(openID)) {
                crdInfo.setHrOrgUnit(allOpenID2AttFileMap.get(openID).getHrOrgUnit());
                crdInfo.setAdminOrg(allOpenID2AttFileMap.get(openID).getAdminOrgUnit());
                crdInfo.setAttAdminOrgUnit(allOpenID2AttFileMap.get(openID).getAttAdminOrgUnit());
            }
        }
        if (json.containsKey((Object)(comprehensiveType = "checkin_type")) && !"".equals(json.getString(comprehensiveType).trim())) {
            String comprehensiveTypeTmp = json.getString(comprehensiveType);
            ComprehensiveType type = "\u4e0a\u73ed\u6253\u5361".equals(comprehensiveTypeTmp) ? ComprehensiveType.onWork : ComprehensiveType.offWork;
            crdInfo.setComprehensiveType(type);
        }
        crdInfo.setCardState(CardStateEnum.normal);
        crdInfo.setAuditOpinion(AuditOpinionEnum.unaudited);
        crdInfo.setSignType(1);
        if (json.containsKey((Object)"remark")) {
            crdInfo.setNote(json.getString("remark"));
        }
        return crdInfo;
    }

    public static boolean isValid(JSONObject json) {
        String checkType = json.getString("checkin_type");
        List<String> legalCheckType = Arrays.asList("\u4e0a\u73ed\u6253\u5361", "\u4e0b\u73ed\u6253\u5361", "\u5916\u51fa\u6253\u5361");
        if (null == checkType || !legalCheckType.contains(checkType)) {
            return false;
        }
        return !json.has("exception_type") || !"\u672a\u6253\u5361".equals(json.getString("exception_type"));
    }
}

