/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsHolidayFileCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AtsHolidayFileInfo;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.IAtsHolidayFile;
import com.kingdee.eas.hr.ats.IAtsHolidayFileHis;
import com.kingdee.eas.hr.ats.biz.util.AtsBizUtil;
import com.kingdee.eas.hr.ats.bizmanage.MessageConfirm.Util.AtsDealMsgConfirmTool;
import com.kingdee.eas.hr.ats.bizmanage.MessageConfirm.impl.AtHolidayFilePosAddMsgDeal;
import com.kingdee.eas.hr.ats.bizmanage.MessageConfirm.impl.AtsHolidayFileUndoMsgDeal;
import com.kingdee.eas.hr.ats.bizmanage.MessageConfirm.impl.AtsPosAddMsgDeal;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.bizmanage.HRBizDefineTypeEnum;
import com.kingdee.shr.base.bizmanage.IPersonBURelation;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmInfo;
import com.kingdee.shr.base.bizmanage.PersonBURelationFactory;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AtsDealHolidayBUConfirmUtil {
    private static Logger logger = Logger.getLogger(AtsDealHolidayBUConfirmUtil.class);

    public static void confirmAndCreateFile(Context ctx, Map<String, PersonBURelaConfirmInfo> personBURelaConfirmInfoMap, Map<String, AtsHolidayFileInfo> holidayFileInfoMap, String existedDataWay) throws BOSException, EASBizException {
        AtsPosAddMsgDeal atsPosAddMsgDeal = new AtsPosAddMsgDeal();
        IAtsHolidayFile iAtsHolidayFile = AtsHolidayFileFactory.getLocalInstance(ctx);
        IAtsHolidayFileHis iAtsHolidayFileHis = AtsHolidayFileHisFactory.getLocalInstance(ctx);
        for (Map.Entry<String, PersonBURelaConfirmInfo> entry : personBURelaConfirmInfoMap.entrySet()) {
            PersonBURelaConfirmInfo personBURelaConfirmInfo = entry.getValue();
            Date changeDate = personBURelaConfirmInfo.getChangeDate();
            AtsHolidayFileInfo holidayFileInfo = holidayFileInfoMap.get(entry.getKey());
            if (holidayFileInfo != null) {
                personBURelaConfirmInfo.setNewHrOrgUnit(holidayFileInfo.getHrOrgUnit());
                personBURelaConfirmInfo.setChangeDate(holidayFileInfo.getEFFDT());
            }
            String personId = personBURelaConfirmInfo.getPerson().getId().toString();
            String bizType = personBURelaConfirmInfo.getBizManageType().getId().toString();
            if (HRBizDefineTypeEnum.ENROLLADJUST.equals((Object)personBURelaConfirmInfo.getBizDefineType())) {
                String empOrgRelId = personBURelaConfirmInfo.getNewEmpOrgRelation().getId().toString();
                EmpPosOrgRelationInfo empPosOrgRelationInfo = AtsBizUtil.getEmpPosOrgRelationbyPersonBURelation(ctx, empOrgRelId);
                AtHolidayFilePosAddMsgDeal.doAdjust(ctx, personBURelaConfirmInfo, empPosOrgRelationInfo, personId, iAtsHolidayFileHis, null);
            } else {
                String oql = "where person.id = '" + personId + "' and state = 1 and bizManageType.id = '" + bizType + "'";
                IPersonBURelation iPersonBURelation = PersonBURelationFactory.getLocalInstance((Context)ctx);
                PersonBURelationInfo beforePersonBURelationInfo = null;
                try {
                    beforePersonBURelationInfo = iPersonBURelation.getPersonBURelationInfo(oql);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PersonBURelationInfo afterPersonBURelationInfo = null;
                if (beforePersonBURelationInfo != null) {
                    PersonBURelationInfo tempPersonBURelationInfo = AtsPosAddMsgDeal.assembleOnePersonBURelationInfo(ctx, personBURelaConfirmInfo);
                    afterPersonBURelationInfo = atsPosAddMsgDeal.comparePersonBURelation(ctx, tempPersonBURelationInfo, beforePersonBURelationInfo, personBURelaConfirmInfo);
                } else {
                    afterPersonBURelationInfo = AtsPosAddMsgDeal.assembleOnePersonBURelationInfo(ctx, personBURelaConfirmInfo);
                    IObjectPK iObjectPK = PersonBURelationFactory.getLocalInstance((Context)ctx).addnew(afterPersonBURelationInfo);
                    afterPersonBURelationInfo.setId(BOSUuid.read((String)iObjectPK.toString()));
                }
                if (HRBizDefineTypeEnum.UNDO.equals((Object)personBURelaConfirmInfo.getBizDefineType())) {
                    AtsHolidayFileUndoMsgDeal atsHolidayFileUndoMsgDeal = new AtsHolidayFileUndoMsgDeal();
                    atsHolidayFileUndoMsgDeal.undoFileDeal(ctx, personBURelaConfirmInfo, null);
                } else {
                    if (holidayFileInfo == null) {
                        logger.debug((Object)MessageFormat.format("holidayFileInfo is null.key={0},holidayFileInfoMap={1}", entry.getKey(), holidayFileInfoMap));
                        continue;
                    }
                    holidayFileInfo.setManageRelation(afterPersonBURelationInfo);
                    String olq = "where proposer.id = '" + personId + "'";
                    AtsHolidayFileCollection coll = iAtsHolidayFile.getAtsHolidayFileCollection(olq);
                    AtsHolidayFileInfo atsHolidayFileInfo = null;
                    if (coll.size() > 0) {
                        atsHolidayFileInfo = coll.get(0);
                        if (holidayFileInfo.getEFFDT().getTime() > atsHolidayFileInfo.getEFFDT().getTime()) {
                            if (atsHolidayFileInfo != null) {
                                AtsBizUtil.assembleAttendanceHolidayFileInfo(ctx, atsHolidayFileInfo, holidayFileInfo);
                                AtsBizUtil.dealAttendanceHisHolidayFileInfo(ctx, atsHolidayFileInfo);
                                iAtsHolidayFileHis.addnew(AtsBizUtil.generateHolidayHis(ctx, atsHolidayFileInfo));
                                iAtsHolidayFile.save((CoreBaseInfo)atsHolidayFileInfo);
                            }
                        } else {
                            String effdtDate = AtsDateUtils.dateShortToString(holidayFileInfo.getEFFDT());
                            AtsHolidayFileHisCollection fileHISColl = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection("where proposer.id = '" + personId + "' and effdt <= {ts '" + effdtDate + "'} and leffdt >= {ts '" + effdtDate + "'}");
                            AtsHolidayFileHisCollection fileHISAfterColl = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection("where proposer.id = '" + personId + "' and effdt > {ts '" + effdtDate + "'} order by effdt asc");
                            if (fileHISColl.size() > 0) {
                                AtsHolidayFileHisInfo hisInfo = fileHISColl.get(0);
                                if (hisInfo.getEFFDT().getTime() == holidayFileInfo.getEFFDT().getTime()) {
                                    holidayFileInfo.setId(atsHolidayFileInfo.getId());
                                    holidayFileInfo.setAttendFileState(AttendFileStateEnum.enable);
                                    holidayFileInfo.setLEFFDT(AtsDateUtils.stringToShortDate("2099-12-31"));
                                    AtsHolidayFileHisInfo tempHisInfo = AtsBizUtil.generateHolidayHis(ctx, holidayFileInfo);
                                    tempHisInfo.setId(hisInfo.getId());
                                    iAtsHolidayFileHis.save((CoreBaseInfo)tempHisInfo);
                                    iAtsHolidayFile.save((CoreBaseInfo)holidayFileInfo);
                                } else {
                                    AtsHolidayFileHisInfo inserHISInfo = AtsBizUtil.generateHolidayHis(ctx, holidayFileInfo);
                                    if (fileHISAfterColl.size() > 0) {
                                        inserHISInfo.setLEFFDT(AtsDateUtils.getPreDay(fileHISAfterColl.get(0).getEFFDT()));
                                    } else {
                                        inserHISInfo.setLEFFDT(hisInfo.getLEFFDT());
                                    }
                                    AtsDealMsgConfirmTool.insertPersonBURelation(ctx, inserHISInfo, personBURelaConfirmInfo);
                                    iAtsHolidayFileHis.addnew(inserHISInfo);
                                    hisInfo.setLEFFDT(AtsDateUtils.getPreDay(holidayFileInfo.getEFFDT()));
                                    iAtsHolidayFileHis.save((CoreBaseInfo)hisInfo);
                                }
                            } else {
                                AtsHolidayFileHisInfo inserHISInfo = AtsBizUtil.generateHolidayHis(ctx, holidayFileInfo);
                                if (fileHISAfterColl.size() > 0) {
                                    inserHISInfo.setLEFFDT(AtsDateUtils.getPreDay(fileHISAfterColl.get(0).getEFFDT()));
                                    AtsDealMsgConfirmTool.insertPersonBURelation(ctx, inserHISInfo, personBURelaConfirmInfo);
                                    iAtsHolidayFileHis.addnew(inserHISInfo);
                                }
                            }
                        }
                    } else {
                        holidayFileInfo.setAttendFileState(AttendFileStateEnum.enable);
                        holidayFileInfo.setLEFFDT(AtsDateUtils.stringToShortDate("2099-12-31"));
                        iAtsHolidayFileHis.addnew(AtsBizUtil.generateHolidayHis(ctx, holidayFileInfo));
                        iAtsHolidayFile.save((CoreBaseInfo)holidayFileInfo);
                    }
                }
            }
            personBURelaConfirmInfo.setChangeDate(changeDate);
            atsPosAddMsgDeal.DealMessConfirm(ctx, personBURelaConfirmInfo);
            if (!StringUtils.isEmpty((String)existedDataWay)) continue;
            AtsHolidayFileHisInfo currentHolidayFileHISInfo = AtsBizUtil.getCurrentHolidayFileHISInfo(personId, iAtsHolidayFileHis, personBURelaConfirmInfo.getChangeDate(), personBURelaConfirmInfo.getChangeDate());
            HashMap<String, AtsHolidayFileHisInfo> currHolidayHisInfoMap = new HashMap<String, AtsHolidayFileHisInfo>();
            currHolidayHisInfoMap.put("personBURelaConfirmInfo", currentHolidayFileHISInfo);
            AtsDealHolidayBUConfirmUtil.dealExistedData(ctx, existedDataWay, currHolidayHisInfoMap);
        }
    }

    public static void dealExistedData(Context ctx, String existedDataWay, Map<String, AtsHolidayFileHisInfo> currHolidayHisInfoMap) throws EASBizException, BOSException {
        if (currHolidayHisInfoMap.size() < 1) {
            return;
        }
        if (StringUtils.isEmpty((String)existedDataWay)) {
            return;
        }
        if (existedDataWay.equals("ignore")) {
            return;
        }
        for (Map.Entry<String, AtsHolidayFileHisInfo> currHolidayHisInfo : currHolidayHisInfoMap.entrySet()) {
            if (existedDataWay.contains("disapprove")) {
                AtsDealHolidayBUConfirmUtil.disapproveExistedDataByDate(ctx, currHolidayHisInfo.getValue());
                continue;
            }
            AtsDealHolidayBUConfirmUtil.updateExistedDataByDate(ctx, currHolidayHisInfo.getValue());
        }
    }

    private static Map disapproveExistedDataByDate(Context ctx, AtsHolidayFileHisInfo currHolidayHisInfo) throws EASBizException, BOSException {
        String personId = currHolidayHisInfo.getProposer().getId().toString();
        Date beginDate = currHolidayHisInfo.getEFFDT();
        Date endDate = currHolidayHisInfo.getLEFFDT();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("personId", personId);
        map.put("startDate", AtsDateUtils.dateShortToString(beginDate));
        map.put("endDate", AtsDateUtils.dateShortToString(endDate));
        OSFAppUtil osfUtil = new OSFAppUtil();
        String serviceName = "disHolidayBillByDateOSF";
        OSFAppUtil.callService((Context)ctx, (String)serviceName, map);
        serviceName = "abortHolidayBillByDateOSF";
        OSFAppUtil.callService((Context)ctx, (String)serviceName, map);
        return null;
    }

    private static Map updateExistedDataByDate(Context ctx, AtsHolidayFileHisInfo atsHolidayFileHisInfo) throws BOSException {
        String personId = atsHolidayFileHisInfo.getProposer().getId().toString();
        Date beginDate = atsHolidayFileHisInfo.getEFFDT();
        Date endDate = atsHolidayFileHisInfo.getLEFFDT();
        String adminOrgUnitId = atsHolidayFileHisInfo.getAdminOrgUnit().getId().toString();
        String positionId = atsHolidayFileHisInfo.getPosition().getId().toString();
        String hrOrgUnitId = atsHolidayFileHisInfo.getHrOrgUnit().getId().toString();
        String leaBillEntry = " update T_HR_ATS_LeaveBillEntry set FAdminOrgUnitID = '" + adminOrgUnitId + "',  FPositionID = '" + positionId + "' where FPersonID = '" + personId + "'  and frealBeginTime >= " + AtsDateUtils.tsDateStr(beginDate) + "  and frealEndTime <= " + AtsDateUtils.tsDateStr(endDate);
        DbUtil.execute((Context)ctx, (String)leaBillEntry);
        String leaveBillId = " select distinct bill0.fid as billId from T_HR_ATS_LeaveBill bill0  inner join  ( select bill.fid from T_HR_ATS_LeaveBill bill   where  ( select count(distinct entry.fpersonid) from T_HR_ATS_LeaveBillEntry entry where entry.fbillid = bill.fid ) = 1  ) tmp on bill0.fid = tmp.fid  inner join T_HR_ATS_LeaveBillEntry entry on bill0.fid = entry.fbillid  where entry.fpersonid ='" + personId + "'  and  exists (select * from T_HR_ATS_LeaveBillEntry entry    where entry.fbillid = bill0.fid and ((entry.FrealBeginTime > " + AtsDateUtils.tsDateStr(beginDate) + " and entry.frealEndTime < " + AtsDateUtils.tsDateStr(endDate) + "  ) or entry.FrealBeginTime is null) ) ";
        String leaBill = " update T_HR_ATS_LeaveBill set FHrOrgUnitId = '" + hrOrgUnitId + "' where fid in (" + leaveBillId + ") ";
        DbUtil.execute((Context)ctx, (String)leaBill);
        String canLeaBillEntry = " update T_HR_ATS_CanLeaveBillEntry set FAdminOrgUnitID = '" + adminOrgUnitId + "',  FPositionID = '" + positionId + "' where FPersonID = '" + personId + "'  and frealLeaBeginTime >= " + AtsDateUtils.tsDateStr(beginDate) + "  and frealLeaEndTime <= " + AtsDateUtils.tsDateStr(endDate);
        DbUtil.execute((Context)ctx, (String)canLeaBillEntry);
        String canLeaBillId = " select distinct bill0.fid as billId from T_HR_ATS_CanLeaveBill bill0  inner join  ( select bill.fid from T_HR_ATS_CanLeaveBill bill   where  ( select count(distinct entry.fpersonid) from T_HR_ATS_CanLeaveBillEntry entry where entry.fbillid = bill.fid ) = 1  ) tmp on bill0.fid = tmp.fid  inner join T_HR_ATS_CanLeaveBillEntry entry on bill0.fid = entry.fbillid  where entry.fpersonid ='" + personId + "'  and  exists (select * from T_HR_ATS_CanLeaveBillEntry entry    where entry.fbillid = bill0.fid and ((entry.FrealLeaBeginTime > " + AtsDateUtils.tsDateStr(beginDate) + " and frealLeaEndTime < " + AtsDateUtils.tsDateStr(endDate) + "  ) or entry.FrealLeaBeginTime is null) ) ";
        String canLeaBill = " update T_HR_ATS_CanLeaveBill set FHrOrgUnitId = '" + hrOrgUnitId + "' where fid in (" + canLeaBillId + ") ";
        DbUtil.execute((Context)ctx, (String)canLeaBill);
        String limit = " update T_HR_ATS_HolidayLimit set FAdminOrgUnitID = '" + adminOrgUnitId + "',  FPositionID = '" + positionId + "', FHrOrgUnitId = '" + hrOrgUnitId + "' where FProposerID = '" + personId + "'  and fcycleBeginDate >= " + AtsDateUtils.tsDateStr(beginDate) + "  and fcycleEndDate <= " + AtsDateUtils.tsDateStr(endDate);
        DbUtil.execute((Context)ctx, (String)limit);
        String toLimit = " update T_ATS_OTtoTakeWorkDetail set FAdminOrgUnitID = '" + adminOrgUnitId + "',  FPositionID = '" + positionId + "', FHrOrgUnitId = '" + hrOrgUnitId + "' where FProposerID = '" + personId + "'  and fperiodStart >= " + AtsDateUtils.tsDateStr(beginDate) + "  and fperiodEnd <= " + AtsDateUtils.tsDateStr(endDate);
        DbUtil.execute((Context)ctx, (String)toLimit);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        String periodBegin = sdf.format(beginDate);
        String periodEnd = sdf.format(beginDate);
        String toholidayResultSum = "UPDATE T_ATS_HolidayResultSum SET FHROrgUnitId = '" + hrOrgUnitId + "',FAdminOrgUnitId = '" + adminOrgUnitId + "',FPositionId='" + positionId + "' where  FProposerId = '" + personId + "' AND Fperiod >= '" + periodBegin + "' and Fperiod <= '" + periodEnd + "'";
        DbUtil.execute((Context)ctx, (String)toholidayResultSum);
        return null;
    }
}

