/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.CancelLeaveBillEntryCollection;
import com.kingdee.eas.hr.ats.CancelLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.CancelLeaveBillFactory;
import com.kingdee.eas.hr.ats.CancelLeaveBillInfo;
import com.kingdee.eas.hr.ats.HolidayLimitBillTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitChangeType;
import com.kingdee.eas.hr.ats.HolidayLimitDetailFactory;
import com.kingdee.eas.hr.ats.HolidayLimitDetailInfo;
import com.kingdee.eas.hr.ats.HolidayLimitDetailStatusEnum;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.hr.ats.LeavebillCancelEnum;
import com.kingdee.eas.hr.ats.app.AtsLeaveBillEntryControllerBean;
import com.kingdee.eas.hr.ats.app.HolidayLimitDetailControllerBean;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogUtil;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.IDecimalPlaceStrategy;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationSystem;
import com.kingdee.eas.hr.ats.util.AtsLeaveBillLimitServer;
import com.kingdee.eas.hr.ats.util.SHRBillServerUtil;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class CancelLeaveBillLimitServer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.util.AtsLeaveBillLimitServer");
    private IDecimalPlaceStrategy decimalPlacesSystem = new DecimalPlaceOperationSystem();

    public CancelLeaveBillLimitServer() {
        if (this.decimalPlacesSystem == null) {
            this.decimalPlacesSystem = new DecimalPlaceOperationSystem();
        }
    }

    public int operatorYearVacationLimit(Context ctx, BOSUuid billId) throws EASBizException, BOSException, SQLException {
        CancelLeaveBillInfo billInfo = CancelLeaveBillFactory.getLocalInstance(ctx).getCancelLeaveBillInfo((IObjectPK)new ObjectUuidPK(billId.toString()));
        BOSUuid atsLeaveBillId = billInfo.getEntries().get(0).getLeavebill().getId();
        ctx.put((Object)(billInfo.getId().toString() + "_OperType"), (Object)"cancelLeaveBill");
        ctx.put((Object)(billInfo.getId().toString() + "_OperAction"), (Object)"approved");
        AtsLeaveBillLimitServer atslimitServer = new AtsLeaveBillLimitServer();
        atslimitServer.rollBackLimitBysubmitEffect(ctx, atsLeaveBillId);
        AtsLeaveBillLimitServer leaveBillLimitServer = new AtsLeaveBillLimitServer();
        leaveBillLimitServer.updateLimitFromCancelLeaveBillBysubmitEffect(ctx, billId);
        ctx.remove((Object)(billInfo.getId().toString() + "_OperType"));
        ctx.remove((Object)(billInfo.getId().toString() + "_OperAction"));
        return 0;
    }

    public CancelLeaveBillEntryCollection getCancelLeaveBillColl(Context ctx, CancelLeaveBillInfo billInfo, AtsLeaveBillInfo leavebilllInfo) throws BOSException, EASBizException, SQLException {
        String personId = billInfo.getEntries().get(0).getPerson().getId().toString();
        String leavebillid = leavebilllInfo.getId().toString();
        String sql_query = "   select bill.*,entry.*  from T_HR_ATS_CanLeaveBill bill  left join  T_HR_ATS_CanLeaveBillEntry entry  on bill.fid = entry.fbillid  where entry.fpersonid='" + personId + "'  and   FLeavebillID = '" + leavebillid + "'  and   bill.fbillstate != 4 ";
        IRowSet row = null;
        row = DbUtil.executeQuery((Context)ctx, (String)sql_query);
        CancelLeaveBillEntryCollection canCollection = new CancelLeaveBillEntryCollection();
        while (row.next()) {
            CancelLeaveBillEntryInfo entryInfo = new CancelLeaveBillEntryInfo();
            entryInfo.setRealLeaLength(row.getBigDecimal("FRealLeaLength"));
            entryInfo.setRealLeaBeginTime(row.getTimestamp("FRealLeaBeginTime"));
            entryInfo.setRealLeaEndTime(row.getTimestamp("FRealLeaEndTime"));
            canCollection.add(entryInfo);
        }
        return canCollection;
    }

    public void updateLeaveBillInfoData(Context ctx, CancelLeaveBillInfo billInfo) throws BOSException, EASBizException, SQLException {
        AtsLeaveBillEntryControllerBean leaveEntryControllerBean = new AtsLeaveBillEntryControllerBean();
        CoreBaseCollection coll = new CoreBaseCollection();
        AtsLeaveBillEntryInfo leavebilllInfo = billInfo.getEntries().get(0).getLeaveEntryBill();
        AtsLeaveBillEntryInfo entryinfos = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo("select *,bill.number where id = '" + leavebilllInfo.getId().toString() + "' ");
        AtsLeaveBillEntryInfo oldEntryInfo = (AtsLeaveBillEntryInfo)entryinfos.clone();
        AtsLeaveBillInfo info = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo(" where id = '" + entryinfos.getBill().getId().toString() + "' ");
        AtsLeaveBillEntryInfo entryinfo = oldEntryInfo;
        CancelLeaveBillEntryCollection collection = this.getCancelLeaveBillColl(ctx, billInfo, info);
        if (collection.size() == 1) {
            entryinfo.setRealBeginTime(billInfo.getEntries().get(0).getRealLeaBeginTime());
            entryinfo.setRealEndTime(billInfo.getEntries().get(0).getRealLeaEndTime());
            entryinfo.setRealLeaveLength(billInfo.getEntries().get(0).getRealLeaLength());
            entryinfo.setIsCancelLeave(LeavebillCancelEnum.hascancel);
        } else {
            entryinfo.setRealBeginTime(billInfo.getEntries().get(0).getRealLeaBeginTime());
            entryinfo.setRealEndTime(billInfo.getEntries().get(0).getRealLeaEndTime());
            entryinfo.setRealLeaveLength(billInfo.getEntries().get(0).getRealLeaLength());
            entryinfo.setIsCancelLeave(LeavebillCancelEnum.hascancel);
        }
        coll.add((CoreBaseInfo)entryinfo);
        leaveEntryControllerBean.update(ctx, coll);
        DataLogUtil.addLogObserverToCenter(ctx, oldEntryInfo, entryinfo);
    }

    protected void updateHolidayLimitInfoData(Context ctx, Map<String, Object> mapBalance, CancelLeaveBillInfo billInfo) throws BOSException, EASBizException {
        HolidayLimitDetailControllerBean detailControllerBean = new HolidayLimitDetailControllerBean();
        AtsLeaveBillEntryInfo leavebilllInfo = billInfo.getEntries().get(0).getLeaveEntryBill();
        HolidayLimitDetailInfo limitInfo = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailInfo(" where LeaveBill='" + leavebilllInfo.getId().toString() + "'  and status='1'  ");
        limitInfo.setStatus(HolidayLimitDetailStatusEnum.invalid);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("LeaveBill"));
        selectors.add(new SelectorItemInfo("status"));
        detailControllerBean.updatePartial(ctx, limitInfo, selectors);
    }

    protected void updateUsedLimit(Context ctx, Map<String, Object> mapBalance) throws BOSException, EASBizException {
        try {
            BigDecimal needCancelLimit_bill = (BigDecimal)mapBalance.get("cancelBillRealLeavelengthSum");
            String holidayLimitId = (String)mapBalance.get("holidayLimitId");
            CancelLeaveBillEntryCollection canColl = (CancelLeaveBillEntryCollection)((Object)mapBalance.get("canCollection"));
            BigDecimal currentBillBigDecimal = (BigDecimal)mapBalance.get("cancelBillRealLeavelengthOne");
            String sql_query = "select holiday_limit.*  from t_hr_ats_holidaylimit holiday_limit  where fid='" + holidayLimitId + "' ";
            IRowSet row = null;
            row = DbUtil.executeQuery((Context)ctx, (String)sql_query);
            BigDecimal fusedLimit_His = BigDecimal.valueOf(0L);
            while (row.next()) {
                fusedLimit_His = row.getBigDecimal("FUsedLimit");
            }
            BigDecimal leaveLengthSum = (BigDecimal)mapBalance.get("leaveBillLeavelengthSum");
            BigDecimal canRealleaveLengthSum = (BigDecimal)mapBalance.get("cancelBillRealLeavelengthSum");
            BigDecimal subBigDecimal = leaveLengthSum.subtract(canRealleaveLengthSum);
            float usedLimit = fusedLimit_His.floatValue();
            if (canColl.size() == 1) {
                BigDecimal usedLimit_res = fusedLimit_His.subtract(subBigDecimal);
                usedLimit_res = this.decimalPlacesSystem.precisionConvert(ctx, usedLimit_res, RoundingMode.HALF_UP);
                usedLimit = usedLimit_res.floatValue();
            }
            if (canColl.size() > 1) {
                usedLimit = fusedLimit_His.add(currentBillBigDecimal).subtract(canRealleaveLengthSum).floatValue();
            }
            String sql_update = "  update  t_hr_ats_holidaylimit set  FUsedLimit='" + usedLimit + "'     where fid='" + holidayLimitId + "' ";
            DbUtil.execute((Context)ctx, (String)sql_update);
        }
        catch (Exception e) {
            logger.info((Object)"update used limit fail\u3002possible cause\uff1aattdance center not available or not exist annual type int hoiday policy\u3002");
            throw new BOSException((Throwable)e);
        }
    }

    protected void updateRemainLimit(Context ctx, Map<String, Object> mapBalance) throws BOSException, EASBizException {
        try {
            String holidayLimitId = (String)mapBalance.get("holidayLimitId");
            String sqlquery = "select holiday_limit.*  from t_hr_ats_holidaylimit holiday_limit  where fid='" + holidayLimitId + "' ";
            IRowSet row = null;
            row = DbUtil.executeQuery((Context)ctx, (String)sqlquery);
            BigDecimal realLimit = BigDecimal.valueOf(0L);
            BigDecimal usedLimit = BigDecimal.valueOf(0L);
            BigDecimal freezeLimit = BigDecimal.valueOf(0L);
            while (row.next()) {
                realLimit = row.getBigDecimal("FRealLimit");
                usedLimit = row.getBigDecimal("FUsedLimit");
                freezeLimit = row.getBigDecimal("FreezeLimit");
            }
            BigDecimal remainLimit_bg = realLimit.subtract(usedLimit).subtract(freezeLimit);
            remainLimit_bg = this.decimalPlacesSystem.precisionConvert(ctx, remainLimit_bg, RoundingMode.HALF_UP);
            float remainLimit = remainLimit_bg.floatValue();
            String sql = " update  t_hr_ats_holidaylimit set FRemainLimit='" + remainLimit + "' where   fid='" + holidayLimitId + "' ";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (Exception e) {
            logger.info((Object)"cance trip bill-update rest annual leave limit faile,possible cause\uff1anot exist avaiable atendance center or in that center not exist annual leave type\u3002");
            throw new BOSException((Throwable)e);
        }
    }

    protected int insertDataInfoToHolildayLimitDetail(Context ctx, Map<String, Object> mapBalance, CancelLeaveBillInfo billInfo) throws EASBizException, BOSException {
        HolidayLimitDetailControllerBean detailControllerBean = new HolidayLimitDetailControllerBean();
        AtsLeaveBillEntryInfo leavebilllInfo = billInfo.getEntries().get(0).getLeaveEntryBill();
        AtsLeaveBillInfo atsbillinfo = AtsLeaveBillFactory.getLocalInstance(ctx).getAtsLeaveBillInfo(" where id = '" + leavebilllInfo.getId().toString() + "' ");
        HolidayLimitDetailInfo limitInfo = HolidayLimitDetailFactory.getLocalInstance(ctx).getHolidayLimitDetailInfo(" where LeaveBill='" + leavebilllInfo.getId().toString() + "'  and status='1'  ");
        limitInfo.setStatus(HolidayLimitDetailStatusEnum.invalid);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("LeaveBill"));
        selectors.add(new SelectorItemInfo("status"));
        detailControllerBean.updatePartial(ctx, limitInfo, selectors);
        int res = 0;
        HolidayLimitDetailControllerBean holidayLimitDetailControllerBean = new HolidayLimitDetailControllerBean();
        CoreBaseCollection colls = new CoreBaseCollection();
        HolidayLimitDetailInfo detailInfo = new HolidayLimitDetailInfo();
        String personId = (String)mapBalance.get("personId");
        PersonPositionInfo personPositionInfo = SHRBillServerUtil.getAdminOrgUnit(ctx, personId);
        detailInfo.setProposer(personPositionInfo.getPerson());
        detailInfo.setAdminOrgUnit(personPositionInfo.getPersonDep());
        detailInfo.setPosition(personPositionInfo.getPrimaryPosition());
        PersonPositionInfo position = SHRBillServerUtil.getAdminOrgUnitAndHrOrgUnit(ctx, personId);
        HROrgUnitInfo hrInfo = null;
        hrInfo = position.getHrOrgUnit();
        detailInfo.setHrOrgUnit(hrInfo);
        Calendar cal = Calendar.getInstance();
        detailInfo.setYear(cal.get(1));
        detailInfo.setChangeDate(CancelLeaveBillLimitServer.dateToTimestamp(new Date()));
        detailInfo.setChangeType(HolidayLimitChangeType.deduction);
        detailInfo.setBillType(HolidayLimitBillTypeEnum.leaveBill);
        detailInfo.setLeaveBillNumber(atsbillinfo.getNumber());
        BigDecimal changeValue = limitInfo.getChangeValue();
        BigDecimal needCancelLimitValue = (BigDecimal)mapBalance.get("cancelBillRealLeavelengthSum");
        BigDecimal resValue = changeValue.subtract(needCancelLimitValue);
        resValue = this.decimalPlacesSystem.precisionConvert(ctx, resValue, RoundingMode.HALF_UP);
        detailInfo.setChangeValue(resValue);
        detailInfo.setChangeUnit((HolidayTypeUnitEnum)((Object)mapBalance.get("holidayPolicyUnit")));
        String holidayLimitId = (String)mapBalance.get("holidayLimitId");
        HolidayLimitInfo Info = new HolidayLimitInfo();
        Info.setId(BOSUuid.read((String)holidayLimitId));
        detailInfo.setHolidayLimit(Info);
        detailInfo.setStatus(HolidayLimitDetailStatusEnum.valid);
        colls.add((CoreBaseInfo)detailInfo);
        try {
            holidayLimitDetailControllerBean.addnewBatchData(ctx, colls);
            res = 1;
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static Timestamp dateToTimestamp(Date date) {
        Timestamp ts = new Timestamp(date.getTime());
        return ts;
    }

    public static void main(String[] args) {
        System.out.println("");
    }
}

