/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.TimeZoneTrigger;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.HRTimeZoneBizException;
import com.kingdee.eas.hr.base.HRTimeZoneInfo;
import com.kingdee.eas.hr.base.TimeZoneChangeEventInfo;
import com.kingdee.eas.hr.base.timezone.TimeZoneDataFetcher;
import com.kingdee.eas.hr.base.timezone.TimeZoneEventEnum;
import com.kingdee.eas.hr.base.timezone.TimeZoneUpdater;
import com.kingdee.eas.hr.base.timezone.TimeZoneUtil;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BaseTripTimeZoneTrigger
extends TimeZoneTrigger {
    private HRTimeZoneInfo defaultTimeZoneInfo;
    private int tripTimeZoneLevel = 200;
    protected Map<String, List<HRTimeZoneInfo>> latestCommonHrTimeZone;
    protected Class<? extends CoreBaseInfo> billEntryClass;
    protected CoreBaseCollection billEntries = new CoreBaseCollection();

    protected Iterator<?> getEntryIterator() {
        return this.billEntries == null ? Collections.EMPTY_LIST.iterator() : this.billEntries.iterator();
    }

    @Override
    public boolean triggerAuthen() throws EASBizException {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)this.billEntries)) {
            return false;
        }
        this.timeZoneUpdater = new TimeZoneUpdater();
        this.beforTriggerAuthen();
        return this.updateTimeZone(this.getTimeZoneChangeEvent(true));
    }

    @Override
    public boolean triggerUnAuthen() throws EASBizException {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)this.billEntries)) {
            return false;
        }
        this.timeZoneUpdater = new TimeZoneUpdater();
        this.beforTriggerUnAuthen();
        return this.updateTimeZone(this.getTimeZoneChangeEvent(false));
    }

    private TimeZoneChangeEventInfo getTimeZoneChangeEvent(boolean authenOperation) throws HRTimeZoneBizException {
        Object event = this.getTimeZoneChangeEventInner(authenOperation);
        if (event == null) {
            return null;
        }
        return TimeZoneUtil.getTimeZoneChangeEvent((Context)this.ctx, (Object)event);
    }

    protected abstract Object getTimeZoneChangeEventInner(boolean var1);

    public TimeZoneTrigger addBillInfo(Object bill) throws EASBizException {
        if (bill instanceof CoreBaseInfo) {
            this.addBillEntries(((CoreBaseInfo)bill).get("entries"));
        } else if (bill instanceof String) {
            try {
                String oql = this.getFetchEntryOsql(bill);
                this.addBillEntries(AtsEntityUtile.getBizInterface(this.ctx, this.billEntryClass).getCollection(oql));
            }
            catch (BOSException e) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return this;
    }

    protected String getFetchEntryOsql(Object bill) {
        return "where bill in ('" + bill.toString().replaceAll(",", "','") + "')";
    }

    protected TimeZoneTrigger addBillEntries(Object tripEntrys) {
        if (tripEntrys == null) {
            return this;
        }
        Iterator it = null;
        if (tripEntrys instanceof IObjectCollection) {
            it = ((IObjectCollection)tripEntrys).iterator();
        } else if (tripEntrys instanceof Collection) {
            it = ((Collection)tripEntrys).iterator();
        }
        if (it != null) {
            while (it.hasNext()) {
                this.addBillEntries(it.next());
            }
        } else if (tripEntrys instanceof CoreBaseInfo) {
            this.billEntries.add((CoreBaseInfo)tripEntrys);
        }
        return this;
    }

    protected HRTimeZoneInfo getPreTimeZone(AtsTripBillEntryInfo entry) throws EASBizException {
        PersonInfo person;
        List<HRTimeZoneInfo> personTimeZone;
        if (this.latestCommonHrTimeZone == null) {
            this.initLatestCommonHrTimeZone();
        }
        List<HRTimeZoneInfo> list = personTimeZone = (person = entry.getPerson()) == null ? null : this.latestCommonHrTimeZone.get(person.getString("id"));
        if (AtsCollectionUtile.isEmpty(personTimeZone)) {
            return this.getDefaultTimeZone();
        }
        Date start = Date.getDate(entry.getTripStartTime());
        int defaultChangeEvent = 100;
        for (int i = personTimeZone.size() - 1; i > -1; --i) {
            HRTimeZoneInfo hrTimeZoneInfo = personTimeZone.get(i);
            if (hrTimeZoneInfo.getChangeEvent().getLevel() > defaultChangeEvent || !hrTimeZoneInfo.getLeffdt().before(start)) continue;
            return personTimeZone.get(i);
        }
        return this.getDefaultTimeZone();
    }

    protected HRTimeZoneInfo getDefaultTimeZone() throws EASBizException {
        if (this.defaultTimeZoneInfo == null) {
            this.defaultTimeZoneInfo = new HRTimeZoneInfo();
            try {
                this.defaultTimeZoneInfo.setTimeZone(TimeZoneUtil.getSysTimeZone((Context)this.ctx));
                this.defaultTimeZoneInfo.setChangeEvent(TimeZoneUtil.getTimeZoneChangeEvent((Context)this.ctx, (Object)TimeZoneEventEnum.CREATE_UPDATE));
            }
            catch (BOSException e) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return this.defaultTimeZoneInfo;
    }

    protected void initLatestCommonHrTimeZone() throws EASBizException {
        java.util.Date maxDateForLatest = this.getMaxDateForLatest();
        TimeZoneDataFetcher fetcher = new TimeZoneDataFetcher();
        fetcher.setSelectSql(" *,changeEvent.* ");
        fetcher.setCtx(this.ctx).addFilterObj(AtsCommonUtile.getValFromeCoreBaseWithDotField(this.getEntryIterator(), "person"));
        fetcher.setBeginTime((Object)"1970-01-01").setEndTime((Object)maxDateForLatest);
        this.latestCommonHrTimeZone = fetcher.setAsendResult(true).fetchMapData();
    }

    protected java.util.Date getMaxDateForLatest() {
        return Calendar.getInstance().getTime();
    }

    protected boolean updateTimeZone(TimeZoneChangeEventInfo event) throws EASBizException {
        boolean needUpdate = false;
        Iterator<?> it = this.getEntryIterator();
        while (it.hasNext()) {
            CoreBaseInfo entryInfo = (CoreBaseInfo)it.next();
            Timestamp startTime = this.getStartTime(entryInfo);
            Timestamp endTime = this.getEndTime(entryInfo);
            if (startTime == null || endTime == null || startTime.equals(endTime)) continue;
            needUpdate = true;
            this.timeZoneUpdater.addToUpdate(entryInfo.get("person"), this.getTimeZone(entryInfo), event == null ? (TimeZoneChangeEventInfo)entryInfo.get("changeEvent") : event, (Object)startTime, (Object)endTime);
        }
        if (needUpdate) {
            return this.timeZoneUpdater.setCtx(this.ctx).update();
        }
        return true;
    }

    protected Timestamp getStartTime(CoreBaseInfo entryInfo) {
        return entryInfo.getTimestamp("tripStartTime");
    }

    protected Timestamp getEndTime(CoreBaseInfo entryInfo) {
        return entryInfo.getTimestamp("tripEndTime");
    }

    protected TimeZoneInfo getTimeZone(CoreBaseInfo entryInfo) {
        return (TimeZoneInfo)entryInfo.get("timeZone");
    }

    public Class<? extends CoreBaseInfo> getBillEntryClass() {
        return this.billEntryClass;
    }

    public BaseTripTimeZoneTrigger setBillEntryClass(Class<? extends CoreBaseInfo> billEntryClass) {
        this.billEntryClass = billEntryClass;
        return this;
    }

    public int getTripTimeZoneLevel() {
        try {
            TimeZoneChangeEventInfo tripTimeZoneEve = TimeZoneUtil.getTimeZoneChangeEvent((Context)this.ctx, (Object)TimeZoneEventEnum.ATS_TRIP_AUTHON);
            if (tripTimeZoneEve != null && tripTimeZoneEve.getLevel() != 0) {
                this.tripTimeZoneLevel = tripTimeZoneEve.getLevel();
            }
        }
        catch (HRTimeZoneBizException e) {
            e.printStackTrace();
        }
        return this.tripTimeZoneLevel;
    }

    public BaseTripTimeZoneTrigger setTripTimeZoneLevel(int tripTimeZoneLevel) {
        this.tripTimeZoneLevel = tripTimeZoneLevel;
        return this;
    }
}

