/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.hr.ats.util.common.AtsSqlUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import org.apache.commons.lang.StringUtils;

public abstract class tempTableUtile {
    public static String createTable(Context ctx, String sqlSelect, String indexCols, String tableKey) throws Exception {
        if (!AtsSqlUtile.validateSelectSql(sqlSelect)) {
            throw new IllegalArgumentException("sqlSelect");
        }
        String tableName = tempTableUtile.createTempTableName(ctx);
        DbUtil.execute((Context)ctx, (String)new StringBuffer("select * into ").append(tableName).append(" from (").append(sqlSelect).append(") T ;").toString());
        if (StringUtils.isNotBlank((String)indexCols)) {
            tempTableUtile.createIndex(ctx, tableName, indexCols);
        }
        if (StringUtils.isNotBlank((String)tableKey)) {
            tempTableUtile.releaseTableFromCtx(ctx, tableKey);
            ctx.put((Object)tableKey, (Object)tableName);
        }
        return tableName;
    }

    public static String createAdminOrgTable(Context ctx, String permItemId, String userId) throws Exception {
        String sqlSelect = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
        return tempTableUtile.createTable(ctx, sqlSelect, "FAdminOrgID");
    }

    public static String createTable(Context ctx, String sqlSelect, String indexCols) throws Exception {
        return tempTableUtile.createTable(ctx, sqlSelect, indexCols, null);
    }

    public static String createTable(Context ctx, String sqlSelect) throws Exception {
        return tempTableUtile.createTable(ctx, sqlSelect, null, null);
    }

    public static String createTableWithFirstIndex(Context ctx, String sqlSelect) throws Exception {
        String selectFields = AtsSqlUtile.getSelectExpression(sqlSelect);
        String[] fisrtFields = selectFields.split(",")[0].split("\\s+");
        String indexCols = fisrtFields[fisrtFields.length - 1];
        return tempTableUtile.createTable(ctx, sqlSelect, indexCols.equals("*") ? null : indexCols, null);
    }

    public static String createTableWithAllIndex(Context ctx, String sqlSelect) throws Exception {
        String selectFields = AtsSqlUtile.getSelectExpression(sqlSelect);
        return tempTableUtile.createTable(ctx, sqlSelect, selectFields.equals("*") ? null : selectFields, null);
    }

    public static String createTempTableName(Context ctx) throws Exception {
        return TempTablePool.getInstance((Context)ctx).createTempTableName();
    }

    public static void releaseTable(Context ctx, String tableName) {
        TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
    }

    public static void dropTable(Context ctx, String tableName, boolean truncateTable) throws Exception {
        TableManager tableManager = TableManager.getTableManager((Context)ctx);
        TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
        if (truncateTable) {
            tableManager.truncateTable(tableName);
        }
        tableManager.dropTable(tableName);
    }

    public static void releaseTableFromCtx(Context ctx, String tableKey) {
        String tableName = (String)ctx.get((Object)tableKey);
        if (StringUtils.isNotBlank((String)tableName)) {
            tempTableUtile.releaseTable(ctx, tableName);
        }
    }

    public static void createIndex(Context ctx, String tableName, String columns) throws Exception {
        tempTableUtile.createIndex(ctx, tableName, columns, false, false);
    }

    public static void createUniqueIndex(Context ctx, String tableName, String columns) throws Exception {
        tempTableUtile.createIndex(ctx, tableName, columns, true, false);
    }

    public static void createClusterIndex(Context ctx, String tableName, String columns) throws Exception {
        tempTableUtile.createIndex(ctx, tableName, columns, false, true);
    }

    public static void createIndex(Context ctx, String tableName, String columns, boolean isUnique, boolean isClustered) throws Exception {
        if (StringUtils.isBlank((String)columns)) {
            return;
        }
        StringBuffer colsBuff = new StringBuffer();
        for (String column : columns.split(",")) {
            if (columns.contains(".") && columns.charAt(0) != '\"') {
                colsBuff.append(columns.substring(columns.lastIndexOf(".") + 1)).append(",");
                continue;
            }
            colsBuff.append(column).append(",");
        }
        TempTablePool.getInstance((Context)ctx).createIndex(tableName, colsBuff.substring(0, colsBuff.length() - 1), isUnique, isClustered);
    }
}

