/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsAffairBaseInfo;
import com.kingdee.eas.hr.ats.AtsBillBizException;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.AtsFileBizException;
import com.kingdee.eas.hr.ats.AtsScheduleShiftCollection;
import com.kingdee.eas.hr.ats.AtsScheduleShiftEntryCollection;
import com.kingdee.eas.hr.ats.AtsScheduleShiftEntryInfo;
import com.kingdee.eas.hr.ats.AtsScheduleShiftFactory;
import com.kingdee.eas.hr.ats.AtsScheduleShiftInfo;
import com.kingdee.eas.hr.ats.AtsScheduleShiftResEnum;
import com.kingdee.eas.hr.ats.AtsShiftCollection;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AtsShiftResEnum;
import com.kingdee.eas.hr.ats.AtsStaticResourceBizException;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.IAtsScheduleShift;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftItemFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.SegmentEnum;
import com.kingdee.eas.hr.ats.lightapp.util.NumberCodeRule;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsAttendanceFileUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.ScheduleShiftUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.validator.BillHelper;
import com.kingdee.eas.hr.ats.vo.common.ShiftDetailModel;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class AdjustShiftHelper
extends BillHelper {
    public AdjustShiftHelper() {
    }

    public AdjustShiftHelper(Context ctx) {
        super(ctx);
    }

    @Override
    public <T extends AtsAffairBaseInfo> T storefields(Context ctx, T bill) throws BOSException, EASBizException {
        AtsScheduleShiftInfo billInfo = (AtsScheduleShiftInfo)bill;
        PersonInfo curPerson = SHRBillUtil.getCurrPersonInfoNew(ctx);
        if (billInfo.getAdminOrg() == null) {
            PersonPositionInfo curPersonPosition = SHRBillUtil.getAdminOrgUnit(CoreBaseUtile.getId(curPerson), ctx);
            billInfo.setAdminOrg(curPersonPosition.getPersonDep());
        }
        if (billInfo.getProposer() == null) {
            billInfo.setProposer(curPerson);
        }
        if (billInfo.getHrOrgUnit() == null) {
            HROrgUnitInfo hrOrgUnitInfo = SHRBillUtil.getCurrentHRUnitByAttFile(ctx, CoreBaseUtile.getId(curPerson));
            billInfo.setHrOrgUnit(hrOrgUnitInfo);
        }
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        billInfo.setLastUpdateTime(now);
        billInfo.setLastUpdateUser(currentUserInfo);
        billInfo.setBizDate(DateTimeUtils.truncateDate((Date)now));
        billInfo.setApplyDate(DateTimeUtils.truncateDate((Date)now));
        if (billInfo.getNumber() == null) {
            billInfo.setNumber(NumberCodeRule.getCodeRuleNumber(ctx, (IObjectValue)billInfo, NumberCodeRule.getMainOrgByCu(ctx)));
        }
        AtsScheduleShiftEntryCollection entries = billInfo.getEntries();
        if (billInfo.getBillType() == null || billInfo.getBillType().equals("")) {
            billInfo.setBillType(ScheduleShiftEnum.person);
        }
        if (billInfo.getBillState() == null) {
            billInfo.setBillState(HRBillStateEnum.SUBMITED);
        }
        this.storeEntryfields(billInfo);
        billInfo.setIsMultiEntry(entries.size() > 1);
        return bill;
    }

    private void storeEntryfields(AtsScheduleShiftInfo billInfo) throws BOSException, HRCommonException {
        AtsScheduleShiftEntryCollection entries = billInfo.getEntries();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)entries)) {
            return;
        }
        int entrySize = entries.size();
        block20: for (int i = 0; i < entrySize; ++i) {
            AtsScheduleShiftEntryInfo entryInfo = entries.get(i);
            switch (entryInfo.getAdjustType().getValue()) {
                case "1": {
                    entries.add(this.getNewEntry(entryInfo));
                    continue block20;
                }
                case "2": {
                    entries.add(this.getNewEntry(entryInfo));
                    continue block20;
                }
                case "3": {
                    continue block20;
                }
            }
        }
        HashMap<String, AtsShiftInfo> shiftMap = this.initShiftInfo(billInfo.getHrOrgUnit().getString("id"));
        for (int i = 0; i < entries.size(); ++i) {
            AtsScheduleShiftEntryInfo entryInfo = entries.get(i);
            this.checkAdjustShift(entryInfo);
            switch (entryInfo.getAdjustType().getValue()) {
                case "1": {
                    this.adjustShiftOther(this.ctx, entryInfo, shiftMap);
                    break;
                }
                case "2": {
                    this.adjustShiftOther(this.ctx, entryInfo, shiftMap);
                    break;
                }
                case "3": {
                    this.adjustShift(this.ctx, entryInfo, shiftMap);
                    break;
                }
                default: {
                    this.adjustShiftOther(this.ctx, entryInfo, shiftMap);
                }
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entryInfo.getAdjustReason())) continue;
            entryInfo.setAdjustReason("");
        }
    }

    protected void checkAdjustShift(AtsScheduleShiftEntryInfo entryInfo) throws BOSException, HRCommonException {
        if (entryInfo == null) {
            return;
        }
        ScheduleShiftUtils.checkCanEditSchedule(this.ctx, CoreBaseUtile.getId(entryInfo.getProposerBefore()), entryInfo.getAttendDateBefore());
        ScheduleShiftUtils.checkCanEditSchedule(this.ctx, CoreBaseUtile.getId(entryInfo.getProposerAfter()), entryInfo.getAttendDateAfter());
    }

    private HashMap<String, AtsShiftInfo> initShiftInfo(String hrOrgUnitId) throws HRCommonException {
        HashMap<String, AtsShiftInfo> avaiShifts = new HashMap<String, AtsShiftInfo>();
        StringBuffer shiftOsql = new StringBuffer();
        shiftOsql.append(" where id in (");
        shiftOsql.append(" select fbaseInfoid from T_ATS_AtsShiftAvaliable");
        shiftOsql.append(" where fhrOrgUseid='").append(hrOrgUnitId).append("'");
        shiftOsql.append(" and fstate = 100 ");
        shiftOsql.append(") order by items.segment asc");
        try {
            AtsShiftCollection atsShiftCollection = AtsShiftFactory.getLocalInstance(this.ctx).getAtsShiftCollection(shiftOsql.toString());
            avaiShifts = new HashMap(atsShiftCollection.size());
            for (int i = 0; i < atsShiftCollection.size(); ++i) {
                avaiShifts.put(atsShiftCollection.get(i).getString("id"), atsShiftCollection.get(i));
            }
        }
        catch (BOSException e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{MLUtile.getRes((ResourceEnum)AtsShiftResEnum.InitShiftDataFail, this.ctx, "\uff1a" + e.getMessage())});
        }
        return avaiShifts;
    }

    private AtsScheduleShiftEntryInfo getNewEntry(AtsScheduleShiftEntryInfo entryInfo) throws HRCommonException, BOSException {
        AtsScheduleShiftEntryInfo newEntryInfo = new AtsScheduleShiftEntryInfo();
        if (entryInfo == null) {
            return newEntryInfo;
        }
        newEntryInfo.setAdjustReason(entryInfo.getAdjustReason());
        newEntryInfo.setAdjustType(entryInfo.getAdjustType());
        newEntryInfo.setProposerBefore(entryInfo.getProposerAfter());
        newEntryInfo.setAttendDateBefore(entryInfo.getAttendDateAfter());
        newEntryInfo.setProposerAfter(entryInfo.getProposerBefore());
        newEntryInfo.setAttendDateAfter(entryInfo.getAttendDateBefore());
        AttendanceFileHISInfo realAttendanceFile = AtsAttendanceFileUtils.getAttendanceFileHISInfoByAttenceDate(this.ctx, entryInfo.getAttendDateAfter(), entryInfo.getProposerAfter().getString("id"));
        AttendanceFileHISInfo realAttendanceFile1 = AtsAttendanceFileUtils.getAttendanceFileHISInfoByAttenceDate(this.ctx, AtsDateUtils.getPreDay(entryInfo.getAttendDateAfter()), entryInfo.getProposerAfter().getString("id"));
        if (null == realAttendanceFile && null == realAttendanceFile1) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{new AtsFileBizException(AtsFileBizException.NOTEXISTFILEHIS).getMessage()});
        }
        if (null == realAttendanceFile && null != realAttendanceFile1) {
            realAttendanceFile = realAttendanceFile1;
        }
        newEntryInfo.setPosition(realAttendanceFile.getPosition());
        newEntryInfo.setAdminOrgUnit(realAttendanceFile.getAdminOrgUnit());
        newEntryInfo.setPerson(entryInfo.getProposerAfter());
        return newEntryInfo;
    }

    public static Map<String, String> getPlanWorkTimeOfShift(Context ctx, Set<String> shiftIds) {
        String planWorkTime = "";
        HashMap<String, String> resultMap = new HashMap<String, String>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", shiftIds, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        AtsShiftCollection atsShiftCollection = null;
        try {
            atsShiftCollection = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection(entityViewInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        AtsShiftItemCollection atsShiftItemCollection = null;
        if (atsShiftCollection != null) {
            for (int j = 0; j < atsShiftCollection.size(); ++j) {
                AtsShiftInfo atsShiftInfo = atsShiftCollection.get(j);
                atsShiftItemCollection = atsShiftInfo.getItems();
                if (atsShiftItemCollection != null) {
                    String startStr = "";
                    String endStr = "";
                    for (int i = 0; i < atsShiftItemCollection.size(); ++i) {
                        AtsShiftItemInfo atsShiftItemInfo = atsShiftItemCollection.get(i);
                        if (atsShiftItemInfo == null) continue;
                        int segmentValue = Integer.parseInt(atsShiftItemInfo.getSegment().getValue());
                        if (segmentValue == 1) {
                            startStr = atsShiftItemInfo.getPreTime();
                        }
                        if (segmentValue != atsShiftItemCollection.size()) continue;
                        endStr = atsShiftItemInfo.getNextTime();
                    }
                    planWorkTime = StringUtils.isEmpty((String)(startStr + endStr)) ? "" : startStr + "-" + endStr;
                }
                resultMap.put(atsShiftInfo.getId().toString(), planWorkTime);
            }
        }
        return resultMap;
    }

    private void adjustShift(Context ctx, AtsScheduleShiftEntryInfo entryInfo, HashMap<String, AtsShiftInfo> shiftMap) {
        Map<String, String> workTimeOfShift;
        String beforeShift = "";
        if (entryInfo.getDefaultShiftBefore() != null) {
            beforeShift = entryInfo.getDefaultShiftBefore().getString("id");
        }
        String afterShift = "";
        if (entryInfo.getDefaultShiftAfter() != null) {
            afterShift = entryInfo.getDefaultShiftAfter().getString("id");
        }
        HashSet<String> sets = new HashSet<String>();
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)beforeShift)) {
            sets.add(beforeShift);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)afterShift)) {
            sets.add(afterShift);
        }
        if ((workTimeOfShift = AdjustShiftHelper.getPlanWorkTimeOfShift(ctx, sets)).containsKey(beforeShift)) {
            entryInfo.setWorkTimeBefore(workTimeOfShift.get(beforeShift));
        }
        if (workTimeOfShift.containsKey(afterShift)) {
            entryInfo.setWorkTimeAfter(workTimeOfShift.get(afterShift));
        }
        AtsShiftInfo atsShiftInfo = null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)afterShift)) {
            atsShiftInfo = shiftMap.get(afterShift);
            entryInfo.setDefaultShiftAfter(atsShiftInfo);
        }
    }

    private void adjustShiftOther(Context ctx, AtsScheduleShiftEntryInfo entryInfo, HashMap<String, AtsShiftInfo> shiftMap) throws BOSException, HRCommonException {
        AtsShiftInfo atsShiftInfo;
        String proposerBefore = entryInfo.getProposerBefore().getString("id");
        String proposerAfter = entryInfo.getProposerAfter().getString("id");
        String personIds = proposerBefore + "," + proposerAfter;
        String dateBefore = AtsDateUtils.dateShortToString(entryInfo.getAttendDateBefore());
        String dateAfter = AtsDateUtils.dateShortToString(entryInfo.getAttendDateAfter());
        Map<String, ShiftDetailModel> scheduleShiftDetail = AdjustShiftHelper.getScheduleShiftDetail(ctx, personIds, dateBefore, dateAfter);
        if (AtsCollectionUtile.isEmpty(scheduleShiftDetail)) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{MLUtile.getRes(AtsScheduleShiftResEnum.NoScheduleShiftData, ctx)});
        }
        if (scheduleShiftDetail.containsKey(AdjustShiftHelper.getKey(proposerBefore, dateBefore))) {
            ShiftDetailModel shiftDetailModelBefore = scheduleShiftDetail.get(AdjustShiftHelper.getKey(proposerBefore, dateBefore));
            entryInfo.setDayTypeBefore(shiftDetailModelBefore.getDayType());
            atsShiftInfo = new AtsShiftInfo();
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)shiftDetailModelBefore.getShiftId())) {
                atsShiftInfo = shiftMap.get(shiftDetailModelBefore.getShiftId());
            }
            entryInfo.setDefaultShiftBefore(atsShiftInfo);
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)shiftDetailModelBefore.getWorkTime())) {
                entryInfo.setWorkTimeBefore(shiftDetailModelBefore.getWorkTime());
            }
        } else {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{MLUtile.getRes((ResourceEnum)AtsScheduleShiftResEnum.NoScheduleShift, ctx, entryInfo.getProposerBefore().getName(), dateBefore)});
        }
        if (scheduleShiftDetail.containsKey(AdjustShiftHelper.getKey(proposerAfter, dateAfter))) {
            ShiftDetailModel shiftDetailModelAfter = scheduleShiftDetail.get(AdjustShiftHelper.getKey(proposerAfter, dateAfter));
            entryInfo.setDayTypeAfter(shiftDetailModelAfter.getDayType());
            atsShiftInfo = new AtsShiftInfo();
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)shiftDetailModelAfter.getShiftId())) {
                atsShiftInfo = shiftMap.get(shiftDetailModelAfter.getShiftId());
            }
            entryInfo.setDefaultShiftAfter(atsShiftInfo);
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)shiftDetailModelAfter.getWorkTime())) {
                entryInfo.setWorkTimeAfter(shiftDetailModelAfter.getWorkTime());
            }
        } else {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{MLUtile.getRes((ResourceEnum)AtsScheduleShiftResEnum.NoScheduleShift, ctx, entryInfo.getProposerAfter().getName(), dateAfter)});
        }
    }

    public String getRandomNumber() throws AtsCommonBizException {
        StringBuilder number = new StringBuilder();
        number.append("TBD");
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatDate.format(new Date());
        dateString = dateString.toString().replace("-", "");
        number.append(dateString);
        number.append("-");
        int i = 1;
        while (true) {
            String temnumber = "";
            temnumber = number.toString();
            String randNumber = this.getRandom(i);
            temnumber = temnumber + randNumber;
            String sqlString = "select 1 from T_ATS_AtsScheduleShift where fnumber =?";
            IRowSet rowSet = null;
            try {
                rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlString, (Object[])new Object[]{temnumber});
            }
            catch (BOSException e1) {
                e1.printStackTrace();
                throw new AtsCommonBizException(AtsCommonBizException.COMMITFAIL);
            }
            try {
                if (!rowSet.next()) {
                    return temnumber;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new AtsCommonBizException(AtsCommonBizException.COMMITFAIL);
            }
            ++i;
        }
    }

    public String getRandom(int i) {
        SecureRandom rand = new SecureRandom();
        String randNumber = "0000000" + i;
        if (randNumber.length() > 8) {
            randNumber = randNumber.substring(randNumber.length() - 8);
        }
        return randNumber;
    }

    public void validateBill(Context ctx, CoreBaseInfo model) throws EASBizException {
        this.verifyModel(ctx, model);
        this.checkWorkFlowInstance(ctx, model, "com.kingdee.eas.hr.ats.AtsScheduleShiftBizFunction", "actionSubmit");
    }

    private void verifyModel(Context ctx, CoreBaseInfo model) throws EASBizException {
        AtsScheduleShiftInfo billInfo = (AtsScheduleShiftInfo)model;
        PersonInfo personInfo_main = null;
        personInfo_main = SHRBillUtil.getCurrPersonInfoNew(ctx);
        String personId = personInfo_main.getId().toString();
        this.checkAttendanceFileAction(ctx, personId);
        AtsScheduleShiftEntryCollection entries = billInfo.getEntries();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)entries)) {
            throw new AtsBillBizException(AtsBillBizException.NULLBILLINFO);
        }
        for (int i = 0; i < entries.size(); ++i) {
            AtsScheduleShiftEntryInfo atsScheduleShiftEntryInfo = entries.get(i);
            String attendDateAfter = AtsDateUtils.dateShortToString(atsScheduleShiftEntryInfo.getAttendDateAfter());
            String attendDateBefore = AtsDateUtils.dateShortToString(atsScheduleShiftEntryInfo.getAttendDateBefore());
            if ("1".equals(atsScheduleShiftEntryInfo.getAdjustType().getValue()) && attendDateAfter.equals(attendDateBefore)) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{MLUtile.getRes(AtsScheduleShiftResEnum.NoSameDate, ctx)});
            }
            Boolean valid = this.isSubmmitScheduleShiftBill(ctx, personId, attendDateBefore);
            if (valid.booleanValue()) continue;
            throw new AtsBillBizException(AtsBillBizException.BILLINFLOW, new Object[]{attendDateBefore});
        }
    }

    public boolean isSubmmitScheduleShiftBill(Context ctx, String personId, String date) throws EASBizException {
        PersonInfo personInfo_main;
        boolean isSubmmit = false;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)personId) && (personInfo_main = SHRBillUtil.getCurrPersonInfoNew(ctx)) != null && personInfo_main.getId() != null) {
            personId = personInfo_main.getId().toString();
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)personId)) {
            throw new AtsCommonBizException(AtsCommonBizException.NULLEMPID);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select count (*) as result from T_ATS_AtsScheduleShift where fid in (select distinct( FBillID )from T_ATS_AtsScheduleShiftEntry where ");
        sql.append("FProposerBefore='" + personId + "' ");
        sql.append("and FAttendDateBefore >= { ts'" + date + " 00:00:00'} and FAttendDateBefore <= { ts'" + date + " 23:59:59'} ) ");
        sql.append("and (fbillstate = 1 or fbillstate = 2)");
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new AtsCommonBizException(AtsCommonBizException.COMMITFAIL);
        }
        try {
            while (rowSet.next()) {
                int result = rowSet.getInt("result");
                if (result != 0) continue;
                isSubmmit = true;
            }
        }
        catch (SQLException e) {
            throw new AtsCommonBizException(AtsCommonBizException.COMMITFAIL);
        }
        return isSubmmit;
    }

    public void checkAttendanceFileAction(Context ctx, String personId) throws AtsCommonBizException {
        AttendanceFileCollection attendanceFileColl = null;
        try {
            attendanceFileColl = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(" where proposer.id='" + personId + "' and attendFileState='1' ");
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new AtsCommonBizException(AtsFileBizException.NOTEXISTEFFECTATTFILE);
        }
        if (AtsCollectionUtile.isEmpty((IObjectCollection)attendanceFileColl)) {
            throw new AtsCommonBizException(AtsFileBizException.NOTEXISTEFFECTATTFILE);
        }
    }

    public void checkWorkFlowInstance(Context ctx, CoreBaseInfo model, String functionName, String operationName) throws HRCommonException, AtsBillBizException {
        String userid = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        try {
            String temp = EnactmentServiceProxy.getEnacementService((Context)ctx).findSubmitProcDef(userid, (IObjectValue)model, functionName, operationName);
            if (temp == null || temp.trim().equals("")) {
                throw new AtsBillBizException(AtsBillBizException.NULLATSSCHEDULESHIFTFLOW);
            }
        }
        catch (BOSException e) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public String[] doAbortBill(Context ctx, String billIdParam) throws BOSException, EASBizException {
        HashSet atsInfoIds = new HashSet();
        String billIds = billIdParam.replaceAll(",", "','");
        String[] billIdArr = billIdParam.split(",");
        ArrayList<String> noSubmitBilList = new ArrayList<String>();
        ArrayList<String> approveBilList = new ArrayList<String>();
        String oql = " select billstate,id where id in ( '" + billIds + "' )";
        IAtsScheduleShift iAtsScheduleShift = AtsScheduleShiftFactory.getLocalInstance(ctx);
        AtsScheduleShiftCollection entrys = iAtsScheduleShift.getAtsScheduleShiftCollection(oql);
        for (int i = 0; i < entrys.size(); ++i) {
            HRBillStateEnum billState = entrys.get(i).getBillState();
            String billId = entrys.get(i).getId().toString();
            if (HRBillStateEnum.SAVED.equals((Object)billState)) {
                noSubmitBilList.add(billId);
                continue;
            }
            if (!HRBillStateEnum.AUDITED.equals((Object)billState)) continue;
            approveBilList.add(billId);
        }
        if (noSubmitBilList.size() > 0) {
            throw new AtsStaticResourceBizException(AtsStaticResourceBizException.CHOOSEUNCOMMITORCOMMITINGBILL);
        }
        if (approveBilList.size() > 0) {
            throw new AtsStaticResourceBizException(AtsStaticResourceBizException.CHOOSEUNCOMMITORCOMMITINGBILL);
        }
        for (int j = 0; j < billIdArr.length; ++j) {
            String billId = billIdArr[j];
            try {
                iAtsScheduleShift.abortBizBill(billId);
                AdjustShiftHelper.uptBillSourceTypeWithBack(ctx, billId);
                continue;
            }
            catch (EASBizException e) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return billIdArr;
    }

    public static Map<String, ShiftDetailModel> getScheduleShiftDetail(Context ctx, String personIds, String startDate, String endDate) throws BOSException {
        HashMap<String, HashMap<String, ScheduleShiftItemInfo>> shiftMap = null;
        Map<String, ScheduleShiftInfo> scheduleShiftMap = null;
        shiftMap = AdjustShiftHelper.getScheduleShiftItem(ctx, personIds, startDate, endDate);
        boolean needSegmentWorkTime = TypeConversionUtils.objToBoolean((Object)ctx.remove((Object)"needSegmentWorkTime"));
        scheduleShiftMap = AdjustShiftHelper.getScheduleShift(ctx, personIds, startDate, endDate);
        Iterator<String> itr = scheduleShiftMap.keySet().iterator();
        HashMap<String, ShiftDetailModel> temMap = new HashMap<String, ShiftDetailModel>();
        ShiftDetailModel ssm = null;
        String[] shiftIdAndName = null;
        while (itr.hasNext()) {
            String personIdAndDate = itr.next();
            String[] str = personIdAndDate.split("_");
            String personId = str[0];
            String date = str[1];
            ssm = new ShiftDetailModel();
            ssm.setPersonId(personId);
            ssm.setDateStr(date);
            ssm.setAttendDate(AtsDateUtils.stringToShortDate(date));
            ssm.setWorkTime(needSegmentWorkTime ? AdjustShiftHelper.getScheduleWorkTime(personIdAndDate, shiftMap) : AdjustShiftHelper.getPlanWorkTimeOfScheduleShift(personIdAndDate, shiftMap));
            shiftIdAndName = AdjustShiftHelper.getShiftNameAndId(personIdAndDate, scheduleShiftMap);
            ssm.setShiftId(shiftIdAndName[0]);
            ssm.setShiftName(shiftIdAndName[1]);
            ssm.setDayType(scheduleShiftMap.get(personIdAndDate) != null ? scheduleShiftMap.get(personIdAndDate).getDayType() : DayTypeEnum.workDay);
            temMap.put(personIdAndDate, ssm);
        }
        return temMap;
    }

    public static String getScheduleWorkTime(String personAndDate, HashMap<String, HashMap<String, ScheduleShiftItemInfo>> shiftMap) {
        HashMap<String, ScheduleShiftItemInfo> scheduleItems;
        HashMap<String, ScheduleShiftItemInfo> hashMap = scheduleItems = shiftMap == null ? null : shiftMap.get(personAndDate);
        if (scheduleItems == null) {
            return "";
        }
        StringBuffer workTime = new StringBuffer();
        for (String segment : new String[]{"1", "2", "3"}) {
            ScheduleShiftItemInfo item = scheduleItems.get(segment);
            if (item == null) continue;
            workTime.append(item.getPreTime()).append('-').append(item.getNextTime()).append(' ');
        }
        return workTime.toString().trim();
    }

    private static HashMap<String, HashMap<String, ScheduleShiftItemInfo>> getScheduleShiftItem(Context ctx, String personId, String startDate, String endDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("group.attendDate"));
        sic.add(new SelectorItemInfo("group.proposer"));
        sic.add(new SelectorItemInfo("segment"));
        sic.add(new SelectorItemInfo("preTime"));
        sic.add(new SelectorItemInfo("nextTime"));
        sic.add(new SelectorItemInfo("shiftItem"));
        entityViewInfo.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        if (personId.split(",").length == 1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("group.proposer", (Object)personId, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("group.proposer", AtsUtil.getSetFromStringArr(personId.split(",")), CompareType.INCLUDE));
        }
        HashSet<String> set = new HashSet<String>();
        set.add(startDate);
        set.add(endDate);
        filterInfo.getFilterItems().add(new FilterItemInfo("group.attendDate", set, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        ScheduleShiftItemCollection coll = null;
        try {
            coll = ScheduleShiftItemFactory.getLocalInstance(ctx).getScheduleShiftItemCollection(entityViewInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        HashMap<String, HashMap<String, ScheduleShiftItemInfo>> shiftMap = new HashMap<String, HashMap<String, ScheduleShiftItemInfo>>();
        if (coll != null && coll.size() != 0) {
            Iterator itr = coll.iterator();
            while (itr.hasNext()) {
                ScheduleShiftItemInfo info = (ScheduleShiftItemInfo)itr.next();
                ScheduleShiftInfo group = null;
                SegmentEnum segment = null;
                if (info != null) {
                    group = info.getGroup();
                    segment = info.getSegment();
                }
                if (group == null || segment == null) continue;
                if (shiftMap.get(AdjustShiftHelper.getKey(group.getProposer().getString("id"), dateFormat.format(group.getAttendDate()))) != null) {
                    shiftMap.get(AdjustShiftHelper.getKey(group.getProposer().getString("id"), dateFormat.format(group.getAttendDate()))).put("" + segment.getValue(), info);
                    continue;
                }
                HashMap<String, ScheduleShiftItemInfo> tempMap = new HashMap<String, ScheduleShiftItemInfo>();
                tempMap.put("" + segment.getValue(), info);
                shiftMap.put(AdjustShiftHelper.getKey(group.getProposer().getString("id"), dateFormat.format(group.getAttendDate())), tempMap);
            }
        }
        return shiftMap;
    }

    private static Map<String, ScheduleShiftInfo> getScheduleShift(Context ctx, String personId, String startDate, String endDate) {
        HashMap<String, ScheduleShiftInfo> result = new HashMap<String, ScheduleShiftInfo>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("attendDate"));
        sic.add(new SelectorItemInfo("proposer.id"));
        sic.add(new SelectorItemInfo("dayType"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("defaultShift.*"));
        sic.add(new SelectorItemInfo("items.*"));
        entityViewInfo.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        if (personId.split(",").length == 1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)personId, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("proposer.id", AtsUtil.getSetFromStringArr(personId.split(",")), CompareType.INCLUDE));
        }
        HashSet<String> set = new HashSet<String>();
        set.add(startDate);
        set.add(endDate);
        filterInfo.getFilterItems().add(new FilterItemInfo("attendDate", set, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        ScheduleShiftCollection coll = null;
        try {
            coll = ScheduleShiftFactory.getLocalInstance(ctx).getScheduleShiftCollection(entityViewInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (coll != null && coll.size() != 0) {
            Iterator itr = coll.iterator();
            ScheduleShiftInfo info = null;
            while (itr.hasNext()) {
                info = (ScheduleShiftInfo)itr.next();
                if (info == null || result.get(AdjustShiftHelper.getKey(info.getProposer().getString("id"), dateFormat.format(info.getAttendDate()))) != null) continue;
                result.put(AdjustShiftHelper.getKey(info.getProposer().getString("id"), dateFormat.format(info.getAttendDate())), info);
            }
        }
        return result;
    }

    private static String getPlanWorkTimeOfScheduleShift(String personAndDate, HashMap<String, HashMap<String, ScheduleShiftItemInfo>> shiftMap) {
        HashMap<String, ScheduleShiftItemInfo> hashMap = shiftMap.get(personAndDate);
        String noShift = "";
        if (hashMap == null) {
            return noShift;
        }
        String startStr = "";
        String endStr = "";
        ScheduleShiftItemInfo info = hashMap.get("1");
        if (info != null) {
            startStr = info.getPreTime();
            endStr = info.getNextTime();
        }
        if ((info = hashMap.get("2")) != null) {
            startStr = StringUtils.isEmpty((String)startStr) ? info.getPreTime() : startStr;
            String string = endStr = StringUtils.isEmpty((String)info.getNextTime()) ? endStr : info.getNextTime();
        }
        if ((info = hashMap.get("3")) != null) {
            startStr = StringUtils.isEmpty((String)startStr) ? info.getPreTime() : startStr;
            endStr = StringUtils.isEmpty((String)info.getNextTime()) ? endStr : info.getNextTime();
        }
        return StringUtils.isEmpty((String)(startStr + endStr)) ? "" : startStr + "-" + endStr;
    }

    private static String[] getShiftNameAndId(String personIdAndDate, Map<String, ScheduleShiftInfo> scheduleShiftMap) throws BOSException {
        ScheduleShiftInfo scheduleShiftInfo = scheduleShiftMap.get(personIdAndDate);
        String[] resultStrings = new String[2];
        String shiftName = "";
        String shiftId = "";
        AtsShiftInfo shiftInfo = scheduleShiftInfo.getDefaultShift();
        if (shiftInfo != null) {
            shiftName = shiftInfo.getName();
            shiftId = shiftInfo.getId().toString();
        }
        resultStrings[0] = shiftId;
        resultStrings[1] = shiftName;
        return resultStrings;
    }

    public static String getKey(String personId, String attendDateStr) {
        return personId + "_" + attendDateStr;
    }
}

