/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.arrange;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.EArrangeWay;
import com.kingdee.eas.hr.ats.EHolidayProcessWay;
import com.kingdee.eas.hr.ats.HolidayArrange;
import com.kingdee.eas.hr.ats.RestdayArrange;
import com.kingdee.eas.hr.ats.ScheduleShiftCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.SchlShiftSrcTypeEnum;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.vo.common.RangeDate;
import com.kingdee.eas.hr.ats.vo.common.RangeMap;
import com.kingdee.eas.hr.ats.workShift.arrange.ArrangeShiftUtile;
import com.kingdee.eas.hr.ats.workShift.arrange.EArrangeState;
import com.kingdee.eas.hr.ats.workShift.arrange.IArrangeShift;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class BaseArrangeShift
implements IArrangeShift,
Cloneable {
    protected PersonInfo personInfo;
    protected Date beginDate;
    protected Date endDate;
    protected Date currentShiftDate;
    protected SchlShiftSrcTypeEnum operationType;
    protected EArrangeWay arrangeWay;
    protected EHolidayProcessWay holidayProcessWay;
    protected HolidayArrange holidayArrange;
    protected RestdayArrange restdayArrange;
    protected EArrangeState arrangeState;
    protected boolean continueArrangeShift = true;
    private String attenceGroups;
    protected boolean validateEffdt;
    protected Map<String, List<RangeDate>> personsEffdtRange;
    protected ScheduleShiftCollection arrangeResult;
    protected ScheduleShiftInfo curentArrangingSchedule;
    protected Map<String, Integer> holidayMap;
    protected RangeMap<Date, ScheduleShiftInfo> scheduleShiftMap;
    protected Set<String> errorMsg = new HashSet<String>();
    protected Context ctx;

    public BaseArrangeShift() {
    }

    public BaseArrangeShift(Context ctx) {
        this.ctx = ctx;
    }

    public HolidayArrange getHolidayArrange() {
        return this.holidayArrange;
    }

    public void setHolidayArrange(HolidayArrange holidayArrange) {
        this.holidayArrange = holidayArrange;
    }

    public RestdayArrange getRestdayArrange() {
        return this.restdayArrange;
    }

    public void setRestdayArrange(RestdayArrange restdayArrange) {
        this.restdayArrange = restdayArrange;
    }

    @Override
    public void arrangeShift() {
        this.arrangeResult = new ScheduleShiftCollection();
        this.currentShiftDate = (Date)this.beginDate.clone();
        if (this.holidayProcessWay == null) {
            this.holidayProcessWay = EHolidayProcessWay.unprocess;
        }
        this.beforeArrangeShift();
        while (!this.currentShiftDate.after(this.endDate) && this.getContinueArrangeShift()) {
            if (this.satisfyRange()) {
                this.doArrange();
            }
            this.nextDay();
        }
        this.afterArrangeShift();
    }

    protected void doArrange() {
        Integer holidayType = this.holidayMap.get(AtsCommonUtile.getDateFormat().format(this.currentShiftDate));
        this.curentArrangingSchedule = new ScheduleShiftInfo();
        this.setBasicScheduleInfo();
        switch (holidayType == null ? 0 : holidayType) {
            case 2: {
                this.curentArrangingSchedule.setDayType(DayTypeEnum.legalHoliday);
                this.holidayProcss();
                break;
            }
            case 1: {
                this.curentArrangingSchedule.setDayType(DayTypeEnum.restDay);
                this.weekendProcess();
                break;
            }
            default: {
                this.curentArrangingSchedule.setDayType(DayTypeEnum.workDay);
                this.workDayProcess();
            }
        }
        if (this.curentArrangingSchedule != null) {
            this.arrangeResult.add(this.curentArrangingSchedule);
        }
    }

    protected boolean satisfyRange() {
        return true;
    }

    void beforeArrangeShift() {
        if (this.holidayMap == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String personNum = this.personInfo.getNumber();
            this.holidayMap = ArrangeShiftUtile.getPersonHoliday(this.ctx, personNum, sdf.format(this.beginDate), sdf.format(this.endDate));
        }
        if (StringUtils.isNotBlank((String)this.attenceGroups)) {
            this.setValidateEffdt(true);
        }
        if (this.isValidateEffdt()) {
            // empty if block
        }
    }

    @Override
    public JSONArray showArrangeResult() throws JSONException {
        ScheduleShiftCollection arrangeResult = this.getArrangeResult();
        if (AtsCollectionUtile.isEmpty((IObjectCollection)arrangeResult)) {
            return new JSONArray(0);
        }
        JSONArray shiftResult = new JSONArray(arrangeResult.size());
        for (int i = 0; i < arrangeResult.size(); ++i) {
            ScheduleShiftInfo currentShift = arrangeResult.get(i);
            JSONObject dateShift = new JSONObject(4);
            dateShift.put("dayType", (Object)currentShift.getDayType().getValue());
            dateShift.put("attendDate", (Object)AtsCommonUtile.getDateFormat().format(currentShift.getAttendDate()));
            dateShift.put("shiftSimpleName", (Object)(currentShift.getDefaultShift() == null ? "" : currentShift.getDefaultShift().getSimpleName()));
            dateShift.put("shiftName", (Object)(currentShift.getDefaultShift() == null ? "" : currentShift.getDefaultShift().getName()));
            if (currentShift.getAtsTurnShift() != null && currentShift.getShiftByTurnSegment() != 0) {
                dateShift.put("turnShiftId", (Object)currentShift.getAtsTurnShift().getId().toString());
                dateShift.put("segment", (Object)String.valueOf(currentShift.getShiftByTurnSegment()));
            }
            shiftResult.add((Object)dateShift);
        }
        return shiftResult;
    }

    protected void setBasicScheduleInfo() {
        this.curentArrangingSchedule.setAttendDate((Date)this.currentShiftDate.clone());
        this.curentArrangingSchedule.setProposer(this.getPersonInfo());
    }

    protected void afterArrangeShift() {
    }

    protected void addErrorMsg(String errorInfo) {
        this.curentArrangingSchedule = null;
        if (StringUtils.isNotEmpty((String)errorInfo)) {
            this.errorMsg.add(errorInfo);
        }
    }

    @Override
    public PersonInfo getPersonInfo() {
        return this.personInfo;
    }

    public void setPersonInfo(PersonInfo personInfo) {
        this.personInfo = personInfo;
    }

    @Override
    public Date getBeginDate() {
        return this.beginDate;
    }

    @Override
    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public ScheduleShiftCollection getArrangeResult() {
        return this.arrangeResult;
    }

    @Override
    public void setArrangeResult(ScheduleShiftCollection arrangeResult) {
        this.arrangeResult = arrangeResult;
    }

    @Override
    public EArrangeWay getArrangeWay() {
        return this.arrangeWay;
    }

    @Override
    public void setArrangeWay(EArrangeWay arrangeWay) {
        this.arrangeWay = arrangeWay;
    }

    @Override
    public Date getCurrentShiftDate() {
        return this.currentShiftDate;
    }

    @Override
    public void setCurrentShiftDate(Date currentShiftDate) {
        this.currentShiftDate = currentShiftDate;
    }

    @Override
    public void nextDay() {
        this.getCurrentShiftDate().setTime(this.getCurrentShiftDate().getTime() + 86400000L);
    }

    @Override
    public EHolidayProcessWay getHolidayProcessWay() {
        return this.holidayProcessWay;
    }

    @Override
    public void setHolidayProcessWay(EHolidayProcessWay holidayProcessWay) {
        this.holidayProcessWay = holidayProcessWay;
    }

    @Override
    public EArrangeState getArrangeState() {
        return this.arrangeState;
    }

    @Override
    public void setArrangeState(EArrangeState arrangeState) {
        this.arrangeState = arrangeState;
    }

    @Override
    public boolean getContinueArrangeShift() {
        return this.continueArrangeShift;
    }

    @Override
    public void setContinueArrangeShift(boolean isContinueArrangeShift) {
        this.continueArrangeShift = isContinueArrangeShift;
    }

    @Override
    public Map<String, Integer> getHolidayMap() {
        return this.holidayMap;
    }

    @Override
    public void setHolidayMap(Map<String, Integer> holidayMap) {
        this.holidayMap = holidayMap;
    }

    public RangeMap<Date, ScheduleShiftInfo> getScheduleShiftMap() {
        return this.scheduleShiftMap;
    }

    public void setScheduleShiftMap(RangeMap<Date, ScheduleShiftInfo> scheduleShiftMap) {
        this.scheduleShiftMap = scheduleShiftMap;
    }

    public ScheduleShiftInfo getCurentArrangingSchedule() {
        return this.curentArrangingSchedule;
    }

    public void setCurentArrangingSchedule(ScheduleShiftInfo curentArrangingSchedule) {
        this.curentArrangingSchedule = curentArrangingSchedule;
    }

    @Override
    public Set<String> getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public void setErrorMsg(Set<String> errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Override
    public SchlShiftSrcTypeEnum getOperationType() {
        return this.operationType;
    }

    @Override
    public void setOperationType(SchlShiftSrcTypeEnum operationType) {
        this.operationType = operationType;
    }

    public String getAttenceGroups() {
        return this.attenceGroups;
    }

    public BaseArrangeShift setAttenceGroups(String attenceGroups) {
        this.attenceGroups = attenceGroups;
        return this;
    }

    public boolean isValidateEffdt() {
        return this.validateEffdt;
    }

    public BaseArrangeShift setValidateEffdt(boolean validateEffdt) {
        this.validateEffdt = validateEffdt;
        return this;
    }

    protected Object clone() throws CloneNotSupportedException {
        BaseArrangeShift abstractArrangeShift = (BaseArrangeShift)super.clone();
        if (this.personInfo != null) {
            abstractArrangeShift.setPersonInfo((PersonInfo)this.personInfo.clone());
        }
        if (this.beginDate != null) {
            abstractArrangeShift.setBeginDate((Date)this.beginDate.clone());
        }
        if (this.endDate != null) {
            abstractArrangeShift.setEndDate((Date)this.endDate.clone());
        }
        if (this.currentShiftDate != null) {
            abstractArrangeShift.setCurrentShiftDate((Date)this.currentShiftDate.clone());
        }
        return abstractArrangeShift;
    }
}

