/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShiftGroup;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftInfo;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.AtsMapFn;
import com.kingdee.eas.hr.ats.workShiftGroup.arrange.ArrangeShiftUtile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WorkShiftUtile {
    public static List<JSONObject> getScheduleShiftList(Context ctx, Collection<String> personNums, String beginDate, String endDate) {
        List<List<String>> batchPersonNums = AtsCollectionUtile.group(personNums, AtsConstants.SIZE_COMMON_BATCH);
        Iterator<List<String>> personIterator = batchPersonNums.iterator();
        HashMap<String, Map<String, AttendanceGroupShiftInfo>> allpersonSchedule = new HashMap<String, Map<String, AttendanceGroupShiftInfo>>(personNums.size());
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"proposer.name", "defaultShift.name"});
        while (personIterator.hasNext()) {
            allpersonSchedule.putAll(ArrangeShiftUtile.getScheduleShifts(ctx, (Collection<String>)personIterator.next(), beginDate, endDate, evi));
        }
        int rowNum = 1;
        ArrayList<JSONObject> shiftResult = new ArrayList<JSONObject>(allpersonSchedule.size());
        JSONArray scheduleData = null;
        for (String personNum : allpersonSchedule.keySet()) {
            JSONObject personSchedules = null;
            for (AttendanceGroupShiftInfo currentSchedule : ((Map)allpersonSchedule.get(personNum)).values()) {
                if (personSchedules == null) {
                    PersonInfo person = currentSchedule.getProposer();
                    personSchedules = new JSONObject(4);
                    personSchedules.put("rowNum", (Object)rowNum++);
                    personSchedules.put("personName", (Object)String.valueOf(person.getName()));
                    personSchedules.put("personNum", (Object)person.getNumber());
                    scheduleData = new JSONArray();
                    personSchedules.put("scheduleData", (Object)scheduleData);
                    shiftResult.add(personSchedules);
                }
                JSONObject personDateSchedule = new JSONObject(5);
                personDateSchedule.put("dayType", (Object)currentSchedule.getDayType().getAlias());
                if (currentSchedule.getTurnShift() != null) {
                    personDateSchedule.put("turnShiftId", (Object)currentSchedule.getTurnShift().getId());
                }
                if (currentSchedule.getShiftByTurnSegment() != 0) {
                    personDateSchedule.put("segment", (Object)String.valueOf(currentSchedule.getShiftByTurnSegment()));
                }
                if (currentSchedule.getDefaultShift() != null) {
                    personDateSchedule.put("shiftName", (Object)currentSchedule.getDefaultShift().getName());
                }
                personDateSchedule.put("attendDate", (Object)AtsCommonUtile.getDateFormat().format(currentSchedule.getAttendDate()));
                if (AtsCollectionUtile.isEmpty(scheduleData)) continue;
                scheduleData.add((Object)personDateSchedule);
            }
        }
        return shiftResult;
    }

    public static Collection<LinkedHashMap<String, Object>> assembleNoShiftData(Context ctx, Collection<LinkedHashMap<String, Object>> noShiftPersonInfo, String beginDate, String endDate) {
        List<String> personNums = AtsCollectionUtile.map(noShiftPersonInfo, new AtsMapFn<LinkedHashMap<String, Object>, String>(){

            @Override
            public String map(LinkedHashMap<String, Object> t) {
                return (String)t.get("personNum");
            }
        });
        List<JSONObject> scheduleData = WorkShiftUtile.getScheduleShiftList(ctx, personNums, beginDate, endDate);
        block0: for (LinkedHashMap<String, Object> personAndSchedule : noShiftPersonInfo) {
            for (int i = 0; i < scheduleData.size(); ++i) {
                if (!personAndSchedule.get("personNum").equals(scheduleData.get(i).get((Object)"personNum"))) continue;
                personAndSchedule.put("scheduleData", scheduleData.get(i).get((Object)"scheduleData"));
                continue block0;
            }
        }
        return noShiftPersonInfo;
    }
}

