/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShiftGroup.save;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.ats.AtsShiftCollection;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsShiftItemInfo;
import com.kingdee.eas.hr.ats.AtsTurnShiftInfo;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftCollection;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftFactory;
import com.kingdee.eas.hr.ats.AttendanceGroupShiftInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.helper.ScheduleShiftItemHelper;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.AtsMapAndFitFn;
import com.kingdee.eas.hr.ats.vo.common.RangeDate;
import com.kingdee.eas.hr.ats.vo.common.RangeMap;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class SaveShiftUtile {
    public static Map<String, AtsShiftInfo> getAtsShiftByNames(Context ctx, Set<String> shiftNames) {
        AtsShiftCollection atsShiftCollection = null;
        try {
            EntityViewInfo evi = new EntityViewInfo("select * ,items.*,otCompens.id,shiftType.id,cardRule.id");
            evi = AtsViewUtile.getViewByFilter("name", shiftNames, CompareType.INCLUDE, evi);
            atsShiftCollection = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        if (atsShiftCollection == null) {
            return null;
        }
        HashMap<String, AtsShiftInfo> AtsShifts = new HashMap<String, AtsShiftInfo>(atsShiftCollection.size());
        for (int i = 0; i < atsShiftCollection.size(); ++i) {
            AtsShiftInfo atsShiftInfo = atsShiftCollection.get(i);
            AtsShifts.put(atsShiftInfo.getName(), atsShiftInfo);
        }
        return AtsShifts;
    }

    public static AttendanceFileHISCollection getAttendanceFileHisShift(Context ctx, Set<String> numbers, String startDate, String endDate, String hrOrgUnitId) {
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"id", "proposer.id", "isAttendance", "attendFileState", "proposer.number", "proposer.name", "adminOrgUnit.id", "attAdminOrgUnit.id", "position.id", "hrOrgUnit.id", "attencePolicy.id", "atsShift.cardRule.id", "atsShift.*", "holidayPolicySet.id", "effdt", "leffdt"});
        if (StringUtils.isNotEmpty((String)hrOrgUnitId)) {
            AtsViewUtile.getViewByFilter("hrOrgUnit.id", (Object)hrOrgUnitId, evi);
        }
        AtsViewUtile.getViewByFilter("attendFileState", (Object)"1", evi);
        AtsViewUtile.getViewByFilter("proposer.number", numbers, CompareType.INCLUDE, evi);
        AtsViewUtile.getViewByFilter("leffdt", AtsDateUtils.stringToShortDate(startDate), CompareType.GREATER_EQUALS, evi);
        AtsViewUtile.getViewByFilter("effdt", AtsDateUtils.stringToShortDate(endDate), CompareType.LESS_EQUALS, evi);
        AttendanceFileHISCollection attFileHISColleciton = null;
        try {
            attFileHISColleciton = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return attFileHISColleciton;
    }

    public static Map<String, BOSUuid> getAttendanceFileId(Context ctx, Set<String> numbers) {
        EntityViewInfo attendFileEvi = AtsViewUtile.getViewBySelector(new String[]{"id", "proposer.number"});
        attendFileEvi = AtsViewUtile.getViewByFilter("proposer.number", numbers, CompareType.INCLUDE);
        AttendanceFileCollection attendanceFileFiles = null;
        try {
            attendanceFileFiles = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(attendFileEvi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (attendanceFileFiles == null) {
            return null;
        }
        HashMap<String, BOSUuid> personNumToAttendanceFileId = new HashMap<String, BOSUuid>(attendanceFileFiles.size());
        int size = attendanceFileFiles.size();
        for (int i = 0; i < size; ++i) {
            AttendanceFileInfo fileInfo = attendanceFileFiles.get(i);
            personNumToAttendanceFileId.put(fileInfo.getProposer().getNumber(), fileInfo.getId());
        }
        return personNumToAttendanceFileId;
    }

    public static RangeMap<Date, AttendanceGroupShiftInfo> getDefaultScheduleShiftFromHIS(Context ctx, Set<String> numbers, String startDate, String endDate, String hrOrgUnitId) {
        AttendanceFileHISCollection attFileHISColleciton = SaveShiftUtile.getAttendanceFileHisShift(ctx, numbers, startDate, endDate, hrOrgUnitId);
        Map<String, BOSUuid> personNumToAttendanceFileId = SaveShiftUtile.getAttendanceFileId(ctx, numbers);
        if (AtsCollectionUtile.isEmpty((IObjectCollection)attFileHISColleciton) || AtsCollectionUtile.isEmpty(personNumToAttendanceFileId)) {
            return null;
        }
        RangeMap<Date, AttendanceGroupShiftInfo> defaultSchedule = new RangeMap<Date, AttendanceGroupShiftInfo>(attFileHISColleciton.size());
        AttendanceFileHISInfo hisFile = null;
        for (int i = 0; i < attFileHISColleciton.size(); ++i) {
            hisFile = attFileHISColleciton.get(i);
            BOSUuid uuid = personNumToAttendanceFileId.get(hisFile.getProposer().getNumber());
            if (uuid == null) {
                System.out.println("==========during saving schedule info,personNum:" + hisFile.getProposer().getNumber() + " can not find the file in HrOrg:" + hrOrgUnitId);
                continue;
            }
            hisFile = attFileHISColleciton.get(i);
            AttendanceGroupShiftInfo scheduleInfo = new AttendanceGroupShiftInfo();
            scheduleInfo.setProposer(hisFile.getProposer());
            scheduleInfo.setAdminOrgUnit(hisFile.getAttAdminOrgUnit());
            scheduleInfo.setPosition(hisFile.getPosition());
            scheduleInfo.setHrOrgUnit(hisFile.getHrOrgUnit());
            AtsShiftInfo atsShift = hisFile.getAtsShift();
            scheduleInfo.setCardRule(atsShift == null ? null : atsShift.getCardRule());
            scheduleInfo.setOtCompens(atsShift == null ? null : atsShift.getOtCompens());
            scheduleInfo.setStandardHour(atsShift == null ? null : atsShift.getStandardHour());
            hisFile.setId(uuid);
            defaultSchedule.put(new RangeDate(hisFile.getEFFDT(), hisFile.getLEFFDT()), scheduleInfo);
        }
        return defaultSchedule;
    }

    public static AttendanceGroupShiftCollection resolveToScheduleShift(PersonInfo personInfo, List<JSONObject> schedules, Map<String, AtsShiftInfo> atsShifts) {
        if (AtsCollectionUtile.isEmpty(schedules)) {
            return null;
        }
        AttendanceGroupShiftCollection scheduleResult = new AttendanceGroupShiftCollection();
        for (JSONObject schedule : schedules) {
            AttendanceGroupShiftInfo scheduleShift = new AttendanceGroupShiftInfo();
            scheduleShift.setProposer(personInfo);
            scheduleShift.setAdvcValue(2);
            if (!schedule.containsKey((Object)"attendDate")) continue;
            scheduleShift.setAttendDate(schedule.getDate("attendDate"));
            if (!schedule.containsKey((Object)"dayType")) continue;
            scheduleShift.setDayType(DayTypeEnum.getEnum(schedule.getIntValue("dayType")));
            if (schedule.containsKey((Object)"shiftName") && StringUtils.isNotEmpty((String)schedule.getString("shiftName"))) {
                scheduleShift.setDefaultShift(atsShifts.get(schedule.getString("shiftName")));
            }
            if (schedule.containsKey((Object)"segment")) {
                scheduleShift.setShiftByTurnSegment(schedule.getIntValue("segment"));
            }
            if (schedule.containsKey((Object)"turnShiftId") && StringUtils.isNotEmpty((String)schedule.getString("turnShiftId"))) {
                AtsTurnShiftInfo turnShiftInfo = new AtsTurnShiftInfo();
                turnShiftInfo.setId(BOSUuid.read((String)schedule.getString("turnShiftId")));
                scheduleShift.setTurnShift(turnShiftInfo);
            }
            scheduleResult.add(scheduleShift);
        }
        return scheduleResult;
    }

    public static Map<String, AttendanceGroupShiftInfo> getExistsSchedule(Context ctx, Set<String> attenceGroups, Date begin, Date end) {
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"id", "number", "attendDate"});
        AtsViewUtile.getViewByFilter("attenceGroup.id", attenceGroups, CompareType.INCLUDE, evi);
        AtsViewUtile.getViewByFilter("attendDate", end, CompareType.LESS_EQUALS, evi);
        AtsViewUtile.getViewByFilter("attendDate", begin, CompareType.GREATER_EQUALS, evi);
        AttendanceGroupShiftCollection shiftCollection = null;
        try {
            shiftCollection = AttendanceGroupShiftFactory.getLocalInstance(ctx).getAttendanceGroupShiftCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (AtsCollectionUtile.isEmpty((IObjectCollection)shiftCollection)) {
            return new HashMap<String, AttendanceGroupShiftInfo>();
        }
        HashMap<String, AttendanceGroupShiftInfo> existSchedule = new HashMap<String, AttendanceGroupShiftInfo>();
        AttendanceGroupShiftInfo shiftTemp = null;
        for (int i = 0; i < shiftCollection.size(); ++i) {
            shiftTemp = shiftCollection.get(i);
            String attenceGroupId = shiftTemp.getAttenceGroup().getId().toString();
            existSchedule.put(attenceGroupId + "_" + AtsCommonUtile.getDateFormat().format(shiftTemp.getAttendDate()), shiftTemp);
        }
        return existSchedule;
    }

    public static List<String> getShiftNameFromJson(Collection<JSONObject> schedules) {
        return AtsCollectionUtile.map(schedules, new AtsMapAndFitFn<JSONObject, String>(){

            @Override
            public boolean fit(JSONObject t) {
                return t.containsKey((Object)"shiftName") && StringUtils.isNotEmpty((String)t.getString("shiftName"));
            }

            @Override
            public String map(JSONObject t) {
                return t.getString("shiftName");
            }
        });
    }

    public static void insertScheduleShiftItemsBatch(Context ctx, List<Object[]> insertParamList, Collection<String> deleteGroupIds) throws BOSException {
        SaveShiftUtile.deleteByIds(ctx, "t_hr_ats_scheduleshiftItem", "fgroupId", deleteGroupIds);
        StringBuffer insertShiftItemSql = new StringBuffer("insert into T_HR_ATS_ScheduleShiftItem").append("(").append(" Fid,FShiftItemID,FSegment, FPreTime,FPreFloatAdjusted,FPreUnit,FPreIsPunchCard, ").append(" FNextTime, FNextFloatAdjusted, FNextUnit, FNextIsPunchCard, FSegmentInRest, FAttendanceType,").append(" FPreTimeDayType, FNextTimeDayType, FPreDateTime, FNextDateTime, FRestPreTime, ").append(" FRestNextTime, FRestPreDateTime, FRestNextDateTime,FGroupID").append(")").append(" values(newbosid('4ECBA044'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        if (insertParamList != null && insertParamList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)insertShiftItemSql.toString(), insertParamList);
        }
    }

    public static void deleteByIds(Context ctx, String tableName, String fieldName, Collection<String> deleteIds) throws BOSException {
        if (StringUtils.isNotEmpty((String)tableName) && StringUtils.isNotEmpty((String)fieldName) && !AtsCollectionUtile.isEmpty(deleteIds)) {
            List<List<String>> groupIds = AtsCollectionUtile.group(deleteIds, AtsConstants.SIZE_COMMON_BATCH);
            Iterator<List<String>> groupIdsIterator = groupIds.iterator();
            ArrayList<String[]> batchGroupIds = new ArrayList<String[]>();
            while (groupIdsIterator.hasNext()) {
                String temp = AtsCollectionUtile.joinForSql((Collection)groupIdsIterator.next());
                batchGroupIds.add(new String[]{temp.substring(1, temp.length() - 1)});
            }
            DbUtil.executeBatch((Context)ctx, (String)("delete from " + tableName + " where " + fieldName + " in (?)"), batchGroupIds);
        }
    }

    public static Object[] getScheduleShiftParams(AttendanceGroupShiftInfo AttendanceGroupShiftInfo2, String currentUserInfo, String cu) {
        Object[] objArr = new Object[20];
        if (AttendanceGroupShiftInfo2 != null) {
            objArr[0] = AttendanceGroupShiftInfo2.getDayType() != null ? Integer.valueOf(AttendanceGroupShiftInfo2.getDayType().getValue()) : null;
            objArr[1] = SaveShiftUtile.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getDefaultShift());
            objArr[2] = SaveShiftUtile.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getCardRule());
            objArr[3] = AttendanceGroupShiftInfo2.getSrcType() != null ? AttendanceGroupShiftInfo2.getSrcType().getValue() : null;
            objArr[4] = AttendanceGroupShiftInfo2.getAdvcValue();
            objArr[5] = AttendanceGroupShiftInfo2.getStandardHour() != null ? AttendanceGroupShiftInfo2.getStandardHour() : Integer.valueOf(0);
            objArr[6] = SaveShiftUtile.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getProposer());
            objArr[7] = SaveShiftUtile.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getPosition());
            objArr[8] = currentUserInfo;
            objArr[9] = currentUserInfo;
            objArr[10] = SaveShiftUtile.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getAdminOrgUnit());
            objArr[11] = SaveShiftUtile.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getShiftType());
            objArr[12] = SaveShiftUtile.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getOtCompens());
            objArr[13] = AttendanceGroupShiftInfo2.getAttendDate();
            objArr[14] = cu;
            objArr[15] = SaveShiftUtile.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getHrOrgUnit());
            objArr[16] = AttendanceGroupShiftInfo2.getShiftByTurnSegment() == 0 ? "" : Integer.valueOf(AttendanceGroupShiftInfo2.getShiftByTurnSegment());
            objArr[17] = SaveShiftUtile.correctId((DataBaseInfo)AttendanceGroupShiftInfo2.getTurnShift());
            objArr[18] = AttendanceGroupShiftInfo2.isIsHalfDay() ? 1 : 0;
            objArr[19] = SaveShiftUtile.correctId(AttendanceGroupShiftInfo2);
        }
        return objArr;
    }

    public static String correctId(DataBaseInfo dataBaseInfo) {
        if (dataBaseInfo == null || dataBaseInfo.getId() == null) {
            return "";
        }
        return dataBaseInfo.getId().toString();
    }

    public static List<Object[]> getScheduleShiftItemParams(AttendanceGroupShiftInfo AttendanceGroupShiftInfo2) {
        ArrayList<Object[]> shiftItemList = new ArrayList<Object[]>();
        AtsShiftItemCollection atsShiftItemCollection = AttendanceGroupShiftInfo2.getDefaultShift().getItems();
        Date atdt = AttendanceGroupShiftInfo2.getAttendDate();
        String atdtString = AtsDateUtils.dateShortToString(atdt);
        Calendar atdtNextDayCal = Calendar.getInstance();
        atdtNextDayCal.setTimeInMillis(atdt.getTime() + 86400000L);
        String atdtNextDayString = SaveShiftUtile.dateShortToString(atdtNextDayCal.getTime());
        Calendar atdtPreDayCal = Calendar.getInstance();
        atdtPreDayCal.setTimeInMillis(atdt.getTime() - 86400000L);
        String atdtPreDayString = SaveShiftUtile.dateShortToString(atdtPreDayCal.getTime());
        String preTimeStr = "";
        String preDateTimeStr = "";
        String nextTimeStr = "";
        String nextDateTimeStr = "";
        String restPreTime = "";
        for (int j = 0; j < atsShiftItemCollection.size(); ++j) {
            Object[] insertShiftItemObjArr = new Object[21];
            AtsShiftItemInfo atsShiftItemInfo = atsShiftItemCollection.get(j);
            preTimeStr = atsShiftItemInfo.getPreTime();
            int preTimeValue = atsShiftItemInfo.getPreTimeDayType().getValue();
            preDateTimeStr = ScheduleShiftItemHelper.getRealTimeByType(preTimeValue, atdtString, atdtPreDayString, atdtNextDayString, preTimeStr);
            int nextTimeValue = atsShiftItemInfo.getNextTimeDayType().getValue();
            nextTimeStr = atsShiftItemInfo.getNextTime();
            nextDateTimeStr = ScheduleShiftItemHelper.getRealTimeByType(nextTimeValue, atdtString, atdtPreDayString, atdtNextDayString, nextTimeStr);
            restPreTime = atsShiftItemInfo.getRestPreTime();
            String restNextTime = atsShiftItemInfo.getRestNextTime();
            String restPreDateTimeStr = "";
            String restNextDateTimeStr = "";
            if (!StringUtils.isEmpty((String)restPreTime) && !StringUtils.isEmpty((String)restNextTime)) {
                restPreDateTimeStr = ScheduleShiftItemHelper.getRealRestTime(preTimeStr, preTimeValue, restPreTime, restNextTime, atdtString, atdtPreDayString, atdtNextDayString, "restPreTime");
                restNextDateTimeStr = ScheduleShiftItemHelper.getRealRestTime(preTimeStr, preTimeValue, restPreTime, restNextTime, atdtString, atdtPreDayString, atdtNextDayString, "restNextTime");
            }
            insertShiftItemObjArr[0] = atsShiftItemInfo != null && atsShiftItemInfo.getId() != null ? atsShiftItemInfo.getId().toString() : "";
            insertShiftItemObjArr[1] = atsShiftItemInfo.getSegment() == null ? "" : atsShiftItemInfo.getSegment().getValue();
            insertShiftItemObjArr[2] = atsShiftItemInfo.getPreTime() == null ? "" : atsShiftItemInfo.getPreTime();
            insertShiftItemObjArr[3] = atsShiftItemInfo.getPreFloatAdjusted() == null ? 0.0 : (double)atsShiftItemInfo.getPreFloatAdjusted().floatValue();
            insertShiftItemObjArr[4] = atsShiftItemInfo.getPreUnit() == null ? "" : Integer.valueOf(atsShiftItemInfo.getPreUnit().getValue());
            insertShiftItemObjArr[5] = atsShiftItemInfo.getPreIsPunchCard() == null ? "" : atsShiftItemInfo.getPreIsPunchCard().getValue();
            insertShiftItemObjArr[6] = atsShiftItemInfo.getNextTime() == null ? "" : atsShiftItemInfo.getNextTime();
            insertShiftItemObjArr[7] = atsShiftItemInfo.getNextFloatAdjusted() == null ? 0.0 : (double)atsShiftItemInfo.getNextFloatAdjusted().floatValue();
            insertShiftItemObjArr[8] = atsShiftItemInfo.getNextUnit() == null ? "" : Integer.valueOf(atsShiftItemInfo.getNextUnit().getValue());
            insertShiftItemObjArr[9] = atsShiftItemInfo.getNextIsPunchCard() == null ? "" : atsShiftItemInfo.getNextIsPunchCard().getValue();
            insertShiftItemObjArr[10] = atsShiftItemInfo.getSegmentInRest() == null ? Integer.valueOf(0) : atsShiftItemInfo.getSegmentInRest();
            insertShiftItemObjArr[11] = atsShiftItemInfo.getAttendanceType() == null ? "" : atsShiftItemInfo.getAttendanceType().getValue();
            insertShiftItemObjArr[12] = atsShiftItemInfo.getPreTimeDayType().getValue();
            insertShiftItemObjArr[13] = atsShiftItemInfo.getNextTimeDayType().getValue();
            insertShiftItemObjArr[14] = StringUtils.isNotEmpty((String)preDateTimeStr) ? SaveShiftUtile.stringToTimestamp(preDateTimeStr) : null;
            insertShiftItemObjArr[15] = StringUtils.isNotEmpty((String)nextDateTimeStr) ? SaveShiftUtile.stringToTimestamp(nextDateTimeStr) : null;
            insertShiftItemObjArr[16] = restPreTime == null ? "" : restPreTime;
            insertShiftItemObjArr[17] = restNextTime == null ? "" : restNextTime;
            insertShiftItemObjArr[18] = StringUtils.isNotEmpty((String)restPreDateTimeStr) ? SaveShiftUtile.stringToTimestamp(restPreDateTimeStr) : null;
            insertShiftItemObjArr[19] = StringUtils.isNotEmpty((String)restNextDateTimeStr) ? SaveShiftUtile.stringToTimestamp(restNextDateTimeStr) : null;
            insertShiftItemObjArr[20] = AttendanceGroupShiftInfo2 != null && AttendanceGroupShiftInfo2.getId() != null ? AttendanceGroupShiftInfo2.getId().toString() : "";
            shiftItemList.add(insertShiftItemObjArr);
        }
        return shiftItemList;
    }

    public static String dateShortToString(Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    public static Timestamp stringToTimestamp(String tsStr) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = Timestamp.valueOf(tsStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ts;
    }
}

