/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.atsContrl.plan.department;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.hr.ats.AtsCommonBizException;
import com.kingdee.eas.hr.ats.AtsFileBizException;
import com.kingdee.eas.hr.ats.AtsOrgBizException;
import com.kingdee.eas.hr.ats.AttCycleBizException;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEQFn;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.AtsSqlUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.util.commonSelect.AtsAdminUtile;
import com.kingdee.eas.hr.atsContrl.AttenceDepOTLimitCollection;
import com.kingdee.eas.hr.atsContrl.AttenceDepOTLimitFactory;
import com.kingdee.eas.hr.atsContrl.AttenceDepOTLimitInfo;
import com.kingdee.eas.hr.atsContrl.AttenceOTCycleType;
import com.kingdee.eas.hr.atsContrl.EOTCtrlPersonSource;
import com.kingdee.eas.hr.atsContrl.EOTUpdateType;
import com.kingdee.eas.hr.atsContrl.OTCtrlPlanDepItemInfo;
import com.kingdee.eas.hr.atsContrl.plan.OTCLUtile;
import com.kingdee.eas.hr.atsContrl.plan.OTCLimitGenerator;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class OTCDepGenerator
extends OTCLimitGenerator<OTCtrlPlanDepItemInfo, AttenceDepOTLimitInfo> {
    private int staffNum;
    private BigDecimal workDay;
    private Set<String> curAdmins = new HashSet<String>();
    BigDecimal usedOTFree = new BigDecimal(0);

    @Override
    protected void beforeGenerater() {
        super.beforeGenerater();
        this.initUsedOTFreeMap();
    }

    @Override
    public void generateLimitInfo() {
        if (this.workDay == null) {
            AtsLog.getLog().error((Object)"no workDay in cycle,can not generate limit!");
            return;
        }
        for (String depId : this.bizTargets) {
            this.generateSpecialLimitInfo(depId);
        }
    }

    @Override
    public void init() {
        super.init();
    }

    public void initSelf() {
        try {
            this.initCurAdmins();
            this.initStaffNum();
            this.initWorkDay();
        }
        catch (BOSException e) {
            AtsLog.getLog().error((Object)e);
        }
    }

    private void initCurAdmins() throws BOSException {
        try {
            this.curAdmins = AtsAdminUtile.getSubAdminByLongNumber((Context)this.ctx, (String)this.plan.getAdminOrgUnit().getLongNumber(), (String)this.plan.getHrOrgUnit().getId().toString(), null);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)new AtsCommonBizException(AtsCommonBizException.INITADMINORGERROR));
        }
    }

    private void initWorkDay() throws BOSException {
        StringBuffer sqlFilter = new StringBuffer();
        sqlFilter.append(" Select policy.fid policyid,policy.fname" + MLUtile.getMlFlag((Context)this.ctx) + " policyName from  T_HR_ATS_AttencePolicy policy");
        sqlFilter.append(" join t_org_admin adminats on adminats.fid=policy.fadminOrgUnitId");
        sqlFilter.append(" JOIN T_ATS_AttencePolicyAvailable available on  available.FBaseInfoId=policy.fid");
        sqlFilter.append(" where policy.fisdefault=1 and policy.fstate=1 and  adminats.fid in ").append(AtsCollectionUtile.joinForSqlWithBrackets((Collection)AtsAdminUtile.getSuperAdminByLongNumber((Context)this.ctx, (String)this.plan.getAdminOrgUnit().getLongNumber(), null)));
        sqlFilter.append("and available.fHrOrgUseId='").append(this.plan.getHrOrgUnit().getId().toString()).append("'");
        sqlFilter.append(" order by adminats.flongnumber desc");
        String policyid = null;
        String policyName = null;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlFilter.toString());
            while (rowSet.next()) {
                policyid = rowSet.getString("policyid");
                if (!StringUtils.isNotBlank((String)policyid)) continue;
                policyName = rowSet.getString("policyName") + "[id:" + policyid + "]";
                AtsLog.getLog().error((Object)("the attendance policy used this time is" + policyName));
                break;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)new AtsFileBizException(AtsFileBizException.INITPOLICYRELATEADMINERROR, (Throwable)e));
        }
        if (policyid == null) {
            throw new BOSException((Throwable)new AtsOrgBizException(AtsOrgBizException.NOAPOLICYRELATEADORG, new Object[]{this.plan.getAdminOrgUnit().getLongNumber()}));
        }
        StringBuffer workDaySql = new StringBuffer();
        workDaySql.append(" SELECT count(*) as val FROM T_HR_ATS_WorkCalendarItem  item ");
        workDaySql.append(" join T_HR_ATS_WorkCalendar atsCalendar on item.FCalendarGroupID = atsCalendar.fid ");
        workDaySql.append(" join T_HR_ATS_AttencePolicy policy on policy.fworkcalendarid = atsCalendar.fid ");
        workDaySql.append(" where 1 = 1 and atsCalendar.fstate = 1 ");
        workDaySql.append(" and fdate >= {ts '").append(AtsCommonUtile.formateTime((Date)this.beginDate1)).append("'}");
        workDaySql.append(" and fdate <= {ts '").append(AtsCommonUtile.formateTime((Date)this.endDate1)).append("'}");
        workDaySql.append(" and fdayType =0 and policy.fid='").append(policyid).append("'");
        try {
            this.workDay = AtsSqlUtile.getOneFieldVal((Context)this.ctx, (String)workDaySql.toString()).getBigDecimal("data");
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)new AttCycleBizException(AttCycleBizException.INITWORKDAYERRORINCYCLE, (Throwable)e, new Object[]{policyName}));
        }
        if (this.workDay != null && this.workDay.compareTo(new BigDecimal(1)) < 0) {
            throw new BOSException((Throwable)new AttCycleBizException(AttCycleBizException.NOWORKDAY, new Object[]{policyName}));
        }
    }

    private void initStaffNum() throws BOSException {
        String filter = ((OTCtrlPlanDepItemInfo)this.planItem).getGroup().getPersonSource() == EOTCtrlPersonSource.InCount ? "PERSON.EMPLOYEETYPE.isInCount" : "PERSON.EMPLOYEETYPE.isOnTheStrength";
        try {
            this.staffNum = OTCLUtile.getOrgPersonNumV85(this.ctx, this.plan.getHrOrgUnit().getId().toString(), this.curAdmins, filter, AtsCommonUtile.getPreDay((Date)this.beginDate1));
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)new AtsFileBizException(AtsFileBizException.INITPERCOUNTERRORINORG, (Throwable)e));
        }
    }

    @Override
    protected void groupUpdateAndNew() {
        for (AttenceDepOTLimitInfo info : this.generateResults) {
            int index;
            List perList = (List)this.existLimitMap.get(info.getAdminOrgUnit().getLongNumber());
            int n = index = perList == null ? -1 : AtsCollectionUtile.indexOf((Collection)perList, (Object)info, (AtsEQFn)this.limitEquasComparator);
            if (index == -1) {
                this.newColl.add(info);
                continue;
            }
            if (perList == null) continue;
            this.processUpdateInfo(info, (AttenceDepOTLimitInfo)perList.get(index));
        }
    }

    @Override
    protected void processUpdateInfo(AttenceDepOTLimitInfo newInfo, AttenceDepOTLimitInfo oldInfo) {
        if (this.plan.getUpdateType() == EOTUpdateType.cover) {
            newInfo.setId(oldInfo.getId());
            newInfo.setCreateTime(oldInfo.getCreateTime());
            newInfo.setCreator(oldInfo.getCreator());
            this.updateColl.add(newInfo);
        }
    }

    @Override
    protected void initLimitEquasComparator() {
        this.limitEquasComparator = new AtsEQFn<AttenceDepOTLimitInfo>(){

            public boolean eq(AttenceDepOTLimitInfo t1, Object t2) {
                if (t1 == t2) {
                    return true;
                }
                if (t1 == null || t2 == null) {
                    return false;
                }
                if (t1.getClass() != t2.getClass()) {
                    return false;
                }
                AttenceDepOTLimitInfo other = (AttenceDepOTLimitInfo)t2;
                if (t1.getHrOrgHashCode() != other.getHrOrgHashCode()) {
                    return false;
                }
                if (t1.getAdminHashCode() != other.getAdminHashCode()) {
                    return false;
                }
                if (t1.getLiTypeHashCode() != other.getLiTypeHashCode()) {
                    return false;
                }
                return t1.getdateVHashCode() == other.getdateVHashCode();
            }
        };
    }

    protected void initUsedOTFreeMap() {
        String ctrlTypeSql = OTCLUtile.getOTBillfreeSql(((OTCtrlPlanDepItemInfo)this.planItem).getCtrlType());
        if (StringUtils.isBlank((String)ctrlTypeSql)) {
            return;
        }
        BigDecimal otfree = new BigDecimal(0);
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)this.getDepBillEntryTitle(this.plan.getAdminOrgUnit().getLongNumber(), true).append(ctrlTypeSql).toString());
            while (rowSet.next()) {
                BigDecimal relOt = new BigDecimal(rowSet.getString("frealOTTIME"));
                String otType = rowSet.getString("FOTTypeID");
                if (otType.equalsIgnoreCase("rBy0u1YgQ9C1OxcM85mxyY6C/nU=")) {
                    otfree = otfree.add(relOt.multiply(BigDecimal.valueOf(1.5)));
                    continue;
                }
                if (otType.equalsIgnoreCase("zr+ur5D4RA+2bdVZ2VPqp46C/nU=")) {
                    otfree = otfree.add(relOt.multiply(new BigDecimal(2)));
                    continue;
                }
                if (!otType.equalsIgnoreCase("sRWUOt7sRpOY0TCo6NMqGY6C/nU=")) continue;
                otfree = otfree.add(relOt.multiply(new BigDecimal(3)));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.usedOTFree = otfree.multiply(this.plan.getLimitCtrlParam().getOTfree());
    }

    @Override
    protected void initExistLimitMap() {
        EntityViewInfo evi = AtsViewUtile.getViewBySelector((String[])new String[]{"id", "longNumber", "adminOrgUnit.id", "attenceOTCycle", "controlTimeRag", "hrOrgUnit.id", "creator", "createTime"});
        AtsViewUtile.getViewByFilter((String)"ControlType", (Object)((OTCtrlPlanDepItemInfo)this.planItem).getCtrlType().getValue(), (CompareType)CompareType.EQUALS, (EntityViewInfo)evi);
        AtsViewUtile.getViewByFilter((String)"adminOrgUnit.id", this.curAdmins, (CompareType)CompareType.INCLUDE, (EntityViewInfo)evi);
        AtsViewUtile.getViewByFilter((String)"hrOrgUnit", (Object)this.plan.getHrOrgUnit().getId().toString(), (CompareType)CompareType.EQUALS, (EntityViewInfo)evi);
        AtsViewUtile.getViewByFilter((String)"beginDate", (Object)this.endDate1, (CompareType)CompareType.LESS_EQUALS, (EntityViewInfo)evi);
        AtsViewUtile.getViewByFilter((String)"endDate", (Object)this.beginDate1, (CompareType)CompareType.GREATER_EQUALS, (EntityViewInfo)evi);
        AttenceDepOTLimitCollection coll = null;
        try {
            coll = AttenceDepOTLimitFactory.getLocalInstance(this.ctx).getAttenceDepOTLimitCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)coll)) {
            String longNumber = this.plan.getAdminOrgUnit().getLongNumber();
            this.existLimitMap.put(longNumber, AtsCollectionUtile.toList((IObjectCollection)coll, AttenceDepOTLimitInfo.class));
        }
    }

    private void generateSpecialLimitInfo(String adminId) {
        AttenceDepOTLimitInfo depOTLimitInfo = new AttenceDepOTLimitInfo();
        depOTLimitInfo.setStaffNum(this.staffNum);
        depOTLimitInfo.setWorkDay(this.workDay);
        depOTLimitInfo.setMonthAvgeOTfree(((OTCtrlPlanDepItemInfo)this.planItem).getPerAVGOTFee());
        depOTLimitInfo.setMonthAvgTimeVal(((OTCtrlPlanDepItemInfo)this.planItem).getPerAveTime());
        BigDecimal staffCount = new BigDecimal(this.staffNum);
        depOTLimitInfo.setOTfreeVal(depOTLimitInfo.getMonthAvgeOTfree().multiply(staffCount));
        depOTLimitInfo.setWorkTimeVal(depOTLimitInfo.getMonthAvgTimeVal().multiply(staffCount));
        depOTLimitInfo.setOTfreeAvgVal(depOTLimitInfo.getOTfreeVal().divide(depOTLimitInfo.getWorkDay(), DecimalPlaceUtil.getDecimalPlaceSystem((Context)this.ctx), RoundingMode.HALF_UP));
        depOTLimitInfo.setWorkTimeAvgVal(depOTLimitInfo.getWorkTimeVal().divide(depOTLimitInfo.getWorkDay(), DecimalPlaceUtil.getDecimalPlaceSystem((Context)this.ctx), RoundingMode.HALF_UP));
        depOTLimitInfo.setUsedfreeVal(this.usedOTFree);
        depOTLimitInfo.setRemainfreeVal(depOTLimitInfo.getOTfreeVal().subtract(depOTLimitInfo.getUsedfreeVal()));
        depOTLimitInfo.setUsedTimeVal(this.getBigVal(this.usedLimitMap, adminId));
        depOTLimitInfo.setRemainTimeVal(depOTLimitInfo.getWorkTimeVal().subtract(depOTLimitInfo.getUsedTimeVal()));
        depOTLimitInfo.setBeginDate(this.beginDate1);
        depOTLimitInfo.setEndDate(this.endDate1);
        depOTLimitInfo.setName(((OTCtrlPlanDepItemInfo)this.planItem).getGroup().getAdminOrgUnit().getNumber());
        depOTLimitInfo.setAdminOrgUnit(((OTCtrlPlanDepItemInfo)this.planItem).getGroup().getAdminOrgUnit());
        depOTLimitInfo.setHrOrgUnit(((OTCtrlPlanDepItemInfo)this.planItem).getGroup().getHrOrgUnit());
        depOTLimitInfo.setControlTimeRag(this.limitCycleName1);
        depOTLimitInfo.setControlType(((OTCtrlPlanDepItemInfo)this.planItem).getCtrlType());
        depOTLimitInfo.setAttenceOTCycle(((OTCtrlPlanDepItemInfo)this.planItem).getGroup().getCycleType());
        depOTLimitInfo.setOtLimitControlParam(((OTCtrlPlanDepItemInfo)this.planItem).getGroup().getLimitCtrlParam());
        depOTLimitInfo.setCreateTime(this.getCurTime());
        depOTLimitInfo.setCreator(this.getCurrentUserInfo());
        depOTLimitInfo.setLastUpdateTime(this.getCurTime());
        depOTLimitInfo.setLastUpdateUser(this.getCurrentUserInfo());
        depOTLimitInfo.setCU(this.getCuInfo());
        if (((OTCtrlPlanDepItemInfo)this.planItem).getGroup().getCycleType() == AttenceOTCycleType.attenceCycle) {
            depOTLimitInfo.setRelatedRecord(this.periodOnAttedCycle);
        }
        this.generateResults.add(depOTLimitInfo);
    }

    private BigDecimal getBigVal(Map<String, BigDecimal> map, String key) {
        BigDecimal data = map.get(key);
        return data == null ? new BigDecimal(0) : data;
    }

    private StringBuffer getDepBillEntryTitle(String adminLongNumber, boolean calFee) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select ").append(calFee ? "frealOTTIME,FOTTypeID" : "sum(frealOTTIME) val");
        sql.append(" from T_HR_ATS_OverTimeBillentry entrys");
        sql.append(" left join t_org_admin org on org.fid = entrys.fadminorgunitid");
        sql.append(" LEFT JOIN T_HR_ATS_OVERTIMEBILL BILL ON BILL.FID = entrys.FBILLID ");
        sql.append(" where FBILLSTATE = 3 and org.fid in ").append(AtsCollectionUtile.joinForSqlWithBrackets(this.curAdmins));
        sql.append(" and entrys.fotdate >= {ts '").append(AtsCommonUtile.formateTime((Date)this.beginDate1)).append("'}");
        sql.append(" and entrys.fotdate <= {ts '").append(AtsCommonUtile.formateTime((Date)this.endDate1)).append("'}");
        return sql;
    }

    @Override
    protected void initUsedLimitMap() {
        String adminLongNumber = this.plan.getAdminOrgUnit().getLongNumber();
        StringBuffer sqlbuf = this.getDepBillEntryTitle(adminLongNumber, false);
        sqlbuf.append(OTCLUtile.getOTBillCycleTypeSql(((OTCtrlPlanDepItemInfo)this.planItem).getCtrlType()));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlbuf.toString());
            while (rs.next()) {
                this.usedLimitMap.put(adminLongNumber, rs.getBigDecimal("val"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public final int getStaffNum() {
        return this.staffNum;
    }

    public final void setStaffNum(int staffNum) {
        this.staffNum = staffNum;
    }

    public final BigDecimal getWorkDay() {
        return this.workDay;
    }

    public final void setWorkDay(BigDecimal workDay) {
        this.workDay = workDay;
    }

    public final BigDecimal getUsedOTFree() {
        return this.usedOTFree;
    }

    public final void setUsedOTFree(BigDecimal usedOTFree) {
        this.usedOTFree = usedOTFree;
    }

    public Set<String> getCurAdmins() {
        return this.curAdmins;
    }

    public void setCurAdmins(Set<String> curAdmins) {
        this.curAdmins = curAdmins;
    }
}

