/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.atsContrl.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.util.GroupControlUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.atsContrl.AtsOtLimitControlParamCollection;
import com.kingdee.eas.hr.atsContrl.AtsOtLimitControlParamFactory;
import com.kingdee.eas.hr.atsContrl.AtsOtLimitControlParamInfo;
import com.kingdee.eas.hr.atsContrl.AtsOverTimeLimitRuleStatueEnum;
import com.kingdee.eas.hr.atsContrl.AttenceOTControlType;
import com.kingdee.eas.hr.atsContrl.AttenceOTCycleType;
import com.kingdee.eas.hr.atsContrl.OtLimitCtrlEnableSettingCollection;
import com.kingdee.eas.hr.atsContrl.OtLimitCtrlEnableSettingFactory;
import com.kingdee.eas.hr.atsContrl.OtLimitCtrlEnableSettingInfo;
import com.kingdee.eas.hr.atsContrl.util.AtsControlLimitBean;
import com.kingdee.eas.hr.atsContrl.util.AttendContrlServerConstant;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AtsControlServerUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.attendContrl.web.util.AtsControlServerUtil");
    private Context ctx;
    private AtsOtLimitControlParamCollection param = null;
    private Map<String, AtsControlLimitBean> totalMapForPerOT = new HashMap<String, AtsControlLimitBean>();
    private Map<String, AtsControlLimitBean> totalMapForDepOT = new HashMap<String, AtsControlLimitBean>();
    private Map<String, AtsControlLimitBean> totalMapForDepOTCompens = new HashMap<String, AtsControlLimitBean>();
    private int index = 1;

    public AtsControlServerUtil(Context ctx) {
        this.ctx = ctx;
        this.initParam(ctx);
    }

    public void initParam(Context ctx) {
        try {
            this.param = AtsOtLimitControlParamFactory.getLocalInstance(ctx).getAtsOtLimitControlParamCollection();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
    }

    public List<AtsOverTimeBillInfo> getRecalculateOvertimeList(List<AtsOverTimeBillInfo> overtimeListBefore, Map<String, String> overTimeControlMap) {
        ArrayList<AtsOverTimeBillInfo> recalculateOvertimeList = null;
        if (null != overtimeListBefore && overtimeListBefore.size() > 0 && null != overTimeControlMap && overTimeControlMap.size() > 0) {
            recalculateOvertimeList = new ArrayList<AtsOverTimeBillInfo>();
            for (int i = 0; i < overtimeListBefore.size(); ++i) {
                String state;
                String hrOrgUnitId = overtimeListBefore.get(i).getHrOrgUnit().getId().toString();
                if (!StringUtils.isNotEmpty((CharSequence)hrOrgUnitId) || !StringUtils.isNotEmpty((CharSequence)(state = overTimeControlMap.get(hrOrgUnitId))) || !AtsOverTimeLimitRuleStatueEnum.enable.getValue().equals(state)) continue;
                recalculateOvertimeList.add(overtimeListBefore.get(i));
            }
        }
        return recalculateOvertimeList;
    }

    public List<AtsOverTimeBillEntryInfo> getRecalculateOvertimeEntryList(List<AtsOverTimeBillEntryInfo> overTimeBillEntryInfos, Map<String, String> overTimeControlMap) {
        ArrayList<AtsOverTimeBillEntryInfo> recalculateOvertimeList = null;
        if (null != overTimeBillEntryInfos && overTimeBillEntryInfos.size() > 0 && null != overTimeControlMap && overTimeControlMap.size() > 0) {
            recalculateOvertimeList = new ArrayList<AtsOverTimeBillEntryInfo>();
            for (int i = 0; i < overTimeBillEntryInfos.size(); ++i) {
                String state;
                String hrOrgUnitId = overTimeBillEntryInfos.get(i).getBill().getHrOrgUnit().getId().toString();
                if (!StringUtils.isNotEmpty((CharSequence)hrOrgUnitId) || !StringUtils.isNotEmpty((CharSequence)(state = overTimeControlMap.get(hrOrgUnitId))) || !AtsOverTimeLimitRuleStatueEnum.enable.getValue().equals(state)) continue;
                recalculateOvertimeList.add(overTimeBillEntryInfos.get(i));
            }
        }
        return recalculateOvertimeList;
    }

    public void recalculatePersonOTlimit(HashMap<String, BigDecimal> preData, List<AtsOverTimeBillEntryInfo> afterData) {
        if (afterData.size() <= 0) {
            logger.error((Object)"afterData_size 0");
            return;
        }
        logger.error((Object)("enter recalculatePersonOTlimit preDataSize===" + preData.size()));
        logger.error((Object)("enter recalculatePersonOTlimit afterDataSize===" + afterData.size()));
        if (preData.size() != afterData.size()) {
            logger.error((Object)"preData size  not equst afterDate size");
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<Object[]> updatePerParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> updateDepParamList = new ArrayList<Object[]>();
        BigDecimal oTPaymentPerhour = new BigDecimal(12);
        if (this.param.size() > 0) {
            oTPaymentPerhour = this.param.get(0).getOTfree();
        }
        for (int index = 0; index < afterData.size(); ++index) {
            AtsOverTimeBillEntryInfo afterBillEntryInfo = afterData.get(index);
            String entryId = afterBillEntryInfo.getId().toString();
            BigDecimal preRealOtLength = preData.get(entryId);
            BigDecimal afterRealOtLength = afterBillEntryInfo.getRealOTTime();
            if (preRealOtLength == null) {
                logger.error((Object)("entry id is " + preRealOtLength + "  not has preRealOtLength"));
                continue;
            }
            if (preRealOtLength.compareTo(afterRealOtLength) == 0) continue;
            BigDecimal subtractOtLength = afterRealOtLength.subtract(preRealOtLength);
            logger.info((Object)("recalculatePersonOTlimit_billid===" + entryId + "==subtractOtLength" + subtractOtLength));
            BigDecimal nSubtractOtLength = new BigDecimal(0).subtract(subtractOtLength);
            BigDecimal payMent = new BigDecimal(0);
            String otCompens = afterBillEntryInfo.getOtCompens().getId().toString();
            String personId = afterBillEntryInfo.getPerson().getId().toString();
            Date oTDate = afterBillEntryInfo.getOtDate();
            Timestamp timestamp = new Timestamp(oTDate.getTime());
            String otType = afterBillEntryInfo.getOtType().getId().toString();
            String orgId = afterBillEntryInfo.getAdminOrgUnit().getId().toString();
            String orgNumber = this.getOrgLongNumberByorgId(orgId);
            Set<String> parentOrgLongNumsSet = AtsControlServerUtil.getParentOrgsByOrgLongNum(orgNumber);
            String parentOrgLongNums = AtsUtil.convertSetToString(parentOrgLongNumsSet);
            List<String> orgIdList = this.getOrgIdbyLongNum(parentOrgLongNums);
            if (AttendContrlServerConstant.OTCOMPENS_PAY.equalsIgnoreCase(otCompens)) {
                payMent = AtsControlServerUtil.getOtPayment(subtractOtLength, otType, oTPaymentPerhour);
            }
            BigDecimal npayMent = new BigDecimal(0).subtract(payMent);
            int[] limitType = AtsControlServerUtil.getLimitType(otType, otCompens);
            if (null == limitType || orgIdList.size() == 0 || null == limitType || limitType.length <= 0) continue;
            for (int x = 0; x < limitType.length; ++x) {
                Object[] updatePerParam = new Object[]{subtractOtLength, nSubtractOtLength, personId, timestamp, timestamp, String.valueOf(limitType[x])};
                updatePerParamList.add(updatePerParam);
                for (int y = 0; y < orgIdList.size(); ++y) {
                    Object[] updateDepParam = new Object[]{subtractOtLength, nSubtractOtLength, payMent, npayMent, orgIdList.get(y), timestamp, timestamp, String.valueOf(limitType[x])};
                    updateDepParamList.add(updateDepParam);
                }
            }
        }
        logger.info((Object)("enter recalculatePersonOTlimit updatePerParamList===" + updatePerParamList.size()));
        if (updatePerParamList.size() > 0) {
            this.updatePerOTLimit(updatePerParamList);
        }
        logger.info((Object)("enter recalculatePersonOTlimit updateDepParamList===" + updateDepParamList.size()));
        if (updateDepParamList.size() > 0) {
            this.updateDepOTLimit(updateDepParamList);
        }
    }

    public void recalculatePersonOTlimit(List<AtsOverTimeBillInfo> preData, List<AtsOverTimeBillInfo> afterData) {
        if (afterData.size() <= 0) {
            logger.error((Object)"afterData_size 0");
            return;
        }
        logger.error((Object)("enter recalculatePersonOTlimit preDataSize===" + preData.size()));
        logger.error((Object)("enter recalculatePersonOTlimit afterDataSize===" + afterData.size()));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<Object[]> updatePerParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> updateDepParamList = new ArrayList<Object[]>();
        BigDecimal oTPaymentPerhour = new BigDecimal(12);
        if (this.param.size() > 0) {
            oTPaymentPerhour = this.param.get(0).getOTfree();
        }
        for (int i = 0; i < afterData.size(); ++i) {
            AtsOverTimeBillInfo afterInfo = afterData.get(i);
            String afterInfoId = afterInfo.getId().toString();
            AtsOverTimeBillEntryCollection afterEntryCol = afterInfo.getEntries();
            for (int j = 0; j < preData.size(); ++j) {
                AtsOverTimeBillInfo preInfo = preData.get(j);
                String preInfoId = preInfo.getId().toString();
                if (!afterInfoId.equalsIgnoreCase(preInfoId)) continue;
                AtsOverTimeBillEntryCollection preEntryCol = preInfo.getEntries();
                for (int m = 0; m < afterEntryCol.size(); ++m) {
                    AtsOverTimeBillEntryInfo afterEntryInfo = afterEntryCol.get(m);
                    String afterEntryInfoID = afterEntryInfo.getId().toString();
                    for (int n = 0; n < preEntryCol.size(); ++n) {
                        AtsOverTimeBillEntryInfo preEntryInfo = preEntryCol.get(n);
                        String preEntryInfoID = preEntryInfo.getId().toString();
                        if (!afterEntryInfoID.equalsIgnoreCase(preEntryInfoID)) continue;
                        BigDecimal afterRealOtLength = afterEntryInfo.getRealOTTime();
                        BigDecimal preRealOtLength = preEntryInfo.getRealOTTime();
                        if (preRealOtLength.compareTo(afterRealOtLength) == 0) continue;
                        BigDecimal subtractOtLength = afterRealOtLength.subtract(preRealOtLength);
                        logger.info((Object)("recalculatePersonOTlimit_billid===" + preEntryInfoID + "==subtractOtLength" + subtractOtLength));
                        BigDecimal nSubtractOtLength = new BigDecimal(0).subtract(subtractOtLength);
                        BigDecimal payMent = new BigDecimal(0);
                        String otCompens = afterEntryInfo.getOtCompens().getId().toString();
                        String personId = afterEntryInfo.getPerson().getId().toString();
                        Date oTDate = afterEntryInfo.getOtDate();
                        Timestamp timestamp = new Timestamp(oTDate.getTime());
                        String otType = afterEntryInfo.getOtType().getId().toString();
                        String orgId = afterEntryInfo.getAdminOrgUnit().getId().toString();
                        String orgNumber = this.getOrgLongNumberByorgId(orgId);
                        Set<String> parentOrgLongNumsSet = AtsControlServerUtil.getParentOrgsByOrgLongNum(orgNumber);
                        String parentOrgLongNums = AtsUtil.convertSetToString(parentOrgLongNumsSet);
                        List<String> orgIdList = this.getOrgIdbyLongNum(parentOrgLongNums);
                        if (AttendContrlServerConstant.OTCOMPENS_PAY.equalsIgnoreCase(otCompens)) {
                            payMent = AtsControlServerUtil.getOtPayment(subtractOtLength, otType, oTPaymentPerhour);
                        }
                        BigDecimal npayMent = new BigDecimal(0).subtract(payMent);
                        int[] limitType = AtsControlServerUtil.getLimitType(otType, otCompens);
                        if (null == limitType || orgIdList.size() == 0 || null == limitType || limitType.length <= 0) continue;
                        for (int x = 0; x < limitType.length; ++x) {
                            Object[] updatePerParam = new Object[]{subtractOtLength, nSubtractOtLength, personId, timestamp, timestamp, String.valueOf(limitType[x])};
                            updatePerParamList.add(updatePerParam);
                            for (int y = 0; y < orgIdList.size(); ++y) {
                                Object[] updateDepParam = new Object[]{subtractOtLength, nSubtractOtLength, payMent, npayMent, orgIdList.get(y), timestamp, timestamp, String.valueOf(limitType[x])};
                                updateDepParamList.add(updateDepParam);
                            }
                        }
                    }
                }
            }
        }
        logger.info((Object)("enter recalculatePersonOTlimit updatePerParamList===" + updatePerParamList.size()));
        if (updatePerParamList.size() > 0) {
            this.updatePerOTLimit(updatePerParamList);
        }
        logger.info((Object)("enter recalculatePersonOTlimit updateDepParamList===" + updateDepParamList.size()));
        if (updateDepParamList.size() > 0) {
            this.updateDepOTLimit(updateDepParamList);
        }
    }

    public static BigDecimal getOtPayment(BigDecimal otLength, String otType, BigDecimal oTPaymentPerhour) {
        BigDecimal totalPayment = new BigDecimal(0);
        BigDecimal multiple = BigDecimal.valueOf(1.5);
        if (AttendContrlServerConstant.OTTYPE_HOLIDAYDAY.equalsIgnoreCase(otType)) {
            multiple = new BigDecimal(3);
        } else if (AttendContrlServerConstant.OTTYPE_RESTDAY.equalsIgnoreCase(otType)) {
            multiple = new BigDecimal(2);
        }
        totalPayment = otLength.multiply(oTPaymentPerhour).multiply(multiple);
        return totalPayment;
    }

    public static Map<String, Object> getOTContrlParams() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        try {
            AtsOtLimitControlParamCollection param = AtsOtLimitControlParamFactory.getRemoteInstance().getAtsOtLimitControlParamCollection();
            if (param.size() > 0) {
                AttenceOTControlType controlType = param.get(0).getPerControlType();
                AttenceOTCycleType cycleType = param.get(0).getPerCycleType();
                int perLimitAdjusetPercent = param.get(0).getPerLimitAdjust();
                BigDecimal perHourPayMent = param.get(0).getOTfree();
                res.put("defaultCycleType", (Object)cycleType);
                res.put("defaultControlType", (Object)controlType);
                res.put("perLimitAdjusetPercent", perLimitAdjusetPercent);
                res.put("perHourPayMent", perHourPayMent);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static AtsOtLimitControlParamInfo getOTContrlParam(String hrOrgUnitId, Context ctx) {
        AtsOtLimitControlParamInfo info = null;
        try {
            OtLimitCtrlEnableSettingInfo settingInfo = OtLimitCtrlEnableSettingFactory.getLocalInstance(ctx).getOtLimitCtrlEnableSettingInfo(" where hrOrgUnit.id = '" + hrOrgUnitId + "' ");
            if (settingInfo == null || settingInfo.getState().equals((Object)AtsOverTimeLimitRuleStatueEnum.disable)) {
                return null;
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        AtsOtLimitControlParamCollection coll = null;
        try {
            coll = AtsOtLimitControlParamFactory.getLocalInstance(ctx).getAtsOtLimitControlParamCollection(" select *, perCtrlSettingEntries.*, depCtrlSettingEntries.* where hrOrgUnit.id = '" + hrOrgUnitId + "' ");
            if (coll != null && coll.size() > 0) {
                coll.sort("flastupdatetime");
                info = coll.get(coll.size() - 1);
            } else {
                String sql = " select top 1 otpca.fbaseInfoId fid from T_ATS_OtLimitControlAvailable otpca inner join T_HR_ATS_AtsOtLimitControlPar otp on otpca.fbaseInfoId = otp.fid  where otpca.fhrOrgUseId = '" + hrOrgUnitId + "' and otpca.fstate = 100  order by otp.fnumber asc ";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rs != null && rs.next()) {
                    String avaliableParId = rs.getString("fid");
                    coll = AtsOtLimitControlParamFactory.getLocalInstance(ctx).getAtsOtLimitControlParamCollection("select *, perCtrlSettingEntries.*, depCtrlSettingEntries.*  where id = '" + avaliableParId + "' ");
                }
                if (coll != null && coll.size() > 0) {
                    info = coll.get(0);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return info;
    }

    public static int[] getLimitType(String otType, String otCompens) {
        int[] limitTypeArray = null;
        if (otType.equalsIgnoreCase(AttendContrlServerConstant.OTTYPE_WORKDAY) && otCompens.equalsIgnoreCase(AttendContrlServerConstant.OTCOMPENS_REST)) {
            int[] limitTypeArrayTemp;
            limitTypeArray = limitTypeArrayTemp = new int[]{1, 2, 5, 6, 7};
        } else if (otType.equalsIgnoreCase(AttendContrlServerConstant.OTTYPE_RESTDAY) && otCompens.equalsIgnoreCase(AttendContrlServerConstant.OTCOMPENS_REST)) {
            int[] limitTypeArrayTemp = new int[]{1, 3, 5, 6, 8};
            limitTypeArray = limitTypeArrayTemp;
        } else if (otType.equalsIgnoreCase(AttendContrlServerConstant.OTTYPE_WORKDAY) && otCompens.equalsIgnoreCase(AttendContrlServerConstant.OTCOMPENS_PAY)) {
            int[] limitTypeArrayTemp = new int[]{1, 2, 5, 9, 10, 13};
            limitTypeArray = limitTypeArrayTemp;
        } else if (otType.equalsIgnoreCase(AttendContrlServerConstant.OTTYPE_RESTDAY) && otCompens.equalsIgnoreCase(AttendContrlServerConstant.OTCOMPENS_PAY)) {
            int[] limitTypeArrayTemp = new int[]{1, 3, 5, 9, 11, 13};
            limitTypeArray = limitTypeArrayTemp;
        } else if (otType.equalsIgnoreCase(AttendContrlServerConstant.OTTYPE_HOLIDAYDAY) && otCompens.equalsIgnoreCase(AttendContrlServerConstant.OTCOMPENS_PAY)) {
            int[] limitTypeArrayTemp = new int[]{1, 4, 9, 12};
            limitTypeArray = limitTypeArrayTemp;
        } else if (otType.equalsIgnoreCase(AttendContrlServerConstant.OTTYPE_HOLIDAYDAY) && otCompens.equalsIgnoreCase(AttendContrlServerConstant.OTCOMPENS_REST)) {
            int[] limitTypeArrayTemp = new int[]{1, 4, 6};
            limitTypeArray = limitTypeArrayTemp;
        }
        return limitTypeArray;
    }

    public String getOrgLongNumberByorgId(String orgId) {
        String flongNumber = "";
        String sql = "select flongnumber from t_org_admin where fid='" + orgId + "'";
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rowset.next()) {
                flongNumber = rowset.getString("flongnumber");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flongNumber;
    }

    public static Set<String> getParentOrgsByOrgLongNum(String orgLongNum) {
        HashSet<String> parentOrgLongNums = new HashSet<String>();
        parentOrgLongNums.add(orgLongNum);
        while (orgLongNum.indexOf("!") > 0) {
            orgLongNum = orgLongNum.substring(0, orgLongNum.lastIndexOf("!"));
            parentOrgLongNums.add(orgLongNum);
        }
        return parentOrgLongNums;
    }

    private void updatePerOTLimit(List<Object[]> updatePerParamList) {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("update T_ATS_AtsPersonOTLimit set fused=fused+?,fremained=fremained+? where fproposerid=?");
        sqlBuf.append(" and fstartdate<=?");
        sqlBuf.append(" and fenddate>=?");
        sqlBuf.append(" and flimittype=?");
        try {
            DbUtil.executeBatch((Context)this.ctx, (String)sqlBuf.toString(), updatePerParamList);
        }
        catch (Exception e) {
            logger.error((Object)"calculate PersonOTLimit error!");
            e.printStackTrace();
        }
    }

    private void updateDepOTLimit(List<Object[]> updateDepParamList) {
        StringBuffer sqlDepBuf = new StringBuffer();
        sqlDepBuf.append("update T_HR_ATS_AttenceDepOTLimit set fusedtimeval=fusedtimeval+?,fremaintimeval=fremaintimeval+?,");
        sqlDepBuf.append("fusedfreeval=fusedfreeval+?,fremainfreeval=fremainfreeval+?");
        sqlDepBuf.append("  where fadminorgunitid=? and fbegindate <=?");
        sqlDepBuf.append(" and fenddate>=?");
        sqlDepBuf.append("and fcontroltype=?");
        try {
            DbUtil.executeBatch((Context)this.ctx, (String)sqlDepBuf.toString(), updateDepParamList);
        }
        catch (Exception e) {
            logger.error((Object)"calculate DepOTLimit error!");
            e.printStackTrace();
        }
    }

    private List<String> getOrgIdbyLongNum(String parentOrgLongNums) {
        ArrayList<String> orgIdList = new ArrayList<String>();
        String sql = "select fid from t_org_admin where flongnumber in(" + parentOrgLongNums + ")";
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rowset.next()) {
                orgIdList.add(rowset.getString("fid"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orgIdList;
    }

    public Map<String, Object> checkOverTimeLimit(Context ctx, AtsOverTimeBillEntryInfo entry, String hrOrgUnitId) throws BOSException {
        String resMsg;
        String returnVal;
        AttendanceFileHISInfo hisInfo;
        Locale locale = ctx.getLocale();
        HashMap<String, Object> res = new HashMap<String, Object>();
        ArrayList<String> errorMsgList = new ArrayList<String>();
        StringBuffer errorMSg = new StringBuffer();
        OtLimitCtrlEnableSettingInfo setting = null;
        try {
            setting = OtLimitCtrlEnableSettingFactory.getLocalInstance(ctx).getOtLimitCtrlEnableSettingInfo(" where hrOrgUnit.id = '" + hrOrgUnitId + "' ");
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        AtsOtLimitControlParamInfo paramInfo = AtsControlServerUtil.getOTContrlParam(hrOrgUnitId, ctx);
        if (paramInfo == null) {
            errorMSg.append(ResourceBase.getString((String)AttendContrlServerConstant.RESOURCENAME, (String)AttendContrlServerConstant.ERRORTIP_GETPARAMSFAIL, (Locale)locale));
            errorMsgList.add(errorMSg.toString());
            res.put("errorMsgList", errorMsgList);
            return res;
        }
        if (setting == null || setting.getPerNoOtLimitWay() == null || setting.getDepNoOtLimitWay() == null) {
            throw new RuntimeException("exist null val");
        }
        int perNotLimit = setting.getPerNoOtLimitWay().getValue();
        int depNotLimit = setting.getDepNoOtLimitWay().getValue();
        BigDecimal oTPaymentPerhour = paramInfo.getOTfree();
        ArrayList<String> hasNotLimitRecord = new ArrayList<String>();
        ArrayList overLimitRecord = new ArrayList();
        ArrayList<String> hasNotDepLimitRecord = new ArrayList<String>();
        ArrayList overDepLimitRecord = new ArrayList();
        ArrayList<String> overDepPaymentLimitRecord = new ArrayList<String>();
        ArrayList overAppDateRecord = new ArrayList();
        String appDateContrMsg = "";
        SimpleDateFormat shortFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDateTemp = new Date();
        String nowDate = shortFormat.format(nowDateTemp);
        Date oTDate = entry.getOtDate();
        String dateStr = shortFormat.format(oTDate);
        String personId = entry.getPerson().getId().toString();
        String orgId = entry.getAdminOrgUnit().getId().toString();
        String orgLongNum = this.getOrgLongNumberByorgId(orgId);
        String otType = entry.getOtType().getId().toString();
        String otCompens = entry.getOtCompens().getId().toString();
        String limitType = AtsControlServerUtil.getLimitTypeStr(otType, otCompens);
        BigDecimal oTlength = entry.getApplyOTTime();
        String checkPOTlimtRes = this.checkPersonOtLimit(personId, oTlength, dateStr, limitType, perNotLimit, (hisInfo = GroupControlUtil.getAttendanceFileHISInfoByAttenceDate((Context)ctx, (Date)entry.getOtDate(), (String)personId)).getHrOrgUnit().getId().toString());
        if (AttendContrlServerConstant.NOPEROTLIMITRECORD.equalsIgnoreCase(checkPOTlimtRes)) {
            hasNotLimitRecord.add(String.valueOf(1));
        }
        if (AttendContrlServerConstant.NODEPOTLIMITRECORD.equalsIgnoreCase(returnVal = this.checkDepsOtLimit(oTlength, orgLongNum, dateStr, limitType, depNotLimit, hisInfo.getHrOrgUnit().getId().toString()))) {
            hasNotDepLimitRecord.add(String.valueOf(1));
        } else if (AttendContrlServerConstant.OTCOMPENS_PAY.equalsIgnoreCase(otCompens) && AttendContrlServerConstant.OVERDEPOTPAYMENTLIMIT.equalsIgnoreCase(resMsg = this.checkDepsPayMentOtLimit(oTlength, orgLongNum, dateStr, limitType, oTPaymentPerhour, otType, hisInfo.getHrOrgUnit().getId().toString()))) {
            overDepPaymentLimitRecord.add(String.valueOf(1));
        }
        ArrayList<String> appDateContrMsgList = new ArrayList<String>();
        if (!"".equalsIgnoreCase(appDateContrMsg)) {
            // empty if block
        }
        appDateContrMsgList.add(appDateContrMsg);
        res.put("appDateContrMsgList", appDateContrMsgList);
        res.put("overAppDateRecord", overAppDateRecord);
        res.put("overLimitRecord", overLimitRecord);
        res.put("hasNotLimitRecord", hasNotLimitRecord);
        res.put("overDepLimitRecord", overDepLimitRecord);
        res.put("hasNotDepLimitRecord", hasNotDepLimitRecord);
        res.put("overDepPaymentLimitRecord", overDepPaymentLimitRecord);
        res.put("totalMapForPerOT", this.totalMapForPerOT);
        res.put("totalMapForDepOT", this.totalMapForDepOT);
        res.put("totalMapForDepOTCompens", this.totalMapForDepOTCompens);
        return res;
    }

    public OtLimitCtrlEnableSettingInfo getOtLimitCtrlEnableSetting(Context ctx, String hrOrgUnitId) {
        OtLimitCtrlEnableSettingCollection coll = null;
        try {
            coll = OtLimitCtrlEnableSettingFactory.getLocalInstance(ctx).getOtLimitCtrlEnableSettingCollection("where hrOrgUnit.id = '" + hrOrgUnitId + "' and state = 1");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (null != coll && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public Map<String, Object> checkOverTimeLimit(AtsOverTimeBillInfo atsOverTimeBillInfo, String uipk) throws BOSException {
        Locale locale = this.ctx.getLocale();
        HashMap<String, Object> res = new HashMap<String, Object>();
        ArrayList<String> errorMsgList = new ArrayList<String>();
        boolean isOTLimit = true;
        boolean BillAftAppContrl = false;
        boolean isPerbefAppBill = true;
        StringBuffer errorMSg = new StringBuffer();
        int perNotLimit = 1;
        int depNotLimit = 1;
        int billAftAppDay = 28;
        BigDecimal oTPaymentPerhour = new BigDecimal(12);
        OtLimitCtrlEnableSettingInfo otLimitCtrlEnableSettingInfo = this.getOtLimitCtrlEnableSetting(this.ctx, atsOverTimeBillInfo.getHrOrgUnit().getId().toString());
        if (null != otLimitCtrlEnableSettingInfo) {
            isOTLimit = true;
            perNotLimit = otLimitCtrlEnableSettingInfo.getPerNoOtLimitWay().getValue();
            depNotLimit = otLimitCtrlEnableSettingInfo.getDepNoOtLimitWay().getValue();
        }
        if (null == this.param || this.param.size() <= 0) {
            errorMSg.append(ResourceBase.getString((String)AttendContrlServerConstant.RESOURCENAME, (String)AttendContrlServerConstant.ERRORTIP_GETPARAMSFAIL, (Locale)locale));
            errorMsgList.add(errorMSg.toString());
            res.put("errorMsgList", errorMsgList);
            return res;
        }
        AtsOtLimitControlParamInfo paramInfo = this.param.get(0);
        isPerbefAppBill = paramInfo.isIsPerbefAppBill();
        BillAftAppContrl = paramInfo.isBillAftAppContrl();
        billAftAppDay = paramInfo.getBillAftAppDay();
        oTPaymentPerhour = paramInfo.getOTfree();
        AtsOverTimeBillEntryCollection entryInfoCol = atsOverTimeBillInfo.getEntries();
        ArrayList<String> hasNotLimitRecord = new ArrayList<String>();
        ArrayList overLimitRecord = new ArrayList();
        ArrayList<String> hasNotDepLimitRecord = new ArrayList<String>();
        ArrayList overDepLimitRecord = new ArrayList();
        ArrayList<String> overDepPaymentLimitRecord = new ArrayList<String>();
        ArrayList overAppDateRecord = new ArrayList();
        String appDateContrMsg = "";
        if (isOTLimit) {
            SimpleDateFormat shortFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date nowDateTemp = new Date();
            String nowDate = shortFormat.format(nowDateTemp);
            for (int i = 0; i < entryInfoCol.size(); ++i) {
                String resMsg;
                String returnVal;
                AttendanceFileHISInfo hisInfo;
                this.index = i + 1;
                AtsOverTimeBillEntryInfo entryInfo = entryInfoCol.get(i);
                if (!entryInfo.isAvailable()) continue;
                Date oTDate = entryInfo.getOtDate();
                String dateStr = shortFormat.format(oTDate);
                String personId = entryInfo.getPerson().getId().toString();
                String orgId = entryInfo.getAdminOrgUnit().getId().toString();
                String orgLongNum = this.getOrgLongNumberByorgId(orgId);
                String otType = entryInfo.getOtType().getId().toString();
                String otCompens = entryInfo.getOtCompens().getId().toString();
                String limitType = AtsControlServerUtil.getLimitTypeStr(otType, otCompens);
                BigDecimal oTlength = entryInfo.getApplyOTTime();
                String checkPOTlimtRes = this.checkPersonOtLimit(personId, oTlength, dateStr, limitType, perNotLimit, (hisInfo = GroupControlUtil.getAttendanceFileHISInfoByAttenceDate((Context)this.ctx, (Date)entryInfo.getOtDate(), (String)personId)).getHrOrgUnit().getId().toString());
                if (AttendContrlServerConstant.NOPEROTLIMITRECORD.equalsIgnoreCase(checkPOTlimtRes)) {
                    hasNotLimitRecord.add(String.valueOf(i + 1));
                }
                if (AttendContrlServerConstant.NODEPOTLIMITRECORD.equalsIgnoreCase(returnVal = this.checkDepsOtLimit(oTlength, orgLongNum, dateStr, limitType, depNotLimit, hisInfo.getHrOrgUnit().getId().toString()))) {
                    hasNotDepLimitRecord.add(String.valueOf(i + 1));
                    continue;
                }
                if (!AttendContrlServerConstant.OTCOMPENS_PAY.equalsIgnoreCase(otCompens) || !AttendContrlServerConstant.OVERDEPOTPAYMENTLIMIT.equalsIgnoreCase(resMsg = this.checkDepsPayMentOtLimit(oTlength, orgLongNum, dateStr, limitType, oTPaymentPerhour, otType, hisInfo.getHrOrgUnit().getId().toString()))) continue;
                overDepPaymentLimitRecord.add(String.valueOf(i + 1));
            }
        }
        ArrayList<String> appDateContrMsgList = new ArrayList<String>();
        if (!"".equalsIgnoreCase(appDateContrMsg)) {
            // empty if block
        }
        appDateContrMsgList.add(appDateContrMsg);
        res.put("appDateContrMsgList", appDateContrMsgList);
        res.put("overAppDateRecord", overAppDateRecord);
        res.put("overLimitRecord", overLimitRecord);
        res.put("hasNotLimitRecord", hasNotLimitRecord);
        res.put("overDepLimitRecord", overDepLimitRecord);
        res.put("hasNotDepLimitRecord", hasNotDepLimitRecord);
        res.put("overDepPaymentLimitRecord", overDepPaymentLimitRecord);
        res.put("totalMapForPerOT", this.totalMapForPerOT);
        res.put("totalMapForDepOT", this.totalMapForDepOT);
        res.put("totalMapForDepOTCompens", this.totalMapForDepOTCompens);
        return res;
    }

    public static String getLimitTypeStr(String otType, String otCompens) {
        String limitType = null;
        limitType = otType.equalsIgnoreCase(AttendContrlServerConstant.OTTYPE_WORKDAY) && otCompens.equalsIgnoreCase(AttendContrlServerConstant.OTCOMPENS_REST) ? "'1','2','5','6','7'" : (otType.equalsIgnoreCase(AttendContrlServerConstant.OTTYPE_RESTDAY) && otCompens.equalsIgnoreCase(AttendContrlServerConstant.OTCOMPENS_REST) ? "'1','3','5','6','8'" : (otType.equalsIgnoreCase(AttendContrlServerConstant.OTTYPE_WORKDAY) && otCompens.equalsIgnoreCase(AttendContrlServerConstant.OTCOMPENS_PAY) ? "'1','2','5','9','10','13'" : (otType.equalsIgnoreCase(AttendContrlServerConstant.OTTYPE_RESTDAY) && otCompens.equalsIgnoreCase(AttendContrlServerConstant.OTCOMPENS_PAY) ? "'1','3','5','9','11','13'" : (otType.equalsIgnoreCase(AttendContrlServerConstant.OTTYPE_HOLIDAYDAY) && otCompens.equalsIgnoreCase(AttendContrlServerConstant.OTCOMPENS_PAY) ? "'1','4','9','12'" : (otType.equalsIgnoreCase(AttendContrlServerConstant.OTTYPE_HOLIDAYDAY) && otCompens.equalsIgnoreCase(AttendContrlServerConstant.OTCOMPENS_REST) ? "'1','4','6'" : "'1'")))));
        return limitType;
    }

    public boolean oTDateIsOverControl(String personID, String type, Date oTDate, String attendanceFileHisId) {
        StringBuffer sql = new StringBuffer();
        sql.append("select atsperiod.fname" + MLUtile.getMlFlag((Context)this.ctx) + " fname, atsperiod.fstartDate startDate, atsperiod.fendDate endDate from T_HR_ATS_AttendancePeriod atsperiod where atsperiod.fgroupid= ( ");
        sql.append("select atscycle.fid from T_HR_ATS_AttendanceFileHIS atsfile inner join T_HR_ATS_AttencePolicy atspolicy on atspolicy.fid=atsfile.fattencepolicyid ");
        sql.append("inner join T_ATS_AttenceCycle atscycle on  atscycle.fid=atspolicy.fattencecycleid ");
        sql.append("where atsfile.fproposerid='" + personID + "' and atsfile.fid='" + attendanceFileHisId + "')");
        sql.append(" order by atsperiod.fname" + MLUtile.getMlFlag((Context)this.ctx));
        Date nowDate = new Date();
        Date startDate = new Date();
        Date endDate = new Date();
        boolean flag = true;
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rowset.next()) {
                Date prestartDate = startDate;
                startDate = rowset.getDate("startDate");
                endDate = rowset.getDate("endDate");
                if (startDate.getTime() > nowDate.getTime() || nowDate.getTime() > endDate.getTime()) continue;
                if (type.equalsIgnoreCase("current")) {
                    if (oTDate.getTime() >= startDate.getTime()) continue;
                    flag = false;
                    continue;
                }
                if (oTDate.getTime() >= prestartDate.getTime()) continue;
                flag = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    public String checkPersonOtLimit(String personId, BigDecimal oTlength, String dateStr, String limitType, int perNotLimit, String hrOrgUnitId) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select * from T_ATS_AtsPersonOTLimit where fproposerid='" + personId + "' and fhrorgunitid='" + hrOrgUnitId + "' ");
        sqlBuf.append(" and to_Char(fstartdate,'yyyy-mm-dd')<='" + dateStr + "'");
        sqlBuf.append(" and to_Char(fenddate,'yyyy-mm-dd')>='" + dateStr + "'");
        sqlBuf.append(" and flimittype in(" + limitType + ")");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuf.toString());
            if (rowSet.size() == 0 && perNotLimit == 0) {
                return AttendContrlServerConstant.NOPEROTLIMITRECORD;
            }
            while (rowSet.next()) {
                BigDecimal remained = rowSet.getBigDecimal("fremained");
                String fstartDate = format.format(rowSet.getDate("fstartdate"));
                String fendDate = format.format(rowSet.getDate("fenddate"));
                String fdatevalue = rowSet.getString("fdatevalue");
                int flimittype = rowSet.getInt("flimittype");
                String flimittypeStr = rowSet.getString("flimittype");
                String otType = AttenceOTControlType.getEnum(flimittypeStr).getAlias();
                String key = personId + fdatevalue + flimittype;
                BigDecimal preLength = new BigDecimal(0);
                boolean exist = false;
                AtsControlLimitBean atsControlLimitBean = new AtsControlLimitBean();
                if (this.totalMapForPerOT.containsKey(key)) {
                    exist = true;
                    preLength = this.totalMapForPerOT.get(key).getTotalAppLength();
                } else {
                    atsControlLimitBean.setTotalAppLength(oTlength);
                    atsControlLimitBean.setOverLimit(false);
                    atsControlLimitBean.setDateValue(fdatevalue);
                    atsControlLimitBean.setOTType(otType);
                    ArrayList<String> record = new ArrayList<String>();
                    record.add(String.valueOf(this.index));
                    atsControlLimitBean.setRecordList(record);
                    this.totalMapForPerOT.put(key, atsControlLimitBean);
                }
                BigDecimal totalLength = preLength.add(oTlength);
                this.totalMapForPerOT.get(key).setTotalAppLength(totalLength);
                if (totalLength.compareTo(remained) > 0) {
                    if (exist) {
                        this.totalMapForPerOT.get(key).getRecordList().add(String.valueOf(this.index));
                    }
                    this.totalMapForPerOT.get(key).setOverLimit(true);
                    return AttendContrlServerConstant.OVERPEROTLIMITRECORD;
                }
                BigDecimal frozenOTLimit = this.getFrozenOTLimit(personId, fstartDate, fendDate, flimittype, hrOrgUnitId);
                if (totalLength.add(frozenOTLimit).compareTo(remained) <= 0) continue;
                if (exist) {
                    this.totalMapForPerOT.get(key).getRecordList().add(String.valueOf(this.index));
                }
                this.totalMapForPerOT.get(key).setOverLimit(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String checkDepsOtLimit(BigDecimal otLength, String longNum, String dateStr, String limitType, int depNotlimitWay, String hrOrgUnitId) {
        StringBuffer sql = new StringBuffer();
        Set<String> parentOrgLongNumsSet = AtsControlServerUtil.getParentOrgsByOrgLongNum(longNum);
        String parentOrgLongNums = AtsUtil.convertSetToString(parentOrgLongNumsSet);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        sql.append(" select dep.fcontrolTimeRag fcontrolTimeRag,dep.fcontroltype fcontroltype,dep.fremaintimeval fremaintimeval,dep.fremainfreeval fremainfreeval,dep.fbegindate fbegindate,dep.fenddate fenddate,org.flongnumber flongnumber from T_HR_ATS_AttenceDepOTLimit dep");
        sql.append("  left join t_org_admin org on  dep.fadminorgunitid=org.fid");
        sql.append("  where to_Char(dep.fbegindate,'yyyy-mm-dd')<='" + dateStr + "'");
        sql.append(" and to_Char(dep.fenddate,'yyyy-mm-dd')>='" + dateStr + "' and dep.fhrorgunitid='" + hrOrgUnitId + "' ");
        sql.append("and dep.fcontroltype in (" + limitType + ")  and org.flongnumber in (" + parentOrgLongNums + ")");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            if (rowset.size() == 0 && depNotlimitWay == 0) {
                return AttendContrlServerConstant.NODEPOTLIMITRECORD;
            }
            while (rowset.next()) {
                if (null == rowset.getBigDecimal("fremaintimeval")) continue;
                BigDecimal fremainlimit = rowset.getBigDecimal("fremaintimeval");
                String flongnumber = rowset.getString("flongnumber");
                String fstartDate = format.format(rowset.getDate("fbegindate"));
                String fendDate = format.format(rowset.getDate("fenddate"));
                String controlTimeRag = rowset.getString("fcontrolTimeRag");
                int fcontroltype = rowset.getInt("fcontroltype");
                String fcontroltypeStr = rowset.getString("fcontroltype");
                String otType = AttenceOTControlType.getEnum(fcontroltypeStr).getAlias();
                String key = flongnumber + controlTimeRag + fcontroltypeStr;
                BigDecimal preLength = new BigDecimal(0);
                boolean exist = false;
                AtsControlLimitBean atsControlLimitBean = new AtsControlLimitBean();
                if (this.totalMapForDepOT.containsKey(key)) {
                    exist = true;
                    preLength = this.totalMapForDepOT.get(key).getTotalAppLength();
                } else {
                    atsControlLimitBean.setTotalAppLength(otLength);
                    atsControlLimitBean.setOverLimit(false);
                    atsControlLimitBean.setDateValue(controlTimeRag);
                    atsControlLimitBean.setOTType(otType);
                    ArrayList<String> record = new ArrayList<String>();
                    record.add(String.valueOf(this.index));
                    atsControlLimitBean.setRecordList(record);
                    this.totalMapForDepOT.put(key, atsControlLimitBean);
                }
                BigDecimal totalLength = preLength.add(otLength);
                this.totalMapForDepOT.get(key).setTotalAppLength(totalLength);
                if (totalLength.compareTo(fremainlimit) > 0) {
                    if (exist) {
                        this.totalMapForDepOT.get(key).getRecordList().add(String.valueOf(this.index));
                    }
                    this.totalMapForDepOT.get(key).setOverLimit(true);
                    continue;
                }
                BigDecimal depFrozenVal = this.getDepsOtLimitFrozenInfo(flongnumber, fstartDate, fendDate, fcontroltype, hrOrgUnitId);
                if (totalLength.add(depFrozenVal).compareTo(fremainlimit) <= 0) continue;
                if (exist) {
                    this.totalMapForDepOT.get(key).setTotalAppLength(totalLength);
                    this.totalMapForDepOT.get(key).getRecordList().add(String.valueOf(this.index));
                }
                this.totalMapForDepOT.get(key).setOverLimit(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String checkDepsPayMentOtLimit(BigDecimal otLength, String longNum, String dateStr, String limitType, BigDecimal oTPaymentPerhour, String otType, String hrOrgUnitId) {
        StringBuffer sql = new StringBuffer();
        Set<String> parentOrgLongNumsSet = AtsControlServerUtil.getParentOrgsByOrgLongNum(longNum);
        String parentOrgLongNums = AtsUtil.convertSetToString(parentOrgLongNumsSet);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        sql.append(" select dep.fcontrolTimeRag fcontrolTimeRag,dep.fcontroltype fcontroltype,dep.fremaintimeval fremaintimeval,dep.fremainfreeval fremainfreeval,dep.fbegindate fbegindate,dep.fenddate fenddate,org.flongnumber flongnumber from T_HR_ATS_AttenceDepOTLimit dep");
        sql.append("  left join t_org_admin org on  dep.fadminorgunitid=org.fid ");
        sql.append("  where to_Char(dep.fbegindate,'yyyy-mm-dd')<='" + dateStr + "' and dep.fhrorgunitid='" + hrOrgUnitId + "' ");
        sql.append(" and to_Char(dep.fenddate,'yyyy-mm-dd')>='" + dateStr + "'");
        sql.append("and dep.fcontroltype in (" + limitType + ") and org.flongnumber in (" + parentOrgLongNums + ")");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rowset.next()) {
                if (null == rowset.getBigDecimal("fremainfreeval")) continue;
                BigDecimal fremainfreeval = rowset.getBigDecimal("fremainfreeval");
                String flongnumber = rowset.getString("flongnumber");
                String fstartDate = format.format(rowset.getDate("fbegindate"));
                String fendDate = format.format(rowset.getDate("fenddate"));
                String controlTimeRag = rowset.getString("fcontrolTimeRag");
                int fcontroltype = rowset.getInt("fcontroltype");
                String fcontroltypeStr = rowset.getString("fcontroltype");
                String controlType = AttenceOTControlType.getEnum(fcontroltypeStr).getAlias();
                String key = flongnumber + controlTimeRag + fcontroltypeStr;
                BigDecimal preLength = new BigDecimal(0);
                boolean exist = false;
                AtsControlLimitBean atsControlLimitBean = new AtsControlLimitBean();
                if (this.totalMapForDepOTCompens.containsKey(key)) {
                    exist = true;
                    preLength = this.totalMapForDepOTCompens.get(key).getTotalAppLength();
                } else {
                    atsControlLimitBean.setTotalAppLength(otLength);
                    atsControlLimitBean.setOverLimit(false);
                    atsControlLimitBean.setDateValue(controlTimeRag);
                    atsControlLimitBean.setOTType(controlType);
                    ArrayList<String> record = new ArrayList<String>();
                    record.add(String.valueOf(this.index));
                    atsControlLimitBean.setRecordList(record);
                    this.totalMapForDepOTCompens.put(key, atsControlLimitBean);
                }
                BigDecimal totalLength = preLength.add(otLength);
                BigDecimal otPayment = AtsControlServerUtil.getOtPayment(totalLength, otType, oTPaymentPerhour);
                if (otPayment.compareTo(fremainfreeval) > 0) {
                    if (exist) {
                        this.totalMapForDepOTCompens.get(key).setTotalAppLength(totalLength);
                        this.totalMapForDepOTCompens.get(key).getRecordList().add(String.valueOf(this.index));
                    }
                    this.totalMapForDepOTCompens.get(key).setOverLimit(true);
                    continue;
                }
                BigDecimal depPaymentFrozen = this.getDepPaymentFrozen(flongnumber, fstartDate, fendDate, fcontroltype, hrOrgUnitId);
                if (otPayment.add(depPaymentFrozen.multiply(oTPaymentPerhour)).compareTo(fremainfreeval) <= 0) continue;
                if (exist) {
                    this.totalMapForDepOTCompens.get(key).setTotalAppLength(totalLength);
                    this.totalMapForDepOTCompens.get(key).getRecordList().add(String.valueOf(this.index));
                }
                this.totalMapForDepOTCompens.get(key).setOverLimit(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public BigDecimal getFrozenOTLimit(String personID, String startDate, String endDate, int limitType, String hrOrgUnitId) throws Exception {
        BigDecimal frozenOTLimit = new BigDecimal(0);
        StringBuffer sqlbuf = new StringBuffer();
        sqlbuf.append("select sum(billentry.frealottime) frealottime from T_HR_ATS_OverTimeBillEntry billentry");
        sqlbuf.append(" inner join T_HR_ATS_OverTimeBill bill on bill.fid=billentry.fbillid and (bill.fbillstate=1 or bill.fbillstate=2)");
        sqlbuf.append(" and billentry.fpersonid='" + personID + "'");
        sqlbuf.append(" where to_Char(billentry.fotdate,'yyyy-mm-dd')>='" + startDate + "'");
        sqlbuf.append(" and to_Char(billentry.fotdate,'yyyy-mm-dd')<='" + endDate + "' and bill.fhrOrgUnitId='" + hrOrgUnitId + "'");
        sqlbuf.append(this.genateUsedTimeSql(limitType));
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)this.ctx, (String)sqlbuf.toString());
            while (rowset.next()) {
                if (null == rowset.getBigDecimal("frealottime")) continue;
                frozenOTLimit = rowset.getBigDecimal("frealottime");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return frozenOTLimit;
    }

    public String genateUsedTimeSql(int cycle) {
        StringBuffer sql = new StringBuffer();
        switch (cycle) {
            case 1: {
                sql.append(" and FOTTypeID in ('zr+ur5D4RA+2bdVZ2VPqp46C/nU=','rBy0u1YgQ9C1OxcM85mxyY6C/nU=','sRWUOt7sRpOY0TCo6NMqGY6C/nU=')");
                break;
            }
            case 2: {
                sql.append(" and FOTTypeID ='rBy0u1YgQ9C1OxcM85mxyY6C/nU='");
                break;
            }
            case 3: {
                sql.append(" and FOTTypeID ='zr+ur5D4RA+2bdVZ2VPqp46C/nU='");
                break;
            }
            case 4: {
                sql.append(" and FOTTypeID ='sRWUOt7sRpOY0TCo6NMqGY6C/nU='");
                break;
            }
            case 5: {
                sql.append(" and FOTTypeID in ('zr+ur5D4RA+2bdVZ2VPqp46C/nU=','rBy0u1YgQ9C1OxcM85mxyY6C/nU=')");
                break;
            }
            case 6: {
                sql.append(" and FOTCompensID ='AERg0TIcSnaM40EKvJCdRKlrTmA='");
                break;
            }
            case 7: {
                sql.append(" and FOTCompensID ='AERg0TIcSnaM40EKvJCdRKlrTmA=' and FOTTypeID='rBy0u1YgQ9C1OxcM85mxyY6C/nU='");
                break;
            }
            case 8: {
                sql.append(" and FOTCompensID ='AERg0TIcSnaM40EKvJCdRKlrTmA=' and FOTTypeID='zr+ur5D4RA+2bdVZ2VPqp46C/nU='");
                break;
            }
            case 9: {
                sql.append(" and FOTCompensID ='zkbt5bMLQ3ehUivmKbtBOqlrTmA='");
                break;
            }
            case 10: {
                sql.append(" and FOTCompensID ='zkbt5bMLQ3ehUivmKbtBOqlrTmA=' and FOTTypeID='rBy0u1YgQ9C1OxcM85mxyY6C/nU='");
                break;
            }
            case 11: {
                sql.append(" and FOTCompensID ='zkbt5bMLQ3ehUivmKbtBOqlrTmA=' and FOTTypeID='zr+ur5D4RA+2bdVZ2VPqp46C/nU='");
                break;
            }
            case 12: {
                sql.append(" and FOTCompensID ='zkbt5bMLQ3ehUivmKbtBOqlrTmA=' and FOTTypeID='sRWUOt7sRpOY0TCo6NMqGY6C/nU='");
                break;
            }
            case 13: {
                sql.append(" and FOTCompensID ='zkbt5bMLQ3ehUivmKbtBOqlrTmA=' and FOTTypeID in ('zr+ur5D4RA+2bdVZ2VPqp46C/nU=','rBy0u1YgQ9C1OxcM85mxyY6C/nU=')");
            }
        }
        return sql.toString();
    }

    private BigDecimal getDepPaymentFrozen(String longNum, String beginDate, String endDate, int fcontroltype, String hrOrgUnitId) {
        BigDecimal totalFrozenPayment = new BigDecimal(0);
        StringBuffer sql = new StringBuffer();
        sql.append(" select frealOTTIME,FOTTypeID,FOTCompensID from T_HR_ATS_OverTimeBillentry entrys");
        sql.append("  left join t_org_admin org on org.fid = entrys.fadminorgunitid");
        sql.append("  LEFT JOIN T_HR_ATS_OVERTIMEBILL BILL ON BILL.FID = entrys.FBILLID ");
        sql.append(" where (FBILLSTATE = 1 or FBILLSTATE=2) AND BILL.fhrorgunitid='" + hrOrgUnitId + "' AND org.flongnumber like '" + longNum + "%' and to_Char(entrys.fotdate,'yyyy-MM-dd') >='" + beginDate + "' and to_Char(entrys.fotdate,'yyyy-MM-dd') <='" + endDate + "'");
        sql.append(AtsControlServerUtil.genateOTUsedfreeSql(fcontroltype));
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rowSet.next()) {
                BigDecimal relOt = new BigDecimal(rowSet.getString("frealOTTIME"));
                String otType = rowSet.getString("FOTTypeID");
                if (AttendContrlServerConstant.OTTYPE_WORKDAY.equalsIgnoreCase(otType)) {
                    totalFrozenPayment = totalFrozenPayment.add(relOt.multiply(BigDecimal.valueOf(1.5)));
                    continue;
                }
                if (AttendContrlServerConstant.OTTYPE_RESTDAY.equalsIgnoreCase(otType)) {
                    totalFrozenPayment = totalFrozenPayment.add(relOt.multiply(new BigDecimal(2)));
                    continue;
                }
                if (!AttendContrlServerConstant.OTTYPE_HOLIDAYDAY.equalsIgnoreCase(otType)) continue;
                totalFrozenPayment = totalFrozenPayment.add(relOt.multiply(new BigDecimal(3)));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return totalFrozenPayment;
    }

    public static String genateOTUsedfreeSql(int cycle) {
        StringBuffer sql = new StringBuffer();
        switch (cycle) {
            case 1: {
                sql.append(" and FOTCompensID ='zkbt5bMLQ3ehUivmKbtBOqlrTmA=' and FOTTypeID in ('zr+ur5D4RA+2bdVZ2VPqp46C/nU=','rBy0u1YgQ9C1OxcM85mxyY6C/nU=','sRWUOt7sRpOY0TCo6NMqGY6C/nU=')");
                break;
            }
            case 2: {
                sql.append(" and FOTCompensID ='zkbt5bMLQ3ehUivmKbtBOqlrTmA=' and FOTTypeID ='rBy0u1YgQ9C1OxcM85mxyY6C/nU='");
                break;
            }
            case 3: {
                sql.append(" and FOTCompensID ='zkbt5bMLQ3ehUivmKbtBOqlrTmA=' and FOTTypeID ='zr+ur5D4RA+2bdVZ2VPqp46C/nU='");
                break;
            }
            case 4: {
                sql.append(" and FOTCompensID ='zkbt5bMLQ3ehUivmKbtBOqlrTmA=' and FOTTypeID ='sRWUOt7sRpOY0TCo6NMqGY6C/nU='");
                break;
            }
            case 5: {
                sql.append(" and FOTCompensID ='zkbt5bMLQ3ehUivmKbtBOqlrTmA=' and FOTTypeID in('rBy0u1YgQ9C1OxcM85mxyY6C/nU=','zr+ur5D4RA+2bdVZ2VPqp46C/nU=')");
                break;
            }
            case 9: {
                sql.append(" and FOTCompensID ='zkbt5bMLQ3ehUivmKbtBOqlrTmA=' and FOTTypeID in ('zr+ur5D4RA+2bdVZ2VPqp46C/nU=','rBy0u1YgQ9C1OxcM85mxyY6C/nU=','sRWUOt7sRpOY0TCo6NMqGY6C/nU=')");
                break;
            }
            case 10: {
                sql.append(" and FOTCompensID ='zkbt5bMLQ3ehUivmKbtBOqlrTmA=' and FOTTypeID ='rBy0u1YgQ9C1OxcM85mxyY6C/nU='");
                break;
            }
            case 11: {
                sql.append(" and FOTCompensID ='zkbt5bMLQ3ehUivmKbtBOqlrTmA=' and FOTTypeID ='zr+ur5D4RA+2bdVZ2VPqp46C/nU='");
                break;
            }
            case 12: {
                sql.append(" and FOTCompensID ='zkbt5bMLQ3ehUivmKbtBOqlrTmA=' and FOTTypeID ='sRWUOt7sRpOY0TCo6NMqGY6C/nU='");
                break;
            }
            case 13: {
                sql.append(" and FOTCompensID ='zkbt5bMLQ3ehUivmKbtBOqlrTmA=' and FOTTypeID in('rBy0u1YgQ9C1OxcM85mxyY6C/nU=','zr+ur5D4RA+2bdVZ2VPqp46C/nU=')");
                break;
            }
            default: {
                return "";
            }
        }
        return sql.toString();
    }

    public BigDecimal getDepsOtLimitFrozenInfo(String longNum, String startDate, String endDate, int limitType, String hrOrgUnitId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(frealOTTIME) as val from T_HR_ATS_OverTimeBillentry entrys");
        sql.append("  left join t_org_admin org on org.fid = entrys.fadminorgunitid");
        sql.append("  LEFT JOIN T_HR_ATS_OVERTIMEBILL BILL ON BILL.FID = entrys.FBILLID ");
        sql.append(" where (FBILLSTATE = 1 or FBILLSTATE=2) AND BILL.fhrorgunitid='" + hrOrgUnitId + "' AND org.flongnumber like '" + longNum + "%' and to_Char(entrys.fotdate,'yyyy-MM-dd') >='" + startDate + "' and to_Char(entrys.fotdate,'yyyy-MM-dd') <='" + endDate + "'");
        sql.append(this.genateUsedTimeSql(limitType));
        BigDecimal depFrozenValue = new BigDecimal(0);
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rowset.next()) {
                if (null == rowset.getBigDecimal("val")) continue;
                depFrozenValue = rowset.getBigDecimal("val");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return depFrozenValue;
    }

    public static Date stringToShortDate(String str) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sdf.parse(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    public static JSONArray stringEnumToJsonArray(List<StringEnum> subEnum) {
        if (subEnum == null || subEnum.size() < 1 || !(subEnum.get(0) instanceof StringEnum)) {
            return null;
        }
        JSONArray arr = new JSONArray();
        for (StringEnum item : subEnum) {
            JSONObject obj = new JSONObject();
            try {
                obj.put("value", (Object)item.getValue());
                obj.put("alias", (Object)item.getAlias());
                obj.put("name", (Object)item.getName());
                arr.put((Object)obj);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return arr;
    }

    public static JSONArray intEnumToJsonArray(List<IntEnum> subEnum) {
        if (subEnum == null || subEnum.size() < 1 || !(subEnum.get(0) instanceof IntEnum)) {
            return null;
        }
        JSONArray arr = new JSONArray();
        for (IntEnum item : subEnum) {
            JSONObject obj = new JSONObject();
            try {
                obj.put("value", item.getValue());
                obj.put("alias", (Object)item.getAlias());
                obj.put("name", (Object)item.getName());
                arr.put((Object)obj);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return arr;
    }

    public static String validID(String id, String entityName) {
        if (id == null || "".equals(id.trim())) {
            return "empty id!";
        }
        if (entityName == null || "".equals(entityName.trim())) {
            return "empty entityName!";
        }
        return null;
    }
}

