/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cloudservice.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.cloud.http.MyHttpClient;
import com.kingdee.shr.base.syssetting.cloud.http.ResultVo;
import com.kingdee.shr.base.syssetting.util.URLUtil;
import com.kingdee.shr.cloudservice.util.Base64Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final String CHARSET = "UTF-8";
    private static final String ALLOW_CIRCULAR_REDIRECTS = "http.protocol.allow-circular-redirects";
    private static final String[] chars = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject get(Context ctx, String url, Map<String, String> dataMap) {
        JSONObject result = new JSONObject();
        HttpGet method = null;
        try {
            Set<Map.Entry<String, String>> entrySet = dataMap.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                if (entry.getKey() == null || entry.getKey().equals("_session_")) continue;
                if (url.indexOf("?") > 0) {
                    url = url + "&" + entry.getKey() + "=" + entry.getValue();
                    continue;
                }
                url = url + "?" + entry.getKey() + "=" + entry.getValue();
            }
            CloseableHttpClient httpClient = HttpClients.createDefault();
            method = new HttpGet(url);
            logger.info("HttpClientUtil get url : " + url);
            HttpResponse response = httpClient.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            result = HttpClientUtil.processHttpResponseString(statusCode, responseString);
        }
        catch (ClientProtocolException e) {
            logger.error("HttpClientUtil post ClientProtocolException : \n", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("HttpClientUtil post IOException : \n", (Throwable)e);
        }
        catch (ParseException e) {
            logger.error("HttpClientUtil post ParseException : \n", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("HttpClientUtil post Exception : \n", (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject get(String url, Map<String, String> dataMap) {
        JSONObject result = new JSONObject();
        HttpGet method = null;
        try {
            Set<Map.Entry<String, String>> entrySet = dataMap.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                if (entry.getKey() == null || entry.getKey().equals("_session_")) continue;
                if (url.indexOf("?") > 0) {
                    url = url + "&" + entry.getKey() + "=" + entry.getValue();
                    continue;
                }
                url = url + "?" + entry.getKey() + "=" + entry.getValue();
            }
            CloseableHttpClient httpClient = HttpClients.createDefault();
            method = new HttpGet(url);
            logger.info("HttpClientUtil get url : " + url);
            HttpResponse response = httpClient.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            result = HttpClientUtil.processHttpResponseString(statusCode, responseString);
        }
        catch (ClientProtocolException e) {
            logger.error("HttpClientUtil post ClientProtocolException : \n", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("HttpClientUtil post IOException : \n", (Throwable)e);
        }
        catch (ParseException e) {
            logger.error("HttpClientUtil post ParseException : \n", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("HttpClientUtil post Exception : \n", (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject get(Context ctx, String url) {
        JSONObject result = new JSONObject();
        HttpGet method = null;
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            method = new HttpGet(url);
            logger.info("HttpClientUtil get url : " + url);
            HttpResponse response = httpClient.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            result = HttpClientUtil.processHttpResponseString(statusCode, responseString);
        }
        catch (ClientProtocolException e) {
            logger.error("HttpClientUtil post ClientProtocolException : \n", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("HttpClientUtil post IOException : \n", (Throwable)e);
        }
        catch (ParseException e) {
            logger.error("HttpClientUtil post ParseException : \n", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("HttpClientUtil post Exception : \n", (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject get(String url) {
        JSONObject result = new JSONObject();
        HttpGet method = null;
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            method = new HttpGet(url);
            logger.info("HttpClientUtil get url : " + url);
            HttpResponse response = httpClient.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            result = HttpClientUtil.processHttpResponseString(statusCode, responseString);
        }
        catch (ClientProtocolException e) {
            logger.error("HttpClientUtil post ClientProtocolException : \n", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("HttpClientUtil post IOException : \n", (Throwable)e);
        }
        catch (ParseException e) {
            logger.error("HttpClientUtil post ParseException : \n", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("HttpClientUtil post Exception : \n", (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject postForm(Context ctx, String url, Map<String, Object> dataMap) {
        JSONObject result = new JSONObject();
        HttpPost method = null;
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            method = new HttpPost(url);
            method.setHeader("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            if (dataMap != null && !dataMap.isEmpty()) {
                for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                    String value = entry.getValue() != null ? entry.getValue().toString() : "";
                    BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), value);
                    pairs.add(pair);
                }
                method.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, CHARSET));
            }
            logger.info("HttpClientUtil post form to url : " + url + ", params: " + dataMap);
            HttpResponse response = httpClient.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            logger.info("HttpClientUtil postForm : " + statusCode + " " + responseString);
            result = HttpClientUtil.processHttpResponseString(statusCode, responseString);
        }
        catch (ClientProtocolException e) {
            logger.error("HttpClientUtil post ClientProtocolException : \n", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("HttpClientUtil post IOException : \n", (Throwable)e);
        }
        catch (ParseException e) {
            logger.error("HttpClientUtil post ParseException : \n", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("HttpClientUtil post Exception : \n", (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject postForm(String url, Map<String, Object> dataMap) {
        JSONObject result = new JSONObject();
        HttpPost method = null;
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            method = new HttpPost(url);
            method.setHeader("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            if (dataMap != null && !dataMap.isEmpty()) {
                for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                    String value = entry.getValue() != null ? entry.getValue().toString() : "";
                    BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), value);
                    pairs.add(pair);
                }
                method.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, CHARSET));
            }
            logger.info("HttpClientUtil post form to url : " + url + ", params: " + dataMap);
            HttpResponse response = httpClient.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            logger.info("HttpClientUtil postForm : " + statusCode + " " + responseString);
            result = HttpClientUtil.processHttpResponseString(statusCode, responseString);
        }
        catch (ClientProtocolException e) {
            logger.error("HttpClientUtil post ClientProtocolException : \n", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("HttpClientUtil post IOException : \n", (Throwable)e);
        }
        catch (ParseException e) {
            logger.error("HttpClientUtil post ParseException : \n", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("HttpClientUtil post Exception : \n", (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return result;
    }

    public static ResultVo doPostJson(Context ctx, String url, String json) throws BOSException {
        MyHttpClient httpClient = null;
        PostMethod method = null;
        ResultVo resultVo = null;
        try {
            httpClient = new MyHttpClient();
            httpClient.getParams().setParameter(ALLOW_CIRCULAR_REDIRECTS, (Object)true);
            httpClient.getParams().setIntParameter("http.socket.timeout", 30000);
            method = URLUtil.getPostMethod((String)url, null);
            StringRequestEntity requestEntity = new StringRequestEntity(json, "application/json", CHARSET);
            method.setRequestEntity((RequestEntity)requestEntity);
            method.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
            int status = httpClient.executeMethod((HttpMethod)method);
            String data = method.getResponseBodyAsString();
            resultVo = status == 200 ? new ResultVo(String.valueOf(status), (Object)data, "Request successful") : new ResultVo(String.valueOf(status), (Object)data, "Request fails");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return resultVo;
    }

    public static ResultVo doPostJson(String url, String json) throws BOSException {
        MyHttpClient httpClient = null;
        PostMethod method = null;
        ResultVo resultVo = null;
        try {
            httpClient = new MyHttpClient();
            httpClient.getParams().setParameter(ALLOW_CIRCULAR_REDIRECTS, (Object)true);
            httpClient.getParams().setIntParameter("http.socket.timeout", 30000);
            method = URLUtil.getPostMethod((String)url, null);
            StringRequestEntity requestEntity = new StringRequestEntity(json, "application/json", CHARSET);
            method.setRequestEntity((RequestEntity)requestEntity);
            method.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
            int status = httpClient.executeMethod((HttpMethod)method);
            String data = method.getResponseBodyAsString();
            resultVo = status == 200 ? new ResultVo(String.valueOf(status), (Object)data, "Request successful") : new ResultVo(String.valueOf(status), (Object)data, "Request fails");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return resultVo;
    }

    public static ResultVo doGet(Context ctx, String url, Map<String, Object> params) throws BOSException {
        MyHttpClient httpClient = null;
        GetMethod method = null;
        ResultVo resultVo = null;
        try {
            httpClient = new MyHttpClient();
            httpClient.getParams().setParameter(ALLOW_CIRCULAR_REDIRECTS, (Object)true);
            httpClient.getParams().setIntParameter("http.socket.timeout", 3000);
            method = URLUtil.getGetMethod((String)url, params);
            logger.info("HttpClientUtil doGet url : " + method.getURI().getURI());
            int status = httpClient.executeMethod((HttpMethod)method);
            String data = method.getResponseBodyAsString();
            resultVo = status == 200 ? new ResultVo(String.valueOf(status), (Object)data, "Request successful") : new ResultVo(String.valueOf(status), (Object)data, "Request fails");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return resultVo;
    }

    public static ResultVo doGet(String url, Map<String, Object> params) throws BOSException {
        MyHttpClient httpClient = null;
        GetMethod method = null;
        ResultVo resultVo = null;
        try {
            httpClient = new MyHttpClient();
            httpClient.getParams().setParameter(ALLOW_CIRCULAR_REDIRECTS, (Object)true);
            httpClient.getParams().setIntParameter("http.socket.timeout", 3000);
            method = URLUtil.getGetMethod((String)url, params);
            logger.info("HttpClientUtil doGet url : " + method.getURI().getURI());
            int status = httpClient.executeMethod((HttpMethod)method);
            String data = method.getResponseBodyAsString();
            resultVo = status == 200 ? new ResultVo(String.valueOf(status), (Object)data, "Request successful") : new ResultVo(String.valueOf(status), (Object)data, "Request fails");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return resultVo;
    }

    private static JSONObject processHttpResponseString(int statusCode, String responseString) {
        JSONObject result = new JSONObject();
        try {
            JSONObject data = JSONObject.fromObject((Object)responseString);
            result.put((Object)"result", (Object)data);
        }
        catch (Exception e) {
            logger.error("HttpClientUtil processHttpResponseString Exception : \n", (Throwable)e);
            result.put((Object)"result", (Object)responseString);
        }
        result.put((Object)"status", (Object)statusCode);
        return result;
    }

    private static String appendUuid(String url) {
        url = url.indexOf("?") > 0 ? url + "&randomuuid=" + HttpClientUtil.generateShortUuid() : url + "?randomuuid=" + HttpClientUtil.generateShortUuid();
        return url;
    }

    public static String generateShortUuid() {
        StringBuffer shortBuffer = new StringBuffer();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        for (int i = 0; i < 8; ++i) {
            String str = uuid.substring(i * 4, i * 4 + 4);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(chars[x % 62]);
        }
        return shortBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(Context ctx, String url, String queryString) {
        String response = null;
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(url);
        try {
            method.setQueryString(URIUtil.encodeQuery((String)queryString));
            client.executeMethod((HttpMethod)method);
            if (method.getStatusCode() == 200) {
                response = method.getResponseBodyAsString();
            }
        }
        catch (URIException e) {
            String string = Base64Utils.encode(queryString);
        }
        catch (IOException e) {
            String string = Base64Utils.encode(url);
        }
        finally {
            method.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(Context ctx, String path, Map<String, String> param, String charset) throws Exception {
        String result = null;
        PostMethod postMethod = null;
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setParameter("http.protocol.content-charset", (Object)charset);
        postMethod = new PostMethod(path);
        if (param != null && param.size() > 0) {
            NameValuePair[] datas = new NameValuePair[param.size()];
            int index = 0;
            for (String key : param.keySet()) {
                datas[index++] = new NameValuePair(key, param.get(key));
            }
            postMethod.setRequestBody(datas);
        }
        HttpClientParams httparams = new HttpClientParams();
        httparams.setSoTimeout(60000);
        postMethod.setParams((HttpMethodParams)httparams);
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)postMethod);
            if (statusCode == 200) {
                result = postMethod.getResponseBodyAsString();
            } else {
                logger.error(" http response status is " + statusCode);
            }
        }
        catch (HttpException e) {
            logger.error("Http error url=" + path);
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("error url=" + path);
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
        return result;
    }

    public static String mapToString(Map<String, String> param) {
        String map = "";
        if (!param.isEmpty()) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                map = map + entry.getKey() + "=" + entry.getValue() + "&";
            }
            map.substring(0, map.length() - 1);
            return map;
        }
        return "";
    }
}

