/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.easupgrade.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.easupgrade.compensation.InterfaceCmpUpGradeException;
import com.kingdee.shr.easupgrade.compensation.app.AbstractCmpItemMappingControllerBean;
import com.kingdee.shr.easupgrade.compensation.util.UpGradeUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpItemMappingControllerBean
extends AbstractCmpItemMappingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.CmpItemMappingControllerBean");

    @Override
    protected void _backUp(Context ctx) throws BOSException {
        StringBuilder bakSb = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        Timestamp sqlDate = new Timestamp(calendar.getTimeInMillis());
        String year = calendar.get(1) + "";
        int monthNum = calendar.get(2) + 1;
        String month = monthNum < 10 ? "0" + monthNum : "" + monthNum;
        int dayNum = calendar.get(5);
        String day = dayNum < 10 ? "0" + dayNum : "" + dayNum;
        String hour = calendar.get(11) + "";
        String minute = calendar.get(12) + "";
        String second = calendar.get(13) + "";
        String hisName = "\u85aa\u916c\u9879\u76ee\u5339\u914d\u5386\u53f2" + year + month + day + hour + minute + second;
        bakSb.append("insert into t_hr_scmpitemmappinghis(fid, fname_l2, fOutOrgID, fOuterOrgName, FOuterCmpItemID, ");
        bakSb.append("fOuterCmpItemNumber, fOuterCmpItemName, fCmpItemID, fCmpItemNumber, fCmpItemName, ");
        bakSb.append("fCmpItemField, fCmpItemOrgID, fCmpItemOrgName, fMatchState, fIsAssigned, fLastUpdateTime) ");
        bakSb.append("(select newbosid('75B93C66'), ?, fOutOrgID, fOuterOrgName, FOuterCmpItemID, fOuterCmpItemNumber, fOuterCmpItemName, fCmpItemID, ");
        bakSb.append("fCmpItemNumber, fCmpItemName, fCmpItemField, fCmpItemOrgID, fCmpItemOrgName, fMatchState, ");
        bakSb.append("fIsAssigned, ? from t_hr_scmpitemmapping)");
        DbUtil.execute((Context)ctx, (String)bakSb.toString(), (Object[])new Object[]{hisName, sqlDate});
        String delSql = "delete from t_hr_scmpitemmapping";
        DbUtil.execute((Context)ctx, (String)delSql.toString());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _getOutCmpItem(Context ctx, Map params) throws BOSException, EASBizException {
        Connection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            connection = UpGradeUtil.getOuterConnection(ctx, "EasSysDB");
            statement = connection.createStatement();
            String delOldMappingSql = "delete t_hr_scmpitemmapping";
            DbUtil.execute((Context)ctx, (String)delOldMappingSql);
            StringBuilder sb = new StringBuilder();
            sb.append(" select org.fid outerOrg, org.fname_l2 outerOrgName, cmpItem.fid outerCmpItem, cmpItem.fDataType dataType, ");
            sb.append(" cmpItem.fnumber outerCmpItemNumber, cmpItem.fname_l2 outerCmpItemName, cmpitem.FIsAssigned isAssigned ");
            sb.append(" from t_hr_cmpitem cmpitem inner join t_org_baseunit org ");
            sb.append(" on cmpitem.fhrorgunitid = org.fid where org.FIsHROrgUnit=1 ");
            rs = statement.executeQuery(sb.toString());
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            StringBuilder tempSb = new StringBuilder();
            tempSb.append(" insert into t_hr_scmpitemmapping(fid, FOutOrgID, fouterOrgName, FOuterCmpItemID, ");
            tempSb.append(" fouterCmpItemNumber, fouterCmpItemName, FIsAssigned, FOuterDataType, FMatchState) values (");
            tempSb.append(" newbosid('90A0A38C'), ?, ?, ?, ?, ?, ?, ?, 2) ");
            while (rs.next()) {
                ArrayList<Object> param = new ArrayList<Object>();
                String outerOrg = rs.getString("outerOrg") == null ? "" : rs.getString("outerOrg").toString();
                String outerOrgName = rs.getString("outerOrgName") == null ? "" : rs.getString("outerOrgName").toString();
                String outerCmpItem = rs.getString("outerCmpItem") == null ? "" : rs.getString("outerCmpItem").toString();
                String outerCmpItemNumber = rs.getString("outerCmpItemNumber") == null ? "" : rs.getString("outerCmpItemNumber").toString();
                String outerCmpItemName = rs.getString("outerCmpItemName") == null ? "" : rs.getString("outerCmpItemName").toString();
                int dataType = rs.getInt("dataType") <= 30 ? 1 : 0;
                String isAssigned = rs.getString("isAssigned") == null ? "" : rs.getString("isAssigned").toString();
                param.add(outerOrg);
                param.add(outerOrgName);
                param.add(outerCmpItem);
                param.add(outerCmpItemNumber);
                param.add(outerCmpItemName);
                param.add(isAssigned);
                param.add(dataType);
                paramList.add(param.toArray());
            }
            DbUtil.executeBatchAndReturn((Context)ctx, (String)tempSb.toString(), paramList);
        }
        catch (EASBizException e) {
            try {
                e.printStackTrace();
                throw e;
                catch (Exception e2) {
                    e2.printStackTrace();
                    throw new InterfaceCmpUpGradeException(InterfaceCmpUpGradeException.GET_CMPITEM_ERROR);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)connection);
    }

    @Override
    protected void _autoMatch(Context ctx) throws BOSException {
        StringBuilder autoByNameSb = new StringBuilder();
        autoByNameSb.append("update t_hr_scmpitemmapping itemMapping set (FCmpItemID, FCmpItemNumber, FCmpItemName, ");
        autoByNameSb.append("FCmpItemField, FCmpItemOrgID, FcmpItemOrgName, FMatchState) =  ");
        autoByNameSb.append("(select cmpItem.fid, cmpItem.fnumber, cmpItem.fname_l2, cmpItem.FieldSn, cmpItem.FAdminOrgUnitID, org.fname_l2, 0 ");
        autoByNameSb.append("from t_hr_scmpitem cmpItem left join t_org_admin org on cmpItem.FAdminOrgUnitID = org.fid where cmpItem.fname_l2");
        autoByNameSb.append(" = itemMapping.FOuterCmpItemName and cmpItem.FDataType = itemMapping.FOuterDataType and itemMapping.FCmpItemNumber is null ");
        autoByNameSb.append(" and not exists(select 1 from t_hr_scmpitemmapping t where t.FOutOrgID=itemMapping.FOutOrgID and t.FCmpItemName=itemMapping.FOuterCmpItemName)) ");
        DbUtil.execute((Context)ctx, (String)autoByNameSb.toString());
        StringBuilder autoByNumberSb = new StringBuilder();
        autoByNumberSb.append("update t_hr_scmpitemmapping itemMapping set (FCmpItemID, FCmpItemNumber, FCmpItemName, ");
        autoByNumberSb.append("FCmpItemField, FCmpItemOrgID, FcmpItemOrgName, FMatchState) =  ");
        autoByNumberSb.append("(select cmpItem.fid, cmpItem.fnumber, cmpItem.fname_l2, cmpItem.FieldSn, cmpItem.FAdminOrgUnitID, org.fname_l2, 0 ");
        autoByNumberSb.append("from t_hr_scmpitem cmpItem left join t_org_admin org on cmpItem.FAdminOrgUnitID = org.fid where cmpItem.fnumber");
        autoByNumberSb.append(" = itemMapping.FOuterCmpItemNumber and cmpItem.FDataType = itemMapping.FOuterDataType and itemMapping.FCmpItemNumber is null ");
        autoByNumberSb.append(" and not exists(select 1 from t_hr_scmpitemmapping t where t.FOutOrgID=itemMapping.FOutOrgID and t.FCmpItemNumber=itemMapping.FOuterCmpItemNumber)) ");
        DbUtil.execute((Context)ctx, (String)autoByNumberSb.toString());
    }

    @Override
    protected void _synchMappingData(Context ctx, Map param) throws BOSException {
        List delList = (List)param.get("delList");
        String delSql = "delete t_hr_scmpitemMapping where FOuterOrgName=? and FOuterCmpItemNumber=? and FOuterCmpItemName =?";
        DbUtil.executeBatch((Context)ctx, (String)delSql, (List)delList);
        List addList = (List)param.get("addList");
        StringBuilder tempSb = new StringBuilder();
        tempSb.append(" insert into t_hr_scmpitemmapping(fid, FOutOrgID, fouterOrgName, FOuterCmpItemID, ");
        tempSb.append(" fouterCmpItemNumber, fouterCmpItemName, FOuterDataType, FCmpItemID, FCmpItemNumber, ");
        tempSb.append(" FCmpItemName, FCmpItemField, FCmpItemOrgID, FcmpItemOrgName, FMatchState, FIsAssigned) values (");
        tempSb.append(" newbosid('90A0A38C'), ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1, ?) ");
        DbUtil.executeBatch((Context)ctx, (String)tempSb.toString(), (List)addList);
    }

    @Override
    protected Map _getCmpItemMap(Context ctx) throws BOSException, EASBizException {
        IRowSet rs = null;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String sql = "select item.fnumber cmpItemNumber, item.fname_l2 cmpItemName, org.fid orgId, org.fname_l2 orgName, item.FieldSn, item.fid, item.FDataType from t_hr_scmpitem item left join t_org_admin org on item.FAdminOrgUnitID = org.fid";
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String number = rs.getString("cmpItemNumber");
                String name = rs.getString("cmpItemName");
                String orgId = rs.getString("orgId");
                String orgName = rs.getString("orgName");
                String fieldSn = rs.getString("FieldSn");
                String id = rs.getString("fid");
                String dataType = rs.getString("FDataType");
                String key = number + "||" + name;
                String value = orgId + "||" + orgName + "||" + id + "||" + fieldSn + "||" + dataType;
                resultMap.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InterfaceCmpUpGradeException(InterfaceCmpUpGradeException.GET_ITEM_ERROR);
        }
        return resultMap;
    }

    @Override
    protected Map _getAdminMap(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            conn = UpGradeUtil.getOuterConnection(ctx, "EasSysDB");
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new InterfaceCmpUpGradeException(InterfaceCmpUpGradeException.CONN_ERROR);
        }
        String sql = "select fid, fname_l2 from t_org_baseunit where FIsHROrgUnit=1";
        IRowSet rs = UpGradeUtil.executeQuery(ctx, sql, conn, true);
        try {
            while (rs.next()) {
                String outOrgId = rs.getString("fid");
                String outOrgName = rs.getString("fname_l2");
                map.put(outOrgName, outOrgId);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new InterfaceCmpUpGradeException(InterfaceCmpUpGradeException.GET_OUTADMIN_ERROR);
        }
        return map;
    }

    @Override
    protected Map _getOutCmpItemMap(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        Connection conn = null;
        try {
            conn = UpGradeUtil.getOuterConnection(ctx, "EasSysDB");
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new InterfaceCmpUpGradeException(InterfaceCmpUpGradeException.CONN_ERROR);
        }
        String sql = "select item.fid, item.fnumber, item.fname_l2, item.FDataType, org.fname_l2 orgName, FIsAssigned from t_hr_cmpItem item left join t_org_baseunit org on item.fhrorgunitid = org.fid where org.FIsHROrgUnit=1";
        IRowSet rs = UpGradeUtil.executeQuery(ctx, sql, conn, true);
        try {
            while (rs.next()) {
                String itemId = rs.getString("fid");
                String itemNum = rs.getString("fnumber");
                String itemName = rs.getString("fname_l2");
                String orgName = rs.getString("orgName");
                int assigned = rs.getInt("FIsAssigned");
                int dataType = rs.getInt("FDataType") <= 30 ? 1 : 0;
                map.put(orgName + "||" + itemNum + "||" + itemName, itemId + "||" + dataType + "||" + assigned);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new InterfaceCmpUpGradeException(InterfaceCmpUpGradeException.GET_SCHEME_ERROR);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    @Override
    protected Map _getMappingMap(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        sb.append(" select FCmpItemNumber, FCmpItemName, FOuterOrgName, FOuterCmpItemNumber, FOuterCmpItemName ");
        sb.append(" from T_HR_SCmpItemMapping where FCmpItemID is not null ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                String cmpItemNumber = rs.getString("FCmpItemNumber");
                String cmpItemName = rs.getString("FCmpItemName");
                String outOrgName = rs.getString("FOuterOrgName");
                String outNumber = rs.getString("FOuterCmpItemNumber");
                String outName = rs.getString("FOuterCmpItemName");
                String key = cmpItemNumber + "||" + cmpItemName;
                String value = outOrgName + "||" + outNumber + "||" + outName;
                map.put(key, value);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return map;
    }
}

