/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.easupgrade.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalFlag;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalSchemeItemFactory;
import com.kingdee.shr.compensation.CalSchemeItemInfo;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.easupgrade.compensation.AdjRecordFactory;
import com.kingdee.shr.easupgrade.compensation.CalSchemeMappingCollection;
import com.kingdee.shr.easupgrade.compensation.CalSchemeMappingFactory;
import com.kingdee.shr.easupgrade.compensation.CmpUpGradeLogFactory;
import com.kingdee.shr.easupgrade.compensation.CmpUpGradeLogInfo;
import com.kingdee.shr.easupgrade.compensation.InterfaceCmpUpGradeException;
import com.kingdee.shr.easupgrade.compensation.SchemeRecordFactory;
import com.kingdee.shr.easupgrade.compensation.UpGradeLogType;
import com.kingdee.shr.easupgrade.compensation.app.AbstractCmpUpGradeProjectControllerBean;
import com.kingdee.shr.easupgrade.compensation.util.UpGradeUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CmpUpGradeProjectControllerBean
extends AbstractCmpUpGradeProjectControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.easupgrade.compensation.app.CmpUpGradeProjectControllerBean");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _initCmpUpGrade(Context ctx, Map param) throws BOSException, EASBizException {
        String tableName;
        IRowSet tempRs;
        IRowSet rs;
        Statement ps;
        Connection connection;
        block10: {
            String releaseTempSql;
            connection = null;
            ps = null;
            rs = null;
            tempRs = null;
            tableName = "";
            try {
                String hasUpGraded = "select * from T_HR_SSchemeRecord";
                IRowSet hasUpGradedRs = DbUtil.executeQuery((Context)ctx, (String)hasUpGraded);
                if (hasUpGradedRs.next()) {
                    return;
                }
                connection = UpGradeUtil.getOuterConnection(ctx, "EasSysDB");
                List schemeIds = this.getSchemeMapping(ctx);
                tableName = this.createTempTable(ctx, connection, schemeIds);
                String sql = "select fid schemeId, fname_l2 name, FHisTableName hisName, FHROrgUnitID hrOrgId from t_hr_cmpscheme where fid in(select fid from " + tableName + ") order by fnumber";
                rs = UpGradeUtil.executeQuery(ctx, sql, connection, false);
                String schemeId = "";
                String schemeName = "";
                String hisName = "";
                String hrOrgId = "";
                int recordNum = 0;
                int i = 1;
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                while (rs.next()) {
                    ArrayList<Object> paramDetail = new ArrayList<Object>();
                    schemeId = rs.getString("schemeId");
                    schemeName = rs.getString("name");
                    hisName = rs.getString("hisName") == null ? "" : rs.getString("hisName");
                    String string = hrOrgId = rs.getString("hrOrgId") == null ? "" : rs.getString("hrOrgId");
                    if (hisName != "") {
                        String countSql = "select count(*) num from " + hisName;
                        tempRs = UpGradeUtil.executeQuery(ctx, countSql, connection, false);
                        tempRs.next();
                        recordNum = tempRs.getInt("num");
                    }
                    paramDetail.add(schemeId);
                    paramDetail.add(schemeName);
                    paramDetail.add(hisName);
                    paramDetail.add(hrOrgId);
                    paramDetail.add(recordNum);
                    paramDetail.add(i);
                    paramList.add(paramDetail.toArray());
                    ++i;
                }
                StringBuilder recordSb = new StringBuilder();
                recordSb.append("insert into T_HR_SSchemeRecord(fid, FCalSchemeID, FCalSchemeName, FHistoryName, FHrOrgID, FCmpDataNum, ");
                recordSb.append("FIndexNum, FState) values(newbosid('9CD5EA8D'), ?, ?, ?, ?, ?, ?, 0) ");
                DbUtil.executeBatchAndReturn((Context)ctx, (String)recordSb.toString(), paramList);
                releaseTempSql = "drop table " + tableName;
                if (tableName == "") break block10;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InterfaceCmpUpGradeException(InterfaceCmpUpGradeException.INIT_CMPUPGRADE_ERROR);
            }
            UpGradeUtil.execute(ctx, releaseTempSql, connection, false);
        }
        SQLUtils.cleanup(tempRs);
        SQLUtils.cleanup((ResultSet)rs, ps, (Connection)connection);
        return;
        finally {
            String releaseTempSql = "drop table " + tableName;
            if (tableName != "") {
                UpGradeUtil.execute(ctx, releaseTempSql, connection, false);
            }
            SQLUtils.cleanup(tempRs);
            SQLUtils.cleanup(rs, ps, (Connection)connection);
        }
    }

    @Override
    protected void _initAdjUpGrade(Context ctx, Map param) throws BOSException, EASBizException {
        Connection connection = null;
        Statement ps = null;
        IRowSet rs = null;
        try {
            String entryId;
            String hasUpGraded = "select * from T_HR_SAdjRecord";
            IRowSet hasUpGradedRs = DbUtil.executeQuery((Context)ctx, (String)hasUpGraded);
            if (hasUpGradedRs.next()) {
                return;
            }
            connection = UpGradeUtil.getOuterConnection(ctx, "EasSysDB");
            String source = "";
            String tableName = "t_hr_adjscheme";
            String hrOrgId = "";
            int i = 1;
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            Map<String, List<String>> adjSchemeMap = this.getAdjSchemeMap(ctx, connection);
            String sql = "select fid, FHROrgUnitID hrOrgId from " + tableName + " where FAdjSchemeState=30";
            rs = UpGradeUtil.executeQuery(ctx, sql, connection, false);
            while (rs.next()) {
                ArrayList<Object> paramDetail = new ArrayList<Object>();
                hrOrgId = rs.getString("hrOrgId") == null ? "" : rs.getString("hrOrgId");
                source = rs.getString("fid");
                List<String> entryList = adjSchemeMap.get(source);
                if (!adjSchemeMap.containsKey(source) || entryList == null || entryList.size() == 0) continue;
                for (int j = 0; j < entryList.size(); ++j) {
                    paramDetail.clear();
                    String[] entrys = entryList.get(j).split("_");
                    entryId = entrys[0];
                    paramDetail.add(source);
                    paramDetail.add(entryId);
                    paramDetail.add(tableName);
                    paramDetail.add(i);
                    paramDetail.add(hrOrgId);
                    paramList.add(paramDetail.toArray());
                    ++i;
                }
            }
            tableName = "T_HR_PartJobFixedAdjust";
            Map<String, LinkedList<String>> partAdjSchemeMap = this.getPartAdjSchemeMap(ctx, connection);
            sql = "select fid, FHROrgUnitID hrOrgId from " + tableName + " where FAdjSchemeState=30";
            rs = UpGradeUtil.executeQuery(ctx, sql, connection, false);
            while (rs.next()) {
                ArrayList<Object> paramDetail = new ArrayList<Object>();
                hrOrgId = rs.getString("hrOrgId") == null ? "" : rs.getString("hrOrgId");
                source = rs.getString("fid");
                List entryList = partAdjSchemeMap.get(source);
                if (!partAdjSchemeMap.containsKey(source) || entryList == null || entryList.size() == 0) continue;
                for (int j = 0; j < entryList.size(); ++j) {
                    paramDetail.clear();
                    entryId = (String)entryList.get(j);
                    paramDetail.add(source);
                    paramDetail.add(entryId);
                    paramDetail.add(tableName);
                    paramDetail.add(i);
                    paramDetail.add(hrOrgId);
                    paramList.add(paramDetail.toArray());
                    ++i;
                }
            }
            StringBuilder recordSb = new StringBuilder();
            recordSb.append("insert into T_HR_SAdjRecord(fid, FSourceID, FSourceEntryID, FTableName, FIndexNum, FState, FHrOrgID)");
            recordSb.append(" values(newbosid('9E61CF01'), ?, ?, ?, ?, 0, ?) ");
            DbUtil.executeBatchAndReturn((Context)ctx, (String)recordSb.toString(), paramList);
            SQLUtils.cleanup((ResultSet)rs, ps, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InterfaceCmpUpGradeException(InterfaceCmpUpGradeException.INIT_ADJUPGRADE_ERROR);
        }
        finally {
            SQLUtils.cleanup(rs, ps, connection);
        }
    }

    @Override
    protected void _cmpUpGrade(Context ctx, Map param) throws BOSException, EASBizException {
        Connection conn = null;
        IRowSet rs = null;
        IRowSet tempRs = null;
        StringBuilder tempSb = null;
        String currentId = "";
        String currentSchemeId = "";
        LinkedList<String> matchColumns = new LinkedList<String>();
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        try {
            conn = UpGradeUtil.getOuterConnection(ctx, "EasSysDB");
        }
        catch (SQLException e) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        try {
            Map<String, String> schemeMap = this.getSchemeMap(ctx);
            Map<String, String> itemMap = this.getItemMap(ctx);
            Map<String, String> periodMap = this.getPeriodMap(ctx, conn);
            Map<String, String> employeeTypeMap = this.getEmployTypeMap(ctx);
            Map<String, String> relationMap = this.getOrgRelationMap(ctx);
            Map<String, String> jobMap = this.getJobMap(ctx);
            Map<String, List<String>> calSchemeItemMap = this.getSchemeItemMap(ctx);
            rs = this.getCmpRs(ctx);
            while (rs.next()) {
                int i;
                String schemeId;
                String fid;
                matchColumns.clear();
                currentId = fid = rs.getString("fid");
                currentSchemeId = schemeId = rs.getString("FCalSchemeID");
                String hisName = rs.getString("hisName");
                String hrOrg = rs.getString("hrOrg");
                String columnSql = "";
                String innerSchemeId = schemeMap.get(schemeId);
                CalSchemeInfo calSchemeInfo = CalSchemeFactory.getLocalInstance((Context)ctx).getCalSchemeInfo((IObjectPK)new ObjectUuidPK(innerSchemeId));
                List<String> itemList = calSchemeItemMap.get(innerSchemeId);
                String startSql = "update T_HR_SSchemeRecord set FState=1 where fid=?";
                DbUtil.execute((Context)ctx, (String)startSql, (Object[])new Object[]{fid});
                if (StringUtils.isEmpty((CharSequence)hisName)) {
                    this.schemeComplete(ctx, fid);
                    continue;
                }
                tempSb = new StringBuilder();
                tempSb.append(" insert into T_HR_SCmpCalTable(fid, FPersonID, FAdminOrgUnitID, FPositionID, FEmpPosOrgRelationID, FEmployeeTypeID, ");
                tempSb.append(" FJobID, FCostBearOrgID, FCmpCalOrgID, FCalSchemeID, FPeriodYear, FPeriodMonth, FBeginDate, FEndDate, ");
                tempSb.append(" FCalTime, FCalState, FIsLockOtherSysData, FDescription_l2, fcreateTime, fcreatorid, flastupdateuserid, ");
                tempSb.append(" flastupdateTime, FCmpPeriodType ");
                String dbType = UpGradeUtil.getDbType(conn);
                columnSql = "oracle".equalsIgnoreCase(dbType) ? "select * from " + hisName + " where rownum<1" : "select top 0 * from " + hisName;
                tempRs = UpGradeUtil.executeQuery(ctx, columnSql, conn, false);
                ResultSetMetaData metaData = tempRs.getMetaData();
                int columnCount = metaData.getColumnCount();
                CoreBaseCollection calSchemeItemCollection = new CoreBaseCollection();
                for (i = 1; i <= columnCount; ++i) {
                    String columnName = metaData.getColumnName(i);
                    String key = hrOrg + "||" + columnName;
                    if (!itemMap.containsKey(key)) continue;
                    matchColumns.add(columnName);
                    String[] split = itemMap.get(key).split("\\|\\|");
                    tempSb.append(", S" + split[2]);
                    String idID = split[3];
                    if (itemList.contains(idID)) continue;
                    this.storeCalSchemeItem(ctx, calSchemeItemCollection, calSchemeInfo, idID);
                }
                if (matchColumns.size() == 0) continue;
                CalSchemeItemFactory.getRemoteInstance().save(calSchemeItemCollection);
                tempSb.append(") values(newbosid('269E3024'), ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?");
                for (i = 0; i < matchColumns.size(); ++i) {
                    tempSb.append(", ?");
                }
                tempSb.append(")");
                String dataSql = "select * from " + hisName;
                IRowSet dataRs = UpGradeUtil.executeQuery(ctx, dataSql, conn, false);
                List<Object> paramList = new ArrayList();
                paramList = this.getParamList(ctx, dataRs, schemeId, innerSchemeId, "EAS HR\u5386\u53f2\u85aa\u916c\u6570\u636e\u8fc1\u79fb", currentUserId, matchColumns, relationMap, employeeTypeMap, jobMap, periodMap);
                UpGradeUtil.executeBatchRoll(ctx, tempSb.toString(), paramList);
                this.schemeComplete(ctx, fid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.storeLog(ctx, currentId, "cmp", e);
            throw new InterfaceCmpUpGradeException(InterfaceCmpUpGradeException.CMP_UPGRADE_ERROR);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected void _adjUpGrade(Context ctx, Map param) throws BOSException, EASBizException {
        Connection conn = null;
        IRowSet rs = null;
        StringBuilder tempSb = new StringBuilder();
        String currentId = "";
        String businessId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String cu = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        try {
            conn = UpGradeUtil.getOuterConnection(ctx, "EasSysDB");
        }
        catch (SQLException e) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        try {
            Map<String, String> adjItemMap = this.getAdjItemMap(ctx, conn);
            Map<String, LinkedList<Object>> partAdjItemMap = this.getPartAdjItemMap(ctx, conn);
            Map<String, String> itemMap = this.getItemMap(ctx);
            String[] partAdjItems = this.getPartAdjItems(ctx);
            tempSb.append(" insert into T_HR_SFixAdjustSalary(fid, FPersonID, FCmpItemID, FMoney, ");
            tempSb.append(" FEffectDay, FDescription_l2, fcreateTime, fcreatorid, flastupdateuserid,  ");
            tempSb.append(" flastupdateTime, FControlUnitID, FBusinessUnitID) values ");
            tempSb.append(" (newbosid('0715640C'), ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            rs = this.getAdjRs(ctx);
            while (rs.next()) {
                BigDecimal money;
                String innerItemId;
                Object entrys;
                String fid;
                currentId = fid = rs.getString("fid");
                String sourceId = rs.getString("FSourceID");
                String entryId = rs.getString("FSourceEntryID");
                String tableName = rs.getString("FTableName");
                String hrOrg = rs.getString("hrOrg");
                String startSql = "update T_HR_SAdjRecord set FState=1 where fid=?";
                DbUtil.execute((Context)ctx, (String)startSql, (Object[])new Object[]{fid});
                Date currentTime = new Date(new java.util.Date().getTime());
                ArrayList<Object> tempParam = new ArrayList<Object>();
                if ("t_hr_adjscheme".equalsIgnoreCase(tableName)) {
                    entrys = adjItemMap.get(sourceId + "||" + entryId);
                    String[] split = ((String)entrys).split("\\|\\|");
                    String personId = split[0];
                    String itemNum = split[1];
                    if (!itemMap.containsKey(hrOrg + "||" + itemNum)) {
                        this.adjComplete(ctx, fid);
                        continue;
                    }
                    innerItemId = itemMap.get(hrOrg + "||" + itemNum).split("\\|\\|")[3];
                    String moneyStr = split[2];
                    money = BigDecimal.ZERO;
                    if (!"null".equals(moneyStr)) {
                        money = new BigDecimal(moneyStr);
                    }
                    Date effectDate = new Date(UpGradeUtil.toDate(split[3]).getTime());
                    tempParam.add(personId);
                    tempParam.add(innerItemId);
                    tempParam.add(money);
                    tempParam.add(effectDate);
                    tempParam.add("EASHR\u5b9a\u8c03\u85aa\u6570\u636e\u8fc1\u79fb_\u4e3b\u804c_" + entryId);
                    tempParam.add(currentTime);
                    tempParam.add(currentUserId);
                    tempParam.add(currentUserId);
                    tempParam.add(currentTime);
                    tempParam.add(cu);
                    tempParam.add(businessId);
                } else {
                    entrys = partAdjItemMap.get(sourceId + "||" + entryId);
                    String personId = ((LinkedList)entrys).get(0).toString();
                    for (int i = 0; i < partAdjItems.length; ++i) {
                        String outItemNum = partAdjItems[i];
                        if (!itemMap.containsKey(hrOrg + "||" + outItemNum) || ((LinkedList)entrys).get(i + 2) == null) {
                            this.adjComplete(ctx, fid);
                            continue;
                        }
                        tempParam.clear();
                        innerItemId = itemMap.get(hrOrg + "||" + outItemNum).split("\\|\\|")[3];
                        Date effectDate = new Date(UpGradeUtil.toDate(((LinkedList)entrys).get(1)).getTime());
                        money = new BigDecimal(((LinkedList)entrys).get(2).toString());
                        tempParam.add(personId);
                        tempParam.add(innerItemId);
                        tempParam.add(money);
                        tempParam.add(effectDate);
                        tempParam.add("EASHR\u5b9a\u8c03\u85aa\u6570\u636e\u8fc1\u79fb_\u517c\u804c_" + entryId);
                        tempParam.add(currentTime);
                        tempParam.add(currentUserId);
                        tempParam.add(currentUserId);
                        tempParam.add(currentTime);
                        tempParam.add(cu);
                        tempParam.add(businessId);
                    }
                }
                if (tempParam == null || tempParam.size() == 0) continue;
                DbUtil.execute((Context)ctx, (String)tempSb.toString(), (Object[])tempParam.toArray());
                this.adjComplete(ctx, fid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.storeLog(ctx, currentId, "adj", e);
            throw new InterfaceCmpUpGradeException(InterfaceCmpUpGradeException.ADJ_UPGRADE_ERROR);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected double _getCmpPer(Context ctx) throws BOSException, EASBizException {
        String finishSql = "select sum(FCmpDataNum) num from T_HR_SSchemeRecord where FState=2";
        String sumSql = "select sum(FCmpDataNum) num from T_HR_SSchemeRecord";
        IRowSet finishRs = DbUtil.executeQuery((Context)ctx, (String)finishSql);
        IRowSet sumRs = DbUtil.executeQuery((Context)ctx, (String)sumSql);
        int finishNum = 0;
        int sumNum = 0;
        try {
            finishRs.next();
            finishNum = finishRs.getInt("num");
            sumRs.next();
            sumNum = sumRs.getInt("num");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (sumNum == 0) {
            return 100.0;
        }
        double per = Math.round(finishNum * 100 / sumNum);
        return per;
    }

    @Override
    protected double _getAdjPer(Context ctx) throws BOSException, EASBizException {
        String finishSql = "select count(*) num from T_HR_SAdjRecord where FState=2";
        String sumSql = "select count(*) num from T_HR_SAdjRecord";
        IRowSet finishRs = DbUtil.executeQuery((Context)ctx, (String)finishSql);
        IRowSet sumRs = DbUtil.executeQuery((Context)ctx, (String)sumSql);
        int finishNum = 0;
        int sumNum = 0;
        try {
            finishRs.next();
            finishNum = finishRs.getInt("num");
            sumRs.next();
            sumNum = sumRs.getInt("num");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (sumNum == 0) {
            return 100.0;
        }
        double per = Math.round(finishNum * 100 / sumNum);
        return per;
    }

    @Override
    protected void _delUpGradeData(Context ctx, Map param) throws BOSException, EASBizException {
        String delRecordSql;
        String delDataSql;
        boolean scheme = Boolean.valueOf(param.get("scheme").toString());
        boolean adj = Boolean.valueOf(param.get("adj").toString());
        if (scheme) {
            delDataSql = "delete t_hr_scmpcaltable where FDescription_l2 like ?";
            delRecordSql = "delete T_HR_SSchemeRecord";
            DbUtil.execute((Context)ctx, (String)delDataSql, (Object[])new Object[]{"%EAS HR\u5386\u53f2\u85aa\u916c\u6570\u636e\u8fc1\u79fb%"});
            DbUtil.execute((Context)ctx, (String)delRecordSql);
        }
        if (adj) {
            delDataSql = "delete T_HR_SFixAdjustSalary where FDescription_l2 like ?";
            delRecordSql = "delete T_HR_SAdjRecord";
            DbUtil.execute((Context)ctx, (String)delDataSql, (Object[])new Object[]{"%EASHR\u5b9a\u8c03\u85aa\u6570\u636e\u8fc1\u79fb%"});
            DbUtil.execute((Context)ctx, (String)delRecordSql);
        }
    }

    private Map<String, String> getSchemeMap(Context ctx) throws BOSException, SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select FOuterCmpSchemeID, FCalSchemeID from T_HR_SCalSchemeMapping";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            String outSchemeId = rs.getString("FOuterCmpSchemeID");
            String inSchemeId = rs.getString("FCalSchemeID");
            map.put(outSchemeId, inSchemeId);
        }
        return map;
    }

    private Map<String, List<String>> getSchemeItemMap(Context ctx) throws BOSException, SQLException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String sql = "select FCalSchemeID, FCmpItemID from T_HR_SCalSchemeItem";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            List itemList = null;
            String schemeId = rs.getString("FCalSchemeID");
            String cmpItemId = rs.getString("FCmpItemID");
            itemList = map.containsKey(schemeId) ? (List)map.get(schemeId) : new ArrayList();
            itemList.add(cmpItemId);
            map.put(schemeId, itemList);
        }
        return map;
    }

    private Map<String, String> getJobMap(Context ctx) throws BOSException, SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select fid, fjobid from T_HR_EmpOrgRelation";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            String fid = rs.getString("fid");
            String fjobid = rs.getString("fjobid");
            map.put(fid, fjobid);
        }
        return map;
    }

    private Map<String, String> getEmployTypeMap(Context ctx) throws BOSException, SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select fid, FEmployeeTypeID from t_bd_person";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            String fid = rs.getString("fid");
            String employeeTypeid = rs.getString("FEmployeeTypeID");
            map.put(fid, employeeTypeid);
        }
        return map;
    }

    private Map<String, String> getOrgRelationMap(Context ctx) throws BOSException, SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select fid, fpersonId, fPositionId from T_HR_EmpOrgRelation where FLEFFDT>={ts '2199-12-31'}";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            String fid = rs.getString("fid");
            String personId = rs.getString("fpersonId");
            String positionId = rs.getString("fPositionId");
            String key = personId + "||" + positionId;
            String value = fid;
            map.put(key, value);
        }
        return map;
    }

    private Map<String, String> getPeriodMap(Context ctx, Connection conn) throws BOSException, SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select * from t_hr_cmpperiod";
        IRowSet rs = UpGradeUtil.executeQuery(ctx, sql, conn, false);
        while (rs.next()) {
            String fid = rs.getString("fid");
            String beginDate = UpGradeUtil.datetoString(rs.getDate("fbeginDate"));
            String periodNumber = rs.getString("fNumber");
            int periodYear = Integer.valueOf(periodNumber.substring(0, 4));
            int periodMonth = Integer.valueOf(periodNumber.substring(4));
            String endDate = UpGradeUtil.datetoString(rs.getDate("fendDate"));
            String value = fid + "||" + periodYear + "||" + periodMonth + "||" + beginDate + "||" + endDate;
            map.put(fid, value);
        }
        return map;
    }

    private Map<String, List<String>> getAdjSchemeMap(Context ctx, Connection conn) throws BOSException, SQLException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String sql = "select fid, fadjschemeid, FAdjCmpItemID, FNewValue, FEffectDate from t_hr_adjschitem";
        IRowSet rs = UpGradeUtil.executeQuery(ctx, sql, conn, false);
        while (rs.next()) {
            String entryId;
            String adjId = rs.getString("fadjschemeid");
            List entryList = null;
            entryList = map.containsKey(adjId) ? (List)map.get(adjId) : new ArrayList();
            String value = entryId = rs.getString("fid");
            entryList.add(value);
            map.put(adjId, entryList);
        }
        return map;
    }

    private Map<String, String> getAdjItemMap(Context ctx, Connection conn) throws BOSException, SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select t1.fid, t1.fadjschemeid, t1.FAdjEmpID, t2.fnumber, t1.FNewValue, t1.FEffectDate from t_hr_adjschitem t1 ";
        sql = sql + "left join t_hr_cmpitem t2 on t1.FAdjCmpItemID = t2.fid ";
        IRowSet rs = UpGradeUtil.executeQuery(ctx, sql, conn, false);
        while (rs.next()) {
            String adjId = rs.getString("fadjschemeid");
            String entryId = rs.getString("fid");
            String personId = rs.getString("FAdjEmpID");
            String itemNumber = rs.getString("fnumber");
            BigDecimal newValue = rs.getBigDecimal("FNewValue");
            String effectDate = UpGradeUtil.datetoString(rs.getDate("FEffectDate"));
            String value = personId + "||" + itemNumber + "||" + newValue + "||" + effectDate;
            map.put(adjId + "||" + entryId, value);
        }
        return map;
    }

    private Map<String, LinkedList<String>> getPartAdjSchemeMap(Context ctx, Connection conn) throws BOSException, SQLException {
        HashMap<String, LinkedList<String>> map = new HashMap<String, LinkedList<String>>();
        LinkedList entryList = null;
        StringBuilder sb = new StringBuilder();
        sb.append("select fid, FPartJobFixedAdjustID ");
        sb.append(" from T_HR_PartJobFixedAdjustEntry");
        IRowSet rs = UpGradeUtil.executeQuery(ctx, sb.toString(), conn, false);
        while (rs.next()) {
            String partAdjId = rs.getString("FPartJobFixedAdjustID");
            entryList = map.containsKey(partAdjId) ? (LinkedList)map.get(partAdjId) : new LinkedList();
            map.put(partAdjId, entryList);
            entryList.add(rs.getString("fid"));
        }
        return map;
    }

    private Map<String, LinkedList<Object>> getPartAdjItemMap(Context ctx, Connection conn) throws BOSException, SQLException {
        HashMap<String, LinkedList<Object>> map = new HashMap<String, LinkedList<Object>>();
        LinkedList<Object> dataList = null;
        StringBuilder sb = new StringBuilder();
        sb.append("select fid, FAdjEmpID, FPartJobFixedAdjustID, FEffectDate, FSal001_new, FSal031_new, ");
        sb.append("FSal032_new, FSal033_new, FSal034_new, FSal035_new, FSal036_new, FSal037_new, FSal038_new,");
        sb.append("FSal039_new, FSal040_new from T_HR_PartJobFixedAdjustEntry");
        IRowSet rs = UpGradeUtil.executeQuery(ctx, sb.toString(), conn, false);
        String[] partAdjItems = this.getPartAdjItems(ctx);
        while (rs.next()) {
            dataList = new LinkedList<Object>();
            String partAdjId = rs.getString("FPartJobFixedAdjustID");
            String entryId = rs.getString("fid");
            String personId = rs.getString("FAdjEmpID");
            dataList.add(personId);
            dataList.add(UpGradeUtil.datetoString(rs.getDate("FEffectDate")));
            for (int i = 0; i < partAdjItems.length; ++i) {
                dataList.add(rs.getBigDecimal(partAdjItems[i] + "_new"));
            }
            map.put(partAdjId + "||" + entryId, dataList);
        }
        return map;
    }

    private Map<String, String> getItemMap(Context ctx) throws BOSException, SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select FOutOrgID, fouterCmpItemNumber, FCmpItemOrgID, FCmpItemNumber, FCmpItemField, FCmpItemID from T_HR_SCmpItemMapping where FMatchState=0 or FMatchState=1";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            String outOrg = rs.getString("FOutOrgID");
            String outNumber = rs.getString("fouterCmpItemNumber");
            String inOrg = rs.getString("FCmpItemOrgID");
            String inNumber = rs.getString("FCmpItemNumber");
            String inField = rs.getString("FCmpItemField");
            String inID = rs.getString("FCmpItemID");
            String key = outOrg + "||" + outNumber;
            String value = inOrg + "||" + inNumber + "||" + inField + "||" + inID;
            map.put(key, value);
        }
        return map;
    }

    private List getSchemeMapping(Context ctx) throws BOSException {
        CalSchemeMappingCollection collection = CalSchemeMappingFactory.getLocalInstance(ctx).getCalSchemeMappingCollection();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (int i = 0; i < collection.size(); ++i) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(collection.get(i).getOuterCmpScheme());
            paramList.add(list.toArray());
        }
        return paramList;
    }

    private IRowSet getCmpRs(Context ctx) throws EASBizException, BOSException, SQLException {
        String recordSql = "";
        String delSql = "";
        IRowSet rs = null;
        boolean exists = SchemeRecordFactory.getLocalInstance(ctx).exists("where state=2");
        if (exists) {
            String currentSql = "select max(FIndexNum) indexNum from T_HR_SSchemeRecord where FState=2";
            IRowSet currentRs = DbUtil.executeQuery((Context)ctx, (String)currentSql);
            currentRs.next();
            int indexNum = currentRs.getInt("indexNum");
            recordSql = "select fid, FCalSchemeID, FHistoryName hisName, FHrOrgID hrOrg from T_HR_SSchemeRecord where FIndexNum>" + indexNum + " order by FIndexNum";
            delSql = "select fid, FCalSchemeID, FHistoryName hisName, FHrOrgID hrOrg from T_HR_SSchemeRecord where FIndexNum=? and fState=1";
            IRowSet delRs = DbUtil.executeQuery((Context)ctx, (String)delSql, (Object[])new Object[]{indexNum + 1});
            if (delRs.next()) {
                String schemeId = delRs.getString("FCalSchemeID");
                delSql = "delete t_hr_scmpcaltable where FDescription_l2=?";
                DbUtil.execute((Context)ctx, (String)delSql, (Object[])new Object[]{"EAS HR\u5386\u53f2\u85aa\u916c\u6570\u636e\u8fc1\u79fb_" + schemeId});
            }
        } else {
            recordSql = "select fid, FCalSchemeID, FHistoryName hisName, FHrOrgID hrOrg from T_HR_SSchemeRecord order by FIndexNum";
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)recordSql);
        return rs;
    }

    private IRowSet getAdjRs(Context ctx) throws EASBizException, BOSException, SQLException {
        String recordSql = "";
        String delSql = "";
        IRowSet rs = null;
        boolean exists = AdjRecordFactory.getLocalInstance(ctx).exists("where state=2");
        if (exists) {
            String currentSql = "select max(FIndexNum) indexNum from T_HR_SAdjRecord where FState=2";
            IRowSet currentRs = DbUtil.executeQuery((Context)ctx, (String)currentSql);
            currentRs.next();
            int indexNum = currentRs.getInt("indexNum");
            recordSql = "select fid, FSourceID, FSourceEntryID, FTableName, FHrOrgID hrOrg from T_HR_SAdjRecord where FIndexNum>" + indexNum + " order by FIndexNum";
            delSql = "select fid, FSourceID, FSourceEntryID, FTableName, FHrOrgID hrOrg from T_HR_SAdjRecord where FIndexNum=? and fState=1";
            IRowSet delRs = DbUtil.executeQuery((Context)ctx, (String)delSql, (Object[])new Object[]{indexNum + 1});
            if (delRs.next()) {
                String entryId = delRs.getString("FSourceEntryID");
                delSql = "delete T_HR_SFixAdjustSalary where FDescription_l2=?";
                DbUtil.execute((Context)ctx, (String)delSql, (Object[])new Object[]{"EASHR\u5b9a\u8c03\u85aa\u6570\u636e\u8fc1\u79fb_" + entryId});
            }
        } else {
            recordSql = "select fid, FSourceID, FSourceEntryID, FTableName, FHrOrgID hrOrg from T_HR_SAdjRecord  order by FIndexNum";
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)recordSql);
        return rs;
    }

    private List<Object[]> getParamList(Context ctx, IRowSet dataRs, String schemeId, String innerSchemeId, String desc, String currentUserId, List<String> matchColumns, Map<String, String> relationMap, Map<String, String> employeeTypeMap, Map<String, String> jobMap, Map<String, String> periodMap) throws SQLException {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        while (dataRs.next()) {
            ArrayList<Object> tempParam = new ArrayList<Object>();
            String personId = dataRs.getString("FPersonid");
            String adminId = dataRs.getString("FAdminorgunitid");
            String positionId = dataRs.getString("FPositionID");
            String periodId = dataRs.getString("fperiod");
            String orgRelationId = relationMap.get(personId + "||" + positionId) == null ? "" : relationMap.get(personId + "||" + positionId);
            String employeeTypeId = employeeTypeMap.get(personId) == null ? "" : employeeTypeMap.get(personId);
            String jobId = jobMap.get(orgRelationId) == null ? "" : jobMap.get(orgRelationId);
            String[] split = periodMap.get(periodId).split("\\|\\|");
            int periodYear = Integer.valueOf(split[1]);
            int periodMonth = Integer.valueOf(split[2]);
            Date beginDate = new Date(UpGradeUtil.toDate(split[3]).getTime());
            Date endDate = new Date(UpGradeUtil.toDate(split[4]).getTime());
            int calTime = dataRs.getInt("ftime");
            Date currentTime = new Date(new java.util.Date().getTime());
            tempParam.add(personId);
            tempParam.add(adminId);
            tempParam.add(positionId);
            tempParam.add(orgRelationId);
            tempParam.add(employeeTypeId);
            tempParam.add(jobId);
            tempParam.add(adminId);
            tempParam.add(adminId);
            tempParam.add(innerSchemeId);
            tempParam.add(periodYear);
            tempParam.add(periodMonth);
            tempParam.add(beginDate);
            tempParam.add(endDate);
            tempParam.add(calTime);
            tempParam.add(20);
            tempParam.add(0);
            tempParam.add(desc + "_" + schemeId);
            tempParam.add(currentTime);
            tempParam.add(currentUserId);
            tempParam.add(currentUserId);
            tempParam.add(currentTime);
            tempParam.add(2);
            for (int j = 0; j < matchColumns.size(); ++j) {
                String columnName = matchColumns.get(j);
                Object value = dataRs.getObject(columnName);
                if (value instanceof java.util.Date) {
                    value = UpGradeUtil.dateToString(value, "yyyy-MM-dd");
                }
                tempParam.add(value);
            }
            paramList.add(tempParam.toArray());
        }
        return paramList;
    }

    private void schemeComplete(Context ctx, String fid) throws BOSException {
        String endSql = "update T_HR_SSchemeRecord set FState=2 where fid=?";
        DbUtil.execute((Context)ctx, (String)endSql, (Object[])new Object[]{fid});
    }

    private void adjComplete(Context ctx, String fid) throws BOSException {
        String endSql = "update T_HR_SAdjRecord set FState=2 where fid=?";
        DbUtil.execute((Context)ctx, (String)endSql, (Object[])new Object[]{fid});
    }

    private String createTempTable(Context ctx, Connection conn, List paramList) throws Exception {
        String tempTableName = "t_schemetemp";
        String createSql = "";
        createSql = "create table " + tempTableName + "(fid varchar(44) default '' not null)";
        UpGradeUtil.execute(ctx, createSql, conn, false);
        String insertSql = "insert into " + tempTableName + " values(?)";
        UpGradeUtil.executeBatchAndReturn(conn, insertSql, paramList, false);
        return tempTableName;
    }

    private String[] getPartAdjItems(Context ctx) {
        String[] arr = new String[]{"FSAL001", "FSAL031", "FSAL032", "FSAL033", "FSAL034", "FSAL035", "FSAL036", "FSAL037", "FSAL038", "FSAL039", "FSAL040"};
        return arr;
    }

    private void storeLog(Context ctx, String relateId, String type, Exception e) {
        String delLogsql = "delete T_HR_SCmpUpGradeLog where FLogType=?";
        try {
            int logType = "cmp".equals(type) ? 0 : 1;
            DbUtil.execute((Context)ctx, (String)delLogsql, (Object[])new Object[]{logType});
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        CmpUpGradeLogInfo logInfo = new CmpUpGradeLogInfo();
        UpGradeLogType logType = "cmp".equals(type) ? UpGradeLogType.CMP : UpGradeLogType.ADJ;
        logInfo.setLogType(logType);
        logInfo.setDetail(e.getMessage());
        logInfo.setRelateId(relateId);
        try {
            CmpUpGradeLogFactory.getLocalInstance(ctx).save((CoreBaseInfo)logInfo);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
    }

    private void storeCalSchemeItem(Context ctx, CoreBaseCollection calSchemeItemCollection, CalSchemeInfo calSchemeInfo, String idID) throws EASBizException, BOSException {
        CalSchemeItemInfo calSchemeItemInfo = new CalSchemeItemInfo();
        CmpItemInfo cmpItemInfo = CmpItemFactory.getLocalInstance((Context)ctx).getCmpItemInfo((IObjectPK)new ObjectUuidPK(idID));
        calSchemeItemInfo.setCalScheme(calSchemeInfo);
        calSchemeItemInfo.setCmpItem(cmpItemInfo);
        int sortSn = cmpItemInfo.getIndex() == 0 ? cmpItemInfo.getFieldSn() : cmpItemInfo.getIndex();
        calSchemeItemInfo.setSortSn(sortSn);
        calSchemeItemInfo.setIsLeaderAudit(CalFlag.YES);
        calSchemeItemCollection.add((CoreBaseInfo)calSchemeItemInfo);
    }
}

